/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Direction;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.mars.Mars;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.task.AreologyStudyFieldWork;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyManager;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.Rover;

public class AreologyStudyFieldMission
extends RoverMission
implements Serializable {
    private static Logger logger = Logger.getLogger(AreologyStudyFieldMission.class.getName());
    public static final String DEFAULT_DESCRIPTION = "Areology Study Field Mission";
    public static final String RESEARCH_SITE = "Researching Field Site";
    private static final int MIN_PEOPLE = 2;
    public static final double FIELD_SITE_TIME = 1000.0;
    private MarsClock fieldSiteStartTime;
    private boolean endFieldSite;
    private Coordinates fieldSite;
    private ScientificStudy study;
    private Person leadResearcher;

    public AreologyStudyFieldMission(Person startingPerson) {
        super(DEFAULT_DESCRIPTION, startingPerson, 2);
        if (!this.isDone()) {
            int availableSuitNum;
            this.leadResearcher = startingPerson;
            this.study = this.determineStudy(this.leadResearcher);
            if (this.study == null) {
                this.endMission("Scientific study could not be determined.");
            }
            if (this.hasVehicle()) {
                this.setMissionCapacity(this.getRover().getCrewCapacity());
            }
            if ((availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingPerson.getSettlement())) < this.getMissionCapacity()) {
                this.setMissionCapacity(availableSuitNum);
            }
            this.setStartingSettlement(startingPerson.getSettlement());
            this.recruitPeopleForMission(startingPerson);
            if (this.hasVehicle()) {
                double tripTimeLimit = AreologyStudyFieldMission.getTotalTripTimeLimit(this.getRover(), this.getPeopleNumber(), true);
                this.determineFieldSite(this.getVehicle().getRange(), tripTimeLimit);
            }
            this.addNavpoint(new NavPoint(this.getStartingSettlement().getCoordinates(), this.getStartingSettlement(), this.getStartingSettlement().getName()));
            if (this.hasVehicle() && !this.isVehicleLoadable()) {
                this.endMission("Vehicle is not loadable. (AreologyStudyFieldMission)");
            }
        }
        this.addPhase(RESEARCH_SITE);
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
    }

    public AreologyStudyFieldMission(Collection<Person> members, Settlement startingSettlement, Person leadResearcher, ScientificStudy study, Rover rover, Coordinates fieldSite, String description) {
        super(description, leadResearcher, 2, rover);
        this.setStartingSettlement(startingSettlement);
        this.study = study;
        this.leadResearcher = leadResearcher;
        this.fieldSite = fieldSite;
        this.addNavpoint(new NavPoint(fieldSite, "field research site"));
        this.setMissionCapacity(this.getRover().getCrewCapacity());
        int availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingSettlement);
        if (availableSuitNum < this.getMissionCapacity()) {
            this.setMissionCapacity(availableSuitNum);
        }
        Iterator<Person> i = members.iterator();
        while (i.hasNext()) {
            i.next().getMind().setMission(this);
        }
        this.addNavpoint(new NavPoint(this.getStartingSettlement().getCoordinates(), this.getStartingSettlement(), this.getStartingSettlement().getName()));
        this.addPhase(RESEARCH_SITE);
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
        if (this.hasVehicle() && !this.isVehicleLoadable()) {
            this.endMission("Vehicle is not loadable. (AreologyStudyFieldMission)");
        }
    }

    public static double getNewMissionProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            Job job;
            int crowding;
            boolean enoughMethane;
            Settlement settlement = person.getSettlement();
            boolean reservableRover = RoverMission.areVehiclesAvailable(settlement, false);
            boolean backupRover = AreologyStudyFieldMission.hasBackupRover(settlement);
            boolean minNum = RoverMission.minAvailablePeopleAtSettlement(settlement, 3);
            boolean embarkingMissions = VehicleMission.hasEmbarkingMissions(settlement);
            boolean hasBasicResources = RoverMission.hasEnoughBasicResources(settlement);
            boolean enoughSuits = Mission.getNumberAvailableEVASuitsAtSettlement(person.getSettlement()) > 2;
            AmountResource methane = AmountResource.findAmountResource("methane");
            boolean bl = enoughMethane = settlement.getInventory().getAmountResourceStored(methane, false) >= 1000.0;
            if (reservableRover && backupRover && minNum && !embarkingMissions && hasBasicResources && enoughSuits && enoughMethane) {
                try {
                    Rover rover = (Rover)AreologyStudyFieldMission.getVehicleWithGreatestRange(settlement, false);
                    if (rover != null) {
                        Science areology = ScienceUtil.getScience("Areology");
                        ScientificStudyManager studyManager = Simulation.instance().getScientificStudyManager();
                        ScientificStudy primaryStudy = studyManager.getOngoingPrimaryStudy(person);
                        if (primaryStudy != null && "Research".equals(primaryStudy.getPhase()) && !primaryStudy.isPrimaryResearchCompleted() && areology.equals(primaryStudy.getScience())) {
                            result += 10.0;
                        }
                        for (ScientificStudy collabStudy : studyManager.getOngoingCollaborativeStudies(person)) {
                            if (!"Research".equals(collabStudy.getPhase()) || collabStudy.isCollaborativeResearchCompleted(person) || !areology.equals(collabStudy.getCollaborativeResearchers().get(person))) continue;
                            result += 5.0;
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error determining rover.", e);
                }
            }
            if ((crowding = settlement.getCurrentPopulationNum() - settlement.getPopulationCapacity()) > 0) {
                result *= (double)(crowding + 1);
            }
            if ((job = person.getMind().getJob()) != null) {
                result *= job.getStartMissionProbabilityModifier(AreologyStudyFieldMission.class);
            }
        }
        return result;
    }

    public ScientificStudy getScientificStudy() {
        return this.study;
    }

    public Person getLeadResearcher() {
        return this.leadResearcher;
    }

    private ScientificStudy determineStudy(Person researcher) {
        ScientificStudy result = null;
        Science areology = ScienceUtil.getScience("Areology");
        ArrayList<ScientificStudy> possibleStudies = new ArrayList<ScientificStudy>();
        ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
        ScientificStudy primaryStudy = manager.getOngoingPrimaryStudy(researcher);
        if (primaryStudy != null && "Research".equals(primaryStudy.getPhase()) && !primaryStudy.isPrimaryResearchCompleted() && areology.equals(primaryStudy.getScience())) {
            possibleStudies.add(primaryStudy);
            possibleStudies.add(primaryStudy);
        }
        for (ScientificStudy collabStudy : manager.getOngoingCollaborativeStudies(researcher)) {
            if (!"Research".equals(collabStudy.getPhase()) || collabStudy.isCollaborativeResearchCompleted(researcher) || !areology.equals(collabStudy.getCollaborativeResearchers().get(researcher))) continue;
            possibleStudies.add(collabStudy);
        }
        if (possibleStudies.size() > 0) {
            int selected = RandomUtil.getRandomInt(possibleStudies.size() - 1);
            result = (ScientificStudy)possibleStudies.get(selected);
        }
        return result;
    }

    public static double getTotalTripTimeLimit(Rover rover, int memberNum, boolean useBuffer) {
        Inventory vInv = rover.getInventory();
        double timeLimit = Double.MAX_VALUE;
        PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
        AmountResource food = AmountResource.findAmountResource("food");
        double foodConsumptionRate = config.getFoodConsumptionRate();
        double foodCapacity = vInv.getAmountResourceCapacity(food, false);
        double foodTimeLimit = foodCapacity / (foodConsumptionRate * (double)memberNum);
        if (foodTimeLimit < timeLimit) {
            timeLimit = foodTimeLimit;
        }
        AmountResource water = AmountResource.findAmountResource("water");
        double waterConsumptionRate = config.getWaterConsumptionRate();
        double waterCapacity = vInv.getAmountResourceCapacity(water, false);
        double waterTimeLimit = waterCapacity / (waterConsumptionRate * (double)memberNum);
        if (waterTimeLimit < timeLimit) {
            timeLimit = waterTimeLimit;
        }
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenConsumptionRate = config.getOxygenConsumptionRate();
        double oxygenCapacity = vInv.getAmountResourceCapacity(oxygen, false);
        double oxygenTimeLimit = oxygenCapacity / (oxygenConsumptionRate * (double)memberNum);
        if (oxygenTimeLimit < timeLimit) {
            timeLimit = oxygenTimeLimit;
        }
        timeLimit *= 1000.0;
        if (useBuffer) {
            timeLimit /= 3.0;
        }
        return timeLimit;
    }

    private void determineFieldSite(double roverRange, double tripTimeLimit) {
        double range = roverRange;
        double timeRange = this.getTripTimeRange(tripTimeLimit, true);
        if (timeRange < range) {
            range = timeRange;
        }
        Coordinates startingLocation = this.getCurrentMissionLocation();
        Direction direction = new Direction(RandomUtil.getRandomDouble(Math.PI * 2));
        double limit = range / 4.0;
        double siteDistance = RandomUtil.getRandomDouble(limit);
        this.fieldSite = startingLocation.getNewLocation(direction, siteDistance);
        this.addNavpoint(new NavPoint(this.fieldSite, "field research site"));
    }

    private double getTripTimeRange(double tripTimeLimit, boolean useBuffer) {
        double timeAtSite = 1000.0;
        double tripTimeTravelingLimit = tripTimeLimit - timeAtSite;
        double averageSpeed = this.getAverageVehicleSpeedForOperators();
        double millisolsInHour = MarsClock.convertSecondsToMillisols(3600.0);
        double averageSpeedMillisol = averageSpeed / millisolsInHour;
        return tripTimeTravelingLimit * averageSpeedMillisol;
    }

    @Override
    protected void recruitPeopleForMission(Person startingPerson) {
        Person lastPerson;
        super.recruitPeopleForMission(startingPerson);
        if (!AreologyStudyFieldMission.atLeastOnePersonRemainingAtSettlement(this.getStartingSettlement(), startingPerson) && (lastPerson = (Person)this.getPeople().toArray()[this.getPeopleNumber() - 1]) != null) {
            lastPerson.getMind().setMission(null);
            if (this.getPeopleNumber() < this.getMinPeople()) {
                this.endMission("Not enough members.");
            }
        }
    }

    @Override
    protected double getMissionQualification(Person person) {
        double result = 0.0;
        if (this.isCapableOfMission(person)) {
            Job job = person.getMind().getJob();
            if (job != null) {
                result = job.getJoinMissionProbabilityModifier(this.getClass());
            }
            Science areology = ScienceUtil.getScience("Areology");
            if (this.study != null) {
                if (person == this.study.getPrimaryResearcher()) {
                    result += 2.0;
                    if (areology.equals(this.study.getScience())) {
                        result += 1.0;
                    }
                } else if (this.study.getCollaborativeResearchers().containsKey(person)) {
                    result += 1.0;
                    Science collabScience = this.study.getCollaborativeResearchers().get(person);
                    if (areology.equals(collabScience)) {
                        result += 1.0;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public Map<Class, Integer> getEquipmentNeededForRemainingMission(boolean useBuffer) {
        HashMap<Class, Integer> result;
        if (this.equipmentNeededCache != null) {
            return this.equipmentNeededCache;
        }
        this.equipmentNeededCache = result = new HashMap<Class, Integer>();
        return result;
    }

    @Override
    public Settlement getAssociatedSettlement() {
        return this.getStartingSettlement();
    }

    @Override
    protected void determineNewPhase() {
        if ("Embarking".equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
        } else if ("Travelling".equals(this.getPhase())) {
            if (this.getCurrentNavpoint().isSettlementAtNavpoint()) {
                this.setPhase("Disembarking");
                this.setPhaseDescription("Disembarking at " + this.getCurrentNavpoint().getSettlement().getName());
            } else {
                this.setPhase(RESEARCH_SITE);
                this.setPhaseDescription("Researching field site at " + this.getCurrentNavpoint().getDescription());
            }
        } else if (RESEARCH_SITE.equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
        } else if ("Disembarking".equals(this.getPhase())) {
            this.endMission("Successfully disembarked.");
        }
    }

    @Override
    protected void performPhase(Person person) {
        super.performPhase(person);
        if (RESEARCH_SITE.equals(this.getPhase())) {
            this.researchFieldSitePhase(person);
        }
    }

    public void endResearchAtFieldSite() {
        logger.info("Research field site phase ended due to external trigger.");
        this.endFieldSite = true;
        Iterator<Person> i = this.getPeople().iterator();
        while (i.hasNext()) {
            Task task = i.next().getMind().getTaskManager().getTask();
            if (!(task instanceof AreologyStudyFieldWork)) continue;
            ((AreologyStudyFieldWork)task).endEVA();
        }
    }

    private void researchFieldSitePhase(Person person) {
        if (this.fieldSiteStartTime == null) {
            this.fieldSiteStartTime = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
        }
        boolean timeExpired = false;
        MarsClock currentTime = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
        if (MarsClock.getTimeDiff(currentTime, this.fieldSiteStartTime) >= 1000.0) {
            timeExpired = true;
        }
        if (this.isEveryoneInRover()) {
            if (this.endFieldSite) {
                this.endFieldSite = false;
                this.setPhaseEnded(true);
            }
            if (timeExpired) {
                this.setPhaseEnded(true);
            }
            boolean nobodyFieldWork = true;
            Iterator<Person> j = this.getPeople().iterator();
            while (j.hasNext()) {
                if (!AreologyStudyFieldWork.canResearchSite(j.next(), this.getRover())) continue;
                nobodyFieldWork = false;
            }
            Mars mars = Simulation.instance().getMars();
            boolean inDarkPolarRegion = mars.getSurfaceFeatures().inDarkPolarRegion(this.getCurrentMissionLocation());
            double sunlight = mars.getSurfaceFeatures().getSurfaceSunlight(this.getCurrentMissionLocation());
            if (nobodyFieldWork && (sunlight > 0.0 || inDarkPolarRegion)) {
                this.setPhaseEnded(true);
            }
            if (this.hasEmergency()) {
                this.setPhaseEnded(true);
            }
            if (!this.hasEnoughResourcesForRemainingMission(false)) {
                this.determineEmergencyDestination(person);
                this.setPhaseEnded(true);
            }
        } else if (timeExpired) {
            Iterator<Person> i = this.getPeople().iterator();
            while (i.hasNext()) {
                Task task = i.next().getMind().getTaskManager().getTask();
                if (task == null || !(task instanceof AreologyStudyFieldWork)) continue;
                ((AreologyStudyFieldWork)task).endEVA();
            }
        }
        if (!this.getPhaseEnded() && !this.endFieldSite && !timeExpired && AreologyStudyFieldWork.canResearchSite(person, this.getRover())) {
            this.assignTask(person, new AreologyStudyFieldWork(person, this.leadResearcher, this.study, (Rover)this.getVehicle()));
        }
    }

    @Override
    protected boolean isCapableOfMission(Person person) {
        return super.isCapableOfMission(person) && person.getLocationSituation().equals("In Settlement") && person.getSettlement() == this.getStartingSettlement();
    }

    @Override
    public double getEstimatedRemainingMissionTime(boolean useBuffer) {
        double result = super.getEstimatedRemainingMissionTime(useBuffer);
        return result += this.getEstimatedRemainingFieldSiteTime();
    }

    private double getEstimatedRemainingFieldSiteTime() {
        MarsClock currentTime;
        double timeSpentAtExplorationSite;
        double remainingTime;
        double result = 0.0;
        if (RESEARCH_SITE.equals(this.getPhase()) && (remainingTime = 1000.0 - (timeSpentAtExplorationSite = MarsClock.getTimeDiff(currentTime = Simulation.instance().getMasterClock().getMarsClock(), this.fieldSiteStartTime))) > 0.0) {
            result += remainingTime;
        }
        if (this.fieldSiteStartTime == null) {
            result += 1000.0;
        }
        return result;
    }

    @Override
    public Map<Resource, Number> getResourcesNeededForRemainingMission(boolean useBuffer) {
        Map<Resource, Number> result = super.getResourcesNeededForRemainingMission(useBuffer);
        double fieldSiteTime = this.getEstimatedRemainingFieldSiteTime();
        double timeSols = fieldSiteTime / 1000.0;
        int crewNum = this.getPeopleNumber();
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenAmount = PhysicalCondition.getOxygenConsumptionRate() * timeSols * (double)crewNum;
        if (result.containsKey(oxygen)) {
            oxygenAmount += ((Double)result.get(oxygen)).doubleValue();
        }
        result.put(oxygen, oxygenAmount);
        AmountResource water = AmountResource.findAmountResource("water");
        double waterAmount = PhysicalCondition.getWaterConsumptionRate() * timeSols * (double)crewNum;
        if (result.containsKey(water)) {
            waterAmount += ((Double)result.get(water)).doubleValue();
        }
        result.put(water, waterAmount);
        AmountResource food = AmountResource.findAmountResource("food");
        double foodAmount = PhysicalCondition.getFoodConsumptionRate() * timeSols * (double)crewNum;
        if (result.containsKey(food)) {
            foodAmount += ((Double)result.get(food)).doubleValue();
        }
        result.put(food, foodAmount);
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.fieldSiteStartTime = null;
        this.fieldSite = null;
        this.study = null;
        this.leadResearcher = null;
    }
}

