/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.person.ai.task.SalvageBuilding;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.construction.ConstructionManager;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStage;
import org.mars_sim.msp.core.structure.construction.ConstructionVehicleType;
import org.mars_sim.msp.core.structure.construction.SalvageValues;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class BuildingSalvageMission
extends Mission
implements Serializable {
    private static Logger logger = Logger.getLogger(BuildingSalvageMission.class.getName());
    public static final String DEFAULT_DESCRIPTION = "Salvage Building";
    public static final String PREPARE_SITE_PHASE = "Prepare Site";
    public static final String SALVAGE_PHASE = "Salvage";
    private static final int MIN_PEOPLE = 3;
    private static final int MAX_PEOPLE = 10;
    private static final double SITE_PREPARE_TIME = 500.0;
    private Settlement settlement;
    private ConstructionSite constructionSite;
    private ConstructionStage constructionStage;
    private List<GroundVehicle> constructionVehicles;
    private MarsClock sitePreparationStartTime;
    private boolean finishingExistingStage;
    private List<Part> luvAttachmentParts;
    private double wearCondition;

    public BuildingSalvageMission(Person startingPerson) {
        super(DEFAULT_DESCRIPTION, startingPerson, 3);
        this.wearCondition = 100.0;
        if (!this.isDone()) {
            this.settlement = startingPerson.getSettlement();
            this.setMissionCapacity(10);
            int availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(this.settlement);
            if (availableSuitNum < this.getMissionCapacity()) {
                this.setMissionCapacity(availableSuitNum);
            }
            this.recruitPeopleForMission(startingPerson);
            int constructionSkill = startingPerson.getMind().getSkillManager().getEffectiveSkillLevel("Construction");
            ConstructionManager manager = this.settlement.getConstructionManager();
            SalvageValues values = manager.getSalvageValues();
            double existingSitesProfit = values.getAllSalvageSitesProfit(constructionSkill);
            double newSiteProfit = values.getNewSalvageSiteProfit(constructionSkill);
            if (existingSitesProfit > newSiteProfit) {
                this.constructionSite = this.determineMostProfitableSalvageConstructionSite(this.settlement, constructionSkill);
            } else {
                Building salvageBuilding = this.determineBuildingToSalvage(this.settlement, constructionSkill);
                if (salvageBuilding != null) {
                    this.constructionSite = manager.createNewSalvageConstructionSite(salvageBuilding);
                    this.wearCondition = salvageBuilding.getMalfunctionManager().getWearCondition();
                } else {
                    logger.log(Level.WARNING, "No building could be found that is profitable to salvage.");
                }
            }
            if (this.constructionSite != null) {
                if (this.constructionSite.hasUnfinishedStage()) {
                    this.constructionStage = this.constructionSite.getCurrentConstructionStage();
                    this.finishingExistingStage = true;
                    logger.log(Level.INFO, "Continuing work on existing site at " + this.settlement.getName());
                } else {
                    this.constructionStage = this.constructionSite.getCurrentConstructionStage();
                    if (this.constructionStage != null) {
                        this.constructionStage.setCompletedWorkTime(0.0);
                        this.constructionStage.setSalvaging(true);
                        logger.log(Level.INFO, "Starting salvage construction stage: " + this.constructionStage);
                    } else {
                        this.endMission("Salvage construction stage could not be found.");
                    }
                }
                if (this.constructionStage != null) {
                    this.constructionSite.setUndergoingSalvage(true);
                }
            } else {
                this.endMission("Salvage construction site could not be found or created.");
            }
            this.reserveConstructionVehicles();
            this.retrieveConstructionLUVParts();
        }
        this.addPhase(PREPARE_SITE_PHASE);
        this.addPhase(SALVAGE_PHASE);
        this.setPhase(PREPARE_SITE_PHASE);
        this.setPhaseDescription("Preparing salvage construction site at " + this.settlement.getName());
    }

    public BuildingSalvageMission(Collection<Person> members, Settlement settlement, Building building, ConstructionSite site, List<GroundVehicle> vehicles) {
        super(DEFAULT_DESCRIPTION, (Person)members.toArray()[0], 1);
        this.settlement = settlement;
        ConstructionManager manager = settlement.getConstructionManager();
        if (building != null) {
            this.constructionSite = manager.createNewSalvageConstructionSite(building);
        } else if (site != null) {
            this.constructionSite = site;
        } else {
            logger.log(Level.SEVERE, "Neither salvage building or salvage construction site provided.");
            throw new IllegalStateException("Prepare Site:Neither salvage building or salvage construction site provided.");
        }
        if (this.constructionSite != null) {
            if (this.constructionSite.hasUnfinishedStage()) {
                this.constructionStage = this.constructionSite.getCurrentConstructionStage();
                this.finishingExistingStage = true;
                logger.log(Level.INFO, "Continuing work on existing site at " + settlement.getName());
            } else {
                this.constructionStage = this.constructionSite.getCurrentConstructionStage();
                if (this.constructionStage != null) {
                    this.constructionStage.setCompletedWorkTime(0.0);
                    this.constructionStage.setSalvaging(true);
                    logger.log(Level.INFO, "Starting salvage construction stage: " + this.constructionStage);
                } else {
                    this.endMission("Salvage construction stage could not be found.");
                }
            }
            if (this.constructionStage != null) {
                this.constructionSite.setUndergoingSalvage(true);
            }
        } else {
            this.endMission("Salvage construction site could not be found or created.");
        }
        if (this.constructionStage != null) {
            this.constructionSite.setUndergoingSalvage(true);
        }
        Iterator<Person> i = members.iterator();
        while (i.hasNext()) {
            i.next().getMind().setMission(this);
        }
        this.constructionVehicles = vehicles;
        for (GroundVehicle vehicle : vehicles) {
            vehicle.setReservedForMission(true);
            if (settlement.getInventory().containsUnit(vehicle)) {
                settlement.getInventory().retrieveUnit(vehicle);
                continue;
            }
            logger.severe("Unable to retrieve " + vehicle.getName() + " cannot be retrieved from " + settlement.getName() + " inventory.");
            this.endMission("Construction vehicle " + vehicle.getName() + " could not be retrieved from settlement inventory.");
        }
        this.retrieveConstructionLUVParts();
        this.addPhase(PREPARE_SITE_PHASE);
        this.addPhase(SALVAGE_PHASE);
        this.setPhase(PREPARE_SITE_PHASE);
        this.setPhaseDescription("Preparing salvage construction site at " + settlement.getName());
    }

    public static double getNewMissionProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            Job job;
            Settlement settlement = person.getSettlement();
            boolean reservableLUV = BuildingSalvageMission.isLUVAvailable(settlement);
            int availablePeopleNum = 0;
            for (Person member : settlement.getInhabitants()) {
                boolean isFit;
                boolean noMission = !member.getMind().hasActiveMission();
                boolean bl = isFit = !member.getPhysicalCondition().hasSeriousMedicalProblems();
                if (!noMission || !isFit) continue;
                ++availablePeopleNum;
            }
            boolean enoughPeople = availablePeopleNum >= 3;
            MarsClock startTime = Simulation.instance().getMasterClock().getInitialMarsTime();
            MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
            double totalTimeMillisols = MarsClock.getTimeDiff(currentTime, startTime);
            double totalTimeOrbits = totalTimeMillisols / 1000.0 / 668.0;
            boolean firstMonth = totalTimeOrbits < 28.0;
            boolean constructionOverride = settlement.getConstructionOverride();
            if (reservableLUV && enoughPeople && !constructionOverride && !firstMonth) {
                try {
                    double salvageProfit;
                    int constructionSkill = person.getMind().getSkillManager().getEffectiveSkillLevel("Construction");
                    SalvageValues values = settlement.getConstructionManager().getSalvageValues();
                    result = salvageProfit = values.getSettlementSalvageProfit(constructionSkill);
                    if (result > 100.0) {
                        result = 100.0;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error getting salvage construction site.", e);
                }
            }
            if (Mission.getNumberAvailableEVASuitsAtSettlement(person.getSettlement()) < 3) {
                result = 0.0;
            }
            if ((job = person.getMind().getJob()) != null) {
                result *= job.getStartMissionProbabilityModifier(BuildingSalvageMission.class);
            }
        }
        return result;
    }

    private ConstructionSite determineMostProfitableSalvageConstructionSite(Settlement settlement, int constructionSkill) {
        ConstructionSite result = null;
        double topSiteProfit = 0.0;
        ConstructionManager manager = settlement.getConstructionManager();
        for (ConstructionSite site : manager.getConstructionSitesNeedingSalvageMission()) {
            double siteProfit = manager.getSalvageValues().getSalvageSiteProfit(site, constructionSkill);
            if (!(siteProfit > topSiteProfit)) continue;
            result = site;
            topSiteProfit = siteProfit;
        }
        return result;
    }

    private Building determineBuildingToSalvage(Settlement settlement, int constructionSkill) {
        Building result = null;
        SalvageValues values = settlement.getConstructionManager().getSalvageValues();
        HashMap<Building, Double> salvageBuildings = new HashMap<Building, Double>();
        for (Building building : settlement.getBuildingManager().getBuildings()) {
            double salvageProfit = values.getNewBuildingSalvageProfit(building, constructionSkill);
            if (!(salvageProfit > 0.0)) continue;
            salvageBuildings.put(building, salvageProfit);
        }
        if (!salvageBuildings.isEmpty()) {
            result = (Building)RandomUtil.getWeightedRandomObject(salvageBuildings);
        }
        return result;
    }

    @Override
    protected void determineNewPhase() {
        if (PREPARE_SITE_PHASE.equals(this.getPhase())) {
            this.setPhase(SALVAGE_PHASE);
            this.setPhaseDescription("Salvage Construction Site Stage: " + this.constructionStage.getInfo().getName());
        } else if (SALVAGE_PHASE.equals(this.getPhase())) {
            this.endMission("Successfully ended salvage");
        }
    }

    @Override
    protected void performPhase(Person person) {
        super.performPhase(person);
        if (PREPARE_SITE_PHASE.equals(this.getPhase())) {
            this.prepareSitePhase(person);
        } else if (SALVAGE_PHASE.equals(this.getPhase())) {
            this.salvagePhase(person);
        }
    }

    @Override
    public Settlement getAssociatedSettlement() {
        return this.settlement;
    }

    @Override
    public Map<Class, Integer> getEquipmentNeededForRemainingMission(boolean useBuffer) {
        HashMap<Class, Integer> equipment = new HashMap<Class, Integer>(1);
        equipment.put(EVASuit.class, this.getPeopleNumber());
        return equipment;
    }

    @Override
    public Map<Resource, Number> getResourcesNeededForRemainingMission(boolean useBuffer) {
        HashMap<Resource, Number> resources = new HashMap<Resource, Number>(0);
        return resources;
    }

    private void prepareSitePhase(Person person) {
        if (this.finishingExistingStage) {
            this.setPhaseEnded(true);
        }
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        if (this.sitePreparationStartTime == null) {
            this.sitePreparationStartTime = (MarsClock)currentTime.clone();
        }
        if (MarsClock.getTimeDiff(currentTime, this.sitePreparationStartTime) >= 500.0) {
            this.setPhaseEnded(true);
        }
    }

    private void salvagePhase(Person person) {
        if (this.hasEmergency()) {
            this.setPhaseEnded(true);
        }
        if (!this.getPhaseEnded() && RandomUtil.lessThanRandPercent(75.0) && SalvageBuilding.canSalvage(person)) {
            this.assignTask(person, new SalvageBuilding(person, this.constructionStage, this.constructionSite, this.constructionVehicles));
        }
        if (this.constructionStage.isComplete()) {
            this.setPhaseEnded(true);
            this.settlement.getConstructionManager().getConstructionValues().clearCache();
            this.constructionSite.removeSalvagedStage(this.constructionStage);
            this.salvageConstructionParts();
            this.constructionSite.setUndergoingSalvage(false);
            if (this.constructionStage.getInfo().getType().equals("foundation")) {
                this.settlement.getConstructionManager().removeConstructionSite(this.constructionSite);
                this.settlement.fireUnitUpdate("salvage building", this.constructionSite);
                logger.log(Level.INFO, "Construction site completely salvaged at " + this.settlement.getName());
            }
        }
    }

    @Override
    public void endMission(String reason) {
        super.endMission(reason);
        if (this.constructionSite != null) {
            this.constructionSite.setUndergoingSalvage(false);
        }
        this.unreserveConstructionVehicles();
    }

    @Override
    protected boolean isCapableOfMission(Person person) {
        return super.isCapableOfMission(person) && person.getLocationSituation().equals("In Settlement") && person.getSettlement() == this.settlement;
    }

    private static boolean isLUVAvailable(Settlement settlement) {
        boolean result = false;
        for (Vehicle vehicle : settlement.getParkedVehicles()) {
            if (!(vehicle instanceof LightUtilityVehicle)) continue;
            boolean usable = true;
            if (vehicle.isReserved()) {
                usable = false;
            }
            if (!vehicle.getStatus().equals("Parked")) {
                usable = false;
            }
            if (((Crewable)((Object)vehicle)).getCrewNum() > 0) {
                usable = false;
            }
            if (!usable) continue;
            result = true;
        }
        return result;
    }

    private void reserveConstructionVehicles() {
        if (this.constructionStage != null) {
            this.constructionVehicles = new ArrayList<GroundVehicle>();
            for (ConstructionVehicleType vehicleType : this.constructionStage.getInfo().getVehicles()) {
                if (vehicleType.getVehicleClass() != LightUtilityVehicle.class) continue;
                LightUtilityVehicle luv = this.reserveLightUtilityVehicle();
                if (luv != null) {
                    this.constructionVehicles.add(luv);
                    continue;
                }
                this.endMission("Light utility vehicle not available.");
            }
        }
    }

    private void retrieveConstructionLUVParts() {
        if (this.constructionStage != null) {
            this.luvAttachmentParts = new ArrayList<Part>();
            int vehicleIndex = 0;
            Iterator<ConstructionVehicleType> k = this.constructionStage.getInfo().getVehicles().iterator();
            while (k.hasNext()) {
                Vehicle vehicle = null;
                if (this.constructionVehicles.size() > vehicleIndex) {
                    vehicle = this.constructionVehicles.get(vehicleIndex);
                }
                for (Part part : k.next().getAttachmentParts()) {
                    try {
                        this.settlement.getInventory().retrieveItemResources(part, 1);
                        if (vehicle != null) {
                            vehicle.getInventory().storeItemResources(part, 1);
                        }
                        this.luvAttachmentParts.add(part);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error retrieving attachment part " + part.getName());
                        this.endMission("Construction attachment part " + part.getName() + " could not be retrieved.");
                    }
                }
                ++vehicleIndex;
            }
        }
    }

    private LightUtilityVehicle reserveLightUtilityVehicle() {
        LightUtilityVehicle result = null;
        Iterator<Vehicle> i = this.settlement.getParkedVehicles().iterator();
        while (i.hasNext() && result == null) {
            LightUtilityVehicle luvTemp;
            Vehicle vehicle = i.next();
            if (!(vehicle instanceof LightUtilityVehicle) || !(luvTemp = (LightUtilityVehicle)vehicle).getStatus().equals("Parked") || luvTemp.isReserved() || luvTemp.getCrewNum() != 0) continue;
            result = luvTemp;
            luvTemp.setReservedForMission(true);
            Point2D.Double relativeLocSite = LocalAreaUtil.getRandomInteriorLocation(this.constructionSite);
            Point2D.Double settlementLocSite = LocalAreaUtil.getLocalRelativeLocation(relativeLocSite.getX(), relativeLocSite.getY(), this.constructionSite);
            luvTemp.setParkedLocation(settlementLocSite.getX(), settlementLocSite.getY(), RandomUtil.getRandomDouble(360.0));
            if (this.settlement.getInventory().containsUnit(luvTemp)) {
                this.settlement.getInventory().retrieveUnit(luvTemp);
                continue;
            }
            logger.severe("Unable to retrieve " + luvTemp.getName() + " cannot be retrieved from " + this.settlement.getName() + " inventory.");
            this.endMission("Construction vehicle " + luvTemp.getName() + " could not be retrieved from settlement inventory.");
        }
        return result;
    }

    private void unreserveConstructionVehicles() {
        if (this.constructionVehicles != null) {
            for (GroundVehicle vehicle : this.constructionVehicles) {
                vehicle.setReservedForMission(false);
                Inventory vInv = vehicle.getInventory();
                Inventory sInv = this.settlement.getInventory();
                sInv.storeUnit(vehicle);
                vehicle.determinedSettlementParkedLocationAndFacing();
                for (ItemResource attachmentPart : vInv.getAllItemResourcesStored()) {
                    int num = vInv.getItemResourceNum(attachmentPart);
                    vInv.retrieveItemResources(attachmentPart, num);
                    sInv.storeItemResources(attachmentPart, num);
                }
            }
        }
    }

    public List<GroundVehicle> getConstructionVehicles() {
        return new ArrayList<GroundVehicle>(this.constructionVehicles);
    }

    private void salvageConstructionParts() {
        double salvageChance = 50.0;
        salvageChance = this.wearCondition * 0.25 + 25.0;
        double totalSkill = 0.0;
        Iterator<Person> i = this.getPeople().iterator();
        while (i.hasNext()) {
            int constructionSkill = i.next().getMind().getSkillManager().getSkillLevel("Construction");
            totalSkill += (double)constructionSkill;
        }
        double averageSkill = totalSkill / (double)this.getPeopleNumber();
        salvageChance += averageSkill * 5.0;
        Map<Part, Integer> salvagableParts = this.constructionStage.getInfo().getParts();
        for (Part part : salvagableParts.keySet()) {
            double capacity;
            int number = salvagableParts.get(part);
            int salvagedNumber = 0;
            for (int x = 0; x < number; ++x) {
                if (!RandomUtil.lessThanRandPercent(salvageChance)) continue;
                ++salvagedNumber;
            }
            if (salvagedNumber <= 0) continue;
            double mass = (double)salvagedNumber * part.getMassPerItem();
            if (mass <= (capacity = this.settlement.getInventory().getGeneralCapacity())) {
                this.settlement.getInventory().storeItemResources(part, salvagedNumber);
            }
            this.settlement.getGoodsManager().updateGoodValue(GoodsUtil.getResourceGood(part), false);
        }
    }

    @Override
    protected boolean hasEmergency() {
        boolean result = super.hasEmergency();
        try {
            Vehicle vehicleTarget = null;
            Vehicle vehicle = RoverMission.getVehicleWithGreatestRange(this.settlement, true);
            if (vehicle != null && (vehicleTarget = RescueSalvageVehicle.findAvailableBeaconVehicle(this.settlement, vehicle.getRange())) != null && !RescueSalvageVehicle.isClosestCapableSettlement(this.settlement, vehicleTarget)) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public ConstructionSite getConstructionSite() {
        return this.constructionSite;
    }

    public ConstructionStage getConstructionStage() {
        return this.constructionStage;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.settlement = null;
        this.constructionSite = null;
        this.constructionStage = null;
        if (this.constructionVehicles != null) {
            this.constructionVehicles.clear();
        }
        this.constructionVehicles = null;
        this.sitePreparationStartTime = null;
        if (this.luvAttachmentParts != null) {
            this.luvAttachmentParts.clear();
        }
        this.luvAttachmentParts = null;
    }
}

