/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.equipment.Bag;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.CollectResourcesMission;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.goods.GoodsManager;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.vehicle.Rover;

public class CollectIce
extends CollectResourcesMission {
    private static Logger logger = Logger.getLogger(CollectIce.class.getName());
    public static final String DEFAULT_DESCRIPTION = "Ice Prospecting";
    private static final double SITE_GOAL = 1000.0;
    public static final int REQUIRED_BAGS = 20;
    private static final double COLLECTION_RATE = 1.0;
    private static final int NUM_SITES = 1;
    private static final int MIN_PEOPLE = 2;

    public CollectIce(Person startingPerson) {
        super(DEFAULT_DESCRIPTION, startingPerson, CollectIce.getIceResource(), 1000.0, 1.0, Bag.class, 20, 1, 2);
    }

    public CollectIce(Collection<Person> members, Settlement startingSettlement, List<Coordinates> iceCollectionSites, Rover rover, String description) {
        super(description, members, startingSettlement, CollectIce.getIceResource(), 1000.0, 1.0, Bag.class, 20, iceCollectionSites.size(), 1, rover, iceCollectionSites);
    }

    public static double getNewMissionProbability(Person person) {
        double result = CollectResourcesMission.getNewMissionProbability(person, Bag.class, 20, 2, CollectIce.class);
        if (result > 0.0) {
            try {
                GoodsManager manager = person.getSettlement().getGoodsManager();
                AmountResource iceResource = AmountResource.findAmountResource("ice");
                double value = manager.getGoodValuePerItem(GoodsUtil.getResourceGood(iceResource));
                result *= value * 10.0;
                if (result > 100.0) {
                    result = 100.0;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error checking good value of ice.");
            }
            if (Mission.getNumberAvailableEVASuitsAtSettlement(person.getSettlement()) < 2) {
                result = 0.0;
            }
        }
        return result;
    }

    @Override
    protected String getCollectionSiteDescription(int siteNum) {
        return "prospecting site";
    }

    private static AmountResource getIceResource() {
        return AmountResource.findAmountResource("ice");
    }
}

