/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.equipment.Container;
import org.mars_sim.msp.core.equipment.ContainerUtil;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.malfunction.MalfunctionFactory;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.person.ai.mission.Trade;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.task.EnterAirlock;
import org.mars_sim.msp.core.person.ai.task.ExitAirlock;
import org.mars_sim.msp.core.person.ai.task.LoadVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.LoadVehicleGarage;
import org.mars_sim.msp.core.person.ai.task.UnloadVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.UnloadVehicleGarage;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.VehicleMaintenance;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class EmergencySupplyMission
extends RoverMission
implements Serializable {
    private static Logger logger = Logger.getLogger(EmergencySupplyMission.class.getName());
    public static final String DEFAULT_DESCRIPTION = "Deliver Emergency Supplies";
    private static final int MAX_MEMBERS = 2;
    private static final double BASE_STARTING_PROBABILITY = 100.0;
    private static final double VEHICLE_FUEL_DEMAND = 1000.0;
    private static final double VEHICLE_FUEL_REMAINING_MODIFIER = 2.0;
    private static final double MINIMUM_EMERGENCY_SUPPLY_AMOUNT = 100.0;
    public static final String SUPPLY_DELIVERY_DISEMBARKING = "Supply Delivery Disembarking";
    public static final String SUPPLY_DELIVERY = "Unload Supply Goods";
    public static final String LOAD_RETURN_TRIP_SUPPLIES = "Load Return Trip Supplies";
    public static final String RETURN_TRIP_EMBARKING = "Return Trip Embarking";
    private Settlement emergencySettlement;
    private boolean outbound;
    private Map<AmountResource, Double> emergencyResources;
    private Map<Class, Integer> emergencyEquipment;
    private Map<Part, Integer> emergencyParts;
    private Vehicle emergencyVehicle;

    public EmergencySupplyMission(Person startingPerson) {
        super(DEFAULT_DESCRIPTION, startingPerson);
        this.setMissionCapacity(2);
        int availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingPerson.getSettlement());
        if (availableSuitNum < this.getMissionCapacity()) {
            this.setMissionCapacity(availableSuitNum);
        }
        this.outbound = true;
        if (!this.isDone()) {
            this.setStartingSettlement(startingPerson.getSettlement());
            this.emergencySettlement = EmergencySupplyMission.findSettlementNeedingEmergencySupplies(this.getStartingSettlement(), this.getRover());
            if (this.emergencySettlement != null) {
                this.addNavpoint(new NavPoint(this.emergencySettlement.getCoordinates(), this.emergencySettlement, this.emergencySettlement.getName()));
                this.determineNeededEmergencySupplies();
                if (!this.isDone()) {
                    this.recruitPeopleForMission(startingPerson);
                }
            } else {
                this.endMission("No settlement could be found to deliver emergency supplies to.");
            }
        }
        this.addPhase(SUPPLY_DELIVERY_DISEMBARKING);
        this.addPhase(SUPPLY_DELIVERY);
        this.addPhase(LOAD_RETURN_TRIP_SUPPLIES);
        this.addPhase(RETURN_TRIP_EMBARKING);
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
        if (logger.isLoggable(Level.INFO) && startingPerson != null && this.getRover() != null) {
            logger.info(startingPerson.getName() + " starting emergency supply mission from " + this.getStartingSettlement() + " to " + this.getEmergencySettlement() + " using " + this.getRover().getName());
        }
    }

    public EmergencySupplyMission(Collection<Person> members, Settlement startingSettlement, Settlement emergencySettlement, Map<Good, Integer> emergencyGoods, Rover rover, String description) {
        super(description, (Person)members.toArray()[0], 1, rover);
        Person startingPerson;
        this.outbound = true;
        this.setStartingSettlement(startingSettlement);
        this.setMissionCapacity(2);
        int availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingSettlement);
        if (availableSuitNum < this.getMissionCapacity()) {
            this.setMissionCapacity(availableSuitNum);
        }
        this.emergencySettlement = emergencySettlement;
        this.addNavpoint(new NavPoint(emergencySettlement.getCoordinates(), emergencySettlement, emergencySettlement.getName()));
        this.emergencyResources = new HashMap<AmountResource, Double>();
        this.emergencyParts = new HashMap<Part, Integer>();
        this.emergencyEquipment = new HashMap<Class, Integer>();
        block0: for (Good good : emergencyGoods.keySet()) {
            int amount = emergencyGoods.get(good);
            if ("amount resource".equals(good.getCategory())) {
                AmountResource resource = (AmountResource)good.getObject();
                this.emergencyResources.put(resource, Double.valueOf(amount));
                continue;
            }
            if ("item resource".equals(good.getCategory())) {
                Part part = (Part)good.getObject();
                this.emergencyParts.put(part, amount);
                continue;
            }
            if ("equipment".equals(good.getCategory())) {
                Class equipmentClass = good.getClassType();
                this.emergencyEquipment.put(equipmentClass, amount);
                continue;
            }
            if (!"vehicle".equals(good.getCategory())) continue;
            String vehicleType = good.getName();
            for (Vehicle vehicle : startingSettlement.getParkedVehicles()) {
                if (!vehicleType.equalsIgnoreCase(vehicle.getDescription()) || vehicle == this.getVehicle() || vehicle.isReserved()) continue;
                this.emergencyVehicle = vehicle;
                continue block0;
            }
        }
        Iterator<Person> i = members.iterator();
        while (i.hasNext()) {
            i.next().getMind().setMission(this);
        }
        this.addPhase(SUPPLY_DELIVERY_DISEMBARKING);
        this.addPhase(SUPPLY_DELIVERY);
        this.addPhase(LOAD_RETURN_TRIP_SUPPLIES);
        this.addPhase(RETURN_TRIP_EMBARKING);
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
        if (logger.isLoggable(Level.INFO) && (startingPerson = (Person)members.toArray()[0]) != null && this.getRover() != null) {
            logger.info(startingPerson.getName() + " starting emergency supply mission from " + this.getStartingSettlement() + " to " + this.getEmergencySettlement() + "on " + this.getRover().getName());
        }
    }

    public static double getNewMissionProbability(Person person) {
        boolean inSettlement;
        double missionProbability = 0.0;
        Job job = person.getMind().getJob();
        double jobModifier = 0.0;
        if (job != null) {
            jobModifier = job.getStartMissionProbabilityModifier(EmergencySupplyMission.class);
        }
        if ((inSettlement = person.getLocationSituation().equals("In Settlement")) && jobModifier > 0.0) {
            Settlement targetSettlement;
            Rover rover;
            boolean missionPossible = true;
            Settlement settlement = person.getSettlement();
            if (!EmergencySupplyMission.areVehiclesAvailable(settlement, false)) {
                missionPossible = false;
            }
            if (!EmergencySupplyMission.hasBackupRover(settlement)) {
                missionPossible = false;
            }
            if (!EmergencySupplyMission.minAvailablePeopleAtSettlement(settlement, 3)) {
                missionPossible = false;
            }
            if (Mission.getNumberAvailableEVASuitsAtSettlement(settlement) < 2) {
                missionPossible = false;
            }
            if (VehicleMission.hasEmbarkingMissions(settlement)) {
                missionPossible = false;
            }
            if (!RoverMission.hasEnoughBasicResources(settlement)) {
                missionPossible = false;
            }
            if (missionPossible && (rover = (Rover)EmergencySupplyMission.getVehicleWithGreatestRange(settlement, false)) != null && (targetSettlement = EmergencySupplyMission.findSettlementNeedingEmergencySupplies(settlement, rover)) == null) {
                missionPossible = false;
            }
            if (missionPossible) {
                missionProbability = 100.0;
                int crowding = settlement.getCurrentPopulationNum() - settlement.getPopulationCapacity();
                if (crowding > 0) {
                    missionProbability *= (double)(crowding + 1);
                }
                missionProbability *= jobModifier;
            }
        }
        return missionProbability;
    }

    @Override
    protected void determineNewPhase() {
        if ("Embarking".equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
        } else if ("Travelling".equals(this.getPhase())) {
            if (this.getCurrentNavpoint().isSettlementAtNavpoint()) {
                if (this.outbound) {
                    this.setPhase(SUPPLY_DELIVERY_DISEMBARKING);
                    this.setPhaseDescription("Disembarking at " + this.emergencySettlement);
                } else {
                    this.setPhase("Disembarking");
                    this.setPhaseDescription("Disembarking at " + this.getCurrentNavpoint().getDescription());
                }
            }
        } else if (SUPPLY_DELIVERY_DISEMBARKING.equals(this.getPhase())) {
            this.setPhase(SUPPLY_DELIVERY);
            this.setPhaseDescription("Delivering emergency supplies to " + this.emergencySettlement);
        } else if (SUPPLY_DELIVERY.equals(this.getPhase())) {
            this.setPhase(LOAD_RETURN_TRIP_SUPPLIES);
            this.setPhaseDescription("Loading return trip supplies at " + this.emergencySettlement);
        } else if (LOAD_RETURN_TRIP_SUPPLIES.equals(this.getPhase())) {
            this.setPhase(RETURN_TRIP_EMBARKING);
            this.setPhaseDescription("Embarking at " + this.emergencySettlement);
        } else if (RETURN_TRIP_EMBARKING.equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
        } else if ("Disembarking".equals(this.getPhase())) {
            this.endMission("Successfully disembarked.");
        }
    }

    @Override
    protected void performPhase(Person person) {
        super.performPhase(person);
        if (SUPPLY_DELIVERY_DISEMBARKING.equals(this.getPhase())) {
            this.performSupplyDeliveryDisembarkingPhase(person);
        } else if (SUPPLY_DELIVERY.equals(this.getPhase())) {
            this.performSupplyDeliveryPhase(person);
        } else if (LOAD_RETURN_TRIP_SUPPLIES.equals(this.getPhase())) {
            this.performLoadReturnTripSuppliesPhase(person);
        } else if (RETURN_TRIP_EMBARKING.equals(this.getPhase())) {
            this.performReturnTripEmbarkingPhase(person);
        }
    }

    @Override
    protected void performEmbarkFromSettlementPhase(Person person) {
        super.performEmbarkFromSettlementPhase(person);
        if (!this.isDone() && this.getRover().getTowedVehicle() == null && this.emergencyVehicle != null) {
            this.emergencyVehicle.setReservedForMission(true);
            this.getRover().setTowedVehicle(this.emergencyVehicle);
            this.emergencyVehicle.setTowingVehicle(this.getRover());
            this.getStartingSettlement().getInventory().retrieveUnit(this.emergencyVehicle);
        }
    }

    @Override
    protected void performDisembarkToSettlementPhase(Person person, Settlement disembarkSettlement) {
        if (!this.isDone() && this.getRover().getTowedVehicle() != null) {
            this.emergencyVehicle.setReservedForMission(false);
            this.getRover().setTowedVehicle(null);
            this.emergencyVehicle.setTowingVehicle(null);
            disembarkSettlement.getInventory().storeUnit(this.emergencyVehicle);
            this.emergencyVehicle.determinedSettlementParkedLocationAndFacing();
        }
        super.performDisembarkToSettlementPhase(person, disembarkSettlement);
    }

    private void performSupplyDeliveryDisembarkingPhase(Person person) {
        Building garageBuilding = null;
        if (this.getVehicle() != null && this.getVehicle().getSettlement() == null) {
            this.emergencySettlement.getInventory().storeUnit(this.getVehicle());
            this.getVehicle().determinedSettlementParkedLocationAndFacing();
            BuildingManager.addToRandomBuilding((GroundVehicle)this.getVehicle(), this.emergencySettlement);
            garageBuilding = BuildingManager.getBuilding(this.getVehicle());
        }
        if (person.getLocationSituation().equals("In Vehicle")) {
            if (this.isRoverInAGarage()) {
                this.getVehicle().getInventory().retrieveUnit(person);
                this.emergencySettlement.getInventory().storeUnit(person);
                garageBuilding = BuildingManager.getBuilding(this.getVehicle());
                BuildingManager.addPersonToBuilding(person, garageBuilding);
            } else if (ExitAirlock.canExitAirlock(person, this.getRover().getAirlock())) {
                this.assignTask(person, new ExitAirlock(person, this.getRover().getAirlock()));
            } else {
                logger.info(person + " unable to exit " + this.getRover() + " through airlock to settlement " + this.emergencySettlement + " due to health problems or being unable to obtain a functioning EVA suit.  " + "Using emergency exit procedure.");
                this.getVehicle().getInventory().retrieveUnit(person);
                this.emergencySettlement.getInventory().storeUnit(person);
                BuildingManager.addToRandomBuilding(person, this.emergencySettlement);
            }
        } else if (person.getLocationSituation().equals("Outside")) {
            this.assignTask(person, new EnterAirlock(person, this.emergencySettlement.getAvailableAirlock()));
        }
        if (this.isNoOneInRover()) {
            this.setPhaseEnded(true);
        }
    }

    private void performSupplyDeliveryPhase(Person person) {
        boolean roverUnloaded;
        if (this.getRover().getTowedVehicle() != null) {
            this.emergencyVehicle.setReservedForMission(false);
            this.getRover().setTowedVehicle(null);
            this.emergencyVehicle.setTowingVehicle(null);
            this.emergencySettlement.getInventory().storeUnit(this.emergencyVehicle);
            this.emergencyVehicle.determinedSettlementParkedLocationAndFacing();
        }
        boolean bl = roverUnloaded = this.getRover().getInventory().getTotalInventoryMass(false) == 0.0;
        if (!roverUnloaded) {
            if (RandomUtil.lessThanRandPercent(50)) {
                if (this.isRoverInAGarage()) {
                    this.assignTask(person, new UnloadVehicleGarage(person, this.getRover()));
                } else {
                    SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
                    if (surface.getSurfaceSunlight(person.getCoordinates()) > 0.0 || surface.inDarkPolarRegion(person.getCoordinates())) {
                        this.assignTask(person, new UnloadVehicleEVA(person, this.getRover()));
                    }
                }
                return;
            }
        } else {
            this.outbound = false;
            this.addNavpoint(new NavPoint(this.getStartingSettlement().getCoordinates(), this.getStartingSettlement(), this.getStartingSettlement().getName()));
            this.setPhaseEnded(true);
        }
    }

    private void performLoadReturnTripSuppliesPhase(Person person) {
        if (!this.isDone() && !this.isVehicleLoaded()) {
            if (this.isVehicleLoadable()) {
                if (RandomUtil.lessThanRandPercent(50)) {
                    if (this.isRoverInAGarage()) {
                        this.assignTask(person, new LoadVehicleGarage(person, this.getVehicle(), this.getRequiredResourcesToLoad(), this.getOptionalResourcesToLoad(), this.getRequiredEquipmentToLoad(), this.getOptionalEquipmentToLoad()));
                    } else {
                        SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
                        if (surface.getSurfaceSunlight(person.getCoordinates()) > 0.0 || surface.inDarkPolarRegion(person.getCoordinates())) {
                            this.assignTask(person, new LoadVehicleEVA(person, this.getVehicle(), this.getRequiredResourcesToLoad(), this.getOptionalResourcesToLoad(), this.getRequiredEquipmentToLoad(), this.getOptionalEquipmentToLoad()));
                        }
                    }
                }
            } else {
                this.endMission("Vehicle is not loadable (RoverMission).");
            }
        } else {
            this.setPhaseEnded(true);
        }
    }

    private void performReturnTripEmbarkingPhase(Person person) {
        if (!person.getLocationSituation().equals("In Vehicle") && !person.getLocationSituation().equals("Buried")) {
            if (this.isRoverInAGarage()) {
                if (this.getVehicle().getInventory().canStoreUnit(person, false)) {
                    if (this.emergencySettlement.getInventory().containsUnit(person)) {
                        this.emergencySettlement.getInventory().retrieveUnit(person);
                    }
                } else {
                    this.endMission("Crew member " + person + " cannot be loaded in rover " + this.getVehicle());
                    return;
                }
                this.getVehicle().getInventory().storeUnit(person);
                if (this.emergencySettlement.getInventory().findNumUnitsOfClass(EVASuit.class) > 0) {
                    EVASuit suit = (EVASuit)this.emergencySettlement.getInventory().findUnitOfClass(EVASuit.class);
                    if (this.getVehicle().getInventory().canStoreUnit(suit, false)) {
                        this.emergencySettlement.getInventory().retrieveUnit(suit);
                        this.getVehicle().getInventory().storeUnit(suit);
                    } else {
                        this.endMission("Equipment " + suit + " cannot be loaded in rover " + this.getVehicle());
                        return;
                    }
                }
                Point2D.Double vehicleLoc = LocalAreaUtil.getRandomInteriorLocation(this.getVehicle());
                Point2D.Double settlementLoc = LocalAreaUtil.getLocalRelativeLocation(vehicleLoc.getX(), vehicleLoc.getY(), this.getVehicle());
                person.setXLocation(settlementLoc.getX());
                person.setYLocation(settlementLoc.getY());
            } else if (person.getLocationSituation().equals("In Settlement")) {
                if (ExitAirlock.canExitAirlock(person, this.emergencySettlement.getAvailableAirlock())) {
                    this.assignTask(person, new ExitAirlock(person, this.emergencySettlement.getAvailableAirlock()));
                } else {
                    logger.info(person + " unable to exit airlock at " + this.emergencySettlement + " to rover " + this.getRover() + " due to health problems or being unable to obtain a functioning EVA suit.");
                    this.endMission(person + " unable to exit airlock from " + this.emergencySettlement + " due to health problems or being unable to obtain a functioning EVA suit.");
                }
            } else if (person.getLocationSituation().equals("Outside")) {
                this.assignTask(person, new EnterAirlock(person, this.getRover().getAirlock()));
            }
        }
        if (this.isEveryoneInRover()) {
            Building garageBuilding = BuildingManager.getBuilding(this.getVehicle());
            if (garageBuilding != null) {
                VehicleMaintenance garage = (VehicleMaintenance)garageBuilding.getFunction("Ground Vehicle Maintenance");
                garage.removeVehicle(this.getVehicle());
            }
            this.emergencySettlement.getInventory().retrieveUnit(this.getVehicle());
            this.setPhaseEnded(true);
        }
    }

    private static Settlement findSettlementNeedingEmergencySupplies(Settlement startingSettlement, Rover rover) {
        Settlement result = null;
        for (Settlement settlement : Simulation.instance().getUnitManager().getSettlements()) {
            double settlementRange;
            if (settlement == startingSettlement || EmergencySupplyMission.hasCurrentEmergencySupplyMission(settlement) || !((settlementRange = settlement.getCoordinates().getDistance(startingSettlement.getCoordinates())) <= rover.getRange() * 0.8)) continue;
            Map<AmountResource, Double> emergencyResourcesNeeded = EmergencySupplyMission.getEmergencyResourcesNeeded(settlement);
            Map<Class<? extends Container>, Integer> emergencyContainersNeeded = EmergencySupplyMission.getContainersRequired(emergencyResourcesNeeded);
            if (emergencyResourcesNeeded.isEmpty() || !EmergencySupplyMission.hasEnoughSupplies(startingSettlement, emergencyResourcesNeeded, emergencyContainersNeeded)) continue;
            result = settlement;
            break;
        }
        return result;
    }

    private static boolean hasEnoughSupplies(Settlement startingSettlement, Map<AmountResource, Double> emergencyResourcesNeeded, Map<Class<? extends Container>, Integer> emergencyContainersNeeded) {
        boolean result = true;
        Iterator<AmountResource> i = emergencyResourcesNeeded.keySet().iterator();
        while (i.hasNext() && result) {
            AmountResource resource = i.next();
            double amountRequired = emergencyResourcesNeeded.get(resource);
            double amountNeededAtStartingSettlement = EmergencySupplyMission.getResourceAmountNeededAtStartingSettlement(startingSettlement, resource);
            double amountAvailable = startingSettlement.getInventory().getAmountResourceStored(resource, false);
            if (!(amountAvailable < amountRequired + amountNeededAtStartingSettlement)) continue;
            result = false;
        }
        Iterator<Class<? extends Container>> j = emergencyContainersNeeded.keySet().iterator();
        while (j.hasNext() && result) {
            Class<? extends Container> container = j.next();
            int numberRequired = emergencyContainersNeeded.get(container);
            int numberAvailable = startingSettlement.getInventory().findNumEmptyUnitsOfClass(container, false);
            if (numberAvailable >= numberRequired) continue;
            result = false;
        }
        return result;
    }

    private static double getResourceAmountNeededAtStartingSettlement(Settlement startingSettlement, AmountResource resource) {
        double result = 0.0;
        if (resource.isLifeSupport()) {
            AmountResource food;
            AmountResource water;
            double amountNeededSol = 0.0;
            PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
            AmountResource oxygen = AmountResource.findAmountResource("oxygen");
            if (resource.equals(oxygen)) {
                amountNeededSol = config.getOxygenConsumptionRate();
            }
            if (resource.equals(water = AmountResource.findAmountResource("water"))) {
                amountNeededSol = config.getWaterConsumptionRate();
            }
            if (resource.equals(food = AmountResource.findAmountResource("food"))) {
                amountNeededSol = config.getFoodConsumptionRate();
            }
            double amountNeededOrbit = amountNeededSol * 84.0;
            int numPeople = startingSettlement.getAllAssociatedPeople().size();
            result = (double)numPeople * amountNeededOrbit;
        } else {
            AmountResource methane = AmountResource.findAmountResource("methane");
            if (resource.equals(methane)) {
                Iterator<Vehicle> i = startingSettlement.getAllAssociatedVehicles().iterator();
                while (i.hasNext()) {
                    double fuelDemand = i.next().getInventory().getAmountResourceCapacity(resource, false);
                    result += fuelDemand * 2.0;
                }
            }
        }
        return result;
    }

    private static boolean hasCurrentEmergencySupplyMission(Settlement settlement) {
        boolean result = false;
        for (Mission mission : Simulation.instance().getMissionManager().getMissions()) {
            EmergencySupplyMission emergencyMission;
            if (!(mission instanceof EmergencySupplyMission) || !settlement.equals((emergencyMission = (EmergencySupplyMission)mission).getEmergencySettlement())) continue;
            result = true;
            break;
        }
        return result;
    }

    private void determineNeededEmergencySupplies() {
        this.emergencyResources = EmergencySupplyMission.getEmergencyResourcesNeeded(this.emergencySettlement);
        Map<Class<? extends Container>, Integer> containers = EmergencySupplyMission.getContainersRequired(this.emergencyResources);
        this.emergencyEquipment = new HashMap<Class, Integer>(containers.size());
        for (Class<? extends Container> container : containers.keySet()) {
            int number = containers.get(container);
            this.emergencyEquipment.put(container, number);
        }
        this.emergencyParts = EmergencySupplyMission.getEmergencyPartsNeeded(this.emergencySettlement);
    }

    private static Map<AmountResource, Double> getEmergencyResourcesNeeded(Settlement settlement) {
        HashMap<AmountResource, Double> result = new HashMap<AmountResource, Double>();
        double solsMonth = 28.0;
        int numPeople = settlement.getAllAssociatedPeople().size();
        PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenAmountNeeded = config.getOxygenConsumptionRate() * (double)numPeople * solsMonth;
        double oxygenAmountAvailable = settlement.getInventory().getAmountResourceStored(oxygen, false);
        if ((oxygenAmountAvailable += EmergencySupplyMission.getResourcesOnMissions(settlement, oxygen)) < oxygenAmountNeeded) {
            double oxygenAmountEmergency = oxygenAmountNeeded - oxygenAmountAvailable;
            if (oxygenAmountEmergency < 100.0) {
                oxygenAmountEmergency = 100.0;
            }
            result.put(oxygen, oxygenAmountEmergency);
        }
        AmountResource water = AmountResource.findAmountResource("water");
        double waterAmountNeeded = config.getWaterConsumptionRate() * (double)numPeople * solsMonth;
        double waterAmountAvailable = settlement.getInventory().getAmountResourceStored(water, false);
        if ((waterAmountAvailable += EmergencySupplyMission.getResourcesOnMissions(settlement, water)) < waterAmountNeeded) {
            double waterAmountEmergency = waterAmountNeeded - waterAmountAvailable;
            if (waterAmountEmergency < 100.0) {
                waterAmountEmergency = 100.0;
            }
            result.put(water, waterAmountEmergency);
        }
        AmountResource food = AmountResource.findAmountResource("food");
        double foodAmountNeeded = config.getFoodConsumptionRate() * (double)numPeople * solsMonth;
        double foodAmountAvailable = settlement.getInventory().getAmountResourceStored(food, false);
        if ((foodAmountAvailable += EmergencySupplyMission.getResourcesOnMissions(settlement, food)) < foodAmountNeeded) {
            double foodAmountEmergency = foodAmountNeeded - foodAmountAvailable;
            if (foodAmountEmergency < 100.0) {
                foodAmountEmergency = 100.0;
            }
            result.put(food, foodAmountEmergency);
        }
        AmountResource methane = AmountResource.findAmountResource("methane");
        double methaneAmountNeeded = 1000.0;
        double methaneAmountAvailable = settlement.getInventory().getAmountResourceStored(methane, false);
        if ((methaneAmountAvailable += EmergencySupplyMission.getResourcesOnMissions(settlement, methane)) < methaneAmountNeeded) {
            double methaneAmountEmergency = methaneAmountNeeded - methaneAmountAvailable;
            if (methaneAmountEmergency < 100.0) {
                methaneAmountEmergency = 100.0;
            }
            result.put(methane, methaneAmountEmergency);
        }
        return result;
    }

    private static double getResourcesOnMissions(Settlement settlement, AmountResource resource) {
        double result = 0.0;
        MissionManager manager = Simulation.instance().getMissionManager();
        for (Mission mission : manager.getMissionsForSettlement(settlement)) {
            Rover rover;
            if (!(mission instanceof RoverMission)) continue;
            RoverMission roverMission = (RoverMission)mission;
            boolean isTradeMission = roverMission instanceof Trade;
            boolean isEmergencySupplyMission = roverMission instanceof EmergencySupplyMission;
            if (isTradeMission || isEmergencySupplyMission || (rover = roverMission.getRover()) == null) continue;
            result += rover.getInventory().getAmountResourceStored(resource, false);
        }
        return result;
    }

    private static Map<Class<? extends Container>, Integer> getContainersRequired(Map<AmountResource, Double> resources) {
        HashMap<Class<? extends Container>, Integer> result = new HashMap<Class<? extends Container>, Integer>();
        for (AmountResource resource : resources.keySet()) {
            Class<? extends Container> containerClass = ContainerUtil.getContainerClassToHoldResource(resource);
            if (containerClass != null) {
                double resourceAmount = resources.get(resource);
                double containerCapacity = ContainerUtil.getContainerCapacity(containerClass);
                int numContainers = (int)Math.ceil(resourceAmount / containerCapacity);
                result.put(containerClass, numContainers);
                continue;
            }
            throw new IllegalStateException("No container found to hold resource: " + resource);
        }
        return result;
    }

    private static Map<Part, Integer> getEmergencyPartsNeeded(Settlement settlement) {
        HashMap<Part, Integer> result = new HashMap<Part, Integer>();
        for (Malfunctionable entity : MalfunctionFactory.getAssociatedMalfunctionables(settlement)) {
            for (Malfunction malfunction : entity.getMalfunctionManager().getMalfunctions()) {
                Map<Part, Integer> repairParts = malfunction.getRepairParts();
                for (Part part : repairParts.keySet()) {
                    int number = repairParts.get(part);
                    if (settlement.getInventory().hasItemResource(part)) continue;
                    if (result.containsKey(part)) {
                        number += ((Integer)result.get(part)).intValue();
                    }
                    result.put(part, number);
                }
            }
            Map<Part, Integer> maintParts = entity.getMalfunctionManager().getMaintenanceParts();
            for (Part part : maintParts.keySet()) {
                int number = maintParts.get(part);
                if (settlement.getInventory().hasItemResource(part)) continue;
                if (result.containsKey(part)) {
                    number += ((Integer)result.get(part)).intValue();
                }
                result.put(part, number);
            }
        }
        return result;
    }

    public Settlement getEmergencySettlement() {
        return this.emergencySettlement;
    }

    @Override
    public Settlement getAssociatedSettlement() {
        return this.getStartingSettlement();
    }

    @Override
    public Map<Class, Integer> getEquipmentNeededForRemainingMission(boolean useBuffer) {
        return new HashMap<Class, Integer>(0);
    }

    @Override
    protected int compareVehicles(Vehicle firstVehicle, Vehicle secondVehicle) {
        int result = super.compareVehicles(firstVehicle, secondVehicle);
        if (result == 0 && this.isUsableVehicle(firstVehicle) && this.isUsableVehicle(secondVehicle)) {
            double secondCapacity;
            double firstCapacity = firstVehicle.getInventory().getGeneralCapacity();
            if (firstCapacity > (secondCapacity = secondVehicle.getInventory().getGeneralCapacity())) {
                result = 1;
            } else if (secondCapacity > firstCapacity) {
                result = -1;
            }
            if (result == 0) {
                if (firstVehicle.getRange() > secondVehicle.getRange()) {
                    result = 1;
                } else if (firstVehicle.getRange() < secondVehicle.getRange()) {
                    result = -1;
                }
            }
        }
        return result;
    }

    @Override
    protected void recruitPeopleForMission(Person startingPerson) {
        super.recruitPeopleForMission(startingPerson);
        if (!EmergencySupplyMission.atLeastOnePersonRemainingAtSettlement(this.getStartingSettlement(), startingPerson)) {
            Person lastPerson = null;
            int amount = this.getPeopleNumber() - 1;
            Object[] array = this.getPeople().toArray();
            if (amount >= 0 && amount < array.length) {
                lastPerson = (Person)array[amount];
            }
            if (lastPerson != null) {
                lastPerson.getMind().setMission(null);
                if (this.getPeopleNumber() < this.getMinPeople()) {
                    this.endMission("Not enough members.");
                }
            }
        }
    }

    @Override
    public Map<Resource, Number> getRequiredResourcesToLoad() {
        Map<Resource, Number> result = super.getResourcesNeededForRemainingMission(true);
        if (this.outbound && this.emergencyResources != null) {
            for (AmountResource resource : this.emergencyResources.keySet()) {
                double amount = this.emergencyResources.get(resource);
                if (result.containsKey(resource)) {
                    amount += ((Double)result.get(resource)).doubleValue();
                }
                result.put(resource, amount);
            }
        }
        return result;
    }

    @Override
    public Map<Resource, Number> getOptionalResourcesToLoad() {
        Map<Resource, Number> result = super.getOptionalResourcesToLoad();
        if (this.outbound && this.emergencyParts != null) {
            for (Part part : this.emergencyParts.keySet()) {
                int num = this.emergencyParts.get(part);
                if (result.containsKey(part)) {
                    num += ((Integer)result.get(part)).intValue();
                }
                result.put(part, num);
            }
        }
        return result;
    }

    @Override
    public Map<Class, Integer> getRequiredEquipmentToLoad() {
        Map<Class, Integer> result = this.getEquipmentNeededForRemainingMission(true);
        if (this.outbound && this.emergencyEquipment != null) {
            for (Class equipment : this.emergencyEquipment.keySet()) {
                int num = this.emergencyEquipment.get(equipment);
                if (result.containsKey(equipment)) {
                    num += result.get(equipment).intValue();
                }
                result.put(equipment, num);
            }
        }
        return result;
    }

    public Map<Good, Integer> getEmergencySuppliesAsGoods() {
        HashMap<Good, Integer> result = new HashMap<Good, Integer>();
        for (AmountResource resource : this.emergencyResources.keySet()) {
            double amount = this.emergencyResources.get(resource);
            Good resourceGood = GoodsUtil.getResourceGood(resource);
            result.put(resourceGood, (int)amount);
        }
        for (Part part : this.emergencyParts.keySet()) {
            int number = this.emergencyParts.get(part);
            Good partGood = GoodsUtil.getResourceGood(part);
            result.put(partGood, number);
        }
        for (Class equipmentClass : this.emergencyEquipment.keySet()) {
            int number = this.emergencyEquipment.get(equipmentClass);
            Good equipmentGood = GoodsUtil.getEquipmentGood(equipmentClass);
            result.put(equipmentGood, number);
        }
        if (this.emergencyVehicle != null) {
            Good vehicleGood = GoodsUtil.getVehicleGood(this.emergencyVehicle.getDescription());
            result.put(vehicleGood, 1);
        }
        return result;
    }

    @Override
    public void endMission(String reason) {
        super.endMission(reason);
        if (this.getRover() != null && this.getRover().getTowedVehicle() != null) {
            Vehicle towed = this.getRover().getTowedVehicle();
            towed.setReservedForMission(false);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.emergencySettlement = null;
        if (this.emergencyResources != null) {
            this.emergencyResources.clear();
            this.emergencyResources = null;
        }
        if (this.emergencyEquipment != null) {
            this.emergencyEquipment.clear();
            this.emergencyEquipment = null;
        }
        if (this.emergencyParts != null) {
            this.emergencyParts.clear();
            this.emergencyParts = null;
        }
    }
}

