/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.io.Serializable;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.structure.Settlement;

public class NavPoint
implements Serializable {
    private Coordinates location;
    private Settlement settlement;
    private String description;

    public NavPoint(Coordinates location, String description) {
        if (location == null) {
            throw new IllegalArgumentException("location is null");
        }
        this.location = new Coordinates(location);
        this.description = description;
    }

    public NavPoint(Coordinates location, Settlement settlement, String description) {
        this(location, description);
        if (settlement == null) {
            throw new IllegalArgumentException("settlement is null");
        }
        this.settlement = settlement;
    }

    public Coordinates getLocation() {
        return new Coordinates(this.location);
    }

    public String getDescription() {
        return this.description;
    }

    public Settlement getSettlement() {
        return this.settlement;
    }

    public boolean isSettlementAtNavpoint() {
        return this.settlement != null;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof NavPoint) {
            NavPoint otherNavpoint = (NavPoint)object;
            if (this.getLocation().equals(otherNavpoint.getLocation())) {
                if (this.isSettlementAtNavpoint()) {
                    if (this.settlement.equals(otherNavpoint.settlement)) {
                        result = true;
                    }
                } else {
                    result = true;
                }
            }
        }
        return result;
    }

    public int hashCode() {
        return this.getLocation().hashCode() * this.settlement.hashCode();
    }
}

