/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.person.ai.mission.TradeUtil;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.task.EnterAirlock;
import org.mars_sim.msp.core.person.ai.task.ExitAirlock;
import org.mars_sim.msp.core.person.ai.task.LoadVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.LoadVehicleGarage;
import org.mars_sim.msp.core.person.ai.task.NegotiateTrade;
import org.mars_sim.msp.core.person.ai.task.UnloadVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.UnloadVehicleGarage;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Resource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.VehicleMaintenance;
import org.mars_sim.msp.core.structure.goods.CreditManager;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class Trade
extends RoverMission
implements Serializable {
    private static Logger logger = Logger.getLogger(Trade.class.getName());
    public static final String BUY_LOAD_EVENT = "buy load";
    public static final String DEFAULT_DESCRIPTION = "Trade with Settlement";
    public static final String TRADE_DISEMBARKING = "Trade Disembarking";
    public static final String TRADE_NEGOTIATING = "Trade Negotiating";
    public static final String UNLOAD_GOODS = "Unload Goods";
    public static final String LOAD_GOODS = "Load Goods";
    public static final String TRADE_EMBARKING = "Trade Embarking";
    static final int MAX_MEMBERS = 2;
    private static final double MAX_STARTING_PROBABILITY = 10.0;
    private static final Map<Settlement, TradeProfitInfo> TRADE_PROFIT_CACHE = new HashMap<Settlement, TradeProfitInfo>();
    private static final Map<Settlement, Settlement> TRADE_SETTLEMENT_CACHE = new HashMap<Settlement, Settlement>();
    private Settlement tradingSettlement;
    private Map<Good, Integer> sellLoad;
    private Map<Good, Integer> buyLoad;
    private double profit;
    private Map<Good, Integer> desiredBuyLoad;
    private double desiredProfit;
    private boolean outbound;
    private MarsClock startNegotiationTime;
    private NegotiateTrade negotiationTask;
    private boolean doNegotiation;

    public Trade(Person startingPerson) {
        super(DEFAULT_DESCRIPTION, startingPerson);
        this.setMissionCapacity(2);
        int availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingPerson.getSettlement());
        if (availableSuitNum < this.getMissionCapacity()) {
            this.setMissionCapacity(availableSuitNum);
        }
        this.outbound = true;
        this.doNegotiation = true;
        if (!this.isDone()) {
            this.setStartingSettlement(startingPerson.getSettlement());
            this.tradingSettlement = TRADE_SETTLEMENT_CACHE.get(this.getStartingSettlement());
            if (this.tradingSettlement != null && this.tradingSettlement != this.getStartingSettlement()) {
                this.addNavpoint(new NavPoint(this.tradingSettlement.getCoordinates(), this.tradingSettlement, this.tradingSettlement.getName()));
                this.setDescription("Trade with " + this.tradingSettlement.getName());
                TRADE_PROFIT_CACHE.remove(this.getStartingSettlement());
                TRADE_PROFIT_CACHE.remove(this.tradingSettlement);
                TRADE_SETTLEMENT_CACHE.remove(this.getStartingSettlement());
                TRADE_SETTLEMENT_CACHE.remove(this.tradingSettlement);
            } else {
                this.endMission("Could not determine trading settlement.");
            }
            if (!this.isDone()) {
                CreditManager creditManager = Simulation.instance().getCreditManager();
                double credit = creditManager.getCredit(this.getStartingSettlement(), this.tradingSettlement);
                this.desiredBuyLoad = credit > -1.0E7 ? TradeUtil.getDesiredBuyLoad(this.getStartingSettlement(), this.getRover(), this.tradingSettlement) : new HashMap<Good, Integer>(0);
                this.sellLoad = credit < 1.0E7 ? TradeUtil.determineBestSellLoad(this.getStartingSettlement(), this.getRover(), this.tradingSettlement) : new HashMap<Good, Integer>(0);
                this.desiredProfit = this.estimateTradeProfit(this.desiredBuyLoad);
            }
            if (!this.isDone()) {
                this.recruitPeopleForMission(startingPerson);
            }
        }
        this.addPhase(TRADE_DISEMBARKING);
        this.addPhase(TRADE_NEGOTIATING);
        this.addPhase(UNLOAD_GOODS);
        this.addPhase(LOAD_GOODS);
        this.addPhase(TRADE_EMBARKING);
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
        if (logger.isLoggable(Level.INFO) && startingPerson != null && this.getRover() != null) {
            logger.info(startingPerson.getName() + " starting Trade mission on " + this.getRover().getName());
        }
    }

    public Trade(Collection<Person> members, Settlement startingSettlement, Settlement tradingSettlement, Rover rover, String description, Map<Good, Integer> sellGoods, Map<Good, Integer> buyGoods) {
        super(description, (Person)members.toArray()[0], 1, rover);
        Person startingPerson;
        this.outbound = true;
        this.doNegotiation = false;
        this.setStartingSettlement(startingSettlement);
        this.setMissionCapacity(2);
        int availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingSettlement);
        if (availableSuitNum < this.getMissionCapacity()) {
            this.setMissionCapacity(availableSuitNum);
        }
        this.tradingSettlement = tradingSettlement;
        this.addNavpoint(new NavPoint(tradingSettlement.getCoordinates(), tradingSettlement, tradingSettlement.getName()));
        Iterator<Person> i = members.iterator();
        while (i.hasNext()) {
            i.next().getMind().setMission(this);
        }
        this.sellLoad = sellGoods;
        this.buyLoad = buyGoods;
        this.desiredBuyLoad = new HashMap<Good, Integer>(buyGoods);
        this.desiredProfit = this.profit = this.estimateTradeProfit(this.buyLoad);
        this.addPhase(TRADE_DISEMBARKING);
        this.addPhase(TRADE_NEGOTIATING);
        this.addPhase(UNLOAD_GOODS);
        this.addPhase(LOAD_GOODS);
        this.addPhase(TRADE_EMBARKING);
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
        if (logger.isLoggable(Level.INFO) && (startingPerson = (Person)members.toArray()[0]) != null && this.getRover() != null) {
            logger.info(startingPerson.getName() + " starting Trade mission on " + this.getRover().getName());
        }
    }

    public static double getNewMissionProbability(Person person) {
        double missionProbability = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            boolean missionPossible = true;
            Settlement settlement = person.getSettlement();
            if (!Trade.areVehiclesAvailable(settlement, false)) {
                missionPossible = false;
            }
            if (!Trade.hasBackupRover(settlement)) {
                missionPossible = false;
            }
            if (!Trade.minAvailablePeopleAtSettlement(settlement, 3)) {
                missionPossible = false;
            }
            if (Mission.getNumberAvailableEVASuitsAtSettlement(settlement) < 2) {
                missionPossible = false;
            }
            double tradeProfit = 0.0;
            try {
                Rover rover = (Rover)Trade.getVehicleWithGreatestRange(settlement, false);
                if (rover != null) {
                    boolean useCache = false;
                    MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
                    if (TRADE_PROFIT_CACHE.containsKey(settlement)) {
                        TradeProfitInfo profitInfo = TRADE_PROFIT_CACHE.get(settlement);
                        double timeDiff = MarsClock.getTimeDiff(currentTime, profitInfo.time);
                        if (timeDiff < 2000.0) {
                            tradeProfit = profitInfo.profit;
                            useCache = true;
                        }
                    } else {
                        TRADE_PROFIT_CACHE.put(settlement, new TradeProfitInfo(tradeProfit, (MarsClock)currentTime.clone()));
                        useCache = true;
                    }
                    if (!useCache) {
                        double startTime = System.currentTimeMillis();
                        tradeProfit = TradeUtil.getBestTradeProfit(settlement, rover);
                        double endTime = System.currentTimeMillis();
                        logger.info(settlement.getName() + " getBestTradeProfit: " + (endTime - startTime) + " milliseconds - TP: " + (int)tradeProfit + " VP");
                        TRADE_PROFIT_CACHE.put(settlement, new TradeProfitInfo(tradeProfit, (MarsClock)currentTime.clone()));
                        TRADE_SETTLEMENT_CACHE.put(settlement, TradeUtil.bestTradeSettlementCache);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error finding vehicles at settlement.", e);
            }
            if (VehicleMission.hasEmbarkingMissions(settlement)) {
                missionPossible = false;
            }
            if (!RoverMission.hasEnoughBasicResources(settlement)) {
                missionPossible = false;
            }
            AmountResource methane = AmountResource.findAmountResource("methane");
            if (settlement.getInventory().getAmountResourceStored(methane, false) < 1000.0) {
                missionPossible = false;
            }
            if (missionPossible) {
                Job job;
                int crowding;
                missionProbability = tradeProfit / 1000.0;
                if (missionProbability > 10.0) {
                    missionProbability = 10.0;
                }
                if ((crowding = settlement.getCurrentPopulationNum() - settlement.getPopulationCapacity()) > 0) {
                    missionProbability *= (double)(crowding + 1);
                }
                if ((job = person.getMind().getJob()) != null) {
                    missionProbability *= job.getStartMissionProbabilityModifier(Trade.class);
                }
            }
        }
        return missionProbability;
    }

    @Override
    protected void determineNewPhase() {
        if ("Embarking".equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
        } else if ("Travelling".equals(this.getPhase())) {
            if (this.getCurrentNavpoint().isSettlementAtNavpoint()) {
                if (this.outbound) {
                    this.setPhase(TRADE_DISEMBARKING);
                    this.setPhaseDescription("Disembarking at " + this.tradingSettlement);
                } else {
                    this.setPhase("Disembarking");
                    this.setPhaseDescription("Disembarking at " + this.getCurrentNavpoint().getDescription());
                }
            }
        } else if (TRADE_DISEMBARKING.equals(this.getPhase())) {
            this.setPhase(TRADE_NEGOTIATING);
            this.setPhaseDescription("Negotiating trade at " + this.tradingSettlement);
        } else if (TRADE_NEGOTIATING.equals(this.getPhase())) {
            this.setPhase(UNLOAD_GOODS);
            this.setPhaseDescription("Unloading sell goods at " + this.tradingSettlement);
        } else if (UNLOAD_GOODS.equals(this.getPhase())) {
            this.setPhase(LOAD_GOODS);
            this.setPhaseDescription("Loading buy goods at " + this.tradingSettlement);
        } else if (LOAD_GOODS.equals(this.getPhase())) {
            this.setPhase(TRADE_EMBARKING);
            this.setPhaseDescription("Embarking at " + this.tradingSettlement);
        } else if (TRADE_EMBARKING.equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
        } else if ("Disembarking".equals(this.getPhase())) {
            this.endMission("Successfully disembarked.");
        }
    }

    @Override
    protected void performPhase(Person person) {
        super.performPhase(person);
        if (TRADE_DISEMBARKING.equals(this.getPhase())) {
            this.performTradeDisembarkingPhase(person);
        } else if (TRADE_NEGOTIATING.equals(this.getPhase())) {
            this.performTradeNegotiatingPhase(person);
        } else if (UNLOAD_GOODS.equals(this.getPhase())) {
            this.performUnloadGoodsPhase(person);
        } else if (LOAD_GOODS.equals(this.getPhase())) {
            this.performLoadGoodsPhase(person);
        } else if (TRADE_EMBARKING.equals(this.getPhase())) {
            this.performTradeEmbarkingPhase(person);
        }
    }

    private void performTradeDisembarkingPhase(Person person) {
        Building garageBuilding = null;
        if (this.getVehicle() != null && this.getVehicle().getSettlement() == null) {
            this.tradingSettlement.getInventory().storeUnit(this.getVehicle());
            this.getVehicle().determinedSettlementParkedLocationAndFacing();
            BuildingManager.addToRandomBuilding((GroundVehicle)this.getVehicle(), this.tradingSettlement);
            garageBuilding = BuildingManager.getBuilding(this.getVehicle());
        }
        if (person.getLocationSituation().equals("In Vehicle")) {
            if (this.isRoverInAGarage()) {
                this.getVehicle().getInventory().retrieveUnit(person);
                this.tradingSettlement.getInventory().storeUnit(person);
                garageBuilding = BuildingManager.getBuilding(this.getVehicle());
                BuildingManager.addPersonToBuilding(person, garageBuilding);
            } else if (ExitAirlock.canExitAirlock(person, this.getRover().getAirlock())) {
                this.assignTask(person, new ExitAirlock(person, this.getRover().getAirlock()));
            } else {
                logger.info(person + " unable to exit " + this.getRover() + " through airlock to settlement " + this.tradingSettlement + " due to health problems or being unable to obtain a functioning EVA suit.  " + "Using emergency exit procedure.");
                this.getVehicle().getInventory().retrieveUnit(person);
                this.tradingSettlement.getInventory().storeUnit(person);
                BuildingManager.addToRandomBuilding(person, this.tradingSettlement);
            }
        } else if (person.getLocationSituation().equals("Outside")) {
            this.assignTask(person, new EnterAirlock(person, this.tradingSettlement.getAvailableAirlock()));
        }
        if (this.isNoOneInRover()) {
            this.setPhaseEnded(true);
        }
    }

    private void performTradeNegotiatingPhase(Person person) {
        if (this.doNegotiation) {
            if (person == this.getMissionTrader()) {
                if (this.negotiationTask != null) {
                    if (this.negotiationTask.isDone()) {
                        this.buyLoad = this.negotiationTask.getBuyLoad();
                        this.profit = this.estimateTradeProfit(this.buyLoad);
                        this.fireMissionUpdate(BUY_LOAD_EVENT);
                        this.setPhaseEnded(true);
                    }
                } else {
                    Person settlementTrader;
                    if (this.startNegotiationTime == null) {
                        this.startNegotiationTime = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
                    }
                    if ((settlementTrader = this.getSettlementTrader()) != null) {
                        this.negotiationTask = new NegotiateTrade(this.tradingSettlement, this.getStartingSettlement(), this.getRover(), this.sellLoad, person, settlementTrader);
                        this.assignTask(person, this.negotiationTask);
                    } else {
                        MarsClock currentTime = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
                        double timeDiff = MarsClock.getTimeDiff(currentTime, this.startNegotiationTime);
                        if (timeDiff > 1000.0) {
                            this.buyLoad = new HashMap<Good, Integer>(0);
                            this.profit = 0.0;
                            this.fireMissionUpdate(BUY_LOAD_EVENT);
                            this.setPhaseEnded(true);
                        }
                    }
                }
            }
        } else {
            this.setPhaseEnded(true);
        }
        if (this.getPhaseEnded()) {
            this.outbound = false;
            this.equipmentNeededCache = null;
            this.addNavpoint(new NavPoint(this.getStartingSettlement().getCoordinates(), this.getStartingSettlement(), this.getStartingSettlement().getName()));
            TRADE_PROFIT_CACHE.remove(this.getStartingSettlement());
        }
    }

    private void performUnloadGoodsPhase(Person person) {
        boolean roverUnloaded;
        this.unloadTowedVehicle();
        boolean bl = roverUnloaded = this.getRover().getInventory().getTotalInventoryMass(false) == 0.0;
        if (!roverUnloaded) {
            if (RandomUtil.lessThanRandPercent(50)) {
                if (this.isRoverInAGarage()) {
                    this.assignTask(person, new UnloadVehicleGarage(person, this.getRover()));
                } else {
                    SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
                    if (surface.getSurfaceSunlight(person.getCoordinates()) > 0.0 || surface.inDarkPolarRegion(person.getCoordinates())) {
                        this.assignTask(person, new UnloadVehicleEVA(person, this.getRover()));
                    }
                }
                return;
            }
        } else {
            this.setPhaseEnded(true);
        }
    }

    private void performLoadGoodsPhase(Person person) {
        if (!this.isDone()) {
            this.loadTowedVehicle();
        }
        if (!this.isDone() && !this.isVehicleLoaded()) {
            if (this.isVehicleLoadable()) {
                if (RandomUtil.lessThanRandPercent(50)) {
                    if (this.isRoverInAGarage()) {
                        this.assignTask(person, new LoadVehicleGarage(person, this.getVehicle(), this.getRequiredResourcesToLoad(), this.getOptionalResourcesToLoad(), this.getRequiredEquipmentToLoad(), this.getOptionalEquipmentToLoad()));
                    } else {
                        SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
                        if (surface.getSurfaceSunlight(person.getCoordinates()) > 0.0 || surface.inDarkPolarRegion(person.getCoordinates())) {
                            this.assignTask(person, new LoadVehicleEVA(person, this.getVehicle(), this.getRequiredResourcesToLoad(), this.getOptionalResourcesToLoad(), this.getRequiredEquipmentToLoad(), this.getOptionalEquipmentToLoad()));
                        }
                    }
                }
            } else {
                this.endMission("Vehicle is not loadable (RoverMission).");
            }
        } else {
            this.setPhaseEnded(true);
        }
    }

    private void unloadTowedVehicle() {
        Vehicle towed = this.getRover().getTowedVehicle();
        if (towed != null) {
            towed.setReservedForMission(false);
            this.getRover().setTowedVehicle(null);
            towed.setTowingVehicle(null);
            this.tradingSettlement.getInventory().storeUnit(towed);
            towed.determinedSettlementParkedLocationAndFacing();
        }
    }

    private void loadTowedVehicle() {
        String vehicleType;
        if (!this.isDone() && this.getRover().getTowedVehicle() == null && (vehicleType = this.getLoadVehicleType(true)) != null) {
            Vehicle buyVehicle = this.getInitialLoadVehicle(vehicleType, true);
            if (buyVehicle != null) {
                buyVehicle.setReservedForMission(true);
                this.getRover().setTowedVehicle(buyVehicle);
                buyVehicle.setTowingVehicle(this.getRover());
                this.tradingSettlement.getInventory().retrieveUnit(buyVehicle);
            } else {
                this.endMission("Selling vehicle (" + vehicleType + ") is not available (Trade).");
            }
        }
    }

    private void performTradeEmbarkingPhase(Person person) {
        if (!(this.isDone() || person.getLocationSituation().equals("In Vehicle") || person.getLocationSituation().equals("Buried"))) {
            if (this.isRoverInAGarage()) {
                if (this.getVehicle().getInventory().canStoreUnit(person, false)) {
                    if (this.tradingSettlement.getInventory().containsUnit(person)) {
                        this.tradingSettlement.getInventory().retrieveUnit(person);
                    }
                } else {
                    this.endMission("Crew member " + person + " cannot be loaded in rover " + this.getVehicle());
                    return;
                }
                this.getVehicle().getInventory().storeUnit(person);
                if (this.tradingSettlement.getInventory().findNumUnitsOfClass(EVASuit.class) > 0) {
                    EVASuit suit = (EVASuit)this.tradingSettlement.getInventory().findUnitOfClass(EVASuit.class);
                    if (this.getVehicle().getInventory().canStoreUnit(suit, false)) {
                        this.tradingSettlement.getInventory().retrieveUnit(suit);
                        this.getVehicle().getInventory().storeUnit(suit);
                    } else {
                        this.endMission("Equipment " + suit + " cannot be loaded in rover " + this.getVehicle());
                        return;
                    }
                }
                Point2D.Double vehicleLoc = LocalAreaUtil.getRandomInteriorLocation(this.getVehicle());
                Point2D.Double settlementLoc = LocalAreaUtil.getLocalRelativeLocation(vehicleLoc.getX(), vehicleLoc.getY(), this.getVehicle());
                person.setXLocation(settlementLoc.getX());
                person.setYLocation(settlementLoc.getY());
            } else if (person.getLocationSituation().equals("In Settlement")) {
                if (ExitAirlock.canExitAirlock(person, this.tradingSettlement.getAvailableAirlock())) {
                    this.assignTask(person, new ExitAirlock(person, this.tradingSettlement.getAvailableAirlock()));
                } else {
                    logger.info(person + " unable to exit airlock at " + this.tradingSettlement + " to rover " + this.getRover() + " due to health problems or being unable to obtain a functioning EVA suit.");
                    this.endMission(person + " unable to exit airlock from " + this.tradingSettlement + " due to health problems or being unable to obtain a functioning EVA suit.");
                }
            } else if (person.getLocationSituation().equals("Outside")) {
                this.assignTask(person, new EnterAirlock(person, this.getRover().getAirlock()));
            }
        }
        if (!this.isDone() && this.isEveryoneInRover()) {
            Building garageBuilding = BuildingManager.getBuilding(this.getVehicle());
            if (garageBuilding != null) {
                VehicleMaintenance garage = (VehicleMaintenance)garageBuilding.getFunction("Ground Vehicle Maintenance");
                garage.removeVehicle(this.getVehicle());
            }
            this.tradingSettlement.getInventory().retrieveUnit(this.getVehicle());
            this.setPhaseEnded(true);
        }
    }

    @Override
    protected void performEmbarkFromSettlementPhase(Person person) {
        String vehicleType;
        super.performEmbarkFromSettlementPhase(person);
        if (!this.isDone() && this.getRover().getTowedVehicle() == null && (vehicleType = this.getLoadVehicleType(false)) != null) {
            Vehicle sellVehicle = this.getInitialLoadVehicle(vehicleType, false);
            if (sellVehicle != null) {
                sellVehicle.setReservedForMission(true);
                this.getRover().setTowedVehicle(sellVehicle);
                sellVehicle.setTowingVehicle(this.getRover());
                this.getStartingSettlement().getInventory().retrieveUnit(sellVehicle);
            } else {
                this.endMission("Selling vehicle (" + vehicleType + ") is not available (Trade).");
            }
        }
    }

    @Override
    protected void performDisembarkToSettlementPhase(Person person, Settlement disembarkSettlement) {
        if (!this.isDone() && this.getRover().getTowedVehicle() != null) {
            Vehicle towed = this.getRover().getTowedVehicle();
            towed.setReservedForMission(false);
            this.getRover().setTowedVehicle(null);
            towed.setTowingVehicle(null);
            disembarkSettlement.getInventory().storeUnit(towed);
            towed.determinedSettlementParkedLocationAndFacing();
        }
        super.performDisembarkToSettlementPhase(person, disembarkSettlement);
    }

    @Override
    public void endMission(String reason) {
        super.endMission(reason);
        if (this.getRover() != null && this.getRover().getTowedVehicle() != null) {
            Vehicle towed = this.getRover().getTowedVehicle();
            towed.setReservedForMission(false);
        }
    }

    private String getLoadVehicleType(boolean buy) {
        String result = null;
        Map<Good, Integer> load = null;
        load = buy ? this.buyLoad : this.sellLoad;
        for (Good good : load.keySet()) {
            if (!good.getCategory().equals("vehicle")) continue;
            result = good.getName();
        }
        return result;
    }

    private Vehicle getInitialLoadVehicle(String vehicleType, boolean buy) {
        Vehicle result = null;
        if (vehicleType != null) {
            Settlement settlement = null;
            settlement = buy ? this.tradingSettlement : this.getStartingSettlement();
            for (Vehicle vehicle : settlement.getParkedVehicles()) {
                if (!vehicleType.equalsIgnoreCase(vehicle.getDescription()) || vehicle == this.getVehicle() || vehicle.isReserved()) continue;
                result = vehicle;
            }
        }
        return result;
    }

    @Override
    public Map<Class, Integer> getOptionalEquipmentToLoad() {
        Map<Class, Integer> result = super.getOptionalEquipmentToLoad();
        Map<Good, Integer> load = null;
        load = this.outbound ? this.sellLoad : this.buyLoad;
        for (Good good : load.keySet()) {
            if (!good.getCategory().equals("equipment")) continue;
            Class equipmentClass = good.getClassType();
            int num = load.get(good);
            if (result.containsKey(equipmentClass)) {
                num += result.get(equipmentClass).intValue();
            }
            result.put(equipmentClass, num);
        }
        return result;
    }

    @Override
    public Map<Resource, Number> getOptionalResourcesToLoad() {
        Map<Resource, Number> result = super.getOptionalResourcesToLoad();
        Map<Good, Integer> load = null;
        load = this.outbound ? this.sellLoad : this.buyLoad;
        for (Good good : load.keySet()) {
            Serializable resource;
            if (good.getCategory().equals("amount resource")) {
                resource = (AmountResource)good.getObject();
                double amount = load.get(good).doubleValue();
                if (result.containsKey(resource)) {
                    amount += ((Double)result.get(resource)).doubleValue();
                }
                result.put((Resource)((Object)resource), amount);
                continue;
            }
            if (!good.getCategory().equals("item resource")) continue;
            resource = (ItemResource)good.getObject();
            int num = load.get(good);
            if (result.containsKey(resource)) {
                num += ((Integer)result.get(resource)).intValue();
            }
            result.put((Resource)((Object)resource), num);
        }
        return result;
    }

    @Override
    public Settlement getAssociatedSettlement() {
        return this.getStartingSettlement();
    }

    @Override
    protected boolean isCapableOfMission(Person person) {
        return super.isCapableOfMission(person) && person.getLocationSituation().equals("In Settlement") && person.getSettlement() == this.getStartingSettlement();
    }

    @Override
    protected void recruitPeopleForMission(Person startingPerson) {
        super.recruitPeopleForMission(startingPerson);
        if (!Trade.atLeastOnePersonRemainingAtSettlement(this.getStartingSettlement(), startingPerson)) {
            Person lastPerson = null;
            int amount = this.getPeopleNumber() - 1;
            Object[] array = this.getPeople().toArray();
            if (amount >= 0 && amount < array.length) {
                lastPerson = (Person)array[amount];
            }
            if (lastPerson != null) {
                lastPerson.getMind().setMission(null);
                if (this.getPeopleNumber() < this.getMinPeople()) {
                    this.endMission("Not enough members.");
                }
            }
        }
    }

    @Override
    protected int compareVehicles(Vehicle firstVehicle, Vehicle secondVehicle) {
        int result = super.compareVehicles(firstVehicle, secondVehicle);
        if (result == 0 && this.isUsableVehicle(firstVehicle) && this.isUsableVehicle(secondVehicle)) {
            double secondCapacity;
            double firstCapacity = firstVehicle.getInventory().getGeneralCapacity();
            if (firstCapacity > (secondCapacity = secondVehicle.getInventory().getGeneralCapacity())) {
                result = 1;
            } else if (secondCapacity > firstCapacity) {
                result = -1;
            }
            if (result == 0) {
                if (firstVehicle.getRange() > secondVehicle.getRange()) {
                    result = 1;
                } else if (firstVehicle.getRange() < secondVehicle.getRange()) {
                    result = -1;
                }
            }
        }
        return result;
    }

    private Person getMissionTrader() {
        Person bestTrader = null;
        int bestTradeSkill = -1;
        for (Person person : this.getPeople()) {
            int tradeSkill = person.getMind().getSkillManager().getEffectiveSkillLevel("Trading");
            if (tradeSkill <= bestTradeSkill) continue;
            bestTradeSkill = tradeSkill;
            bestTrader = person;
        }
        return bestTrader;
    }

    private Person getSettlementTrader() {
        Person bestTrader = null;
        int bestTradeSkill = -1;
        for (Person person : this.tradingSettlement.getInhabitants()) {
            int tradeSkill;
            if (this.getPeople().contains(person) || (tradeSkill = person.getMind().getSkillManager().getEffectiveSkillLevel("Trading")) <= bestTradeSkill) continue;
            bestTradeSkill = tradeSkill;
            bestTrader = person;
        }
        return bestTrader;
    }

    public Map<Good, Integer> getSellLoad() {
        if (this.sellLoad != null) {
            return new HashMap<Good, Integer>(this.sellLoad);
        }
        return null;
    }

    public Map<Good, Integer> getBuyLoad() {
        if (this.buyLoad != null) {
            return new HashMap<Good, Integer>(this.buyLoad);
        }
        return null;
    }

    public double getProfit() {
        return this.profit;
    }

    public Map<Good, Integer> getDesiredBuyLoad() {
        if (this.desiredBuyLoad != null) {
            return new HashMap<Good, Integer>(this.desiredBuyLoad);
        }
        return null;
    }

    public double getDesiredProfit() {
        return this.desiredProfit;
    }

    public Settlement getTradingSettlement() {
        return this.tradingSettlement;
    }

    private double estimateTradeProfit(Map<Good, Integer> buyingLoad) {
        double result = 0.0;
        try {
            double sellingValueHome = TradeUtil.determineLoadValue(this.sellLoad, this.getStartingSettlement(), false);
            double sellingValueRemote = TradeUtil.determineLoadValue(this.sellLoad, this.tradingSettlement, true);
            double sellingProfit = sellingValueRemote - sellingValueHome;
            double buyingValueHome = TradeUtil.determineLoadValue(buyingLoad, this.getStartingSettlement(), true);
            double buyingValueRemote = TradeUtil.determineLoadValue(buyingLoad, this.tradingSettlement, false);
            double buyingProfit = buyingValueHome - buyingValueRemote;
            double totalProfit = sellingProfit + buyingProfit;
            double estimatedDistance = this.getStartingSettlement().getCoordinates().getDistance(this.tradingSettlement.getCoordinates()) * 2.0;
            double missionCost = TradeUtil.getEstimatedMissionCost(this.getStartingSettlement(), this.getRover(), estimatedDistance);
            result = totalProfit - missionCost;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.endMission("Could not estimate trade profit.");
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.tradingSettlement = null;
        if (this.sellLoad != null) {
            this.sellLoad.clear();
        }
        this.sellLoad = null;
        if (this.buyLoad != null) {
            this.buyLoad.clear();
        }
        this.buyLoad = null;
        if (this.desiredBuyLoad != null) {
            this.desiredBuyLoad.clear();
        }
        this.desiredBuyLoad = null;
        this.startNegotiationTime = null;
        this.negotiationTask = null;
    }

    @Override
    public Map<Class, Integer> getEquipmentNeededForRemainingMission(boolean useBuffer) {
        HashMap<Class, Integer> result;
        if (this.equipmentNeededCache != null) {
            return this.equipmentNeededCache;
        }
        this.equipmentNeededCache = result = new HashMap<Class, Integer>(0);
        return result;
    }

    private static class TradeProfitInfo {
        private double profit;
        private MarsClock time;

        private TradeProfitInfo(double profit, MarsClock time) {
            this.profit = profit;
            this.time = time;
        }
    }
}

