/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.util.ArrayList;
import java.util.List;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.time.MarsClock;

public abstract class TravelMission
extends Mission {
    public static final String TRAVEL_STATUS_EVENT = "travel status";
    public static final String NAVPOINTS_EVENT = "navpoints";
    public static final String DISTANCE_EVENT = "distance";
    public static final String AT_NAVPOINT = "At a navpoint";
    public static final String TRAVEL_TO_NAVPOINT = "Traveling to navpoint";
    private List<NavPoint> navPoints = new ArrayList<NavPoint>();
    private int navIndex = 0;
    private String travelStatus;
    private NavPoint lastStopNavpoint;
    private MarsClock legStartingTime;

    protected TravelMission(String name, Person startingPerson, int minPeople) {
        super(name, startingPerson, minPeople);
        NavPoint startingNavPoint = null;
        startingNavPoint = startingPerson.getSettlement() != null ? new NavPoint(this.getCurrentMissionLocation(), startingPerson.getSettlement(), startingPerson.getSettlement().getName()) : new NavPoint(this.getCurrentMissionLocation(), "starting location");
        this.addNavpoint(startingNavPoint);
        this.lastStopNavpoint = startingNavPoint;
        this.setTravelStatus(AT_NAVPOINT);
    }

    public final void addNavpoint(NavPoint navPoint) {
        if (navPoint == null) {
            throw new IllegalArgumentException("navPoint is null");
        }
        this.navPoints.add(navPoint);
        this.fireMissionUpdate(NAVPOINTS_EVENT);
    }

    protected final void setNavpoint(int index, NavPoint navPoint) {
        if (navPoint == null || index < 0) {
            throw new IllegalArgumentException("navPoint is null");
        }
        this.navPoints.set(index, navPoint);
        this.fireMissionUpdate(NAVPOINTS_EVENT);
    }

    public final void clearRemainingNavpoints() {
        int index = this.getNextNavpointIndex();
        int numNavpoints = this.getNumberOfNavpoints();
        for (int x = index; x < numNavpoints; ++x) {
            this.navPoints.remove(index);
            this.fireMissionUpdate(NAVPOINTS_EVENT);
        }
    }

    public final NavPoint getPreviousNavpoint() {
        return this.lastStopNavpoint;
    }

    public final NavPoint getNextNavpoint() {
        if (this.navIndex < this.navPoints.size()) {
            return this.navPoints.get(this.navIndex);
        }
        return null;
    }

    public final int getNextNavpointIndex() {
        if (this.navIndex < this.navPoints.size()) {
            return this.navIndex;
        }
        return -1;
    }

    public final void setNextNavpointIndex(int newNavIndex) {
        if (newNavIndex >= this.getNumberOfNavpoints()) {
            throw new IllegalStateException(this.getPhase() + " : newNavIndex: " + newNavIndex + " is outOfBounds.");
        }
        this.navIndex = newNavIndex;
    }

    public final NavPoint getNavpoint(int index) {
        if (index >= 0 && index < this.getNumberOfNavpoints()) {
            return this.navPoints.get(index);
        }
        throw new IllegalArgumentException("index: " + index + " out of bounds.");
    }

    public final int getNavpointIndex(NavPoint navpoint) {
        if (navpoint == null) {
            throw new IllegalArgumentException("navpoint is null");
        }
        if (this.navPoints.contains(navpoint)) {
            return this.navPoints.indexOf(navpoint);
        }
        return -1;
    }

    public final int getNumberOfNavpoints() {
        return this.navPoints.size();
    }

    public final NavPoint getCurrentNavpoint() {
        if (AT_NAVPOINT.equals(this.travelStatus)) {
            if (this.navIndex < this.navPoints.size()) {
                return this.navPoints.get(this.navIndex);
            }
            return null;
        }
        return null;
    }

    public final int getCurrentNavpointIndex() {
        if (AT_NAVPOINT.equals(this.travelStatus)) {
            return this.navIndex;
        }
        return -1;
    }

    public final String getTravelStatus() {
        return this.travelStatus;
    }

    private void setTravelStatus(String newTravelStatus) {
        this.travelStatus = newTravelStatus;
        this.fireMissionUpdate(TRAVEL_STATUS_EVENT);
    }

    protected final void startTravelToNextNode() {
        this.setNextNavpointIndex(this.navIndex + 1);
        this.setTravelStatus(TRAVEL_TO_NAVPOINT);
        this.legStartingTime = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
    }

    protected final void reachedNextNode() {
        this.setTravelStatus(AT_NAVPOINT);
        this.lastStopNavpoint = this.getCurrentNavpoint();
    }

    protected abstract void performTravelPhase(Person var1);

    protected final MarsClock getCurrentLegStartingTime() {
        if (this.legStartingTime != null) {
            return (MarsClock)this.legStartingTime.clone();
        }
        return null;
    }

    public final double getCurrentLegDistance() {
        if (TRAVEL_TO_NAVPOINT.equals(this.travelStatus)) {
            return this.lastStopNavpoint.getLocation().getDistance(this.getNextNavpoint().getLocation());
        }
        return 0.0;
    }

    public final double getCurrentLegRemainingDistance() {
        if (this.travelStatus.equals(TRAVEL_TO_NAVPOINT)) {
            return this.getCurrentMissionLocation().getDistance(this.getNextNavpoint().getLocation());
        }
        return 0.0;
    }

    public final double getTotalDistance() {
        double result = 0.0;
        if (this.navPoints.size() > 1) {
            for (int x = 1; x < this.navPoints.size(); ++x) {
                NavPoint prevNav = this.navPoints.get(x - 1);
                NavPoint currNav = this.navPoints.get(x);
                double distance = currNav.getLocation().getDistance(prevNav.getLocation());
                result += distance;
            }
        }
        return result;
    }

    public final double getTotalRemainingDistance() {
        double result = this.getCurrentLegRemainingDistance();
        int index = 0;
        if (AT_NAVPOINT.equals(this.travelStatus)) {
            index = this.getCurrentNavpointIndex();
        } else if (TRAVEL_TO_NAVPOINT.equals(this.travelStatus)) {
            index = this.getNextNavpointIndex();
        }
        for (int x = index + 1; x < this.getNumberOfNavpoints(); ++x) {
            result += this.getNavpoint(x - 1).getLocation().getDistance(this.getNavpoint(x).getLocation());
        }
        return result;
    }

    public abstract double getTotalDistanceTravelled();

    public abstract MarsClock getLegETA();

    public abstract double getEstimatedRemainingMissionTime(boolean var1);

    public abstract double getEstimatedTripTime(boolean var1, double var2);

    public abstract void updateTravelDestination();

    @Override
    public void destroy() {
        super.destroy();
        if (this.navPoints != null) {
            this.navPoints.clear();
        }
        this.navPoints = null;
        this.travelStatus = null;
        this.lastStopNavpoint = null;
        this.legStartingTime = null;
    }
}

