/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.mission;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Driver;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.job.JobManager;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class TravelToSettlement
extends RoverMission
implements Serializable {
    private static Logger logger = Logger.getLogger(TravelToSettlement.class.getName());
    public static final String DEFAULT_DESCRIPTION = "Travel To Settlement";
    public static final String DESTINATION_SETTLEMENT = "destination settlement";
    private static final double BASE_MISSION_WEIGHT = 1.0;
    private static final double RELATIONSHIP_MODIFIER = 10.0;
    private static final double JOB_MODIFIER = 1.0;
    private static final double CROWDING_MODIFIER = 50.0;
    private static final double SCIENCE_MODIFIER = 1.0;
    private static final double RANGE_BUFFER = 0.8;
    private Settlement destinationSettlement;

    public TravelToSettlement(Person startingPerson) {
        super(DEFAULT_DESCRIPTION, startingPerson);
        if (!this.isDone()) {
            int availableSuitNum;
            this.setStartingSettlement(startingPerson.getSettlement());
            if (this.hasVehicle()) {
                this.setMissionCapacity(this.getRover().getCrewCapacity());
            }
            if ((availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingPerson.getSettlement())) < this.getMissionCapacity()) {
                this.setMissionCapacity(availableSuitNum);
            }
            this.setDestinationSettlement(this.getRandomDestinationSettlement(startingPerson, this.getStartingSettlement()));
            if (this.destinationSettlement != null) {
                this.addNavpoint(new NavPoint(this.destinationSettlement.getCoordinates(), this.destinationSettlement, this.destinationSettlement.getName()));
                this.setDescription("Travel To " + this.destinationSettlement.getName());
            } else {
                this.endMission("Destination is null.");
            }
            int availableSpace = this.destinationSettlement.getPopulationCapacity() - this.destinationSettlement.getAllAssociatedPeople().size();
            if (availableSpace < this.getMissionCapacity()) {
                this.setMissionCapacity(availableSpace);
            }
            if (!this.isDone()) {
                this.recruitPeopleForMission(startingPerson);
            }
            if (this.hasVehicle() && !this.isVehicleLoadable()) {
                this.endMission("Vehicle is not loadable. (TravelToSettlement)");
            }
        }
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
        logger.info("Travel to Settlement mission");
    }

    public TravelToSettlement(Collection<Person> members, Settlement startingSettlement, Settlement destinationSettlement, Rover rover, String description) {
        super(description, (Person)members.toArray()[0], 1, rover);
        this.setStartingSettlement(startingSettlement);
        this.setMissionCapacity(this.getRover().getCrewCapacity());
        int availableSuitNum = Mission.getNumberAvailableEVASuitsAtSettlement(startingSettlement);
        if (availableSuitNum < this.getMissionCapacity()) {
            this.setMissionCapacity(availableSuitNum);
        }
        this.setDestinationSettlement(destinationSettlement);
        this.addNavpoint(new NavPoint(this.destinationSettlement.getCoordinates(), this.destinationSettlement, this.destinationSettlement.getName()));
        Iterator<Person> i = members.iterator();
        while (i.hasNext()) {
            i.next().getMind().setMission(this);
        }
        this.setPhase("Embarking");
        this.setPhaseDescription("Embarking from " + this.getStartingSettlement().getName());
        if (this.hasVehicle() && !this.isVehicleLoadable()) {
            this.endMission("Vehicle is not loadable. (TravelToSettlement)");
        }
    }

    public static double getNewMissionProbability(Person person) {
        double missionProbability = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            boolean missionPossible = true;
            Settlement settlement = person.getSettlement();
            if (!TravelToSettlement.areVehiclesAvailable(settlement, false)) {
                missionPossible = false;
            }
            if (!TravelToSettlement.hasBackupRover(settlement)) {
                missionPossible = false;
            }
            if (!TravelToSettlement.minAvailablePeopleAtSettlement(settlement, 3)) {
                missionPossible = false;
            }
            if (Mission.getNumberAvailableEVASuitsAtSettlement(settlement) < 2) {
                missionPossible = false;
            }
            if (!RoverMission.hasEnoughBasicResources(settlement)) {
                missionPossible = false;
            }
            double topSettlementDesirability = 0.0;
            Vehicle vehicle = TravelToSettlement.getVehicleWithGreatestRange(settlement, false);
            if (vehicle != null) {
                Map<Settlement, Double> desirableSettlements = TravelToSettlement.getDestinationSettlements(person, settlement, vehicle.getRange());
                if (desirableSettlements.size() == 0) {
                    missionPossible = false;
                }
                for (Settlement desirableSettlement : desirableSettlements.keySet()) {
                    double desirability = desirableSettlements.get(desirableSettlement);
                    if (!(desirability > topSettlementDesirability)) continue;
                    topSettlementDesirability = desirability;
                }
            }
            if (VehicleMission.hasEmbarkingMissions(settlement)) {
                missionPossible = false;
            }
            AmountResource methane = AmountResource.findAmountResource("methane");
            if (settlement.getInventory().getAmountResourceStored(methane, false) < 1000.0) {
                missionPossible = false;
            }
            if (missionPossible) {
                Job job;
                missionProbability = 1.0 + topSettlementDesirability / 100.0;
                int crowding = settlement.getCurrentPopulationNum() - settlement.getPopulationCapacity();
                if (crowding > 0) {
                    missionProbability *= (double)(crowding + 1);
                }
                if ((job = person.getMind().getJob()) != null) {
                    missionProbability *= job.getStartMissionProbabilityModifier(TravelToSettlement.class);
                }
            }
        }
        return missionProbability;
    }

    @Override
    protected void determineNewPhase() {
        if ("Embarking".equals(this.getPhase())) {
            this.startTravelToNextNode();
            this.setPhase("Travelling");
            this.setPhaseDescription("Driving to " + this.getNextNavpoint().getDescription());
            this.associateAllMembersWithSettlement(this.destinationSettlement);
        } else if ("Travelling".equals(this.getPhase())) {
            if (this.getCurrentNavpoint().isSettlementAtNavpoint()) {
                this.setPhase("Disembarking");
                this.setPhaseDescription("Disembarking at " + this.getCurrentNavpoint().getDescription());
            }
        } else if ("Disembarking".equals(this.getPhase())) {
            this.endMission("Successfully disembarked.");
        }
    }

    private void setDestinationSettlement(Settlement destinationSettlement) {
        this.destinationSettlement = destinationSettlement;
        this.fireMissionUpdate(DESTINATION_SETTLEMENT);
    }

    public final Settlement getDestinationSettlement() {
        return this.destinationSettlement;
    }

    private Settlement getRandomDestinationSettlement(Person person, Settlement startingSettlement) {
        double range = this.getVehicle().getRange();
        Settlement result = null;
        Map<Settlement, Double> desirableSettlements = TravelToSettlement.getDestinationSettlements(person, startingSettlement, range);
        if (desirableSettlements.size() > 0) {
            result = RandomUtil.getWeightedRandomObject(desirableSettlements);
        }
        return result;
    }

    private static Map<Settlement, Double> getDestinationSettlements(Person person, Settlement startingSettlement, double range) {
        HashMap<Settlement, Double> result = new HashMap<Settlement, Double>();
        UnitManager unitManager = startingSettlement.getUnitManager();
        for (Settlement settlement : unitManager.getSettlements()) {
            double desirability;
            double distance = startingSettlement.getCoordinates().getDistance(settlement.getCoordinates());
            if (startingSettlement == settlement || !(distance <= range * 0.8) || !((desirability = TravelToSettlement.getDestinationSettlementDesirability(person, startingSettlement, settlement)) > 0.0)) continue;
            result.put(settlement, desirability);
        }
        return result;
    }

    private static double getDestinationSettlementDesirability(Person person, Settlement startingSettlement, Settlement destinationSettlement) {
        RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
        double currentOpinion = relationshipManager.getAverageOpinionOfPeople(person, startingSettlement.getAllAssociatedPeople());
        double destinationOpinion = relationshipManager.getAverageOpinionOfPeople(person, destinationSettlement.getAllAssociatedPeople());
        double relationshipFactor = (destinationOpinion - currentOpinion) / 100.0;
        Job currentJob = person.getMind().getJob();
        double currentJobProspect = JobManager.getJobProspect(person, currentJob, startingSettlement, true);
        double destinationJobProspect = 0.0;
        destinationJobProspect = person.getMind().getJobLock() ? JobManager.getJobProspect(person, currentJob, destinationSettlement, false) : JobManager.getBestJobProspect(person, destinationSettlement, false);
        double jobFactor = 0.0;
        if (destinationJobProspect > currentJobProspect) {
            jobFactor = 1.0;
        } else if (destinationJobProspect < currentJobProspect) {
            jobFactor = -1.0;
        }
        int startingCrowding = startingSettlement.getPopulationCapacity() - startingSettlement.getAllAssociatedPeople().size() - 1;
        int destinationCrowding = destinationSettlement.getPopulationCapacity() - destinationSettlement.getAllAssociatedPeople().size();
        double crowdingFactor = destinationCrowding - startingCrowding;
        double totalScienceAchievementFactor = (destinationSettlement.getTotalScientificAchievement() - startingSettlement.getTotalScientificAchievement()) / 10.0;
        double jobScienceAchievementFactor = 0.0;
        Science jobScience = ScienceUtil.getAssociatedScience(person.getMind().getJob());
        if (jobScience != null) {
            double startingJobScienceAchievement = startingSettlement.getScientificAchievement(jobScience);
            double destinationJobScienceAchievement = destinationSettlement.getScientificAchievement(jobScience);
            jobScienceAchievementFactor = destinationJobScienceAchievement - startingJobScienceAchievement;
        }
        double scienceAchievementFactor = totalScienceAchievementFactor + jobScienceAchievementFactor;
        if (destinationCrowding < 2) {
            return 0.0;
        }
        return relationshipFactor * 10.0 + jobFactor * 1.0 + crowdingFactor * 50.0 + scienceAchievementFactor * 1.0;
    }

    @Override
    protected boolean isCapableOfMission(Person person) {
        return super.isCapableOfMission(person) && person.getLocationSituation().equals("In Settlement") && person.getSettlement() == this.getStartingSettlement();
    }

    @Override
    protected double getMissionQualification(Person person) {
        double result = 0.0;
        if (this.isCapableOfMission(person)) {
            result = super.getMissionQualification(person);
            RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
            if (this.destinationSettlement != null) {
                Collection<Person> destinationInhabitants = this.destinationSettlement.getAllAssociatedPeople();
                double destinationSocialModifier = (relationshipManager.getAverageOpinionOfPeople(person, destinationInhabitants) - 50.0) / 50.0;
                result += destinationSocialModifier;
            }
            if (this.getStartingSettlement() != null) {
                Collection<Person> startingInhabitants = this.getStartingSettlement().getAllAssociatedPeople();
                Iterator<Person> i = startingInhabitants.iterator();
                while (i.hasNext()) {
                    if (!this.hasPerson(i.next())) continue;
                    i.remove();
                }
                double startingSocialModifier = (relationshipManager.getAverageOpinionOfPeople(person, startingInhabitants) - 50.0) / 50.0;
                result -= startingSocialModifier;
            }
            if (person.getMind().getJob() instanceof Driver) {
                result += 1.0;
            }
        }
        return result;
    }

    @Override
    protected void recruitPeopleForMission(Person startingPerson) {
        super.recruitPeopleForMission(startingPerson);
        if (!TravelToSettlement.atLeastOnePersonRemainingAtSettlement(this.getStartingSettlement(), startingPerson)) {
            Object[] array = this.getPeople().toArray();
            int amount = this.getPeopleNumber() - 1;
            Person lastPerson = null;
            if (amount >= 0 && amount < array.length) {
                lastPerson = (Person)array[amount];
            }
            if (lastPerson != null) {
                lastPerson.getMind().setMission(null);
                if (this.getPeopleNumber() < this.getMinPeople()) {
                    this.endMission("Not enough members.");
                }
            }
        }
    }

    @Override
    public Settlement getAssociatedSettlement() {
        return this.destinationSettlement;
    }

    @Override
    public Map<Class, Integer> getEquipmentNeededForRemainingMission(boolean useBuffer) {
        HashMap<Class, Integer> result;
        if (this.equipmentNeededCache != null) {
            return this.equipmentNeededCache;
        }
        this.equipmentNeededCache = result = new HashMap<Class, Integer>();
        return result;
    }

    @Override
    protected int compareVehicles(Vehicle firstVehicle, Vehicle secondVehicle) {
        int result = super.compareVehicles(firstVehicle, secondVehicle);
        if (result == 0 && this.isUsableVehicle(firstVehicle) && this.isUsableVehicle(secondVehicle)) {
            if (((Rover)firstVehicle).getCrewCapacity() > ((Rover)secondVehicle).getCrewCapacity()) {
                result = 1;
            } else if (((Rover)firstVehicle).getCrewCapacity() < ((Rover)secondVehicle).getCrewCapacity()) {
                result = -1;
            }
            if (result == 0) {
                if (firstVehicle.getRange() > secondVehicle.getRange()) {
                    result = 1;
                } else if (firstVehicle.getRange() < secondVehicle.getRange()) {
                    result = -1;
                }
            }
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.destinationSettlement = null;
    }
}

