/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.social;

import java.io.Serializable;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.PersonalityType;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;

public class Relationship
implements Serializable {
    public static final String FIRST_IMPRESSION = "First Impression";
    public static final String EXISTING_RELATIONSHIP = "Existing Relationship";
    public static final String COMMUNICATION_MEETING = "Communication Meeting";
    private static final double SETTLER_MODIFIER = 20.0;
    private Person person1;
    private double person1Opinion;
    private Person person2;
    private double person2Opinion;

    Relationship(Person person1, Person person2, String startingRelationship) throws IllegalArgumentException {
        this.person1 = person1;
        this.person2 = person2;
        if (FIRST_IMPRESSION.equals(startingRelationship)) {
            this.setPerson1Opinion(this.getFirstImpression(person1, person2));
            this.setPerson2Opinion(this.getFirstImpression(person2, person1));
        } else if (EXISTING_RELATIONSHIP.equals(startingRelationship)) {
            this.setPerson1Opinion(this.getExistingRelationship(person1, person2));
            this.setPerson2Opinion(this.getExistingRelationship(person2, person1));
        } else if (COMMUNICATION_MEETING.equals(startingRelationship)) {
            this.setPerson1Opinion(this.getCommunicationMeeting(person1, person2));
            this.setPerson2Opinion(this.getCommunicationMeeting(person2, person1));
        } else {
            throw new IllegalArgumentException("Invalid starting relationship type: " + startingRelationship);
        }
    }

    public Person[] getPeople() {
        Person[] result = new Person[]{this.person1, this.person2};
        return result;
    }

    public boolean hasPerson(Person person) {
        boolean result = false;
        if (this.person1 == person) {
            result = true;
        } else if (this.person2 == person) {
            result = true;
        }
        return result;
    }

    private void setPerson1Opinion(double opinion) {
        this.person1Opinion = opinion;
        if (this.person1Opinion < 0.0) {
            this.person1Opinion = 0.0;
        }
        if (this.person1Opinion > 100.0) {
            this.person1Opinion = 100.0;
        }
    }

    private void setPerson2Opinion(double opinion) {
        this.person2Opinion = opinion;
        if (this.person2Opinion < 0.0) {
            this.person2Opinion = 0.0;
        }
        if (this.person2Opinion > 100.0) {
            this.person2Opinion = 100.0;
        }
    }

    public double getPersonOpinion(Person person) throws IllegalArgumentException {
        if (person == this.person1) {
            return this.person1Opinion;
        }
        if (person == this.person2) {
            return this.person2Opinion;
        }
        throw new IllegalArgumentException("Invalid person: " + person);
    }

    public void setPersonOpinion(Person person, double opinion) throws IllegalArgumentException {
        if (person == this.person1) {
            this.setPerson1Opinion(opinion);
        } else if (person == this.person2) {
            this.setPerson2Opinion(opinion);
        } else {
            throw new IllegalArgumentException("Invalid person: " + person);
        }
    }

    private double getFirstImpression(Person impressioner, Person impressionee) {
        boolean oppositeGenders;
        double result = 0.0;
        int numberOfIterations = 3;
        for (int x = 0; x < numberOfIterations; ++x) {
            result += RandomUtil.getRandomDouble(100.0);
        }
        result /= (double)numberOfIterations;
        NaturalAttributeManager attributes = impressionee.getNaturalAttributeManager();
        double conversationModifier = (double)attributes.getAttribute("Conversation") - 50.0;
        result += RandomUtil.getRandomDouble(conversationModifier);
        double attractivenessModifier = (double)attributes.getAttribute("Attractiveness") - 50.0;
        boolean bl = oppositeGenders = !impressioner.getGender().equals(impressionee.getGender());
        if (oppositeGenders) {
            result += RandomUtil.getRandomDouble(attractivenessModifier);
        }
        result += impressionee.getTotalScientificAchievement() / 10.0;
        Science science = ScienceUtil.getAssociatedScience(impressioner.getMind().getJob());
        if ((result += impressionee.getScientificAchievement(science)) < 50.0) {
            result += RandomUtil.getRandomDouble(20.0);
        }
        return result;
    }

    private double getExistingRelationship(Person person, Person target) {
        boolean oppositeGenders;
        double result = 0.0;
        int numberOfIterations = 3;
        for (int x = 0; x < numberOfIterations; ++x) {
            result += RandomUtil.getRandomDouble(100.0);
        }
        result /= (double)numberOfIterations;
        NaturalAttributeManager attributes = target.getNaturalAttributeManager();
        double conversationModifier = (double)attributes.getAttribute("Conversation") - 50.0;
        result += RandomUtil.getRandomDouble(conversationModifier);
        double attractivenessModifier = (double)attributes.getAttribute("Attractiveness") - 50.0;
        boolean bl = oppositeGenders = !person.getGender().equals(target.getGender());
        if (oppositeGenders) {
            result += RandomUtil.getRandomDouble(attractivenessModifier);
        }
        PersonalityType personType = person.getMind().getPersonalityType();
        PersonalityType targetType = target.getMind().getPersonalityType();
        double personalityDiffModifier = (2.0 - (double)personType.getPersonalityDifference(targetType.getTypeString())) * 50.0;
        result += RandomUtil.getRandomDouble(personalityDiffModifier);
        result += target.getTotalScientificAchievement() / 10.0;
        Science science = ScienceUtil.getAssociatedScience(target.getMind().getJob());
        if ((result += target.getScientificAchievement(science)) < 50.0) {
            result += RandomUtil.getRandomDouble(20.0);
        }
        return result;
    }

    private double getCommunicationMeeting(Person person, Person target) {
        double result = 0.0;
        result = 50.0;
        result += target.getTotalScientificAchievement() / 10.0;
        Science science = ScienceUtil.getAssociatedScience(target.getMind().getJob());
        return result += target.getScientificAchievement(science);
    }
}

