/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.social.Relationship;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.person.ai.task.ResearchScientificStudy;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.LifeSupport;
import org.mars_sim.msp.core.vehicle.Crewable;

public class AssistScientificStudyResearcher
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(AssistScientificStudyResearcher.class.getName());
    private static final String ASSISTING = "Assisting Researcher";
    private static final double STRESS_MODIFIER = -0.1;
    private static final double BASE_RELATIONSHIP_MODIFIER = 0.2;
    private ResearchScientificStudy researchTask;
    private Person researcher = this.determineResearcher();

    public AssistScientificStudyResearcher(Person person) {
        super("Assisting researcher", person, true, false, -0.1, false, 0.0);
        if (this.researcher != null) {
            this.researchTask = (ResearchScientificStudy)((Object)this.researcher.getMind().getTaskManager().getTask());
            if (this.researchTask != null) {
                Building researcherBuilding;
                Building assistantBuilding;
                this.researchTask.setResearchAssistant(person);
                this.setDescription("Assisting researcher " + this.researcher.getName());
                if (person.getLocationSituation().equals("In Settlement") && !(assistantBuilding = BuildingManager.getBuilding(person)).equals(researcherBuilding = BuildingManager.getBuilding(this.researcher))) {
                    BuildingManager.addPersonToBuilding(person, researcherBuilding);
                }
            } else {
                logger.log(Level.SEVERE, "Researcher task not found.");
                this.endTask();
            }
        } else {
            logger.log(Level.SEVERE, "Cannot find researcher");
            this.endTask();
        }
        this.addPhase(ASSISTING);
        this.setPhase(ASSISTING);
    }

    public static double getProbability(Person person) {
        Job job;
        double result = 0.0;
        Collection<Person> potentialResearchers = AssistScientificStudyResearcher.getBestResearchers(person);
        if (potentialResearchers.size() > 0) {
            result = 50.0;
            if (person.getLocationSituation().equals("In Settlement")) {
                Person researcher = (Person)potentialResearchers.toArray()[0];
                Building building = BuildingManager.getBuilding(researcher);
                if (building != null) {
                    result *= Task.getCrowdingProbabilityModifier(person, building);
                    result *= Task.getRelationshipModifier(person, building);
                } else {
                    result = 0.0;
                }
            }
        }
        if ((job = person.getMind().getJob()) != null) {
            result *= job.getStartTaskProbabilityModifier(AssistScientificStudyResearcher.class);
        }
        return result;
    }

    private Person determineResearcher() {
        Person result = null;
        Collection<Person> researchers = AssistScientificStudyResearcher.getBestResearchers(this.person);
        if (researchers.size() > 0) {
            int rand = RandomUtil.getRandomInt(researchers.size() - 1);
            result = (Person)researchers.toArray()[rand];
        }
        return result;
    }

    private static Collection<Person> getBestResearchers(Person assistant) {
        ConcurrentLinkedQueue<Person> result = null;
        Collection<Person> researchers = AssistScientificStudyResearcher.getAvailableResearchers(assistant);
        Collection<Object> leastCrowded = new ConcurrentLinkedQueue();
        if (assistant.getLocationSituation().equals("In Settlement")) {
            int crowding = Integer.MAX_VALUE;
            for (Person researcher : researchers) {
                Building building = BuildingManager.getBuilding(researcher);
                if (building == null) continue;
                LifeSupport lifeSupport = (LifeSupport)building.getFunction("Life Support");
                int n = lifeSupport.getOccupantNumber() - lifeSupport.getOccupantCapacity() + 1;
                if (n < -1) {
                    n = -1;
                }
                if (n >= crowding) continue;
                crowding = n;
            }
            for (Person researcher : researchers) {
                Building building = BuildingManager.getBuilding(researcher);
                if (building == null) continue;
                LifeSupport lifeSupport = (LifeSupport)building.getFunction("Life Support");
                int buildingCrowding = lifeSupport.getOccupantNumber() - lifeSupport.getOccupantCapacity() + 1;
                if (buildingCrowding < -1) {
                    buildingCrowding = -1;
                }
                if (buildingCrowding != crowding) continue;
                leastCrowded.add(researcher);
            }
        } else {
            leastCrowded = researchers;
        }
        RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
        ConcurrentLinkedQueue<Person> favoriteResearchers = new ConcurrentLinkedQueue<Person>();
        double favorite = Double.NEGATIVE_INFINITY;
        for (Person person : leastCrowded) {
            double opinion = relationshipManager.getOpinionOfPerson(assistant, person);
            if (!(opinion > favorite)) continue;
            favorite = opinion;
        }
        for (Person person : leastCrowded) {
            double opinion = relationshipManager.getOpinionOfPerson(assistant, person);
            if (opinion != favorite) continue;
            favoriteResearchers.add(person);
        }
        result = favoriteResearchers;
        return result;
    }

    private static Collection<Person> getAvailableResearchers(Person assistant) {
        ConcurrentLinkedQueue<Person> result = new ConcurrentLinkedQueue<Person>();
        for (Person person : AssistScientificStudyResearcher.getLocalPeople(assistant)) {
            ResearchScientificStudy researchTask;
            Task personsTask = person.getMind().getTaskManager().getTask();
            if (personsTask == null || !(personsTask instanceof ResearchScientificStudy) || (researchTask = (ResearchScientificStudy)((Object)personsTask)).hasResearchAssistant()) continue;
            String scienceSkill = ScienceUtil.getAssociatedSkill(researchTask.getResearchScience());
            int personSkill = person.getMind().getSkillManager().getEffectiveSkillLevel(scienceSkill);
            int assistantSkill = assistant.getMind().getSkillManager().getEffectiveSkillLevel(scienceSkill);
            if (assistantSkill >= personSkill) continue;
            result.add(person);
        }
        return result;
    }

    private static Collection<Person> getLocalPeople(Person person) {
        ConcurrentLinkedQueue<Person> people;
        block3: {
            block2: {
                people = new ConcurrentLinkedQueue<Person>();
                if (!person.getLocationSituation().equals("In Settlement")) break block2;
                for (Person inhabitant : person.getSettlement().getInhabitants()) {
                    if (person == inhabitant) continue;
                    people.add(inhabitant);
                }
                break block3;
            }
            if (!person.getLocationSituation().equals("In Vehicle")) break block3;
            Crewable rover = (Crewable)((Object)person.getVehicle());
            for (Person crewmember : rover.getCrew()) {
                if (person == crewmember) continue;
                people.add(crewmember);
            }
        }
        return people;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 50.0;
        int academicAptitude = this.person.getNaturalAttributeManager().getAttribute("Academic Aptitude");
        newPoints += newPoints * ((double)academicAptitude - 50.0) / 100.0;
        String scienceSkill = ScienceUtil.getAssociatedSkill(this.researchTask.getResearchScience());
        this.person.getMind().getSkillManager().addExperience(scienceSkill, newPoints *= this.getTeachingExperienceModifier());
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        String scienceSkill = ScienceUtil.getAssociatedSkill(this.researchTask.getResearchScience());
        results.add(scienceSkill);
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        String scienceSkill = ScienceUtil.getAssociatedSkill(this.researchTask.getResearchScience());
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel(scienceSkill);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (ASSISTING.equals(this.getPhase())) {
            return this.assistingPhase(time);
        }
        return time;
    }

    private double assistingPhase(double time) {
        if (((Task)((Object)this.researchTask)).isDone()) {
            this.endTask();
        }
        if (!this.researcher.getLocationSituation().equals(this.person.getLocationSituation())) {
            this.endTask();
        }
        this.addExperience(time);
        this.addRelationshipModifier(time);
        return 0.0;
    }

    private void addRelationshipModifier(double time) {
        RelationshipManager manager = Simulation.instance().getRelationshipManager();
        double currentOpinion = manager.getOpinionOfPerson(this.researcher, this.person);
        double newOpinion = currentOpinion + 0.2 * time;
        Relationship relationship = manager.getRelationship(this.researcher, this.person);
        if (relationship != null) {
            relationship.setPersonOpinion(this.researcher, newOpinion);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.researchTask = null;
        this.researcher = null;
    }
}

