/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.equipment.Bag;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.mission.Mining;
import org.mars_sim.msp.core.person.ai.task.EVAOperation;
import org.mars_sim.msp.core.person.ai.task.ExitAirlock;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.vehicle.Rover;

public class CollectMinedMinerals
extends EVAOperation
implements Serializable {
    private static final String COLLECT_MINERALS = "Collecting Minerals";
    private static final double MINERAL_COLLECTION_RATE = 10.0;
    private Rover rover;
    protected AmountResource mineralType;

    public CollectMinedMinerals(Person person, Rover rover, AmountResource mineralType) {
        super("Collect Minerals", person);
        this.rover = rover;
        this.mineralType = mineralType;
        this.addPhase(COLLECT_MINERALS);
    }

    private double exitRover(double time) {
        try {
            time = this.exitAirlock(time, this.rover.getAirlock());
            this.addExperience(time);
        }
        catch (Exception e) {
            this.endTask();
        }
        if (this.exitedAirlock) {
            if (!this.hasBags()) {
                this.takeBag();
            }
            if (this.hasBags()) {
                this.setPhase(COLLECT_MINERALS);
            } else {
                this.setPhase("Enter Airlock");
            }
        }
        return time;
    }

    private boolean hasBags() {
        return this.person.getInventory().containsUnitClass(Bag.class);
    }

    private void takeBag() {
        Bag bag = CollectMinedMinerals.findMostFullBag(this.rover.getInventory(), this.mineralType);
        if (bag != null && this.person.getInventory().canStoreUnit(bag, false)) {
            this.rover.getInventory().retrieveUnit(bag);
            this.person.getInventory().storeUnit(bag);
        }
    }

    private static Bag findMostFullBag(Inventory inv, AmountResource resource) {
        Bag result = null;
        double leastCapacity = Double.MAX_VALUE;
        for (Bag bag : inv.findAllUnitsOfClass(Bag.class)) {
            double remainingCapacity = bag.getInventory().getAmountResourceRemainingCapacity(resource, true, false);
            if (!(remainingCapacity > 0.0) || !(remainingCapacity < leastCapacity)) continue;
            result = bag;
            leastCapacity = remainingCapacity;
        }
        return result;
    }

    private double collectMinerals(double time) {
        this.checkForAccident(time);
        if (this.shouldEndEVAOperation()) {
            this.setPhase("Enter Airlock");
            return time;
        }
        Mining mission = (Mining)this.person.getMind().getMission();
        double mineralsExcavated = mission.getMineralExcavationAmount(this.mineralType);
        double remainingPersonCapacity = this.person.getInventory().getAmountResourceRemainingCapacity(this.mineralType, true, false);
        double mineralsCollected = time * 10.0;
        int areologySkill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Areology");
        if (areologySkill == 0) {
            mineralsCollected /= 2.0;
        }
        if (areologySkill > 1) {
            mineralsCollected += mineralsCollected * (0.2 * (double)areologySkill);
        }
        if (mineralsCollected > remainingPersonCapacity) {
            mineralsCollected = remainingPersonCapacity;
        }
        if (mineralsCollected > mineralsExcavated) {
            mineralsCollected = mineralsExcavated;
        }
        this.addExperience(time);
        this.person.getInventory().storeAmountResource(this.mineralType, mineralsCollected, true);
        mission.collectMineral(this.mineralType, mineralsCollected);
        if (mineralsExcavated - mineralsCollected <= 0.0 || mineralsCollected >= remainingPersonCapacity) {
            this.setPhase("Enter Airlock");
        }
        return 0.0;
    }

    private double enterRover(double time) {
        time = this.enterAirlock(time, this.rover.getAirlock());
        this.addExperience(time);
        if (this.enteredAirlock) {
            Inventory pInv = this.person.getInventory();
            if (pInv.containsUnitClass(Bag.class)) {
                for (Bag bag : pInv.findAllUnitsOfClass(Bag.class)) {
                    pInv.retrieveUnit(bag);
                    this.rover.getInventory().storeUnit(bag);
                }
            } else {
                this.endTask();
                return time;
            }
        }
        return 0.0;
    }

    public static boolean canCollectMinerals(Person person, Rover rover, AmountResource mineralType) {
        double carryCapacity;
        EVASuit suit;
        boolean exitable = ExitAirlock.canExitAirlock(person, rover.getAirlock());
        SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
        boolean sunlight = surface.getSurfaceSunlight(rover.getCoordinates()) > 0.0;
        boolean darkRegion = surface.inDarkPolarRegion(rover.getCoordinates());
        boolean medical = person.getPerformanceRating() < 0.5;
        Bag bag = CollectMinedMinerals.findMostFullBag(rover.getInventory(), mineralType);
        boolean bagAvailable = bag != null;
        double carryMass = 0.0;
        if (bag != null) {
            carryMass += bag.getMass();
        }
        if ((suit = (EVASuit)rover.getInventory().findUnitOfClass(EVASuit.class)) != null) {
            carryMass += suit.getMass();
            AmountResource oxygenResource = AmountResource.findAmountResource("oxygen");
            carryMass += suit.getInventory().getAmountResourceRemainingCapacity(oxygenResource, false, false);
            AmountResource waterResource = AmountResource.findAmountResource("water");
            carryMass += suit.getInventory().getAmountResourceRemainingCapacity(waterResource, false, false);
        }
        boolean canCarryEquipment = (carryCapacity = person.getInventory().getGeneralCapacity()) >= carryMass;
        return exitable && (sunlight || darkRegion) && !medical && bagAvailable && canCarryEquipment;
    }

    @Override
    protected void addExperience(double time) {
        double evaExperience = time / 100.0;
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        evaExperience += evaExperience * experienceAptitudeModifier;
        this.person.getMind().getSkillManager().addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
        if (COLLECT_MINERALS.equals(this.getPhase())) {
            double areologyExperience = time / 10.0;
            areologyExperience += areologyExperience * experienceAptitudeModifier;
            this.person.getMind().getSkillManager().addExperience("Areology", areologyExperience);
        }
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("EVA Operations");
        results.add("Areology");
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        int EVAOperationsSkill = manager.getEffectiveSkillLevel("EVA Operations");
        int areologySkill = manager.getEffectiveSkillLevel("Areology");
        return (int)Math.round((double)(EVAOperationsSkill + areologySkill) / 2.0);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if ("Exit Airlock".equals(this.getPhase())) {
            return this.exitRover(time);
        }
        if (COLLECT_MINERALS.equals(this.getPhase())) {
            return this.collectMinerals(time);
        }
        if ("Enter Airlock".equals(this.getPhase())) {
            return this.enterRover(time);
        }
        return time;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.rover = null;
        this.mineralType = null;
    }
}

