/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyManager;

public class CompileScientificStudyResults
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(CompileScientificStudyResults.class.getName());
    private static final double STRESS_MODIFIER = 0.0;
    private static final String COMPILING_PHASE = "Compiling Study Data";
    private ScientificStudy study = this.determineStudy();

    public CompileScientificStudyResults(Person person) {
        super("Compiling Scientific Study Data Results", person, true, false, 0.0, true, RandomUtil.getRandomDouble(100.0));
        if (this.study != null) {
            this.setDescription("Compiling Data Results for " + this.study.toString());
        } else {
            logger.info("study could not be determined");
            this.endTask();
        }
        this.addPhase(COMPILING_PHASE);
        this.setPhase(COMPILING_PHASE);
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        ScientificStudyManager studyManager = Simulation.instance().getScientificStudyManager();
        ScientificStudy primaryStudy = studyManager.getOngoingPrimaryStudy(person);
        if (primaryStudy != null && "Writing Paper".equals(primaryStudy.getPhase()) && !primaryStudy.isPrimaryPaperCompleted()) {
            try {
                double primaryResult = 50.0;
                Job job = person.getMind().getJob();
                if (job != null) {
                    Science jobScience = ScienceUtil.getAssociatedScience(job);
                    if (!primaryStudy.getScience().equals(jobScience)) {
                        primaryResult /= 2.0;
                    }
                }
                result += primaryResult;
            }
            catch (Exception e) {
                logger.severe("getProbability(): " + e.getMessage());
            }
        }
        for (ScientificStudy collabStudy : studyManager.getOngoingCollaborativeStudies(person)) {
            if (!"Writing Paper".equals(collabStudy.getPhase()) || collabStudy.isCollaborativePaperCompleted(person)) continue;
            try {
                Science jobScience;
                Science collabScience = collabStudy.getCollaborativeResearchers().get(person);
                double collabResult = 25.0;
                Job job = person.getMind().getJob();
                if (job != null && !collabScience.equals(jobScience = ScienceUtil.getAssociatedScience(job))) {
                    collabResult /= 2.0;
                }
                result += collabResult;
            }
            catch (Exception e) {
                logger.severe("getProbability(): " + e.getMessage());
            }
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(CompileScientificStudyResults.class);
        }
        return result;
    }

    private ScientificStudy determineStudy() {
        ScientificStudy result = null;
        ArrayList<ScientificStudy> possibleStudies = new ArrayList<ScientificStudy>();
        ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
        ScientificStudy primaryStudy = manager.getOngoingPrimaryStudy(this.person);
        if (primaryStudy != null && "Writing Paper".equals(primaryStudy.getPhase()) && !primaryStudy.isPrimaryPaperCompleted()) {
            possibleStudies.add(primaryStudy);
            possibleStudies.add(primaryStudy);
        }
        for (ScientificStudy collabStudy : manager.getOngoingCollaborativeStudies(this.person)) {
            if (!"Writing Paper".equals(collabStudy.getPhase()) || collabStudy.isCollaborativePaperCompleted(this.person)) continue;
            possibleStudies.add(collabStudy);
        }
        if (possibleStudies.size() > 0) {
            int selected = RandomUtil.getRandomInt(possibleStudies.size() - 1);
            result = (ScientificStudy)possibleStudies.get(selected);
        }
        return result;
    }

    private Science getScience() {
        Science result = null;
        if (this.study.getPrimaryResearcher().equals(this.person)) {
            result = this.study.getScience();
        } else if (this.study.getCollaborativeResearchers().containsKey(this.person)) {
            result = this.study.getCollaborativeResearchers().get(this.person);
        }
        return result;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 25.0;
        int academicAptitude = this.person.getNaturalAttributeManager().getAttribute("Academic Aptitude");
        newPoints += newPoints * ((double)academicAptitude - 50.0) / 100.0;
        String scienceSkill = ScienceUtil.getAssociatedSkill(this.getScience());
        this.person.getMind().getSkillManager().addExperience(scienceSkill, newPoints *= this.getTeachingExperienceModifier());
    }

    private double getEffectiveCompilationTime(double time) {
        double compilationTime = time;
        int scienceSkill = this.getEffectiveSkillLevel();
        if (scienceSkill == 0) {
            compilationTime /= 2.0;
        }
        if (scienceSkill > 1) {
            compilationTime += compilationTime * (0.2 * (double)scienceSkill);
        }
        return compilationTime;
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        String scienceSkill = ScienceUtil.getAssociatedSkill(this.getScience());
        results.add(scienceSkill);
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        String scienceSkill = ScienceUtil.getAssociatedSkill(this.getScience());
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel(scienceSkill);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (COMPILING_PHASE.equals(this.getPhase())) {
            return this.compilingPhase(time);
        }
        return time;
    }

    private double compilingPhase(double time) {
        boolean isPrimary;
        if (this.person.getPerformanceRating() == 0.0) {
            this.endTask();
        }
        if (isPrimary = this.study.getPrimaryResearcher().equals(this.person)) {
            if (this.study.isPrimaryPaperCompleted()) {
                this.endTask();
            }
        } else if (this.study.isCollaborativePaperCompleted(this.person)) {
            this.endTask();
        }
        if (this.isDone()) {
            return time;
        }
        double compilingTime = this.getEffectiveCompilationTime(time);
        if (isPrimary) {
            this.study.addPrimaryPaperWorkTime(compilingTime);
        } else {
            this.study.addCollaborativePaperWorkTime(this.person, compilingTime);
        }
        this.addExperience(time);
        return 0.0;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.study = null;
    }
}

