/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.mars.Mars;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.task.EnterAirlock;
import org.mars_sim.msp.core.person.ai.task.ExitAirlock;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.Airlockable;
import org.mars_sim.msp.core.vehicle.Vehicle;

public abstract class EVAOperation
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(EVAOperation.class.getName());
    protected static final String EXIT_AIRLOCK = "Exit Airlock";
    protected static final String ENTER_AIRLOCK = "Enter Airlock";
    private static final double STRESS_MODIFIER = 0.5;
    public static final double BASE_ACCIDENT_CHANCE = 0.001;
    protected boolean exitedAirlock = false;
    protected boolean enteredAirlock = false;
    private boolean endEVA;
    protected Unit containerUnit;

    public EVAOperation(String name, Person person) {
        super(name, person, true, false, 0.5, false, 0.0);
        this.containerUnit = person.getTopContainerUnit();
        this.addPhase(EXIT_AIRLOCK);
        this.addPhase(ENTER_AIRLOCK);
        this.setPhase(EXIT_AIRLOCK);
    }

    public void endEVA() {
        this.endEVA = true;
    }

    protected double exitAirlock(double time, Airlock airlock) {
        if (this.person.getLocationSituation().equals("Outside")) {
            this.exitedAirlock = true;
            return time;
        }
        if (ExitAirlock.canExitAirlock(this.person, airlock)) {
            this.addSubTask(new ExitAirlock(this.person, airlock));
            return 0.0;
        }
        this.endTask();
        throw new IllegalStateException(this.person.getName() + " unable to exit airlock of " + airlock.getEntityName());
    }

    protected double enterAirlock(double time, Airlock airlock) {
        if (this.person.getLocationSituation().equals("Outside")) {
            if (EnterAirlock.canEnterAirlock(this.person, airlock)) {
                this.addSubTask(new EnterAirlock(this.person, airlock));
                return 0.0;
            }
            this.endTask();
            throw new IllegalStateException(this.person.getName() + " unable to enter airlock of " + airlock.getEntityName());
        }
        this.enteredAirlock = true;
        return time;
    }

    protected boolean shouldEndEVAOperation() {
        EVASuit suit;
        Mars mars;
        boolean result = false;
        if (this.endEVA) {
            result = true;
        }
        if ((mars = Simulation.instance().getMars()).getSurfaceFeatures().getSurfaceSunlight(this.person.getCoordinates()) == 0.0) {
            logger.fine(this.person.getName() + " should end EVA: night time.");
            if (!mars.getSurfaceFeatures().inDarkPolarRegion(this.person.getCoordinates())) {
                result = true;
            }
        }
        if ((suit = (EVASuit)this.person.getInventory().findUnitOfClass(EVASuit.class)) == null) {
            logger.fine(this.person.getName() + " should end EVA: No EVA suit found.");
            return true;
        }
        Inventory suitInv = suit.getInventory();
        try {
            AmountResource oxygenResource = AmountResource.findAmountResource("oxygen");
            double oxygenCap = suitInv.getAmountResourceCapacity(oxygenResource, false);
            double oxygen = suitInv.getAmountResourceStored(oxygenResource, false);
            if (oxygen <= oxygenCap * 0.15) {
                logger.fine(this.person.getName() + " should end EVA: EVA suit oxygen level less than 15%");
                result = true;
            }
            AmountResource waterResource = AmountResource.findAmountResource("water");
            double waterCap = suitInv.getAmountResourceCapacity(waterResource, false);
            double water = suitInv.getAmountResourceStored(waterResource, false);
            if (water <= waterCap * 0.15) {
                logger.fine(this.person.getName() + " should end EVA: EVA suit water level less than 15%");
                result = true;
            }
            if (!suit.lifeSupportCheck()) {
                logger.fine(this.person.getName() + " should end EVA: EVA suit failed life support check.");
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (suit.getMalfunctionManager().hasMalfunction()) {
            logger.fine(this.person.getName() + " should end EVA: EVA suit has malfunction.");
            result = true;
        }
        if (this.person.getPerformanceRating() < 0.5) {
            logger.fine(this.person.getName() + " should end EVA: medical problems.");
            result = true;
        }
        return result;
    }

    protected void checkForAccident(double time) {
        EVASuit suit = (EVASuit)this.person.getInventory().findUnitOfClass(EVASuit.class);
        if (suit != null) {
            double chance = 0.001;
            int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("EVA Operations");
            chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
            if (RandomUtil.lessThanRandPercent((chance *= suit.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
                logger.fine(this.person.getName() + " has accident during EVA operation.");
                suit.getMalfunctionManager().accident();
            }
        }
    }

    public static Airlock getAvailableAirlock(Person person) {
        Vehicle vehicle;
        Airlock result = null;
        String location = person.getLocationSituation();
        if (location.equals("In Settlement")) {
            Settlement settlement = person.getSettlement();
            result = settlement.getAvailableAirlock();
        } else if (location.equals("In Vehicle") && (vehicle = person.getVehicle()) instanceof Airlockable) {
            result = ((Airlockable)((Object)vehicle)).getAirlock();
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.containerUnit = null;
    }
}

