/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.social.Relationship;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyManager;
import org.mars_sim.msp.core.science.ScientificStudyUtil;
import org.mars_sim.msp.core.structure.Settlement;

public class InviteStudyCollaborator
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(InviteStudyCollaborator.class.getName());
    private static final double STRESS_MODIFIER = 0.0;
    private static final double DURATION = 50.0;
    private static final String WRITING_INVITATION = "Writing Invitation";
    private ScientificStudy study;
    private Person invitee;

    public InviteStudyCollaborator(Person person) {
        super("Writing Study Collaboration Invitation", person, false, true, 0.0, true, 50.0);
        ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
        this.study = manager.getOngoingPrimaryStudy(person);
        if (this.study != null) {
            this.invitee = this.determineBestInvitee();
            if (this.invitee == null) {
                logger.log(Level.SEVERE, "No available collaborative researchers available for invitation.");
                this.endTask();
            }
        } else {
            logger.log(Level.SEVERE, person.getName() + " does not have a primary scientific study.");
            this.endTask();
        }
        this.addPhase(WRITING_INVITATION);
        this.setPhase(WRITING_INVITATION);
    }

    public static double getProbability(Person person) {
        Job job;
        double result = 0.0;
        ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
        ScientificStudy study = manager.getOngoingPrimaryStudy(person);
        if (study != null && study.getPhase().equals("Collaborator Invitation")) {
            int collabNum = study.getCollaborativeResearchers().size();
            int openInvites = study.getNumOpenResearchInvitations();
            if (openInvites + collabNum < 3 && ScientificStudyUtil.getAvailableCollaboratorsForInvite(study).size() > 0) {
                result = 25.0;
                Job job2 = person.getMind().getJob();
                Science science = study.getScience();
                if (science.equals(ScienceUtil.getAssociatedScience(job2))) {
                    result *= 2.0;
                }
            }
        }
        if ((job = person.getMind().getJob()) != null) {
            result *= job.getStartTaskProbabilityModifier(InviteStudyCollaborator.class);
        }
        return result;
    }

    private Person determineBestInvitee() {
        Person bestInvitee = null;
        double bestValue = Double.NEGATIVE_INFINITY;
        for (Person invitee : ScientificStudyUtil.getAvailableCollaboratorsForInvite(this.study)) {
            double inviteeValue = 0.0;
            Science jobScience = ScienceUtil.getAssociatedScience(invitee.getMind().getJob());
            String skillName = ScienceUtil.getAssociatedSkill(jobScience);
            int skillLevel = invitee.getMind().getSkillManager().getEffectiveSkillLevel(skillName);
            inviteeValue += (double)skillLevel;
            double achievement = invitee.getScientificAchievement(jobScience);
            inviteeValue += achievement;
            if (!jobScience.equals(this.study.getScience())) {
                inviteeValue /= 2.0;
            }
            double totalAchievement = invitee.getTotalScientificAchievement();
            inviteeValue += totalAchievement / 10.0;
            RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
            double opinion = relationshipManager.getOpinionOfPerson(this.study.getPrimaryResearcher(), invitee);
            inviteeValue *= opinion / 100.0;
            ScientificStudyManager studyManager = Simulation.instance().getScientificStudyManager();
            int numCollaborativeStudies = studyManager.getOngoingCollaborativeStudies(invitee).size();
            inviteeValue /= (double)numCollaborativeStudies + 1.0;
            Settlement researcherSettlement = this.person.getAssociatedSettlement();
            Settlement primarySettlement = this.study.getPrimaryResearcher().getAssociatedSettlement();
            if (researcherSettlement != null && researcherSettlement.equals(primarySettlement)) {
                inviteeValue *= 2.0;
            }
            if (!(inviteeValue > bestValue)) continue;
            bestInvitee = invitee;
            bestValue = inviteeValue;
        }
        return bestInvitee;
    }

    private double writingInvitationPhase(double time) {
        if (this.isDone()) {
            return time;
        }
        if (this.getDuration() <= this.getTimeCompleted() + time) {
            this.study.addInvitedResearcher(this.invitee);
            RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
            if (!relationshipManager.hasRelationship(this.person, this.invitee)) {
                relationshipManager.addRelationship(this.person, this.invitee, "Communication Meeting");
            }
            Relationship relationship = relationshipManager.getRelationship(this.invitee, this.person);
            double currentOpinion = relationship.getPersonOpinion(this.invitee);
            relationship.setPersonOpinion(this.invitee, currentOpinion + 10.0);
            logger.info(this.person.getName() + " inviting " + this.invitee.getName() + " to collaborate in " + this.study.toString());
        }
        return 0.0;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 25.0;
        int academicAptitude = this.person.getNaturalAttributeManager().getAttribute("Academic Aptitude");
        newPoints += newPoints * ((double)academicAptitude - 50.0) / 100.0;
        String skillName = ScienceUtil.getAssociatedSkill(this.study.getScience());
        this.person.getMind().getSkillManager().addExperience(skillName, newPoints *= this.getTeachingExperienceModifier());
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> skills = new ArrayList<String>(1);
        skills.add(ScienceUtil.getAssociatedSkill(this.study.getScience()));
        return skills;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        String skillName = ScienceUtil.getAssociatedSkill(this.study.getScience());
        return manager.getEffectiveSkillLevel(skillName);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (WRITING_INVITATION.equals(this.getPhase())) {
            return this.writingInvitationPhase(time);
        }
        return time;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.study = null;
        this.invitee = null;
    }
}

