/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.EVAOperation;
import org.mars_sim.msp.core.person.ai.task.Maintenance;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class MaintainGroundVehicleEVA
extends EVAOperation
implements Serializable {
    private static Logger logger = Logger.getLogger(MaintainGroundVehicleEVA.class.getName());
    private static final String MAINTAIN_VEHICLE = "Maintain Vehicle";
    private GroundVehicle vehicle;
    private Airlock airlock;

    public MaintainGroundVehicleEVA(Person person) {
        super("Performing Vehicle Maintenance", person);
        this.vehicle = this.getNeedyGroundVehicle(person);
        if (this.vehicle != null) {
            this.vehicle.setReservedForMaintenance(true);
        } else {
            this.endTask();
        }
        this.airlock = MaintainGroundVehicleEVA.getAvailableAirlock(person);
        if (this.airlock == null) {
            this.endTask();
        }
        this.addPhase(MAINTAIN_VEHICLE);
        logger.finest(person.getName() + " starting MaintainGroundVehicleEVA task.");
    }

    public static double getProbability(Person person) {
        Settlement settlement;
        SurfaceFeatures surface;
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            Iterator<Vehicle> i = MaintainGroundVehicleEVA.getAllVehicleCandidates(person).iterator();
            while (i.hasNext()) {
                MalfunctionManager manager = i.next().getMalfunctionManager();
                double entityProb = manager.getEffectiveTimeSinceLastMaintenance() / 20.0;
                if (entityProb > 100.0) {
                    entityProb = 100.0;
                }
                result += entityProb;
            }
        }
        if (person.getLocationSituation().equals("In Settlement") && person.getSettlement().getBuildingManager().getBuildings("Ground Vehicle Maintenance").size() > 0) {
            result = 0.0;
        }
        if (MaintainGroundVehicleEVA.getAvailableAirlock(person) == null) {
            result = 0.0;
        }
        if ((surface = Simulation.instance().getMars().getSurfaceFeatures()).getSurfaceSunlight(person.getCoordinates()) == 0.0 && !surface.inDarkPolarRegion(person.getCoordinates())) {
            result = 0.0;
        }
        if (person.getLocationSituation().equals("In Settlement") && (settlement = person.getSettlement()).getCurrentPopulationNum() > settlement.getPopulationCapacity()) {
            result *= 2.0;
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(MaintainGroundVehicleEVA.class);
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if ("Exit Airlock".equals(this.getPhase())) {
            return this.exitEVA(time);
        }
        if (MAINTAIN_VEHICLE.equals(this.getPhase())) {
            return this.maintainVehicle(time);
        }
        if ("Enter Airlock".equals(this.getPhase())) {
            return this.enterEVA(time);
        }
        return time;
    }

    @Override
    protected void addExperience(double time) {
        double evaExperience = time / 100.0;
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        evaExperience += evaExperience * experienceAptitudeModifier;
        this.person.getMind().getSkillManager().addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
        if (MAINTAIN_VEHICLE.equals(this.getPhase())) {
            double mechanicsExperience = time / 100.0;
            mechanicsExperience += mechanicsExperience * experienceAptitudeModifier;
            this.person.getMind().getSkillManager().addExperience("Mechanics", mechanicsExperience);
        }
    }

    private double exitEVA(double time) {
        try {
            time = this.exitAirlock(time, this.airlock);
            this.addExperience(time);
        }
        catch (Exception e) {
            this.endTask();
        }
        if (this.exitedAirlock) {
            this.setPhase(MAINTAIN_VEHICLE);
            this.moveToMaintenanceLocation();
        }
        return time;
    }

    private void moveToMaintenanceLocation() {
        Point2D.Double newLocation = null;
        boolean goodLocation = false;
        for (int x = 0; x < 20 && !goodLocation; ++x) {
            Point2D.Double boundedLocalPoint = LocalAreaUtil.getRandomExteriorLocation(this.vehicle, 1.0);
            newLocation = LocalAreaUtil.getLocalRelativeLocation(boundedLocalPoint.getX(), boundedLocalPoint.getY(), this.vehicle);
            goodLocation = LocalAreaUtil.checkLocationCollision(newLocation.getX(), newLocation.getY(), this.person.getCoordinates());
        }
        this.person.setXLocation(newLocation.getX());
        this.person.setYLocation(newLocation.getY());
    }

    private double maintainVehicle(double time) {
        Inventory inv;
        boolean finishedMaintenance;
        MalfunctionManager manager = this.vehicle.getMalfunctionManager();
        boolean malfunction = manager.hasMalfunction();
        boolean bl = finishedMaintenance = manager.getEffectiveTimeSinceLastMaintenance() == 0.0;
        if (finishedMaintenance) {
            this.vehicle.setReservedForMaintenance(false);
        }
        if (finishedMaintenance || malfunction || this.shouldEndEVAOperation()) {
            this.setPhase("Enter Airlock");
            return time;
        }
        double workTime = time;
        int skill = this.getEffectiveSkillLevel();
        if (skill == 0) {
            workTime /= 2.0;
        }
        if (skill > 1) {
            workTime += workTime * (0.2 * (double)skill);
        }
        if (Maintenance.hasMaintenanceParts(inv = this.containerUnit.getInventory(), (Malfunctionable)this.vehicle)) {
            HashMap<Part, Integer> parts = new HashMap<Part, Integer>(manager.getMaintenanceParts());
            for (Part part : parts.keySet()) {
                int number = (Integer)parts.get(part);
                inv.retrieveItemResources(part, number);
                manager.maintainWithParts(part, number);
            }
        } else {
            this.setPhase("Enter Airlock");
            return time;
        }
        manager.addMaintenanceWorkTime(workTime);
        this.addExperience(time);
        this.checkForAccident(time);
        return 0.0;
    }

    private double enterEVA(double time) {
        time = this.enterAirlock(time, this.airlock);
        this.addExperience(time);
        if (this.enteredAirlock) {
            this.endTask();
        }
        return time;
    }

    @Override
    protected void checkForAccident(double time) {
        super.checkForAccident(time);
        double chance = 0.001;
        int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Mechanics");
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        if (RandomUtil.lessThanRandPercent((chance *= this.vehicle.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            this.vehicle.getMalfunctionManager().accident();
        }
    }

    public Malfunctionable getVehicle() {
        return this.vehicle;
    }

    private static Collection<Vehicle> getAllVehicleCandidates(Person person) {
        ConcurrentLinkedQueue<Vehicle> result = new ConcurrentLinkedQueue<Vehicle>();
        Settlement settlement = person.getSettlement();
        if (settlement != null) {
            for (Vehicle vehicle : settlement.getParkedVehicles()) {
                if (!(vehicle instanceof GroundVehicle) || vehicle.isReservedForMission()) continue;
                result.add(vehicle);
            }
        }
        return result;
    }

    private GroundVehicle getNeedyGroundVehicle(Person person) {
        GroundVehicle result = null;
        Collection<Vehicle> availableVehicles = MaintainGroundVehicleEVA.getAllVehicleCandidates(person);
        HashMap<Vehicle, Double> vehicleProb = new HashMap<Vehicle, Double>(availableVehicles.size());
        for (Vehicle vehicle : availableVehicles) {
            double prob = this.getProbabilityWeight(vehicle);
            if (!(prob > 0.0)) continue;
            vehicleProb.put(vehicle, prob);
        }
        if (!vehicleProb.isEmpty()) {
            result = (GroundVehicle)RandomUtil.getWeightedRandomObject(vehicleProb);
        }
        if (result != null) {
            this.setDescription("Performing maintenance on " + result.getName());
        }
        return result;
    }

    private double getProbabilityWeight(Vehicle vehicle) {
        double result = 0.0;
        MalfunctionManager manager = vehicle.getMalfunctionManager();
        boolean hasMalfunction = manager.hasMalfunction();
        double effectiveTime = manager.getEffectiveTimeSinceLastMaintenance();
        boolean minTime = effectiveTime >= 1000.0;
        boolean enoughParts = Maintenance.hasMaintenanceParts(this.person, (Malfunctionable)vehicle);
        if (!hasMalfunction && minTime && enoughParts) {
            result = effectiveTime;
        }
        return result;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        int EVAOperationsSkill = manager.getEffectiveSkillLevel("EVA Operations");
        int mechanicsSkill = manager.getEffectiveSkillLevel("Mechanics");
        return (int)Math.round((double)(EVAOperationsSkill + mechanicsSkill) / 2.0);
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("EVA Operations");
        results.add("Mechanics");
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.vehicle = null;
        this.airlock = null;
    }
}

