/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.Maintenance;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.VehicleMaintenance;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class MaintainGroundVehicleGarage
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(MaintainGroundVehicleGarage.class.getName());
    private static final String MAINTAIN_VEHICLE = "Maintaining Vehicle";
    private static final double STRESS_MODIFIER = 0.1;
    private VehicleMaintenance garage;
    private GroundVehicle vehicle;

    public MaintainGroundVehicleGarage(Person person) {
        super("Performing Vehicle Maintenance", person, true, false, 0.1, true, RandomUtil.getRandomDouble(200.0));
        this.vehicle = this.getNeedyGroundVehicle(person);
        if (this.vehicle != null) {
            this.vehicle.setReservedForMaintenance(true);
        }
        if (this.vehicle != null) {
            Building building = BuildingManager.getBuilding(this.vehicle);
            if (building != null) {
                try {
                    this.garage = (VehicleMaintenance)building.getFunction("Ground Vehicle Maintenance");
                    BuildingManager.addPersonToBuilding(person, building);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "MaintainGroundVehicleGarage.constructor: ", e);
                }
            } else {
                Settlement settlement = person.getSettlement();
                Iterator<Building> j = settlement.getBuildingManager().getBuildings("Ground Vehicle Maintenance").iterator();
                while (j.hasNext() && this.garage == null) {
                    try {
                        Building garageBuilding = j.next();
                        VehicleMaintenance garageTemp = (VehicleMaintenance)garageBuilding.getFunction("Ground Vehicle Maintenance");
                        if (garageTemp.getCurrentVehicleNumber() >= garageTemp.getVehicleCapacity()) continue;
                        this.garage = garageTemp;
                        this.garage.addVehicle(this.vehicle);
                        BuildingManager.addPersonToBuilding(person, garageBuilding);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "MaintainGroundVehicleGarage.constructor: ", e);
                    }
                }
            }
        }
        if (this.vehicle == null || this.garage == null) {
            this.endTask();
        }
        this.addPhase(MAINTAIN_VEHICLE);
        this.setPhase(MAINTAIN_VEHICLE);
        logger.finest(person.getName() + " starting MaintainGroundVehicleGarage task.");
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        try {
            if (person.getLocationSituation().equals("In Settlement")) {
                for (Vehicle vehicle : MaintainGroundVehicleGarage.getAllVehicleCandidates(person)) {
                    boolean minTime;
                    MalfunctionManager manager = vehicle.getMalfunctionManager();
                    boolean hasMalfunction = manager.hasMalfunction();
                    boolean hasParts = Maintenance.hasMaintenanceParts(person, (Malfunctionable)vehicle);
                    double effectiveTime = manager.getEffectiveTimeSinceLastMaintenance();
                    boolean bl = minTime = effectiveTime >= 1000.0;
                    if (hasMalfunction || !hasParts || !minTime) continue;
                    double entityProb = effectiveTime / 20.0;
                    if (entityProb > 100.0) {
                        entityProb = 100.0;
                    }
                    result += entityProb;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getProbability()", e);
        }
        boolean garageSpace = false;
        boolean needyVehicleInGarage = false;
        if (person.getLocationSituation().equals("In Settlement")) {
            Settlement settlement = person.getSettlement();
            Iterator<Building> j = settlement.getBuildingManager().getBuildings("Ground Vehicle Maintenance").iterator();
            while (j.hasNext() && !garageSpace) {
                try {
                    Building building = j.next();
                    VehicleMaintenance garage = (VehicleMaintenance)building.getFunction("Ground Vehicle Maintenance");
                    if (garage.getCurrentVehicleNumber() < garage.getVehicleCapacity()) {
                        garageSpace = true;
                    }
                    Iterator<Vehicle> i = garage.getVehicles().iterator();
                    while (i.hasNext()) {
                        if (!i.next().isReservedForMaintenance()) continue;
                        needyVehicleInGarage = true;
                    }
                }
                catch (Exception e) {
                }
            }
        }
        if (!garageSpace && !needyVehicleInGarage) {
            result = 0.0;
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(MaintainGroundVehicleGarage.class);
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (MAINTAIN_VEHICLE.equals(this.getPhase())) {
            return this.maintainVehiclePhase(time);
        }
        return time;
    }

    private double maintainVehiclePhase(double time) {
        MalfunctionManager manager = this.vehicle.getMalfunctionManager();
        if (this.person.getPerformanceRating() == 0.0) {
            this.endTask();
        }
        if (manager.getEffectiveTimeSinceLastMaintenance() == 0.0) {
            this.endTask();
        }
        if (manager.hasMalfunction()) {
            this.endTask();
        }
        if (this.isDone()) {
            return time;
        }
        Inventory inv = this.person.getTopContainerUnit().getInventory();
        if (Maintenance.hasMaintenanceParts(inv, (Malfunctionable)this.vehicle)) {
            HashMap<Part, Integer> parts = new HashMap<Part, Integer>(manager.getMaintenanceParts());
            for (Part part : parts.keySet()) {
                int number = (Integer)parts.get(part);
                inv.retrieveItemResources(part, number);
                manager.maintainWithParts(part, number);
            }
        } else {
            this.vehicle.setReservedForMaintenance(false);
            this.garage.removeVehicle(this.vehicle);
            this.endTask();
            return time;
        }
        double workTime = time;
        int mechanicSkill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Mechanics");
        if (mechanicSkill == 0) {
            workTime /= 2.0;
        }
        if (mechanicSkill > 1) {
            workTime += workTime * (0.2 * (double)mechanicSkill);
        }
        manager.addMaintenanceWorkTime(workTime);
        this.addExperience(time);
        if (manager.getEffectiveTimeSinceLastMaintenance() == 0.0) {
            this.vehicle.setReservedForMaintenance(false);
            this.garage.removeVehicle(this.vehicle);
            this.endTask();
        }
        this.checkForAccident(time);
        return 0.0;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 100.0;
        int experienceAptitude = this.person.getNaturalAttributeManager().getAttribute("Experience Aptitude");
        newPoints += newPoints * ((double)experienceAptitude - 50.0) / 100.0;
        this.person.getMind().getSkillManager().addExperience("Mechanics", newPoints *= this.getTeachingExperienceModifier());
    }

    private void checkForAccident(double time) {
        double chance = 0.001;
        int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Mechanics");
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        if (RandomUtil.lessThanRandPercent((chance *= this.vehicle.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            logger.info(this.person.getName() + " has accident while performing maintenance on " + this.vehicle.getName() + ".");
            this.vehicle.getMalfunctionManager().accident();
        }
    }

    public Malfunctionable getVehicle() {
        return this.vehicle;
    }

    private static Collection<Vehicle> getAllVehicleCandidates(Person person) {
        ConcurrentLinkedQueue<Vehicle> result = new ConcurrentLinkedQueue<Vehicle>();
        if (person.getLocationSituation().equals("In Settlement")) {
            for (Vehicle vehicle : person.getSettlement().getParkedVehicles()) {
                if (!(vehicle instanceof GroundVehicle) || vehicle.isReservedForMission()) continue;
                result.add(vehicle);
            }
        }
        return result;
    }

    private GroundVehicle getNeedyGroundVehicle(Person person) {
        GroundVehicle result = null;
        Collection<Vehicle> availableVehicles = MaintainGroundVehicleGarage.getAllVehicleCandidates(person);
        HashMap<Vehicle, Double> vehicleProb = new HashMap<Vehicle, Double>(availableVehicles.size());
        for (Vehicle vehicle : availableVehicles) {
            double prob = this.getProbabilityWeight(vehicle);
            if (!(prob > 0.0)) continue;
            vehicleProb.put(vehicle, prob);
        }
        if (!vehicleProb.isEmpty()) {
            result = (GroundVehicle)RandomUtil.getWeightedRandomObject(vehicleProb);
        }
        if (result != null) {
            this.setDescription("Performing maintenance on " + result.getName());
        }
        return result;
    }

    private double getProbabilityWeight(Vehicle vehicle) {
        double result = 0.0;
        MalfunctionManager manager = vehicle.getMalfunctionManager();
        boolean hasMalfunction = manager.hasMalfunction();
        double effectiveTime = manager.getEffectiveTimeSinceLastMaintenance();
        boolean minTime = effectiveTime >= 1000.0;
        boolean enoughParts = Maintenance.hasMaintenanceParts(this.person, (Malfunctionable)vehicle);
        if (!hasMalfunction && minTime && enoughParts) {
            result = effectiveTime;
        }
        return result;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel("Mechanics");
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        results.add("Mechanics");
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.garage = null;
        this.vehicle = null;
    }
}

