/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.malfunction.MalfunctionFactory;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class Maintenance
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(Maintenance.class.getName());
    private static final String MAINTAIN = "Maintain";
    private static final double STRESS_MODIFIER = 0.1;
    private Malfunctionable entity;

    public Maintenance(Person person) {
        super("Performing Maintenance", person, true, false, 0.1, true, RandomUtil.getRandomDouble(200.0));
        try {
            this.entity = this.getMaintenanceMalfunctionable();
            if (this.entity == null) {
                this.endTask();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Maintenance.constructor()", e);
            this.endTask();
        }
        this.addPhase(MAINTAIN);
        this.setPhase(MAINTAIN);
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        try {
            for (Malfunctionable entity : MalfunctionFactory.getMalfunctionables(person)) {
                boolean minTime;
                boolean isVehicle = entity instanceof Vehicle;
                boolean uninhabitableBuilding = false;
                if (entity instanceof Building) {
                    uninhabitableBuilding = !((Building)entity).hasFunction("Life Support");
                }
                MalfunctionManager manager = entity.getMalfunctionManager();
                boolean hasMalfunction = manager.hasMalfunction();
                boolean hasParts = Maintenance.hasMaintenanceParts(person, entity);
                double effectiveTime = manager.getEffectiveTimeSinceLastMaintenance();
                boolean bl = minTime = effectiveTime >= 1000.0;
                if (hasMalfunction || isVehicle || uninhabitableBuilding || !hasParts || !minTime) continue;
                double entityProb = effectiveTime / 1000.0;
                if (entityProb > 100.0) {
                    entityProb = 100.0;
                }
                result += entityProb;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "getProbability()", e);
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(Maintenance.class);
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (MAINTAIN.equals(this.getPhase())) {
            return this.maintainPhase(time);
        }
        return time;
    }

    private double maintainPhase(double time) {
        Inventory inv;
        MalfunctionManager manager = this.entity.getMalfunctionManager();
        if (this.person.getPerformanceRating() == 0.0) {
            this.endTask();
        }
        if (manager.getEffectiveTimeSinceLastMaintenance() < 1000.0) {
            this.endTask();
        }
        if (manager.hasMalfunction()) {
            this.endTask();
        }
        if (this.isDone()) {
            return time;
        }
        double workTime = time;
        int mechanicSkill = this.getEffectiveSkillLevel();
        if (mechanicSkill == 0) {
            workTime /= 2.0;
        }
        if (mechanicSkill > 1) {
            workTime += workTime * (0.2 * (double)mechanicSkill);
        }
        boolean repairParts = false;
        Unit container = this.person.getTopContainerUnit();
        if (container != null && Maintenance.hasMaintenanceParts(inv = container.getInventory(), this.entity)) {
            repairParts = true;
            HashMap<Part, Integer> parts = new HashMap<Part, Integer>(manager.getMaintenanceParts());
            for (Part part : parts.keySet()) {
                int number = (Integer)parts.get(part);
                inv.retrieveItemResources(part, number);
                manager.maintainWithParts(part, number);
            }
        }
        if (!repairParts) {
            this.endTask();
            return time;
        }
        manager.addMaintenanceWorkTime(workTime);
        this.addExperience(time);
        if (manager.getEffectiveTimeSinceLastMaintenance() == 0.0) {
            this.endTask();
        }
        this.checkForAccident(time);
        return 0.0;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 100.0;
        int experienceAptitude = this.person.getNaturalAttributeManager().getAttribute("Experience Aptitude");
        newPoints += newPoints * ((double)experienceAptitude - 50.0) / 100.0;
        this.person.getMind().getSkillManager().addExperience("Mechanics", newPoints *= this.getTeachingExperienceModifier());
    }

    private void checkForAccident(double time) {
        double chance = 0.001;
        int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Mechanics");
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        if (RandomUtil.lessThanRandPercent((chance *= this.entity.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            logger.info(this.person.getName() + " has accident while performing maintenance on " + this.entity.getName() + ".");
            this.entity.getMalfunctionManager().accident();
        }
    }

    public Malfunctionable getEntity() {
        return this.entity;
    }

    private Malfunctionable getMaintenanceMalfunctionable() {
        Malfunctionable result = null;
        HashMap<Malfunctionable, Double> malfunctionables = new HashMap<Malfunctionable, Double>();
        for (Malfunctionable entity : MalfunctionFactory.getMalfunctionables(this.person)) {
            double probability = this.getProbabilityWeight(entity);
            if (!(probability > 0.0)) continue;
            malfunctionables.put(entity, probability);
        }
        if (!malfunctionables.isEmpty()) {
            result = (Malfunctionable)RandomUtil.getWeightedRandomObject(malfunctionables);
        }
        if (result != null) {
            this.setDescription("Performing maintenance on " + result.getName());
            if (result instanceof Building && this.isInhabitableBuilding(result)) {
                BuildingManager.addPersonToBuilding(this.person, (Building)result);
            }
        }
        return result;
    }

    private boolean isInhabitableBuilding(Malfunctionable malfunctionable) {
        Building building;
        boolean result = false;
        if (malfunctionable instanceof Building && (building = (Building)malfunctionable).hasFunction("Life Support")) {
            result = true;
        }
        return result;
    }

    private double getProbabilityWeight(Malfunctionable malfunctionable) {
        double result = 0.0;
        boolean isVehicle = malfunctionable instanceof Vehicle;
        boolean uninhabitableBuilding = false;
        if (malfunctionable instanceof Building) {
            uninhabitableBuilding = !((Building)malfunctionable).hasFunction("Life Support");
        }
        MalfunctionManager manager = malfunctionable.getMalfunctionManager();
        boolean hasMalfunction = manager.hasMalfunction();
        double effectiveTime = manager.getEffectiveTimeSinceLastMaintenance();
        boolean minTime = effectiveTime >= 1000.0;
        boolean enoughParts = Maintenance.hasMaintenanceParts(this.person, malfunctionable);
        if (!isVehicle && !uninhabitableBuilding && !hasMalfunction && minTime && enoughParts) {
            result = effectiveTime;
            if (malfunctionable instanceof Building) {
                Building building = (Building)malfunctionable;
                if (this.isInhabitableBuilding(malfunctionable)) {
                    result *= Task.getCrowdingProbabilityModifier(this.person, building);
                    result *= Task.getRelationshipModifier(this.person, building);
                }
            }
        }
        return result;
    }

    static boolean hasMaintenanceParts(Person person, Malfunctionable malfunctionable) {
        Inventory inv = null;
        inv = person.getTopContainerUnit() != null ? person.getTopContainerUnit().getInventory() : person.getInventory();
        return Maintenance.hasMaintenanceParts(inv, malfunctionable);
    }

    static boolean hasMaintenanceParts(Inventory inv, Malfunctionable malfunctionable) {
        boolean result = true;
        Map<Part, Integer> parts = malfunctionable.getMalfunctionManager().getMaintenanceParts();
        for (Part part : parts.keySet()) {
            int number = parts.get(part);
            if (inv.getItemResourceNum(part) >= number) continue;
            result = false;
        }
        return result;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel("Mechanics");
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        results.add("Mechanics");
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.entity = null;
    }
}

