/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.manufacture.ManufactureProcess;
import org.mars_sim.msp.core.manufacture.ManufactureProcessInfo;
import org.mars_sim.msp.core.manufacture.ManufactureProcessItem;
import org.mars_sim.msp.core.manufacture.ManufactureUtil;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.Manufacture;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.construction.ConstructionUtil;

public class ManufactureConstructionMaterials
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(ManufactureConstructionMaterials.class.getName());
    private static final String MANUFACTURE = "Manufacture";
    private static final double STRESS_MODIFIER = 0.1;
    private static List<AmountResource> constructionResources;
    private static List<Part> constructionParts;
    private Manufacture workshop;

    public ManufactureConstructionMaterials(Person person) {
        super("Manufacturing Construction Materials", person, true, false, 0.1, true, RandomUtil.getRandomDouble(100.0));
        if (person.getSettlement() != null) {
            this.setDescription("Manufacturing construction materials at " + person.getSettlement().getName());
        } else {
            this.endTask();
        }
        Building manufactureBuilding = ManufactureConstructionMaterials.getAvailableManufacturingBuilding(person);
        if (manufactureBuilding != null) {
            this.workshop = (Manufacture)manufactureBuilding.getFunction(MANUFACTURE);
            BuildingManager.addPersonToBuilding(person, manufactureBuilding);
        } else {
            this.endTask();
        }
        this.addPhase(MANUFACTURE);
        this.setPhase(MANUFACTURE);
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            try {
                Building manufacturingBuilding = ManufactureConstructionMaterials.getAvailableManufacturingBuilding(person);
                if (manufacturingBuilding != null) {
                    SkillManager skillManager;
                    int skill;
                    result = 1.0;
                    result *= Task.getCrowdingProbabilityModifier(person, manufacturingBuilding);
                    result *= Task.getRelationshipModifier(person, manufacturingBuilding);
                    if ((result *= ManufactureConstructionMaterials.getHighestManufacturingProcessValue(person, manufacturingBuilding)) > 100.0) {
                        result = 100.0;
                    }
                    if (ManufactureConstructionMaterials.hasProcessRequiringWork(manufacturingBuilding, skill = (skillManager = person.getMind().getSkillManager()).getEffectiveSkillLevel("Materials Science"))) {
                        result += 10.0;
                    } else if (person.getSettlement().getManufactureOverride()) {
                        result = 0.0;
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "ManufactureConstructionMaterials.getProbability()", e);
            }
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(ManufactureConstructionMaterials.class);
        }
        return result;
    }

    private static Building getAvailableManufacturingBuilding(Person person) {
        Building result = null;
        SkillManager skillManager = person.getMind().getSkillManager();
        int skill = skillManager.getEffectiveSkillLevel("Materials Science");
        if (person.getLocationSituation().equals("In Settlement")) {
            BuildingManager manager = person.getSettlement().getBuildingManager();
            List<Building> manufacturingBuildings = manager.getBuildings(MANUFACTURE);
            manufacturingBuildings = BuildingManager.getNonMalfunctioningBuildings(manufacturingBuildings);
            manufacturingBuildings = ManufactureConstructionMaterials.getManufacturingBuildingsNeedingWork(manufacturingBuildings, skill);
            manufacturingBuildings = ManufactureConstructionMaterials.getBuildingsWithProcessesRequiringWork(manufacturingBuildings, skill);
            manufacturingBuildings = ManufactureConstructionMaterials.getHighestManufacturingTechLevelBuildings(manufacturingBuildings);
            if ((manufacturingBuildings = BuildingManager.getLeastCrowdedBuildings(manufacturingBuildings)).size() > 0) {
                Map<Building, Double> manufacturingBuildingProbs = BuildingManager.getBestRelationshipBuildings(person, manufacturingBuildings);
                result = RandomUtil.getWeightedRandomObject(manufacturingBuildingProbs);
            }
        }
        return result;
    }

    private static List<Building> getManufacturingBuildingsNeedingWork(List<Building> buildingList, int skill) {
        ArrayList<Building> result = new ArrayList<Building>();
        for (Building building : buildingList) {
            Manufacture manufacturingFunction = (Manufacture)building.getFunction(MANUFACTURE);
            if (!manufacturingFunction.requiresManufacturingWork(skill)) continue;
            result.add(building);
        }
        return result;
    }

    private static List<Building> getBuildingsWithProcessesRequiringWork(List<Building> buildingList, int skill) {
        List<Building> result = new ArrayList<Building>();
        for (Building building : buildingList) {
            if (!ManufactureConstructionMaterials.hasProcessRequiringWork(building, skill)) continue;
            result.add(building);
        }
        if (result.size() == 0) {
            result = buildingList;
        }
        return result;
    }

    private static boolean hasProcessRequiringWork(Building manufacturingBuilding, int skill) {
        boolean result = false;
        Manufacture manufacturingFunction = (Manufacture)manufacturingBuilding.getFunction(MANUFACTURE);
        for (ManufactureProcess process : manufacturingFunction.getProcesses()) {
            boolean skillRequired;
            if (!ManufactureConstructionMaterials.producesConstructionMaterials(process)) continue;
            boolean workRequired = process.getWorkTimeRemaining() > 0.0;
            boolean bl = skillRequired = process.getInfo().getSkillLevelRequired() <= skill;
            if (!workRequired || !skillRequired) continue;
            result = true;
        }
        return result;
    }

    private static boolean producesConstructionMaterials(ManufactureProcess process) {
        return ManufactureConstructionMaterials.producesConstructionMaterials(process.getInfo());
    }

    private static List<Building> getHighestManufacturingTechLevelBuildings(List<Building> buildingList) {
        ArrayList<Building> result = new ArrayList<Building>();
        int highestTechLevel = 0;
        for (Building building : buildingList) {
            Manufacture manufacturingFunction = (Manufacture)building.getFunction(MANUFACTURE);
            if (manufacturingFunction.getTechLevel() <= highestTechLevel) continue;
            highestTechLevel = manufacturingFunction.getTechLevel();
        }
        for (Building building : buildingList) {
            Manufacture manufacturingFunction = (Manufacture)building.getFunction(MANUFACTURE);
            if (manufacturingFunction.getTechLevel() != highestTechLevel) continue;
            result.add(building);
        }
        return result;
    }

    private static double getHighestManufacturingProcessValue(Person person, Building manufacturingBuilding) {
        double highestProcessValue = 0.0;
        int skillLevel = person.getMind().getSkillManager().getEffectiveSkillLevel("Materials Science");
        Manufacture manufacturingFunction = (Manufacture)manufacturingBuilding.getFunction(MANUFACTURE);
        int techLevel = manufacturingFunction.getTechLevel();
        for (ManufactureProcessInfo process : ManufactureUtil.getManufactureProcessesForTechSkillLevel(techLevel, skillLevel)) {
            Settlement settlement;
            double processValue;
            if (!ManufactureUtil.canProcessBeStarted(process, manufacturingFunction) && !ManufactureConstructionMaterials.isProcessRunning(process, manufacturingFunction) || !ManufactureConstructionMaterials.producesConstructionMaterials(process) || !((processValue = ManufactureUtil.getManufactureProcessValue(process, settlement = manufacturingBuilding.getBuildingManager().getSettlement())) > highestProcessValue)) continue;
            highestProcessValue = processValue;
        }
        return highestProcessValue;
    }

    private static boolean producesConstructionMaterials(ManufactureProcessInfo info) {
        boolean result = false;
        if (constructionResources == null) {
            ManufactureConstructionMaterials.determineConstructionResources();
        }
        if (constructionParts == null) {
            ManufactureConstructionMaterials.determineConstructionParts();
        }
        for (ManufactureProcessItem item : info.getOutputList()) {
            Part part;
            if ("resource".equalsIgnoreCase(item.getType())) {
                AmountResource resource = AmountResource.findAmountResource(item.getName());
                if (!constructionResources.contains(resource)) continue;
                result = true;
                continue;
            }
            if (!"part".equalsIgnoreCase(item.getType()) || !constructionParts.contains(part = (Part)ItemResource.findItemResource(item.getName()))) continue;
            result = true;
        }
        return result;
    }

    private static void determineConstructionResources() {
        constructionResources = new ArrayList<AmountResource>();
        for (ConstructionStageInfo info : ConstructionUtil.getAllConstructionStageInfoList()) {
            if (!info.isConstructable()) continue;
            for (AmountResource resource : info.getResources().keySet()) {
                if (constructionResources.contains(resource)) continue;
                constructionResources.add(resource);
            }
        }
    }

    private static void determineConstructionParts() {
        constructionParts = new ArrayList<Part>();
        for (ConstructionStageInfo info : ConstructionUtil.getAllConstructionStageInfoList()) {
            if (!info.isConstructable()) continue;
            for (Part part : info.getParts().keySet()) {
                if (constructionParts.contains(part)) continue;
                constructionParts.add(part);
            }
        }
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 100.0;
        int experienceAptitude = this.person.getNaturalAttributeManager().getAttribute("Experience Aptitude");
        newPoints += newPoints * ((double)experienceAptitude - 50.0) / 100.0;
        this.person.getMind().getSkillManager().addExperience("Materials Science", (newPoints *= this.getTeachingExperienceModifier()) / 2.0);
        this.person.getMind().getSkillManager().addExperience("Construction", newPoints / 2.0);
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("Materials Science");
        results.add("Construction");
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        double result = 0.0;
        SkillManager manager = this.person.getMind().getSkillManager();
        result += (double)manager.getEffectiveSkillLevel("Materials Science");
        return (int)Math.round((result += (double)manager.getEffectiveSkillLevel("Construction")) / 2.0);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (MANUFACTURE.equals(this.getPhase())) {
            return this.manufacturePhase(time);
        }
        return time;
    }

    private double manufacturePhase(double time) {
        if (this.workshop.getBuilding().getMalfunctionManager().hasMalfunction()) {
            this.endTask();
            return time;
        }
        double workTime = time;
        int skill = this.getEffectiveSkillLevel();
        workTime = skill == 0 ? (workTime /= 2.0) : (workTime += workTime * (0.2 * (double)skill));
        while (workTime > 0.0 && !this.isDone()) {
            ManufactureProcess process = this.getRunningManufactureProcess();
            if (process != null) {
                double providedWorkTime = workTime;
                double remainingWorkTime = process.getWorkTimeRemaining();
                if (providedWorkTime > remainingWorkTime) {
                    providedWorkTime = remainingWorkTime;
                }
                process.addWorkTime(providedWorkTime);
                workTime -= providedWorkTime;
                if (!(process.getWorkTimeRemaining() <= 0.0) || !(process.getProcessTimeRemaining() <= 0.0)) continue;
                this.workshop.endManufacturingProcess(process, false);
                continue;
            }
            if (!this.person.getSettlement().getManufactureOverride()) {
                process = this.createNewManufactureProcess();
            }
            if (process != null) continue;
            this.endTask();
        }
        this.addExperience(time);
        this.checkForAccident(time);
        return 0.0;
    }

    private ManufactureProcess getRunningManufactureProcess() {
        ManufactureProcess result = null;
        int skillLevel = this.getEffectiveSkillLevel();
        Iterator<ManufactureProcess> i = this.workshop.getProcesses().iterator();
        while (i.hasNext() && result == null) {
            ManufactureProcess process = i.next();
            if (process.getInfo().getSkillLevelRequired() > skillLevel || !(process.getWorkTimeRemaining() > 0.0) || !ManufactureConstructionMaterials.producesConstructionMaterials(process)) continue;
            result = process;
        }
        return result;
    }

    private static boolean isProcessRunning(ManufactureProcessInfo processInfo, Manufacture manufactureBuilding) {
        boolean result = false;
        for (ManufactureProcess process : manufactureBuilding.getProcesses()) {
            if (process.getInfo().getName() != processInfo.getName()) continue;
            result = true;
        }
        return result;
    }

    private ManufactureProcess createNewManufactureProcess() {
        ManufactureProcess result = null;
        if (this.workshop.getTotalProcessNumber() < this.workshop.getConcurrentProcesses()) {
            int skillLevel = this.getEffectiveSkillLevel();
            int techLevel = this.workshop.getTechLevel();
            HashMap<ManufactureProcessInfo, Double> processProbMap = new HashMap<ManufactureProcessInfo, Double>();
            for (ManufactureProcessInfo processInfo : ManufactureUtil.getManufactureProcessesForTechSkillLevel(techLevel, skillLevel)) {
                double processValue;
                if (!ManufactureUtil.canProcessBeStarted(processInfo, this.workshop) || !ManufactureConstructionMaterials.producesConstructionMaterials(processInfo) || !((processValue = ManufactureUtil.getManufactureProcessValue(processInfo, this.person.getSettlement())) > 0.0)) continue;
                processProbMap.put(processInfo, processValue);
            }
            ManufactureProcessInfo chosenProcess = null;
            if (!processProbMap.isEmpty()) {
                chosenProcess = (ManufactureProcessInfo)RandomUtil.getWeightedRandomObject(processProbMap);
            }
            if (chosenProcess != null) {
                result = new ManufactureProcess(chosenProcess, this.workshop);
                this.workshop.addProcess(result);
            }
        }
        return result;
    }

    private void checkForAccident(double time) {
        double chance = 0.001;
        int skill = this.getEffectiveSkillLevel();
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        if (RandomUtil.lessThanRandPercent((chance *= this.workshop.getBuilding().getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            logger.info(this.person.getName() + " has accident while manufacturing " + "construction materials.");
            this.workshop.getBuilding().getMalfunctionManager().accident();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.workshop = null;
    }
}

