/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Doctor;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.person.ai.task.TaskEvent;
import org.mars_sim.msp.core.person.medical.HealthProblem;
import org.mars_sim.msp.core.person.medical.MedicalAid;
import org.mars_sim.msp.core.person.medical.Treatment;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.MedicalCare;
import org.mars_sim.msp.core.vehicle.Medical;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.SickBay;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class MedicalAssistance
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(MedicalAssistance.class.getName());
    private static final String TREATMENT = "Treatment";
    private static final double STRESS_MODIFIER = 1.0;
    private MedicalAid medical;
    private double duration;
    private HealthProblem problem;

    public MedicalAssistance(Person person) {
        super("Medical Assistance", person, true, true, 1.0, true, 0.0);
        List<MedicalAid> localAids = MedicalAssistance.getNeedyMedicalAids(person);
        if (localAids.size() > 0) {
            int rand = RandomUtil.getRandomInt(localAids.size() - 1);
            this.medical = localAids.get(rand);
            this.problem = (HealthProblem)this.medical.getProblemsAwaitingTreatment().get(0);
            int skill = person.getMind().getSkillManager().getEffectiveSkillLevel("Medicine");
            Treatment treatment = this.problem.getIllness().getRecoveryTreatment();
            this.setDescription("Apply " + treatment.getName());
            this.setDuration(treatment.getAdjustedDuration(skill));
            this.setStressModifier(1.0 * (double)treatment.getSkill());
            try {
                this.medical.startTreatment(this.problem, this.duration);
                if (this.medical instanceof MedicalCare) {
                    MedicalCare medicalCare = (MedicalCare)this.medical;
                    Building building = medicalCare.getBuilding();
                    BuildingManager.addPersonToBuilding(person, building);
                }
                if (this.getCreateEvents()) {
                    TaskEvent startingEvent = new TaskEvent(person, this, "Task Starting", "");
                    Simulation.instance().getEventManager().registerNewEvent(startingEvent);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "MedicalAssistance: " + e.getMessage());
                this.endTask();
            }
        } else {
            this.endTask();
        }
        this.addPhase(TREATMENT);
        this.setPhase(TREATMENT);
    }

    public static double getProbability(Person person) {
        Job job;
        double result = 0.0;
        if (MedicalAssistance.getNeedyMedicalAids(person).size() > 0) {
            result = 150.0;
        }
        if (person.getLocationSituation().equals("In Settlement")) {
            try {
                Building building = MedicalAssistance.getMedicalAidBuilding(person);
                if (building != null) {
                    result *= Task.getCrowdingProbabilityModifier(person, building);
                    result *= Task.getRelationshipModifier(person, building);
                } else {
                    result = 0.0;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "MedicalAssistance.getProbability(): " + e.getMessage());
            }
        }
        result *= person.getPerformanceRating();
        if (MedicalAssistance.isThereADoctorInTheHouse(person) && (job = person.getMind().getJob()) != null) {
            result *= job.getStartTaskProbabilityModifier(MedicalAssistance.class);
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (TREATMENT.equals(this.getPhase())) {
            return this.treatmentPhase(time);
        }
        return time;
    }

    private double treatmentPhase(double time) {
        if (MedicalAssistance.getMalfunctionable(this.medical).getMalfunctionManager().hasMalfunction()) {
            this.endTask();
        }
        if (this.isDone()) {
            return time;
        }
        this.checkForAccident(time);
        if (this.getDuration() <= this.getTimeCompleted() + time) {
            this.problem.startRecovery();
            this.endTask();
        }
        this.addExperience(time);
        return 0.0;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 25.0;
        int experienceAptitude = this.person.getNaturalAttributeManager().getAttribute("Experience Aptitude");
        newPoints += newPoints * ((double)experienceAptitude - 50.0) / 100.0;
        this.person.getMind().getSkillManager().addExperience("Medicine", newPoints *= this.getTeachingExperienceModifier());
    }

    private static List<MedicalAid> getNeedyMedicalAids(Person person) {
        SickBay aid;
        Vehicle vehicle;
        ArrayList<MedicalAid> result = new ArrayList<MedicalAid>();
        String location = person.getLocationSituation();
        if (location.equals("In Settlement")) {
            try {
                Building building = MedicalAssistance.getMedicalAidBuilding(person);
                if (building != null) {
                    result.add((MedicalCare)building.getFunction("Medical Care"));
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "MedicalAssistance.getNeedyMedicalAids(): " + e.getMessage());
            }
        } else if (location.equals("In Vehicle") && (vehicle = person.getVehicle()) instanceof Medical && (aid = ((Medical)((Object)vehicle)).getSickBay()) != null && MedicalAssistance.isNeedyMedicalAid(aid)) {
            result.add(aid);
        }
        return result;
    }

    private static boolean isNeedyMedicalAid(MedicalAid aid) {
        if (aid == null) {
            throw new IllegalArgumentException("aid is null");
        }
        boolean waitingProblems = aid.getProblemsAwaitingTreatment().size() > 0;
        boolean malfunction = MedicalAssistance.getMalfunctionable(aid).getMalfunctionManager().hasMalfunction();
        return waitingProblems && !malfunction;
    }

    private static Malfunctionable getMalfunctionable(MedicalAid aid) {
        Malfunctionable result = null;
        result = aid instanceof SickBay ? ((SickBay)aid).getVehicle() : (aid instanceof MedicalCare ? ((MedicalCare)aid).getBuilding() : (Malfunctionable)((Object)aid));
        return result;
    }

    private void checkForAccident(double time) {
        Malfunctionable entity = MedicalAssistance.getMalfunctionable(this.medical);
        double chance = 0.001;
        int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Medicine");
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        if (RandomUtil.lessThanRandPercent((chance *= entity.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            entity.getMalfunctionManager().accident();
        }
    }

    @Override
    public void endTask() {
        super.endTask();
        try {
            this.medical.stopTreatment(this.problem);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MedicalAid getMedicalAid() {
        return this.medical;
    }

    private static Building getMedicalAidBuilding(Person person) {
        Building result = null;
        if (person.getLocationSituation().equals("In Settlement")) {
            Settlement settlement = person.getSettlement();
            BuildingManager manager = settlement.getBuildingManager();
            List<Building> medicalBuildings = manager.getBuildings("Medical Care");
            ArrayList<Building> needyMedicalBuildings = new ArrayList<Building>();
            for (Building building : medicalBuildings) {
                MedicalCare medical = (MedicalCare)building.getFunction("Medical Care");
                if (!MedicalAssistance.isNeedyMedicalAid(medical)) continue;
                needyMedicalBuildings.add(building);
            }
            List<Building> bestMedicalBuildings = BuildingManager.getNonMalfunctioningBuildings(needyMedicalBuildings);
            if ((bestMedicalBuildings = BuildingManager.getLeastCrowdedBuildings(bestMedicalBuildings)).size() > 0) {
                Map<Building, Double> medBuildingProbs = BuildingManager.getBestRelationshipBuildings(person, bestMedicalBuildings);
                result = RandomUtil.getWeightedRandomObject(medBuildingProbs);
            }
        } else {
            throw new IllegalStateException("MedicalAssistance.getMedicalAidBuilding(): Person is not in settlement.");
        }
        return result;
    }

    private static boolean isThereADoctorInTheHouse(Person person) {
        boolean result;
        block3: {
            block2: {
                result = false;
                if (!person.getLocationSituation().equals("In Settlement")) break block2;
                for (Person inhabitant : person.getSettlement().getInhabitants()) {
                    if (inhabitant == person || !(inhabitant.getMind().getJob() instanceof Doctor)) continue;
                    result = true;
                }
                break block3;
            }
            if (!person.getLocationSituation().equals("In Vehicle") || !(person.getVehicle() instanceof Rover)) break block3;
            Rover rover = (Rover)person.getVehicle();
            for (Person crewmember : rover.getCrew()) {
                if (crewmember == person || !(crewmember.getMind().getJob() instanceof Doctor)) continue;
                result = true;
            }
        }
        return result;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel("Medicine");
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        results.add("Medicine");
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.medical = null;
        this.problem = null;
    }
}

