/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.mission.Mining;
import org.mars_sim.msp.core.person.ai.task.EVAOperation;
import org.mars_sim.msp.core.person.ai.task.ExitAirlock;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Rover;

public class MineSite
extends EVAOperation
implements Serializable {
    private static Logger logger = Logger.getLogger(MineSite.class.getName());
    private static final String MINING = "Mining";
    private static final double HAND_EXCAVATION_RATE = 0.1;
    private static final double LUV_EXCAVATION_RATE = 1.0;
    private static final double MINING_TIME_LIMIT = 100.0;
    public static final double BASE_LUV_ACCIDENT_CHANCE = 0.001;
    private Coordinates site;
    private Rover rover;
    private LightUtilityVehicle luv;
    private boolean operatingLUV;
    private double miningTime;

    public MineSite(Person person, Coordinates site, Rover rover, LightUtilityVehicle luv) {
        super("Mine Site", person);
        this.site = site;
        this.rover = rover;
        this.luv = luv;
        this.operatingLUV = false;
        this.addPhase(MINING);
    }

    public static boolean canMineSite(Person person, Rover rover) {
        boolean exitable = ExitAirlock.canExitAirlock(person, rover.getAirlock());
        SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
        boolean sunlight = surface.getSurfaceSunlight(rover.getCoordinates()) > 0.0;
        boolean darkRegion = surface.inDarkPolarRegion(rover.getCoordinates());
        boolean medical = person.getPerformanceRating() < 0.5;
        return exitable && (sunlight || darkRegion) && !medical;
    }

    private double exitRover(double time) {
        try {
            time = this.exitAirlock(time, this.rover.getAirlock());
            this.addExperience(time);
        }
        catch (Exception e) {
            this.endTask();
        }
        if (this.exitedAirlock) {
            this.setPhase(MINING);
        }
        return time;
    }

    private double enterRover(double time) {
        time = this.enterAirlock(time, this.rover.getAirlock());
        this.addExperience(time);
        if (this.enteredAirlock) {
            this.endTask();
            return time;
        }
        return 0.0;
    }

    private double miningPhase(double time) {
        this.checkForAccident(time);
        this.miningTime += time;
        if (this.shouldEndEVAOperation() || this.miningTime >= 100.0) {
            if (this.luv.getInventory().containsUnit(this.person)) {
                this.luv.getInventory().retrieveUnit(this.person);
                this.luv.setOperator(null);
                this.operatingLUV = false;
            }
            this.setPhase("Enter Airlock");
            return time;
        }
        if (!this.luv.getMalfunctionManager().hasMalfunction() && this.luv.getCrewNum() == 0) {
            if (this.luv.getInventory().canStoreUnit(this.person, false)) {
                this.luv.getInventory().storeUnit(this.person);
                Point2D.Double vehicleLoc = LocalAreaUtil.getRandomInteriorLocation(this.luv);
                Point2D.Double settlementLoc = LocalAreaUtil.getLocalRelativeLocation(vehicleLoc.getX(), vehicleLoc.getY(), this.luv);
                this.person.setXLocation(settlementLoc.getX());
                this.person.setYLocation(settlementLoc.getY());
                this.luv.setOperator(this.person);
                this.operatingLUV = true;
                this.setDescription("Excavating site with " + this.luv.getName());
            } else {
                logger.info(this.person.getName() + " could not operate " + this.luv.getName());
            }
        }
        this.excavateMinerals(time);
        this.addExperience(time);
        return 0.0;
    }

    private void excavateMinerals(double time) {
        Map<String, Double> minerals = Simulation.instance().getMars().getSurfaceFeatures().getMineralMap().getAllMineralConcentrations(this.site);
        for (String mineralName : minerals.keySet()) {
            double amountExcavated = 0.0;
            amountExcavated = this.operatingLUV ? 1.0 * time : 0.1 * time;
            double mineralConcentration = minerals.get(mineralName);
            amountExcavated *= mineralConcentration / 100.0;
            AmountResource mineralResource = AmountResource.findAmountResource(mineralName);
            Mining mission = (Mining)this.person.getMind().getMission();
            mission.excavateMineral(mineralResource, amountExcavated *= (double)this.getEffectiveSkillLevel());
        }
    }

    @Override
    protected void addExperience(double time) {
        SkillManager manager = this.person.getMind().getSkillManager();
        double evaExperience = time / 100.0;
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        evaExperience += evaExperience * experienceAptitudeModifier;
        manager.addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
        if (MINING.equals(this.getPhase())) {
            double areologyExperience = time / 10.0;
            areologyExperience += areologyExperience * experienceAptitudeModifier;
            manager.addExperience("Areology", areologyExperience);
            if (this.operatingLUV) {
                double drivingExperience = time / 10.0;
                drivingExperience += drivingExperience * experienceAptitudeModifier;
                manager.addExperience("Driving", drivingExperience);
            }
        }
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(3);
        results.add("EVA Operations");
        results.add("Areology");
        if (this.operatingLUV) {
            results.add("Driving");
        }
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        int result = 0;
        SkillManager manager = this.person.getMind().getSkillManager();
        int EVAOperationsSkill = manager.getEffectiveSkillLevel("EVA Operations");
        int areologySkill = manager.getEffectiveSkillLevel("Areology");
        if (this.operatingLUV) {
            int drivingSkill = manager.getEffectiveSkillLevel("Driving");
            result = (int)Math.round((double)(EVAOperationsSkill + areologySkill + drivingSkill) / 3.0);
        } else {
            result = (int)Math.round((double)(EVAOperationsSkill + areologySkill) / 2.0);
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if ("Exit Airlock".equals(this.getPhase())) {
            return this.exitRover(time);
        }
        if (MINING.equals(this.getPhase())) {
            return this.miningPhase(time);
        }
        if ("Enter Airlock".equals(this.getPhase())) {
            return this.enterRover(time);
        }
        return time;
    }

    @Override
    protected void checkForAccident(double time) {
        super.checkForAccident(time);
        if (this.operatingLUV) {
            double chance = 0.001;
            int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("EVA Operations");
            chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
            if (RandomUtil.lessThanRandPercent((chance *= this.luv.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
                this.luv.getMalfunctionManager().accident();
            }
        }
    }

    @Override
    protected boolean shouldEndEVAOperation() {
        boolean result = super.shouldEndEVAOperation();
        if (this.operatingLUV && this.luv.getMalfunctionManager().hasMalfunction()) {
            result = true;
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.site = null;
        this.rover = null;
        this.luv = null;
    }
}

