/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.mission.TradeUtil;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.goods.CreditManager;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.vehicle.Rover;

public class NegotiateTrade
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(NegotiateTrade.class.getName());
    private static final String NEGOTIATING = "Negotiating";
    private static final double DURATION = 50.0;
    private static final double STRESS_MODIFIER = 0.0;
    private Map<Good, Integer> buyLoad;
    private Settlement sellingSettlement;
    private Settlement buyingSettlement;
    private Rover rover;
    private Map<Good, Integer> soldLoad;
    private Person buyingTrader;
    private Person sellingTrader;

    public NegotiateTrade(Settlement sellingSettlement, Settlement buyingSettlement, Rover rover, Map<Good, Integer> soldLoad, Person buyingTrader, Person sellingTrader) {
        super("Negotiation Trade", buyingTrader, false, false, 0.0, true, 50.0);
        this.sellingSettlement = sellingSettlement;
        this.buyingSettlement = buyingSettlement;
        this.rover = rover;
        this.soldLoad = soldLoad;
        this.buyingTrader = buyingTrader;
        this.sellingTrader = sellingTrader;
        this.addPhase(NEGOTIATING);
        this.setPhase(NEGOTIATING);
    }

    private double negotiatingPhase(double time) {
        this.followSeller();
        if (this.getDuration() <= this.getTimeCompleted() + time) {
            double tradeModifier = this.determineTradeModifier();
            double baseSoldLoadValue = TradeUtil.determineLoadValue(this.soldLoad, this.sellingSettlement, true);
            double soldLoadValue = baseSoldLoadValue * tradeModifier;
            CreditManager creditManager = Simulation.instance().getCreditManager();
            double credit = creditManager.getCredit(this.buyingSettlement, this.sellingSettlement);
            creditManager.setCredit(this.buyingSettlement, this.sellingSettlement, credit += soldLoadValue);
            logger.info("Credit at " + this.buyingSettlement.getName() + " for " + this.sellingSettlement.getName() + " is " + credit);
            if (credit > -1.0E7) {
                this.buyLoad = TradeUtil.determineLoad(this.buyingSettlement, this.sellingSettlement, this.rover, Double.POSITIVE_INFINITY);
                double baseBuyLoadValue = TradeUtil.determineLoadValue(this.buyLoad, this.buyingSettlement, true);
                double buyLoadValue = baseBuyLoadValue / tradeModifier;
                creditManager.setCredit(this.buyingSettlement, this.sellingSettlement, credit -= buyLoadValue);
                logger.info("Credit at " + this.buyingSettlement.getName() + " for " + this.sellingSettlement.getName() + " is " + credit);
            } else {
                this.buyLoad = new HashMap<Good, Integer>(0);
            }
        }
        return this.getTimeCompleted() + time - this.getDuration();
    }

    private void followSeller() {
        Building sellerBuilding;
        Building buyerBuilding = BuildingManager.getBuilding(this.buyingTrader);
        if (buyerBuilding != (sellerBuilding = BuildingManager.getBuilding(this.sellingTrader)) && sellerBuilding != null) {
            BuildingManager.addPersonToBuilding(this.buyingTrader, sellerBuilding);
        }
    }

    private double determineTradeModifier() {
        double modifier = 1.0;
        NaturalAttributeManager sellerAttributes = this.buyingTrader.getNaturalAttributeManager();
        NaturalAttributeManager buyerAttributes = this.sellingTrader.getNaturalAttributeManager();
        modifier += (double)sellerAttributes.getAttribute("Conversation") / 1000.0;
        modifier -= (double)buyerAttributes.getAttribute("Conversation") / 1000.0;
        modifier += (double)sellerAttributes.getAttribute("Attractiveness") / 1000.0;
        modifier -= (double)buyerAttributes.getAttribute("Attractiveness") / 1000.0;
        modifier += (double)this.buyingTrader.getMind().getSkillManager().getEffectiveSkillLevel("Trading") / 10.0;
        modifier -= (double)this.sellingTrader.getMind().getSkillManager().getEffectiveSkillLevel("Trading") / 10.0;
        RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
        modifier += relationshipManager.getOpinionOfPerson(this.buyingTrader, this.sellingTrader) / 1000.0;
        return modifier -= relationshipManager.getOpinionOfPerson(this.sellingTrader, this.buyingTrader) / 1000.0;
    }

    @Override
    protected void addExperience(double time) {
        this.addExperience(time, this.buyingTrader);
        this.addExperience(time, this.sellingTrader);
    }

    private void addExperience(double time, Person trader) {
        double newPoints = time / 2.0;
        int experienceAptitude = trader.getNaturalAttributeManager().getAttribute("Experience Aptitude");
        newPoints += newPoints * ((double)experienceAptitude - 50.0) / 100.0;
        trader.getMind().getSkillManager().addExperience("Trading", newPoints *= this.getTeachingExperienceModifier());
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> skills = new ArrayList<String>(1);
        skills.add("Trading");
        return skills;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel("Trading");
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (NEGOTIATING.equals(this.getPhase())) {
            return this.negotiatingPhase(time);
        }
        return time;
    }

    public Map<Good, Integer> getBuyLoad() {
        return this.buyLoad;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.buyLoad != null) {
            this.buyLoad.clear();
        }
        this.buyLoad = null;
        this.sellingSettlement = null;
        this.buyingSettlement = null;
        this.rover = null;
        if (this.soldLoad != null) {
            this.soldLoad.clear();
        }
        this.soldLoad = null;
        this.buyingTrader = null;
        this.sellingTrader = null;
    }
}

