/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.ResearchScientificStudy;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyManager;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.AstronomicalObservation;

public class ObserveAstronomicalObjects
extends Task
implements ResearchScientificStudy,
Serializable {
    private static Logger logger = Logger.getLogger(ObserveAstronomicalObjects.class.getName());
    private static final double STRESS_MODIFIER = -0.2;
    private static final String OBSERVING = "Observing";
    private ScientificStudy study = this.determineStudy();
    private AstronomicalObservation observatory;
    private Person researchAssistant;

    public ObserveAstronomicalObjects(Person person) {
        super("Observe Night Sky with Telescope", person, true, false, -0.2, true, RandomUtil.getRandomDouble(300.0));
        if (this.study != null) {
            this.observatory = ObserveAstronomicalObjects.determineObservatory(person);
            if (this.observatory != null) {
                Building observatoryBuilding = this.observatory.getBuilding();
                BuildingManager.addPersonToBuilding(person, observatoryBuilding);
                this.observatory.addObserver();
            } else {
                logger.info("observatory could not be determined.");
                this.endTask();
            }
        }
        this.addPhase(OBSERVING);
        this.setPhase(OBSERVING);
    }

    public static double getProbability(Person person) {
        SurfaceFeatures surface;
        double sunlight;
        double result = 0.0;
        AstronomicalObservation observatory = ObserveAstronomicalObjects.determineObservatory(person);
        if (observatory != null && (sunlight = (surface = Simulation.instance().getMars().getSurfaceFeatures()).getSurfaceSunlight(person.getCoordinates())) == 0.0) {
            Science astronomy = ScienceUtil.getScience("Astronomy");
            ScientificStudyManager studyManager = Simulation.instance().getScientificStudyManager();
            ScientificStudy primaryStudy = studyManager.getOngoingPrimaryStudy(person);
            if (primaryStudy != null && "Research".equals(primaryStudy.getPhase()) && !primaryStudy.isPrimaryResearchCompleted() && astronomy.equals(primaryStudy.getScience())) {
                try {
                    Science jobScience;
                    double primaryResult = 100.0;
                    primaryResult *= ObserveAstronomicalObjects.getObservatoryCrowdingModifier(person, observatory);
                    Job job = person.getMind().getJob();
                    if (job != null && !astronomy.equals(jobScience = ScienceUtil.getAssociatedScience(job))) {
                        primaryResult /= 2.0;
                    }
                    result += primaryResult;
                }
                catch (Exception e) {
                    logger.severe("getProbability(): " + e.getMessage());
                }
            }
            for (ScientificStudy collabStudy : studyManager.getOngoingCollaborativeStudies(person)) {
                if (!"Research".equals(collabStudy.getPhase()) || collabStudy.isCollaborativeResearchCompleted(person) || !astronomy.equals(collabStudy.getCollaborativeResearchers().get(person))) continue;
                try {
                    Science jobScience;
                    double collabResult = 50.0;
                    collabResult *= ObserveAstronomicalObjects.getObservatoryCrowdingModifier(person, observatory);
                    Job job = person.getMind().getJob();
                    if (job != null && !astronomy.equals(jobScience = ScienceUtil.getAssociatedScience(job))) {
                        collabResult /= 2.0;
                    }
                    result += collabResult;
                }
                catch (Exception e) {
                    logger.severe("getProbability(): " + e.getMessage());
                }
            }
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(ObserveAstronomicalObjects.class);
        }
        return result;
    }

    private static AstronomicalObservation determineObservatory(Person observer) {
        AstronomicalObservation result = null;
        if ("In Settlement".equals(observer.getLocationSituation())) {
            BuildingManager manager = observer.getSettlement().getBuildingManager();
            List<Building> observatoryBuildings = manager.getBuildings(AstronomicalObservation.NAME);
            observatoryBuildings = BuildingManager.getNonMalfunctioningBuildings(observatoryBuildings);
            observatoryBuildings = ObserveAstronomicalObjects.getObservatoriesWithAvailableSpace(observatoryBuildings);
            if ((observatoryBuildings = BuildingManager.getLeastCrowdedBuildings(observatoryBuildings)).size() > 0) {
                Map<Building, Double> observatoryBuildingProbs = BuildingManager.getBestRelationshipBuildings(observer, observatoryBuildings);
                Building building = RandomUtil.getWeightedRandomObject(observatoryBuildingProbs);
                result = (AstronomicalObservation)building.getFunction(AstronomicalObservation.NAME);
            }
        }
        return result;
    }

    private static double getObservatoryCrowdingModifier(Person observer, AstronomicalObservation observatory) {
        Building observatoryBuilding;
        double result = 1.0;
        if (observer.getLocationSituation().equals("In Settlement") && (observatoryBuilding = observatory.getBuilding()) != null) {
            result *= Task.getCrowdingProbabilityModifier(observer, observatoryBuilding);
            result *= Task.getRelationshipModifier(observer, observatoryBuilding);
        }
        return result;
    }

    private static List<Building> getObservatoriesWithAvailableSpace(List<Building> buildingList) {
        ArrayList<Building> result = new ArrayList<Building>();
        for (Building building : buildingList) {
            AstronomicalObservation observatory = (AstronomicalObservation)building.getFunction(AstronomicalObservation.NAME);
            if (observatory.getObserverNum() >= observatory.getObservatoryCapacity()) continue;
            result.add(building);
        }
        return result;
    }

    private ScientificStudy determineStudy() {
        ScientificStudy result = null;
        Science astronomy = ScienceUtil.getScience("Astronomy");
        ArrayList<ScientificStudy> possibleStudies = new ArrayList<ScientificStudy>();
        ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
        ScientificStudy primaryStudy = manager.getOngoingPrimaryStudy(this.person);
        if (primaryStudy != null && "Research".equals(primaryStudy.getPhase()) && !primaryStudy.isPrimaryResearchCompleted() && astronomy.equals(primaryStudy.getScience())) {
            possibleStudies.add(primaryStudy);
            possibleStudies.add(primaryStudy);
        }
        for (ScientificStudy collabStudy : manager.getOngoingCollaborativeStudies(this.person)) {
            if (!"Research".equals(collabStudy.getPhase()) || collabStudy.isCollaborativeResearchCompleted(this.person) || !astronomy.equals(collabStudy.getCollaborativeResearchers().get(this.person))) continue;
            possibleStudies.add(collabStudy);
        }
        if (possibleStudies.size() > 0) {
            int selected = RandomUtil.getRandomInt(possibleStudies.size() - 1);
            result = (ScientificStudy)possibleStudies.get(selected);
        }
        return result;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 25.0;
        int academicAptitude = this.person.getNaturalAttributeManager().getAttribute("Academic Aptitude");
        newPoints += newPoints * ((double)academicAptitude - 50.0) / 100.0;
        Science astronomyScience = ScienceUtil.getScience("Astronomy");
        String astronomySkill = ScienceUtil.getAssociatedSkill(astronomyScience);
        this.person.getMind().getSkillManager().addExperience(astronomySkill, newPoints *= this.getTeachingExperienceModifier());
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        Science astronomyScience = ScienceUtil.getScience("Astronomy");
        String astronomySkill = ScienceUtil.getAssociatedSkill(astronomyScience);
        results.add(astronomySkill);
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        Science astronomyScience = ScienceUtil.getScience("Astronomy");
        String astronomySkill = ScienceUtil.getAssociatedSkill(astronomyScience);
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel(astronomySkill);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (OBSERVING.equals(this.getPhase())) {
            return this.observingPhase(time);
        }
        return time;
    }

    protected double observingPhase(double time) {
        boolean isPrimary;
        SurfaceFeatures surface;
        double sunlight;
        if (this.person.getPerformanceRating() == 0.0) {
            this.endTask();
        }
        if (this.observatory.getBuilding().getMalfunctionManager().hasMalfunction()) {
            this.endTask();
        }
        if ((sunlight = (surface = Simulation.instance().getMars().getSurfaceFeatures()).getSurfaceSunlight(this.person.getCoordinates())) > 0.0) {
            this.endTask();
        }
        if (isPrimary = this.study.getPrimaryResearcher().equals(this.person)) {
            if (this.study.isPrimaryResearchCompleted()) {
                this.endTask();
            }
        } else if (this.study.isCollaborativeResearchCompleted(this.person)) {
            this.endTask();
        }
        if (this.isDone()) {
            return time;
        }
        double observingTime = this.getEffectiveObservingTime(time);
        if (isPrimary) {
            this.study.addPrimaryResearchWorkTime(observingTime);
        } else {
            this.study.addCollaborativeResearchWorkTime(this.person, observingTime);
        }
        this.addExperience(observingTime);
        this.checkForAccident(time);
        return 0.0;
    }

    private double getEffectiveObservingTime(double time) {
        int techLevel;
        double observingTime = time;
        int astronomySkill = this.getEffectiveSkillLevel();
        if (astronomySkill == 0) {
            observingTime /= 2.0;
        }
        if (astronomySkill > 1) {
            observingTime += observingTime * (0.2 * (double)astronomySkill);
        }
        if ((techLevel = this.observatory.getTechnologyLevel()) > 0) {
            observingTime *= (double)techLevel;
        }
        if (this.hasResearchAssistant()) {
            SkillManager manager = this.researchAssistant.getMind().getSkillManager();
            Science astronomyScience = ScienceUtil.getScience("Astronomy");
            int assistantSkill = manager.getEffectiveSkillLevel(ScienceUtil.getAssociatedSkill(astronomyScience));
            if (astronomySkill > 0) {
                observingTime *= 1.0 + (double)assistantSkill / (double)astronomySkill;
            }
        }
        return observingTime;
    }

    private void checkForAccident(double time) {
        double chance = 0.001;
        Science astronomyScience = ScienceUtil.getScience("Astronomy");
        String astronomySkill = ScienceUtil.getAssociatedSkill(astronomyScience);
        int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel(astronomySkill);
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        Malfunctionable entity = null;
        if (this.person.getLocationSituation().equals("In Settlement")) {
            entity = this.observatory.getBuilding();
        } else if (this.person.getLocationSituation().equals("In Vehicle")) {
            entity = this.person.getVehicle();
        }
        if (entity != null && RandomUtil.lessThanRandPercent((chance *= entity.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            logger.info(this.person.getName() + " has a observatory accident while observing astronomical objects.");
            entity.getMalfunctionManager().accident();
        }
    }

    @Override
    public void endTask() {
        super.endTask();
        try {
            if (this.observatory != null) {
                this.observatory.removeObserver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Science getResearchScience() {
        return ScienceUtil.getScience("Astronomy");
    }

    @Override
    public Person getResearcher() {
        return this.person;
    }

    @Override
    public boolean hasResearchAssistant() {
        return this.researchAssistant != null;
    }

    @Override
    public Person getResearchAssistant() {
        return this.researchAssistant;
    }

    @Override
    public void setResearchAssistant(Person researchAssistant) {
        this.researchAssistant = researchAssistant;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.study = null;
        this.observatory = null;
        this.researchAssistant = null;
    }
}

