/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Direction;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.core.vehicle.VehicleOperator;

public abstract class OperateVehicle
extends Task
implements Serializable {
    public static final String MOBILIZE = "Mobilize Vehicle";
    private static final double DESTINATION_BUFFER = 0.001;
    public static final double BASE_ACCIDENT_CHANCE = 0.001;
    private Vehicle vehicle;
    private Coordinates destination;
    private MarsClock startTripTime;
    private double startTripDistance;

    public OperateVehicle(String name, Person person, Vehicle vehicle, Coordinates destination, MarsClock startTripTime, double startTripDistance, double stressModifier, boolean hasDuration, double duration) {
        super(name, person, true, false, stressModifier, hasDuration, duration);
        if (vehicle == null) {
            throw new IllegalArgumentException("vehicle is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (startTripTime == null) {
            throw new IllegalArgumentException("startTripTime is null");
        }
        if (startTripDistance < 0.0) {
            throw new IllegalArgumentException("startTripDistance is < 0");
        }
        this.vehicle = vehicle;
        this.destination = destination;
        this.startTripTime = startTripTime;
        this.startTripDistance = startTripDistance;
        this.addPhase(MOBILIZE);
        this.setPhase(MOBILIZE);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (MOBILIZE.equals(this.getPhase())) {
            return this.mobilizeVehiclePhase(time);
        }
        return time;
    }

    public Vehicle getVehicle() {
        return this.vehicle;
    }

    public Coordinates getDestination() {
        return this.destination;
    }

    public void setDestination(Coordinates newDestination) {
        this.destination = newDestination;
    }

    protected MarsClock getStartTripTime() {
        return this.startTripTime;
    }

    protected double getStartTripDistance() {
        return this.startTripDistance;
    }

    protected double mobilizeVehiclePhase(double time) {
        this.vehicle.setDirection(this.vehicle.getCoordinates().getDirectionToPoint(this.destination));
        this.updateVehicleElevationAltitude();
        double speed = this.getSpeed(this.vehicle.getDirection());
        this.vehicle.setSpeed(speed);
        double timeUsed = time - this.mobilizeVehicle(time);
        this.addExperience(time);
        if (!this.isDone()) {
            this.checkForAccident(timeUsed);
        }
        if (this.vehicle.getMalfunctionManager().hasMalfunction()) {
            this.endTask();
        }
        return time - timeUsed;
    }

    protected double mobilizeVehicle(double time) {
        AmountResource fuelType;
        Inventory vInv;
        double remainingFuel;
        if (!this.person.equals(this.vehicle.getOperator())) {
            this.vehicle.setOperator(this.person);
        }
        double startingDistanceToDestination = this.getDistanceToDestination();
        double secondsTime = MarsClock.convertMillisolsToSeconds(time);
        double distanceTraveled = secondsTime * (this.vehicle.getSpeed() / 60.0 / 60.0);
        double fuelConsumed = distanceTraveled / this.vehicle.getFuelEfficiency();
        if (fuelConsumed > (remainingFuel = (vInv = this.vehicle.getInventory()).getAmountResourceStored(fuelType = this.vehicle.getFuelType(), false))) {
            fuelConsumed = remainingFuel;
        }
        try {
            vInv.retrieveAmountResource(this.vehicle.getFuelType(), fuelConsumed);
        }
        catch (Exception e) {
            // empty catch block
        }
        double result = 0.0;
        if (startingDistanceToDestination <= distanceTraveled + 0.001) {
            distanceTraveled = startingDistanceToDestination;
            this.vehicle.setCoordinates(this.destination);
            this.vehicle.setSpeed(0.0);
            this.vehicle.setOperator(null);
            this.updateVehicleElevationAltitude();
            if (this.isSettlementDestination()) {
                this.determineInitialSettlementParkedLocation();
            } else {
                double radDir = this.vehicle.getDirection().getDirection();
                double degDir = radDir * 180.0 / Math.PI;
                this.vehicle.setParkedLocation(0.0, 0.0, degDir);
            }
            this.endTask();
            result = time - MarsClock.convertSecondsToMillisols(distanceTraveled / this.vehicle.getSpeed() * 60.0 * 60.0);
        } else {
            this.vehicle.setCoordinates(this.vehicle.getCoordinates().getNewLocation(this.vehicle.getDirection(), distanceTraveled));
        }
        this.vehicle.addTotalDistanceTraveled(distanceTraveled);
        this.vehicle.addDistanceLastMaintenance(distanceTraveled);
        return result;
    }

    private boolean isSettlementDestination() {
        boolean result = false;
        for (Settlement settlement : Simulation.instance().getUnitManager().getSettlements()) {
            if (!settlement.getCoordinates().equals(this.destination)) continue;
            result = true;
        }
        return result;
    }

    private void determineInitialSettlementParkedLocation() {
        Direction oppDir = new Direction(this.vehicle.getDirection().getDirection() + Math.PI);
        double distance = 200.0;
        double xLoc = 0.0 - distance * oppDir.getSinDirection();
        double yLoc = distance * oppDir.getCosDirection();
        double degDir = this.vehicle.getDirection().getDirection() * 180.0 / Math.PI;
        this.vehicle.setParkedLocation(xLoc, yLoc, degDir);
    }

    protected abstract void updateVehicleElevationAltitude();

    public MarsClock getETA() {
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        double millisolsDiff = MarsClock.getTimeDiff(currentTime, this.startTripTime);
        double hoursDiff = MarsClock.convertMillisolsToSeconds(millisolsDiff) / 60.0 / 60.0;
        double avgSpeed = (this.startTripDistance - this.getDistanceToDestination()) / hoursDiff;
        double estimatorConstant = 0.5;
        double estimatedSpeed = estimatorConstant * (this.vehicle.getBaseSpeed() + this.getSpeedSkillModifier());
        double tempAvgSpeed = avgSpeed * ((this.startTripDistance - this.getDistanceToDestination()) / this.startTripDistance);
        double tempEstimatedSpeed = estimatedSpeed * (this.getDistanceToDestination() / this.startTripDistance);
        double finalEstimatedSpeed = tempAvgSpeed + tempEstimatedSpeed;
        double hoursToDestination = this.getDistanceToDestination() / finalEstimatedSpeed;
        double millisolsToDestination = MarsClock.convertSecondsToMillisols(hoursToDestination * 60.0 * 60.0);
        MarsClock eta = (MarsClock)currentTime.clone();
        eta.addTime(millisolsToDestination);
        return eta;
    }

    protected abstract void checkForAccident(double var1);

    protected double getSpeed(Direction direction) {
        double speed = this.vehicle.getBaseSpeed() + this.getSpeedSkillModifier();
        if (speed < 0.0) {
            speed = 0.0;
        }
        return speed;
    }

    protected double getSpeedSkillModifier() {
        double result = 0.0;
        double baseSpeed = this.vehicle.getBaseSpeed();
        if (this.getEffectiveSkillLevel() <= 5) {
            result = 0.0 - baseSpeed / 2.0 * ((5.0 - (double)this.getEffectiveSkillLevel()) / 5.0);
        } else {
            double tempSpeed = baseSpeed;
            for (int x = 0; x < this.getEffectiveSkillLevel() - 5; ++x) {
                result += (tempSpeed /= 2.0);
            }
        }
        return result;
    }

    protected double getDistanceToDestination() {
        return this.vehicle.getCoordinates().getDistance(this.destination);
    }

    protected double getVehicleElevation() {
        SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
        return surface.getSurfaceTerrain().getElevation(this.vehicle.getCoordinates());
    }

    @Override
    public void endTask() {
        this.vehicle.setSpeed(0.0);
        this.vehicle.setOperator(null);
        super.endTask();
    }

    public static double getAverageVehicleSpeed(Vehicle vehicle, VehicleOperator operator) {
        return vehicle.getBaseSpeed() / 2.0;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.vehicle = null;
        this.destination = null;
        this.startTripTime = null;
    }
}

