/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyManager;

public class PeerReviewStudyPaper
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(PeerReviewStudyPaper.class.getName());
    private static final double STRESS_MODIFIER = 0.0;
    private static final String REVIEW = "Reviewing Study Paper";
    private ScientificStudy study = this.determineStudy();

    public PeerReviewStudyPaper(Person person) {
        super("Peer Review Compiled Study Paper", person, true, false, 0.0, true, RandomUtil.getRandomDouble(300.0));
        if (this.study != null) {
            this.setDescription("Peer Review " + this.study.toString());
        } else {
            logger.info("study could not be determined");
            this.endTask();
        }
        this.addPhase(REVIEW);
        this.setPhase(REVIEW);
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        ScientificStudyManager studyManager = Simulation.instance().getScientificStudyManager();
        for (ScientificStudy study : studyManager.getOngoingStudies()) {
            Job job;
            if (!"Peer Review".equals(study.getPhase()) || person.equals(study.getPrimaryResearcher()) || study.getCollaborativeResearchers().keySet().contains(person) || (job = person.getMind().getJob()) == null) continue;
            Science jobScience = ScienceUtil.getAssociatedScience(job);
            if (!study.getScience().equals(jobScience)) continue;
            result += 50.0;
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(PeerReviewStudyPaper.class);
        }
        return result;
    }

    private ScientificStudy determineStudy() {
        ScientificStudy result = null;
        ArrayList<ScientificStudy> possibleStudies = new ArrayList<ScientificStudy>();
        ScientificStudyManager studyManager = Simulation.instance().getScientificStudyManager();
        for (ScientificStudy study : studyManager.getOngoingStudies()) {
            Job job;
            if (!"Peer Review".equals(study.getPhase()) || this.person.equals(study.getPrimaryResearcher()) || study.getCollaborativeResearchers().keySet().contains(this.person) || (job = this.person.getMind().getJob()) == null) continue;
            Science jobScience = ScienceUtil.getAssociatedScience(job);
            if (!study.getScience().equals(jobScience)) continue;
            possibleStudies.add(study);
        }
        if (possibleStudies.size() > 0) {
            int selected = RandomUtil.getRandomInt(possibleStudies.size() - 1);
            result = (ScientificStudy)possibleStudies.get(selected);
        }
        return result;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 25.0;
        int academicAptitude = this.person.getNaturalAttributeManager().getAttribute("Academic Aptitude");
        newPoints += newPoints * ((double)academicAptitude - 50.0) / 100.0;
        String scienceSkill = ScienceUtil.getAssociatedSkill(this.study.getScience());
        this.person.getMind().getSkillManager().addExperience(scienceSkill, newPoints *= this.getTeachingExperienceModifier());
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        String scienceSkill = ScienceUtil.getAssociatedSkill(this.study.getScience());
        results.add(scienceSkill);
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        String scienceSkill = ScienceUtil.getAssociatedSkill(this.study.getScience());
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel(scienceSkill);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (REVIEW.equals(this.getPhase())) {
            return this.reviewingPhase(time);
        }
        return time;
    }

    private double reviewingPhase(double time) {
        if (this.person.getPerformanceRating() == 0.0) {
            this.endTask();
        }
        if (this.study.isCompleted()) {
            this.endTask();
        }
        if (this.isDone()) {
            return time;
        }
        this.addExperience(time);
        return 0.0;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.study = null;
    }
}

