/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Lab;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.ResearchScientificStudy;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyManager;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.Research;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class PerformMathematicalModeling
extends Task
implements ResearchScientificStudy,
Serializable {
    private static Logger logger = Logger.getLogger(PerformMathematicalModeling.class.getName());
    private static final double STRESS_MODIFIER = -0.2;
    private static final String MODELING = "Modeling";
    private ScientificStudy study = this.determineStudy();
    private Lab lab;
    private MalfunctionManager malfunctions;
    private Person researchAssistant;

    public PerformMathematicalModeling(Person person) {
        super("Perform Mathematical Modeling", person, true, false, -0.2, true, RandomUtil.getRandomDouble(200.0));
        if (this.study != null) {
            this.lab = PerformMathematicalModeling.getLocalLab(person);
            if (this.lab != null) {
                this.addPersonToLab();
            } else {
                logger.info("lab could not be determined.");
                this.endTask();
            }
        } else {
            logger.info("study could not be determined");
            this.endTask();
        }
        this.addPhase(MODELING);
        this.setPhase(MODELING);
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        Science mathematicsScience = ScienceUtil.getScience("Mathematics");
        ScientificStudyManager studyManager = Simulation.instance().getScientificStudyManager();
        ScientificStudy primaryStudy = studyManager.getOngoingPrimaryStudy(person);
        if (primaryStudy != null && "Research".equals(primaryStudy.getPhase()) && !primaryStudy.isPrimaryResearchCompleted() && mathematicsScience.equals(primaryStudy.getScience())) {
            try {
                Lab lab = PerformMathematicalModeling.getLocalLab(person);
                if (lab != null) {
                    double primaryResult = 50.0;
                    primaryResult *= PerformMathematicalModeling.getLabCrowdingModifier(person, lab);
                    Job job = person.getMind().getJob();
                    if (job != null) {
                        Science jobScience = ScienceUtil.getAssociatedScience(job);
                        if (!primaryStudy.getScience().equals(jobScience)) {
                            primaryResult /= 2.0;
                        }
                    }
                    result += primaryResult;
                }
            }
            catch (Exception e) {
                logger.severe("getProbability(): " + e.getMessage());
            }
        }
        for (ScientificStudy collabStudy : studyManager.getOngoingCollaborativeStudies(person)) {
            Science collabScience;
            if (!"Research".equals(collabStudy.getPhase()) || collabStudy.isCollaborativeResearchCompleted(person) || !mathematicsScience.equals(collabScience = collabStudy.getCollaborativeResearchers().get(person))) continue;
            try {
                Science jobScience;
                Lab lab = PerformMathematicalModeling.getLocalLab(person);
                if (lab == null) continue;
                double collabResult = 25.0;
                collabResult *= PerformMathematicalModeling.getLabCrowdingModifier(person, lab);
                Job job = person.getMind().getJob();
                if (job != null && !collabScience.equals(jobScience = ScienceUtil.getAssociatedScience(job))) {
                    collabResult /= 2.0;
                }
                result += collabResult;
            }
            catch (Exception e) {
                logger.severe("getProbability(): " + e.getMessage());
            }
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(PerformMathematicalModeling.class);
        }
        return result;
    }

    private static double getLabCrowdingModifier(Person researcher, Lab lab) {
        Building labBuilding;
        double result = 1.0;
        if (researcher.getLocationSituation().equals("In Settlement") && (labBuilding = ((Research)lab).getBuilding()) != null) {
            result *= Task.getCrowdingProbabilityModifier(researcher, labBuilding);
            result *= Task.getRelationshipModifier(researcher, labBuilding);
        }
        return result;
    }

    private ScientificStudy determineStudy() {
        ScientificStudy result = null;
        Science mathematicsScience = ScienceUtil.getScience("Mathematics");
        ArrayList<ScientificStudy> possibleStudies = new ArrayList<ScientificStudy>();
        ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
        ScientificStudy primaryStudy = manager.getOngoingPrimaryStudy(this.person);
        if (primaryStudy != null && "Research".equals(primaryStudy.getPhase()) && !primaryStudy.isPrimaryResearchCompleted() && mathematicsScience.equals(primaryStudy.getScience())) {
            possibleStudies.add(primaryStudy);
            possibleStudies.add(primaryStudy);
        }
        for (ScientificStudy collabStudy : manager.getOngoingCollaborativeStudies(this.person)) {
            Science collabScience;
            if (!"Research".equals(collabStudy.getPhase()) || collabStudy.isCollaborativeResearchCompleted(this.person) || !mathematicsScience.equals(collabScience = collabStudy.getCollaborativeResearchers().get(this.person))) continue;
            possibleStudies.add(collabStudy);
        }
        if (possibleStudies.size() > 0) {
            int selected = RandomUtil.getRandomInt(possibleStudies.size() - 1);
            result = (ScientificStudy)possibleStudies.get(selected);
        }
        return result;
    }

    private static Lab getLocalLab(Person person) {
        Lab result = null;
        String location = person.getLocationSituation();
        if (location.equals("In Settlement")) {
            result = PerformMathematicalModeling.getSettlementLab(person);
        } else if (location.equals("In Vehicle")) {
            result = PerformMathematicalModeling.getVehicleLab(person.getVehicle());
        }
        return result;
    }

    private static Lab getSettlementLab(Person person) {
        Research result = null;
        BuildingManager manager = person.getSettlement().getBuildingManager();
        List<Building> labBuildings = manager.getBuildings("Research");
        labBuildings = PerformMathematicalModeling.getSettlementLabsWithMathematicsSpeciality(labBuildings);
        labBuildings = BuildingManager.getNonMalfunctioningBuildings(labBuildings);
        labBuildings = PerformMathematicalModeling.getSettlementLabsWithAvailableSpace(labBuildings);
        if ((labBuildings = BuildingManager.getLeastCrowdedBuildings(labBuildings)).size() > 0) {
            Map<Building, Double> labBuildingProbs = BuildingManager.getBestRelationshipBuildings(person, labBuildings);
            Building building = RandomUtil.getWeightedRandomObject(labBuildingProbs);
            result = (Research)building.getFunction("Research");
        }
        return result;
    }

    private static List<Building> getSettlementLabsWithAvailableSpace(List<Building> buildingList) {
        ArrayList<Building> result = new ArrayList<Building>();
        for (Building building : buildingList) {
            Research lab = (Research)building.getFunction("Research");
            if (lab.getResearcherNum() >= lab.getLaboratorySize()) continue;
            result.add(building);
        }
        return result;
    }

    private static List<Building> getSettlementLabsWithMathematicsSpeciality(List<Building> buildingList) {
        ArrayList<Building> result = new ArrayList<Building>();
        Science mathematicsScience = ScienceUtil.getScience("Mathematics");
        for (Building building : buildingList) {
            Research lab = (Research)building.getFunction("Research");
            if (!lab.hasSpeciality(mathematicsScience.getName())) continue;
            result.add(building);
        }
        return result;
    }

    private static Lab getVehicleLab(Vehicle vehicle) {
        Rover rover;
        Lab result = null;
        Science mathematicsScience = ScienceUtil.getScience("Mathematics");
        if (vehicle instanceof Rover && (rover = (Rover)vehicle).hasLab()) {
            Lab lab = rover.getLab();
            boolean availableSpace = lab.getResearcherNum() < lab.getLaboratorySize();
            boolean speciality = lab.hasSpeciality(mathematicsScience.getName());
            boolean malfunction = rover.getMalfunctionManager().hasMalfunction();
            if (availableSpace && speciality && !malfunction) {
                result = lab;
            }
        }
        return result;
    }

    private void addPersonToLab() {
        try {
            String location = this.person.getLocationSituation();
            if (location.equals("In Settlement")) {
                Building labBuilding = ((Research)this.lab).getBuilding();
                BuildingManager.addPersonToBuilding(this.person, labBuilding);
                this.lab.addResearcher();
                this.malfunctions = labBuilding.getMalfunctionManager();
            } else if (location.equals("In Vehicle")) {
                this.lab.addResearcher();
                this.malfunctions = this.person.getVehicle().getMalfunctionManager();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "addPersonToLab(): " + e.getMessage());
        }
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 20.0;
        int academicAptitude = this.person.getNaturalAttributeManager().getAttribute("Academic Aptitude");
        newPoints += newPoints * ((double)academicAptitude - 50.0) / 100.0;
        Science mathematicsScience = ScienceUtil.getScience("Mathematics");
        String mathematicsSkill = ScienceUtil.getAssociatedSkill(mathematicsScience);
        this.person.getMind().getSkillManager().addExperience(mathematicsSkill, newPoints *= this.getTeachingExperienceModifier());
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        Science mathematicsScience = ScienceUtil.getScience("Mathematics");
        String mathematicsSkill = ScienceUtil.getAssociatedSkill(mathematicsScience);
        results.add(mathematicsSkill);
        return results;
    }

    @Override
    public int getEffectiveSkillLevel() {
        Science mathematicsScience = ScienceUtil.getScience("Mathematics");
        String mathematicsSkill = ScienceUtil.getAssociatedSkill(mathematicsScience);
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel(mathematicsSkill);
    }

    private double getEffectiveModelingTime(double time) {
        int techLevel;
        double modelingTime = time;
        int mathematicsSkill = this.getEffectiveSkillLevel();
        if (mathematicsSkill == 0) {
            modelingTime /= 2.0;
        }
        if (mathematicsSkill > 1) {
            modelingTime += modelingTime * (0.2 * (double)mathematicsSkill);
        }
        if ((techLevel = this.lab.getTechnologyLevel()) > 0) {
            modelingTime *= (double)techLevel;
        }
        if (this.hasResearchAssistant()) {
            SkillManager manager = this.researchAssistant.getMind().getSkillManager();
            Science mathematicsScience = ScienceUtil.getScience("Mathematics");
            int assistantSkill = manager.getEffectiveSkillLevel(ScienceUtil.getAssociatedSkill(mathematicsScience));
            if (mathematicsSkill > 0) {
                modelingTime *= 1.0 + (double)assistantSkill / (double)mathematicsSkill;
            }
        }
        return modelingTime;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (MODELING.equals(this.getPhase())) {
            return this.modelingPhase(time);
        }
        return time;
    }

    private double modelingPhase(double time) {
        boolean isPrimary;
        if (this.person.getPerformanceRating() == 0.0) {
            this.endTask();
        }
        if (this.malfunctions.hasMalfunction()) {
            this.endTask();
        }
        if (isPrimary = this.study.getPrimaryResearcher().equals(this.person)) {
            if (this.study.isPrimaryResearchCompleted()) {
                this.endTask();
            }
        } else if (this.study.isCollaborativeResearchCompleted(this.person)) {
            this.endTask();
        }
        if (this.isDone()) {
            return time;
        }
        double modelingTime = this.getEffectiveModelingTime(time);
        if (isPrimary) {
            this.study.addPrimaryResearchWorkTime(modelingTime);
        } else {
            this.study.addCollaborativeResearchWorkTime(this.person, modelingTime);
        }
        this.addExperience(modelingTime);
        this.checkForAccident(time);
        return 0.0;
    }

    private void checkForAccident(double time) {
        double chance = 0.001;
        int skill = this.getEffectiveSkillLevel();
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        Malfunctionable entity = null;
        entity = this.lab instanceof Research ? ((Research)this.lab).getBuilding() : this.person.getVehicle();
        if (entity != null && RandomUtil.lessThanRandPercent((chance *= entity.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            logger.info(this.person.getName() + " has a lab accident while performing " + "mathematical modeling");
            entity.getMalfunctionManager().accident();
        }
    }

    @Override
    public void endTask() {
        super.endTask();
        try {
            if (this.lab != null) {
                this.lab.removeResearcher();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Science getResearchScience() {
        return ScienceUtil.getScience("Mathematics");
    }

    @Override
    public Person getResearcher() {
        return this.person;
    }

    @Override
    public boolean hasResearchAssistant() {
        return this.researchAssistant != null;
    }

    @Override
    public Person getResearchAssistant() {
        return this.researchAssistant;
    }

    @Override
    public void setResearchAssistant(Person researchAssistant) {
        this.researchAssistant = researchAssistant;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.study = null;
        this.lab = null;
        this.malfunctions = null;
        this.researchAssistant = null;
    }
}

