/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.LocalBoundedObject;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.malfunction.MalfunctionFactory;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.EVAOperation;
import org.mars_sim.msp.core.person.ai.task.Repair;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;

public class RepairEVAMalfunction
extends EVAOperation
implements Repair,
Serializable {
    private static final String REPAIR_MALFUNCTION = "Repair Malfunction";
    private Malfunctionable entity;
    private Airlock airlock;

    public RepairEVAMalfunction(Person person) {
        super("Repairing EVA Malfunction", person);
        this.entity = RepairEVAMalfunction.getEVAMalfunctionEntity(person, person.getTopContainerUnit());
        if (this.entity == null) {
            this.endTask();
        }
        this.airlock = RepairEVAMalfunction.getAvailableAirlock(person);
        if (this.airlock == null) {
            this.endTask();
        }
        this.addPhase(REPAIR_MALFUNCTION);
    }

    private static boolean hasEVAMalfunction(Person person, Unit containerUnit, Malfunctionable entity) {
        boolean result = false;
        MalfunctionManager manager = entity.getMalfunctionManager();
        Iterator<Malfunction> i = manager.getEVAMalfunctions().iterator();
        while (i.hasNext() && !result) {
            if (!RepairEVAMalfunction.hasRepairPartsForMalfunction(person, containerUnit, i.next())) continue;
            result = true;
        }
        return result;
    }

    private static Malfunctionable getEVAMalfunctionEntity(Person person, Unit containerUnit) {
        Malfunctionable result = null;
        Collection<Malfunctionable> malfunctionables = null;
        if (containerUnit instanceof Malfunctionable) {
            malfunctionables = MalfunctionFactory.getMalfunctionables((Malfunctionable)((Object)containerUnit));
        } else if (containerUnit instanceof Settlement) {
            malfunctionables = MalfunctionFactory.getMalfunctionables((Settlement)containerUnit);
        }
        if (malfunctionables != null) {
            Iterator<Malfunctionable> i = malfunctionables.iterator();
            while (i.hasNext() && result == null) {
                Malfunctionable entity = i.next();
                if (!RepairEVAMalfunction.hasEVAMalfunction(person, containerUnit, entity)) continue;
                result = entity;
            }
        }
        return result;
    }

    private static boolean hasRepairPartsForMalfunction(Person person, Unit containerUnit, Malfunction malfunction) {
        if (person == null) {
            throw new IllegalArgumentException("person is null");
        }
        if (containerUnit == null) {
            throw new IllegalArgumentException("containerUnit is null");
        }
        if (malfunction == null) {
            throw new IllegalArgumentException("malfunction is null");
        }
        boolean result = true;
        Inventory inv = containerUnit.getInventory();
        Map<Part, Integer> repairParts = malfunction.getRepairParts();
        Iterator<Part> i = repairParts.keySet().iterator();
        while (i.hasNext() && result) {
            Part part = i.next();
            int number = repairParts.get(part);
            if (inv.getItemResourceNum(part) >= number) continue;
            result = false;
        }
        return result;
    }

    public static double getProbability(Person person) {
        SurfaceFeatures surface;
        double result = 0.0;
        Iterator<Malfunctionable> i = MalfunctionFactory.getMalfunctionables(person).iterator();
        while (i.hasNext()) {
            MalfunctionManager manager = i.next().getMalfunctionManager();
            for (Malfunction malfunction : manager.getEVAMalfunctions()) {
                try {
                    if (!RepairEVAMalfunction.hasRepairPartsForMalfunction(person, person.getTopContainerUnit(), malfunction)) continue;
                    result += 100.0;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        if (RepairEVAMalfunction.getAvailableAirlock(person) == null) {
            result = 0.0;
        }
        if ((surface = Simulation.instance().getMars().getSurfaceFeatures()).getSurfaceSunlight(person.getCoordinates()) == 0.0 && !surface.inDarkPolarRegion(person.getCoordinates())) {
            result = 0.0;
        }
        result *= person.getPerformanceRating();
        boolean inVehicle = "In Vehicle".equals(person.getLocationSituation());
        Job job = person.getMind().getJob();
        if (job != null && !inVehicle) {
            result *= job.getStartTaskProbabilityModifier(RepairEVAMalfunction.class);
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if ("Exit Airlock".equals(this.getPhase())) {
            return this.exitEVA(time);
        }
        if (REPAIR_MALFUNCTION.equals(this.getPhase())) {
            return this.repairMalfunction(time);
        }
        if ("Enter Airlock".equals(this.getPhase())) {
            return this.enterEVA(time);
        }
        return time;
    }

    @Override
    protected void addExperience(double time) {
        double evaExperience = time / 100.0;
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        evaExperience += evaExperience * experienceAptitudeModifier;
        this.person.getMind().getSkillManager().addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
        if (REPAIR_MALFUNCTION.equals(this.getPhase())) {
            double mechanicsExperience = time / 20.0;
            mechanicsExperience += mechanicsExperience * experienceAptitudeModifier;
            this.person.getMind().getSkillManager().addExperience("Mechanics", mechanicsExperience);
        }
    }

    private double exitEVA(double time) {
        try {
            time = this.exitAirlock(time, this.airlock);
            this.addExperience(time);
        }
        catch (Exception e) {
            this.endTask();
        }
        if (this.exitedAirlock) {
            this.setPhase(REPAIR_MALFUNCTION);
            this.moveToRepairLocation();
        }
        return time;
    }

    private void moveToRepairLocation() {
        Settlement settlement;
        List<Building> allBuildings;
        LocalBoundedObject boundedObject = null;
        if (this.entity instanceof LocalBoundedObject) {
            boundedObject = (LocalBoundedObject)((Object)this.entity);
        } else if (this.entity instanceof Settlement && (allBuildings = (settlement = (Settlement)((Object)this.entity)).getBuildingManager().getBuildings()).size() > 0) {
            int index = RandomUtil.getRandomInt(allBuildings.size() - 1);
            boundedObject = allBuildings.get(index);
        }
        if (boundedObject != null) {
            Point2D.Double newLocation = null;
            boolean goodLocation = false;
            for (int x = 0; x < 20 && !goodLocation; ++x) {
                Point2D.Double boundedLocalPoint = LocalAreaUtil.getRandomExteriorLocation(boundedObject, 1.0);
                newLocation = LocalAreaUtil.getLocalRelativeLocation(boundedLocalPoint.getX(), boundedLocalPoint.getY(), boundedObject);
                goodLocation = LocalAreaUtil.checkLocationCollision(newLocation.getX(), newLocation.getY(), this.person.getCoordinates());
            }
            this.person.setXLocation(newLocation.getX());
            this.person.setYLocation(newLocation.getY());
        }
    }

    private double repairMalfunction(double time) {
        if (!RepairEVAMalfunction.hasEVAMalfunction(this.person, this.containerUnit, this.entity) || this.shouldEndEVAOperation()) {
            this.setPhase("Enter Airlock");
            return time;
        }
        double workTime = time;
        int mechanicSkill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Mechanics");
        if (mechanicSkill == 0) {
            workTime /= 2.0;
        }
        if (mechanicSkill > 1) {
            workTime += workTime * (0.2 * (double)mechanicSkill);
        }
        Malfunction malfunction = null;
        Iterator<Malfunction> i = this.entity.getMalfunctionManager().getEVAMalfunctions().iterator();
        while (i.hasNext() && malfunction == null) {
            Malfunction tempMalfunction = i.next();
            if (!RepairEVAMalfunction.hasRepairPartsForMalfunction(this.person, this.containerUnit, tempMalfunction)) continue;
            malfunction = tempMalfunction;
            this.setDescription("Repairing " + malfunction.getName() + " on " + this.entity.getName());
        }
        Inventory inv = this.containerUnit.getInventory();
        if (RepairEVAMalfunction.hasRepairPartsForMalfunction(this.person, this.containerUnit, malfunction)) {
            HashMap<Part, Integer> parts = new HashMap<Part, Integer>(malfunction.getRepairParts());
            for (Part part : parts.keySet()) {
                int number = (Integer)parts.get(part);
                inv.retrieveItemResources(part, number);
                malfunction.repairWithParts(part, number);
            }
        } else {
            this.setPhase("Enter Airlock");
            return time;
        }
        double workTimeLeft = malfunction.addEVAWorkTime(workTime);
        this.addExperience(time);
        if (!RepairEVAMalfunction.hasEVAMalfunction(this.person, this.containerUnit, this.entity)) {
            this.setPhase("Enter Airlock");
        }
        this.checkForAccident(time);
        return workTimeLeft / workTime * time;
    }

    private double enterEVA(double time) {
        time = this.enterAirlock(time, this.airlock);
        this.addExperience(time);
        if (this.enteredAirlock) {
            this.endTask();
        }
        return time;
    }

    @Override
    public Malfunctionable getEntity() {
        return this.entity;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        int EVAOperationsSkill = manager.getEffectiveSkillLevel("EVA Operations");
        int mechanicsSkill = manager.getEffectiveSkillLevel("Mechanics");
        return (int)Math.round((double)(EVAOperationsSkill + mechanicsSkill) / 2.0);
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("EVA Operations");
        results.add("Mechanics");
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.entity = null;
        this.airlock = null;
    }
}

