/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.malfunction.MalfunctionFactory;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.task.Repair;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.person.ai.task.TaskEvent;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;

public class RepairEmergencyMalfunction
extends Task
implements Repair,
Serializable {
    private static final String REPAIRING = "Repairing";
    private static final double STRESS_MODIFIER = 2.0;
    private Malfunctionable entity;
    private Malfunction malfunction;

    public RepairEmergencyMalfunction(Person person) {
        super("Repairing Emergency Malfunction", person, true, true, 2.0, false, 0.0);
        this.claimMalfunction();
        if (person.getLocationSituation().equals("In Settlement") && this.entity instanceof Building) {
            BuildingManager.addPersonToBuilding(person, (Building)this.entity);
        }
        if (this.getCreateEvents()) {
            TaskEvent startingEvent = new TaskEvent(person, this, "Task Starting", "");
            Simulation.instance().getEventManager().registerNewEvent(startingEvent);
        }
        this.addPhase(REPAIRING);
        this.setPhase(REPAIRING);
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (REPAIRING.equals(this.getPhase())) {
            return this.repairingPhase(time);
        }
        return time;
    }

    private double repairingPhase(double time) {
        double remainingWorkTime;
        double workTimeLeft = this.malfunction.getEmergencyWorkTime() - this.malfunction.getCompletedEmergencyWorkTime();
        if (workTimeLeft == 0.0) {
            this.endTask();
        }
        if (this.isDone()) {
            return time;
        }
        double workTime = time;
        int mechanicSkill = this.getEffectiveSkillLevel();
        if (mechanicSkill == 0) {
            workTime /= 2.0;
        }
        if (mechanicSkill > 1) {
            workTime += workTime * (0.2 * (double)mechanicSkill);
        }
        if ((remainingWorkTime = this.malfunction.addEmergencyWorkTime(workTime)) > 0.0) {
            this.endTask();
        }
        this.addExperience(time);
        return time * (remainingWorkTime / workTime);
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 20.0;
        int experienceAptitude = this.person.getNaturalAttributeManager().getAttribute("Experience Aptitude");
        newPoints += newPoints * ((double)experienceAptitude - 50.0) / 100.0;
        this.person.getMind().getSkillManager().addExperience("Mechanics", newPoints *= this.getTeachingExperienceModifier());
    }

    public static boolean hasEmergencyMalfunction(Person person) {
        boolean result = false;
        for (Malfunctionable entity : MalfunctionFactory.getMalfunctionables(person)) {
            MalfunctionManager manager = entity.getMalfunctionManager();
            if (!manager.hasEmergencyMalfunction()) continue;
            result = true;
        }
        return result;
    }

    private void claimMalfunction() {
        this.malfunction = null;
        Iterator<Malfunctionable> i = MalfunctionFactory.getMalfunctionables(this.person).iterator();
        while (i.hasNext() && this.malfunction == null) {
            Malfunctionable e = i.next();
            MalfunctionManager manager = e.getMalfunctionManager();
            if (!manager.hasEmergencyMalfunction()) continue;
            this.malfunction = manager.getMostSeriousEmergencyMalfunction();
            this.entity = e;
            this.setDescription("Emergency repair " + this.malfunction.getName() + " on " + this.entity);
        }
    }

    @Override
    public Malfunctionable getEntity() {
        return this.entity;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel("Mechanics");
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        results.add("Mechanics");
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.entity = null;
        this.malfunction = null;
    }
}

