/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LifeSupport;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.malfunction.MalfunctionFactory;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.Repair;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;

public class RepairMalfunction
extends Task
implements Repair,
Serializable {
    private static final String REPAIRING = "Repairing";
    private static final double STRESS_MODIFIER = 0.3;
    private Malfunctionable entity;

    public RepairMalfunction(Person person) {
        super("Repairing Malfunction", person, true, false, 0.3, true, RandomUtil.getRandomDouble(200.0));
        this.entity = RepairMalfunction.getMalfunctionEntity(person);
        if (this.entity != null) {
            this.addPersonToMalfunctionableBuilding(this.entity);
        } else {
            this.endTask();
        }
        this.addPhase(REPAIRING);
        this.setPhase(REPAIRING);
    }

    private static Malfunctionable getMalfunctionEntity(Person person) {
        Malfunctionable result = null;
        Iterator<Malfunctionable> i = MalfunctionFactory.getMalfunctionables(person).iterator();
        while (i.hasNext() && result == null) {
            Malfunctionable entity = i.next();
            if (!RepairMalfunction.hasMalfunction(person, entity)) continue;
            result = entity;
        }
        return result;
    }

    private static boolean hasMalfunction(Person person, Malfunctionable entity) {
        boolean result = false;
        MalfunctionManager manager = entity.getMalfunctionManager();
        Iterator<Malfunction> i = manager.getNormalMalfunctions().iterator();
        while (i.hasNext() && !result) {
            if (!RepairMalfunction.hasRepairPartsForMalfunction(person, i.next())) continue;
            result = true;
        }
        return result;
    }

    private static boolean hasRepairPartsForMalfunction(Person person, Malfunction malfunction) {
        if (person == null) {
            throw new IllegalArgumentException("person is null");
        }
        if (malfunction == null) {
            throw new IllegalArgumentException("malfunction is null");
        }
        boolean result = false;
        Unit containerUnit = person.getTopContainerUnit();
        if (containerUnit != null) {
            result = true;
            Inventory inv = containerUnit.getInventory();
            Map<Part, Integer> repairParts = malfunction.getRepairParts();
            Iterator<Part> i = repairParts.keySet().iterator();
            while (i.hasNext() && result) {
                Part part = i.next();
                int number = repairParts.get(part);
                if (inv.getItemResourceNum(part) >= number) continue;
                result = false;
            }
        }
        return result;
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        for (Malfunctionable entity : MalfunctionFactory.getMalfunctionables(person)) {
            MalfunctionManager manager = entity.getMalfunctionManager();
            for (Malfunction malfunction : manager.getNormalMalfunctions()) {
                try {
                    if (!RepairMalfunction.hasRepairPartsForMalfunction(person, malfunction)) continue;
                    result += 100.0;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(RepairMalfunction.class);
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (REPAIRING.equals(this.getPhase())) {
            return this.repairingPhase(time);
        }
        return time;
    }

    private double repairingPhase(double time) {
        if (!RepairMalfunction.hasMalfunction(this.person, this.entity)) {
            this.endTask();
        }
        if (this.isDone()) {
            return time;
        }
        double workTime = time;
        int mechanicSkill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Mechanics");
        if (mechanicSkill == 0) {
            workTime /= 2.0;
        }
        if (mechanicSkill > 1) {
            workTime += workTime * (0.2 * (double)mechanicSkill);
        }
        Malfunction malfunction = null;
        Iterator<Malfunction> i = this.entity.getMalfunctionManager().getNormalMalfunctions().iterator();
        while (i.hasNext() && malfunction == null) {
            Malfunction tempMalfunction = i.next();
            if (!RepairMalfunction.hasRepairPartsForMalfunction(this.person, tempMalfunction)) continue;
            malfunction = tempMalfunction;
            this.setDescription("Repairing " + malfunction.getName() + " on " + this.entity.getName());
        }
        if (RepairMalfunction.hasRepairPartsForMalfunction(this.person, malfunction)) {
            Inventory inv = this.person.getTopContainerUnit().getInventory();
            HashMap<Part, Integer> parts = new HashMap<Part, Integer>(malfunction.getRepairParts());
            for (Part part : parts.keySet()) {
                int number = (Integer)parts.get(part);
                inv.retrieveItemResources(part, number);
                malfunction.repairWithParts(part, number);
            }
        } else {
            this.endTask();
            return time;
        }
        double workTimeLeft = malfunction.addWorkTime(workTime);
        this.addExperience(time);
        this.checkForAccident(time);
        if (!RepairMalfunction.hasMalfunction(this.person, this.entity)) {
            this.endTask();
        }
        return workTimeLeft / workTime / time;
    }

    @Override
    protected void addExperience(double time) {
        double newPoints = time / 20.0;
        int experienceAptitude = this.person.getNaturalAttributeManager().getAttribute("Experience Aptitude");
        newPoints += newPoints * ((double)experienceAptitude - 50.0) / 100.0;
        this.person.getMind().getSkillManager().addExperience("Mechanics", newPoints *= this.getTeachingExperienceModifier());
    }

    private void checkForAccident(double time) {
        double chance = 0.001;
        int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Mechanics");
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        if (RandomUtil.lessThanRandPercent((chance *= this.entity.getMalfunctionManager().getWearConditionAccidentModifier()) * time) && this.entity != null) {
            this.entity.getMalfunctionManager().accident();
        }
    }

    @Override
    public Malfunctionable getEntity() {
        return this.entity;
    }

    private void addPersonToMalfunctionableBuilding(Malfunctionable malfunctionable) {
        Building building;
        if (malfunctionable instanceof Building && (building = (Building)malfunctionable) instanceof LifeSupport) {
            BuildingManager.addPersonToBuilding(this.person, building);
        }
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        return manager.getEffectiveSkillLevel("Mechanics");
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(1);
        results.add("Mechanics");
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.entity = null;
    }
}

