/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.Mind;
import org.mars_sim.msp.core.person.ai.task.AssistScientificStudyResearcher;
import org.mars_sim.msp.core.person.ai.task.CompileScientificStudyResults;
import org.mars_sim.msp.core.person.ai.task.CookMeal;
import org.mars_sim.msp.core.person.ai.task.DigLocalIce;
import org.mars_sim.msp.core.person.ai.task.DigLocalRegolith;
import org.mars_sim.msp.core.person.ai.task.EatMeal;
import org.mars_sim.msp.core.person.ai.task.EnterAirlock;
import org.mars_sim.msp.core.person.ai.task.InviteStudyCollaborator;
import org.mars_sim.msp.core.person.ai.task.LoadVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.LoadVehicleGarage;
import org.mars_sim.msp.core.person.ai.task.MaintainGroundVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.MaintainGroundVehicleGarage;
import org.mars_sim.msp.core.person.ai.task.Maintenance;
import org.mars_sim.msp.core.person.ai.task.MaintenanceEVA;
import org.mars_sim.msp.core.person.ai.task.ManufactureConstructionMaterials;
import org.mars_sim.msp.core.person.ai.task.ManufactureGood;
import org.mars_sim.msp.core.person.ai.task.MedicalAssistance;
import org.mars_sim.msp.core.person.ai.task.ObserveAstronomicalObjects;
import org.mars_sim.msp.core.person.ai.task.PeerReviewStudyPaper;
import org.mars_sim.msp.core.person.ai.task.PerformLaboratoryExperiment;
import org.mars_sim.msp.core.person.ai.task.PerformLaboratoryResearch;
import org.mars_sim.msp.core.person.ai.task.PerformMathematicalModeling;
import org.mars_sim.msp.core.person.ai.task.PrescribeMedication;
import org.mars_sim.msp.core.person.ai.task.ProposeScientificStudy;
import org.mars_sim.msp.core.person.ai.task.Relax;
import org.mars_sim.msp.core.person.ai.task.RepairEVAMalfunction;
import org.mars_sim.msp.core.person.ai.task.RepairEmergencyMalfunction;
import org.mars_sim.msp.core.person.ai.task.RepairMalfunction;
import org.mars_sim.msp.core.person.ai.task.RespondToStudyInvitation;
import org.mars_sim.msp.core.person.ai.task.ReturnLightUtilityVehicle;
import org.mars_sim.msp.core.person.ai.task.SalvageGood;
import org.mars_sim.msp.core.person.ai.task.Sleep;
import org.mars_sim.msp.core.person.ai.task.StudyFieldSamples;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.person.ai.task.Teach;
import org.mars_sim.msp.core.person.ai.task.TendGreenhouse;
import org.mars_sim.msp.core.person.ai.task.ToggleFuelPowerSource;
import org.mars_sim.msp.core.person.ai.task.ToggleResourceProcess;
import org.mars_sim.msp.core.person.ai.task.UnloadVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.UnloadVehicleGarage;
import org.mars_sim.msp.core.person.ai.task.Workout;
import org.mars_sim.msp.core.person.ai.task.Yoga;
import org.mars_sim.msp.core.time.MarsClock;

public class TaskManager
implements Serializable {
    private static Logger logger = Logger.getLogger(TaskManager.class.getName());
    public static final String TASK_EVENT = "task";
    private Task currentTask;
    private Mind mind;
    private Class<? extends Task>[] availableTasks = null;
    private MarsClock timeCache;
    private Map<Class<? extends Task>, Double> taskProbCache;
    private double totalProbCache;

    public TaskManager(Mind mind) {
        this.mind = mind;
        this.currentTask = null;
        this.availableTasks = new Class[40];
        this.availableTasks[0] = Relax.class;
        this.availableTasks[1] = Yoga.class;
        this.availableTasks[2] = TendGreenhouse.class;
        this.availableTasks[3] = Maintenance.class;
        this.availableTasks[4] = MaintainGroundVehicleGarage.class;
        this.availableTasks[5] = MaintainGroundVehicleEVA.class;
        this.availableTasks[6] = Sleep.class;
        this.availableTasks[7] = EatMeal.class;
        this.availableTasks[8] = MedicalAssistance.class;
        this.availableTasks[9] = RepairMalfunction.class;
        this.availableTasks[10] = RepairEVAMalfunction.class;
        this.availableTasks[11] = EnterAirlock.class;
        this.availableTasks[12] = Workout.class;
        this.availableTasks[13] = Teach.class;
        this.availableTasks[14] = CookMeal.class;
        this.availableTasks[15] = MaintenanceEVA.class;
        this.availableTasks[16] = LoadVehicleGarage.class;
        this.availableTasks[17] = UnloadVehicleGarage.class;
        this.availableTasks[18] = ToggleResourceProcess.class;
        this.availableTasks[19] = ManufactureGood.class;
        this.availableTasks[20] = ToggleFuelPowerSource.class;
        this.availableTasks[21] = DigLocalRegolith.class;
        this.availableTasks[22] = PrescribeMedication.class;
        this.availableTasks[23] = ProposeScientificStudy.class;
        this.availableTasks[24] = InviteStudyCollaborator.class;
        this.availableTasks[25] = RespondToStudyInvitation.class;
        this.availableTasks[26] = PerformLaboratoryResearch.class;
        this.availableTasks[27] = ObserveAstronomicalObjects.class;
        this.availableTasks[28] = StudyFieldSamples.class;
        this.availableTasks[29] = PerformLaboratoryExperiment.class;
        this.availableTasks[30] = PerformMathematicalModeling.class;
        this.availableTasks[31] = CompileScientificStudyResults.class;
        this.availableTasks[32] = PeerReviewStudyPaper.class;
        this.availableTasks[33] = AssistScientificStudyResearcher.class;
        this.availableTasks[34] = SalvageGood.class;
        this.availableTasks[35] = ManufactureConstructionMaterials.class;
        this.availableTasks[36] = ReturnLightUtilityVehicle.class;
        this.availableTasks[37] = LoadVehicleEVA.class;
        this.availableTasks[38] = UnloadVehicleEVA.class;
        this.availableTasks[39] = DigLocalIce.class;
        this.timeCache = null;
        this.taskProbCache = new HashMap<Class<? extends Task>, Double>(this.availableTasks.length);
        this.totalProbCache = 0.0;
    }

    public boolean hasActiveTask() {
        return this.currentTask != null && !this.currentTask.isDone();
    }

    public boolean hasTask() {
        return this.currentTask != null;
    }

    public String getTaskName() {
        if (this.currentTask != null) {
            return this.currentTask.getName();
        }
        return "";
    }

    public String getTaskDescription() {
        if (this.currentTask != null) {
            return this.currentTask.getDescription();
        }
        return "";
    }

    public String getPhase() {
        if (this.currentTask != null) {
            return this.currentTask.getPhase();
        }
        return "";
    }

    public Task getTask() {
        return this.currentTask;
    }

    public void clearTask() {
        this.currentTask = null;
        this.mind.getPerson().fireUnitUpdate(TASK_EVENT);
    }

    public void addTask(Task newTask) {
        if (this.hasActiveTask()) {
            this.currentTask.addSubTask(newTask);
        } else {
            this.currentTask = newTask;
        }
        this.mind.getPerson().fireUnitUpdate(TASK_EVENT, newTask);
    }

    public double performTask(double time, double efficiency) {
        double remainingTime = 0.0;
        if (this.currentTask != null) {
            if (efficiency < 0.1) {
                efficiency = 0.1;
            }
            if (this.currentTask.isEffortDriven()) {
                time *= efficiency;
            }
            this.checkForEmergency();
            remainingTime = this.currentTask.performTask(time);
        }
        return remainingTime;
    }

    private void checkForEmergency() {
        if (RepairEmergencyMalfunction.hasEmergencyMalfunction(this.mind.getPerson())) {
            boolean hasEmergencyRepair = false;
            for (Task task = this.currentTask; task != null; task = task.getSubTask()) {
                if (!(task instanceof RepairEmergencyMalfunction)) continue;
                hasEmergencyRepair = true;
            }
            if (!hasEmergencyRepair) {
                this.addTask(new RepairEmergencyMalfunction(this.mind.getPerson()));
            }
        }
    }

    public Task getNewTask() {
        if (!this.useCache()) {
            this.calculateProbability();
        }
        double totalProbability = this.getTotalTaskProbability(true);
        double r = RandomUtil.getRandomDouble(totalProbability);
        Class<? extends Task> selectedTask = null;
        for (Class<? extends Task> task : this.taskProbCache.keySet()) {
            double probWeight = this.taskProbCache.get(task);
            if (selectedTask != null) continue;
            if (r < probWeight) {
                selectedTask = task;
                continue;
            }
            r -= probWeight;
        }
        Class[] parametersForFindingMethod = new Class[]{Person.class};
        Object[] parametersForInvokingMethod = new Object[]{this.mind.getPerson()};
        try {
            Constructor<? extends Task> construct = selectedTask.getConstructor(parametersForFindingMethod);
            return construct.newInstance(parametersForInvokingMethod);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
        catch (SecurityException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public double getTotalTaskProbability(boolean useCache) {
        if (!useCache) {
            this.calculateProbability();
        }
        return this.totalProbCache;
    }

    private void calculateProbability() {
        Class[] parametersForFindingMethod = new Class[]{Person.class};
        Object[] parametersForInvokingMethod = new Object[]{this.mind.getPerson()};
        this.totalProbCache = 0.0;
        for (Class<? extends Task> availableTask : this.availableTasks) {
            try {
                Class<? extends Task> probabilityClass = availableTask;
                Method probabilityMethod = probabilityClass.getMethod("getProbability", parametersForFindingMethod);
                Double probability = (Double)probabilityMethod.invoke(null, parametersForInvokingMethod);
                if (probability >= 0.0 && probability != Double.NaN && probability != Double.POSITIVE_INFINITY) {
                    this.taskProbCache.put(probabilityClass, probability);
                    this.totalProbCache += probability.doubleValue();
                    continue;
                }
                this.taskProbCache.put(probabilityClass, 0.0);
                logger.severe(this.mind.getPerson().getName() + " bad task probability: " + availableTask.getName() + " probability: " + probability);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error calculating task probabilities.", e);
            }
        }
        this.timeCache = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
    }

    private boolean useCache() {
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        return currentTime.equals(this.timeCache);
    }

    public void destroy() {
        if (this.currentTask != null) {
            this.currentTask.destroy();
        }
        this.mind = null;
        this.availableTasks = null;
        this.timeCache = null;
        this.taskProbCache.clear();
        this.taskProbCache = null;
    }
}

