/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.social.Relationship;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.LifeSupport;
import org.mars_sim.msp.core.vehicle.Crewable;

public class Teach
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(Teach.class.getName());
    private static final String TEACHING = "Teaching";
    private static final double STRESS_MODIFIER = -0.1;
    private static final double BASE_RELATIONSHIP_MODIFIER = 0.2;
    private Person student;
    private Task teachingTask;

    public Teach(Person person) {
        super(TEACHING, person, false, false, -0.1, false, 0.0);
        Collection<Person> students = Teach.getBestStudents(person);
        if (students.size() > 0) {
            Building studentBuilding;
            Building teacherBuilding;
            Object[] array = students.toArray();
            int rand = RandomUtil.getRandomInt(students.size() - 1);
            this.student = (Person)array[rand];
            this.teachingTask = this.student.getMind().getTaskManager().getTask();
            this.teachingTask.setTeacher(person);
            this.setDescription("Teaching " + this.teachingTask.getName() + " to " + this.student.getName());
            if (person.getLocationSituation().equals("In Settlement") && (teacherBuilding = BuildingManager.getBuilding(person)) != (studentBuilding = BuildingManager.getBuilding(this.student))) {
                BuildingManager.addPersonToBuilding(person, studentBuilding);
            }
        } else {
            this.endTask();
        }
        this.addPhase(TEACHING);
        this.setPhase(TEACHING);
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        Collection<Person> potentialStudents = Teach.getBestStudents(person);
        if (potentialStudents.size() > 0) {
            result = 50.0;
            if (person.getLocationSituation().equals("In Settlement")) {
                Person student = (Person)potentialStudents.toArray()[0];
                Building building = BuildingManager.getBuilding(student);
                if (building != null) {
                    result *= Task.getCrowdingProbabilityModifier(person, building);
                    result *= Task.getRelationshipModifier(person, building);
                } else {
                    result = 0.0;
                }
            }
        }
        return result;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (TEACHING.equals(this.getPhase())) {
            return this.teachingPhase(time);
        }
        return time;
    }

    private double teachingPhase(double time) {
        if (this.teachingTask.isDone()) {
            this.endTask();
        }
        if (!this.student.getLocationSituation().equals(this.person.getLocationSituation())) {
            this.endTask();
        }
        this.addRelationshipModifier(time);
        return 0.0;
    }

    private void addRelationshipModifier(double time) {
        RelationshipManager manager = Simulation.instance().getRelationshipManager();
        double currentOpinion = manager.getOpinionOfPerson(this.student, this.person);
        double newOpinion = currentOpinion + 0.2 * time;
        Relationship relationship = manager.getRelationship(this.student, this.person);
        if (relationship != null) {
            relationship.setPersonOpinion(this.student, newOpinion);
        }
    }

    @Override
    protected void addExperience(double time) {
    }

    @Override
    public void endTask() {
        super.endTask();
        this.teachingTask.setTeacher(null);
    }

    private static Collection<Person> getBestStudents(Person teacher) {
        ConcurrentLinkedQueue<Person> result = new ConcurrentLinkedQueue<Person>();
        Collection<Person> students = Teach.getTeachableStudents(teacher);
        Collection<Object> leastCrowded = new ConcurrentLinkedQueue();
        if (teacher.getLocationSituation().equals("In Settlement")) {
            int crowding = Integer.MAX_VALUE;
            for (Person student : students) {
                Building building = BuildingManager.getBuilding(student);
                if (building == null) continue;
                LifeSupport lifeSupport = (LifeSupport)building.getFunction("Life Support");
                int n = lifeSupport.getOccupantNumber() - lifeSupport.getOccupantCapacity() + 1;
                if (n < -1) {
                    n = -1;
                }
                if (n >= crowding) continue;
                crowding = n;
            }
            for (Person student : students) {
                Building building = BuildingManager.getBuilding(student);
                if (building == null) continue;
                LifeSupport lifeSupport = (LifeSupport)building.getFunction("Life Support");
                int buildingCrowding = lifeSupport.getOccupantNumber() - lifeSupport.getOccupantCapacity() + 1;
                if (buildingCrowding < -1) {
                    buildingCrowding = -1;
                }
                if (buildingCrowding != crowding) continue;
                leastCrowded.add(student);
            }
        } else {
            leastCrowded = students;
        }
        RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
        ConcurrentLinkedQueue<Person> favoriteStudents = new ConcurrentLinkedQueue<Person>();
        double favorite = Double.NEGATIVE_INFINITY;
        for (Person person : leastCrowded) {
            double opinion = relationshipManager.getOpinionOfPerson(teacher, person);
            if (!(opinion > favorite)) continue;
            favorite = opinion;
        }
        for (Person person : leastCrowded) {
            double opinion = relationshipManager.getOpinionOfPerson(teacher, person);
            if (opinion != favorite) continue;
            favoriteStudents.add(person);
        }
        result = favoriteStudents;
        return result;
    }

    private static Collection<Person> getTeachableStudents(Person teacher) {
        ConcurrentLinkedQueue<Person> result = new ConcurrentLinkedQueue<Person>();
        for (Person student : Teach.getLocalPeople(teacher)) {
            boolean possibleStudent = false;
            Task task = student.getMind().getTaskManager().getTask();
            if (task == null) continue;
            for (String taskSkillName : task.getAssociatedSkills()) {
                int studentSkill = student.getMind().getSkillManager().getSkillLevel(taskSkillName);
                int teacherSkill = teacher.getMind().getSkillManager().getSkillLevel(taskSkillName);
                if (teacherSkill < studentSkill + 1 || task.hasTeacher()) continue;
                possibleStudent = true;
            }
            if (!possibleStudent) continue;
            result.add(student);
        }
        return result;
    }

    private static Collection<Person> getLocalPeople(Person person) {
        ConcurrentLinkedQueue<Person> people;
        block3: {
            block2: {
                people = new ConcurrentLinkedQueue<Person>();
                if (!person.getLocationSituation().equals("In Settlement")) break block2;
                for (Person inhabitant : person.getSettlement().getInhabitants()) {
                    if (person == inhabitant) continue;
                    people.add(inhabitant);
                }
                break block3;
            }
            if (!person.getLocationSituation().equals("In Vehicle")) break block3;
            Crewable rover = (Crewable)((Object)person.getVehicle());
            for (Person crewmember : rover.getCrew()) {
                if (person == crewmember) continue;
                people.add(crewmember);
            }
        }
        return people;
    }

    @Override
    public int getEffectiveSkillLevel() {
        return 0;
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(0);
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.student = null;
        this.teachingTask = null;
    }
}

