/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.EVAOperation;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.FuelPowerSource;
import org.mars_sim.msp.core.structure.building.function.PowerGeneration;
import org.mars_sim.msp.core.structure.building.function.PowerSource;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.time.MarsClock;

public class ToggleFuelPowerSource
extends EVAOperation
implements Serializable {
    private static Logger logger = Logger.getLogger(ToggleFuelPowerSource.class.getName());
    private static final String TOGGLE_POWER_SOURCE = "toggle power source";
    private boolean isEVA;
    private Airlock airlock;
    private FuelPowerSource powerSource;
    private Building building;
    private boolean toggleOn;

    public ToggleFuelPowerSource(Person person) {
        super("Turning on fuel power source", person);
        this.building = ToggleFuelPowerSource.getFuelPowerSourceBuilding(person);
        if (this.building != null) {
            this.powerSource = ToggleFuelPowerSource.getFuelPowerSource(this.building);
            boolean bl = this.toggleOn = !this.powerSource.isToggleON();
            if (!this.toggleOn) {
                this.setName("Turning off fuel power source");
                this.setDescription("Turning off fuel power source");
            }
            boolean bl2 = this.isEVA = !this.building.hasFunction("Life Support");
            if (!this.isEVA) {
                BuildingManager.addPersonToBuilding(person, this.building);
            }
        } else {
            this.endTask();
        }
        if (this.isEVA) {
            this.airlock = ToggleFuelPowerSource.getAvailableAirlock(person);
            if (this.airlock == null) {
                this.endTask();
            }
        }
        this.addPhase(TOGGLE_POWER_SOURCE);
        if (!this.isEVA) {
            this.setPhase(TOGGLE_POWER_SOURCE);
        }
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            boolean isEVA = false;
            Settlement settlement = person.getSettlement();
            try {
                Building building = ToggleFuelPowerSource.getFuelPowerSourceBuilding(person);
                if (building != null) {
                    FuelPowerSource powerSource = ToggleFuelPowerSource.getFuelPowerSource(building);
                    isEVA = !building.hasFunction("Life Support");
                    double diff = ToggleFuelPowerSource.getValueDiff(settlement, powerSource);
                    double baseProb = diff * 10000.0;
                    if (baseProb > 100.0) {
                        baseProb = 100.0;
                    }
                    result += baseProb;
                    if (!isEVA) {
                        result *= Task.getCrowdingProbabilityModifier(person, building);
                        result *= Task.getRelationshipModifier(person, building);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            if (isEVA) {
                SurfaceFeatures surface;
                if (ToggleFuelPowerSource.getAvailableAirlock(person) == null) {
                    result = 0.0;
                }
                if ((surface = Simulation.instance().getMars().getSurfaceFeatures()).getSurfaceSunlight(person.getCoordinates()) == 0.0 && !surface.inDarkPolarRegion(person.getCoordinates())) {
                    result = 0.0;
                }
                if (person.getLocationSituation().equals("In Settlement") && settlement.getCurrentPopulationNum() > settlement.getPopulationCapacity()) {
                    result *= 2.0;
                }
            }
            result *= person.getPerformanceRating();
            Job job = person.getMind().getJob();
            if (job != null) {
                result *= job.getStartTaskProbabilityModifier(ToggleFuelPowerSource.class);
            }
        }
        return result;
    }

    private static Building getFuelPowerSourceBuilding(Person person) {
        Building result = null;
        Settlement settlement = person.getSettlement();
        if (settlement != null) {
            BuildingManager manager = settlement.getBuildingManager();
            double bestDiff = 0.0;
            for (Building building : manager.getBuildings("Power Generation")) {
                double diff;
                FuelPowerSource powerSource = ToggleFuelPowerSource.getFuelPowerSource(building);
                if (powerSource == null || !((diff = ToggleFuelPowerSource.getValueDiff(settlement, powerSource)) > bestDiff)) continue;
                bestDiff = diff;
                result = building;
            }
        }
        return result;
    }

    private static FuelPowerSource getFuelPowerSource(Building building) {
        FuelPowerSource result = null;
        Settlement settlement = building.getBuildingManager().getSettlement();
        if (building.hasFunction("Power Generation")) {
            double bestDiff = 0.0;
            PowerGeneration powerGeneration = (PowerGeneration)building.getFunction("Power Generation");
            for (PowerSource powerSource : powerGeneration.getPowerSources()) {
                FuelPowerSource fuelSource;
                double diff;
                if (!(powerSource instanceof FuelPowerSource) || !((diff = ToggleFuelPowerSource.getValueDiff(settlement, fuelSource = (FuelPowerSource)powerSource)) > bestDiff)) continue;
                bestDiff = diff;
                result = fuelSource;
            }
        }
        return result;
    }

    private static double getValueDiff(Settlement settlement, FuelPowerSource fuelSource) {
        double inputValue = ToggleFuelPowerSource.getInputResourcesValue(settlement, fuelSource);
        double outputValue = ToggleFuelPowerSource.getPowerOutputValue(settlement, fuelSource);
        double diff = outputValue - inputValue;
        if (fuelSource.isToggleON()) {
            diff *= -1.0;
        }
        if (ToggleFuelPowerSource.isEmptyInputResource(settlement, fuelSource)) {
            diff = fuelSource.isToggleON() ? 1.0 : 0.0;
        }
        return diff;
    }

    private static double getInputResourcesValue(Settlement settlement, FuelPowerSource fuelSource) {
        AmountResource resource = fuelSource.getFuelResource();
        double massPerSol = fuelSource.getFuelConsumptionRate();
        double value = settlement.getGoodsManager().getGoodValuePerItem(GoodsUtil.getResourceGood(resource));
        return value * massPerSol;
    }

    private static double getPowerOutputValue(Settlement settlement, FuelPowerSource fuelSource) {
        double power = fuelSource.getMaxPower();
        double hoursInSol = MarsClock.convertMillisolsToSeconds(1000.0) / 60.0 / 60.0;
        double powerPerSol = power * hoursInSol;
        double powerValue = powerPerSol * settlement.getPowerGrid().getPowerValue();
        return powerValue;
    }

    private static boolean isEmptyInputResource(Settlement settlement, FuelPowerSource fuelSource) {
        boolean result = false;
        AmountResource resource = fuelSource.getFuelResource();
        double stored = settlement.getInventory().getAmountResourceStored(resource, false);
        if (stored == 0.0) {
            result = true;
        }
        return result;
    }

    @Override
    protected void addExperience(double time) {
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        if (this.isEVA) {
            double evaExperience = time / 100.0;
            evaExperience += evaExperience * experienceAptitudeModifier;
            this.person.getMind().getSkillManager().addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
        }
        if (TOGGLE_POWER_SOURCE.equals(this.getPhase())) {
            double mechanicsExperience = time / 100.0;
            mechanicsExperience += mechanicsExperience * experienceAptitudeModifier;
            this.person.getMind().getSkillManager().addExperience("Mechanics", mechanicsExperience);
        }
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> result = new ArrayList<String>(2);
        result.add("Mechanics");
        if (this.isEVA) {
            result.add("EVA Operations");
        }
        return result;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        int EVAOperationsSkill = manager.getEffectiveSkillLevel("EVA Operations");
        int mechanicsSkill = manager.getEffectiveSkillLevel("Mechanics");
        if (this.isEVA) {
            return (int)Math.round((double)(EVAOperationsSkill + mechanicsSkill) / 2.0);
        }
        return mechanicsSkill;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (this.isEVA) {
            if ("Exit Airlock".equals(this.getPhase())) {
                return this.exitEVA(time);
            }
            if (TOGGLE_POWER_SOURCE.equals(this.getPhase())) {
                return this.togglePowerSourcePhase(time);
            }
            if ("Enter Airlock".equals(this.getPhase())) {
                return this.enterEVA(time);
            }
            return time;
        }
        if (TOGGLE_POWER_SOURCE.equals(this.getPhase())) {
            return this.togglePowerSourcePhase(time);
        }
        return time;
    }

    private double exitEVA(double time) {
        try {
            time = this.exitAirlock(time, this.airlock);
            this.addExperience(time);
        }
        catch (Exception e) {
            this.endTask();
        }
        if (this.exitedAirlock) {
            this.setPhase(TOGGLE_POWER_SOURCE);
            this.moveToFuelPowerSourceLocation();
        }
        return time;
    }

    public void moveToFuelPowerSourceLocation() {
        Point2D.Double newLocation = null;
        boolean goodLocation = false;
        for (int x = 0; x < 20 && !goodLocation; ++x) {
            Point2D.Double boundedLocalPoint = LocalAreaUtil.getRandomExteriorLocation(this.building, 1.0);
            newLocation = LocalAreaUtil.getLocalRelativeLocation(boundedLocalPoint.getX(), boundedLocalPoint.getY(), this.building);
            goodLocation = LocalAreaUtil.checkLocationCollision(newLocation.getX(), newLocation.getY(), this.person.getCoordinates());
        }
        this.person.setXLocation(newLocation.getX());
        this.person.setYLocation(newLocation.getY());
    }

    private double enterEVA(double time) {
        time = this.enterAirlock(time, this.airlock);
        this.addExperience(time);
        if (this.enteredAirlock) {
            this.endTask();
        }
        return time;
    }

    private double togglePowerSourcePhase(double time) {
        if (this.person.getPerformanceRating() == 0.0) {
            if (this.isEVA) {
                this.setPhase("Enter Airlock");
            } else {
                this.endTask();
            }
        }
        if (this.powerSource.isToggleON() == this.toggleOn) {
            if (this.isEVA) {
                this.setPhase("Enter Airlock");
            } else {
                this.endTask();
            }
        }
        if (this.isDone()) {
            return time;
        }
        double workTime = time;
        int mechanicSkill = this.getEffectiveSkillLevel();
        if (mechanicSkill == 0) {
            workTime /= 2.0;
        }
        if (mechanicSkill > 1) {
            workTime += workTime * (0.2 * (double)mechanicSkill);
        }
        this.powerSource.addToggleWorkTime(workTime);
        this.addExperience(time);
        if (this.powerSource.isToggleON() == this.toggleOn) {
            if (this.isEVA) {
                this.setPhase("Enter Airlock");
            } else {
                this.endTask();
            }
            Settlement settlement = this.building.getBuildingManager().getSettlement();
            String toggle = "off";
            if (this.toggleOn) {
                toggle = "on";
            }
            logger.info(this.person.getName() + " turning " + toggle + " " + this.powerSource.getType() + " at " + settlement.getName() + ": " + this.building.getName());
        }
        this.checkForAccident(time);
        return 0.0;
    }

    @Override
    protected void checkForAccident(double time) {
        if (this.isEVA) {
            super.checkForAccident(time);
        }
        double chance = 0.001;
        int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Mechanics");
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        if (RandomUtil.lessThanRandPercent((chance *= this.building.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            this.building.getMalfunctionManager().accident();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.airlock = null;
        this.powerSource = null;
        this.building = null;
    }
}

