/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.person.NaturalAttributeManager;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.task.EVAOperation;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.ResourceProcess;
import org.mars_sim.msp.core.structure.building.function.ResourceProcessing;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.time.MarsClock;

public class ToggleResourceProcess
extends EVAOperation
implements Serializable {
    private static final String TOGGLE_PROCESS = "toggle process";
    private boolean isEVA;
    private Airlock airlock;
    private ResourceProcess process;
    private Building building;
    private boolean toggleOn;

    public ToggleResourceProcess(Person person) {
        super("Turning on resource process", person);
        this.building = ToggleResourceProcess.getResourceProcessingBuilding(person);
        if (this.building != null) {
            this.process = ToggleResourceProcess.getResourceProcess(this.building);
            boolean bl = this.toggleOn = !this.process.isProcessRunning();
            if (!this.toggleOn) {
                this.setName("Turning off resource process");
                this.setDescription("Turning off resource process");
            }
            boolean bl2 = this.isEVA = !this.building.hasFunction("Life Support");
            if (!this.isEVA) {
                BuildingManager.addPersonToBuilding(person, this.building);
            }
        } else {
            this.endTask();
        }
        if (this.isEVA) {
            this.airlock = ToggleResourceProcess.getAvailableAirlock(person);
            if (this.airlock == null) {
                this.endTask();
            }
        }
        this.addPhase(TOGGLE_PROCESS);
        if (!this.isEVA) {
            this.setPhase(TOGGLE_PROCESS);
        }
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            boolean isEVA = false;
            Settlement settlement = person.getSettlement();
            if (!settlement.getResourceProcessOverride()) {
                try {
                    Building building = ToggleResourceProcess.getResourceProcessingBuilding(person);
                    if (building != null) {
                        ResourceProcess process = ToggleResourceProcess.getResourceProcess(building);
                        isEVA = !building.hasFunction("Life Support");
                        double diff = ToggleResourceProcess.getResourcesValueDiff(settlement, process);
                        double baseProb = diff * 10000.0;
                        if (baseProb > 100.0) {
                            baseProb = 100.0;
                        }
                        result += baseProb;
                        if (!isEVA) {
                            result *= Task.getCrowdingProbabilityModifier(person, building);
                            result *= Task.getRelationshipModifier(person, building);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            if (isEVA) {
                SurfaceFeatures surface;
                if (ToggleResourceProcess.getAvailableAirlock(person) == null) {
                    result = 0.0;
                }
                if ((surface = Simulation.instance().getMars().getSurfaceFeatures()).getSurfaceSunlight(person.getCoordinates()) == 0.0 && !surface.inDarkPolarRegion(person.getCoordinates())) {
                    result = 0.0;
                }
                if (person.getLocationSituation().equals("In Settlement") && settlement.getCurrentPopulationNum() > settlement.getPopulationCapacity()) {
                    result *= 2.0;
                }
            }
            result *= person.getPerformanceRating();
            Job job = person.getMind().getJob();
            if (job != null) {
                result *= job.getStartTaskProbabilityModifier(ToggleResourceProcess.class);
            }
        }
        return result;
    }

    private static Building getResourceProcessingBuilding(Person person) {
        Building result = null;
        Settlement settlement = person.getSettlement();
        if (settlement != null) {
            BuildingManager manager = settlement.getBuildingManager();
            double bestDiff = 0.0;
            for (Building building : manager.getBuildings("Resource Processing")) {
                double diff;
                ResourceProcess process = ToggleResourceProcess.getResourceProcess(building);
                if (process == null || !((diff = ToggleResourceProcess.getResourcesValueDiff(settlement, process)) > bestDiff)) continue;
                bestDiff = diff;
                result = building;
            }
        }
        return result;
    }

    private static ResourceProcess getResourceProcess(Building building) {
        ResourceProcess result = null;
        Settlement settlement = building.getBuildingManager().getSettlement();
        if (building.hasFunction("Resource Processing")) {
            double bestDiff = 0.0;
            ResourceProcessing processing = (ResourceProcessing)building.getFunction("Resource Processing");
            for (ResourceProcess process : processing.getProcesses()) {
                double diff = ToggleResourceProcess.getResourcesValueDiff(settlement, process);
                if (!(diff > bestDiff)) continue;
                bestDiff = diff;
                result = process;
            }
        }
        return result;
    }

    private static double getResourcesValueDiff(Settlement settlement, ResourceProcess process) {
        double inputValue = ToggleResourceProcess.getResourcesValue(settlement, process, true);
        double outputValue = ToggleResourceProcess.getResourcesValue(settlement, process, false);
        double diff = outputValue - inputValue;
        double hoursInMillisol = MarsClock.convertMillisolsToSeconds(1.0) / 60.0 / 60.0;
        double powerHrsRequiredPerMillisol = process.getPowerRequired() * hoursInMillisol;
        double powerValue = powerHrsRequiredPerMillisol * settlement.getPowerGrid().getPowerValue();
        diff -= powerValue;
        if (process.isProcessRunning()) {
            diff *= -1.0;
        }
        if (ToggleResourceProcess.isEmptyInputResourceInProcess(settlement, process)) {
            diff = process.isProcessRunning() ? 1.0 : 0.0;
        }
        return diff;
    }

    private static double getResourcesValue(Settlement settlement, ResourceProcess process, boolean input) {
        double result = 0.0;
        Iterator<AmountResource> i = null;
        i = input ? process.getInputResources().iterator() : process.getOutputResources().iterator();
        while (i.hasNext()) {
            AmountResource resource = i.next();
            boolean useResource = true;
            if (input && process.isAmbientInputResource(resource)) {
                useResource = false;
            }
            if (!input && process.isWasteOutputResource(resource)) {
                useResource = false;
            }
            if (!useResource) continue;
            double value = settlement.getGoodsManager().getGoodValuePerItem(GoodsUtil.getResourceGood(resource));
            double rate = 0.0;
            rate = input ? process.getMaxInputResourceRate(resource) : process.getMaxOutputResourceRate(resource);
            result += value * rate;
        }
        return result;
    }

    private static boolean isEmptyInputResourceInProcess(Settlement settlement, ResourceProcess process) {
        boolean result = false;
        for (AmountResource resource : process.getInputResources()) {
            double stored;
            if (process.isAmbientInputResource(resource) || (stored = settlement.getInventory().getAmountResourceStored(resource, false)) != 0.0) continue;
            result = true;
        }
        return result;
    }

    @Override
    protected void addExperience(double time) {
        NaturalAttributeManager nManager = this.person.getNaturalAttributeManager();
        int experienceAptitude = nManager.getAttribute("Experience Aptitude");
        double experienceAptitudeModifier = ((double)experienceAptitude - 50.0) / 100.0;
        if (this.isEVA) {
            double evaExperience = time / 100.0;
            evaExperience += evaExperience * experienceAptitudeModifier;
            this.person.getMind().getSkillManager().addExperience("EVA Operations", evaExperience *= this.getTeachingExperienceModifier());
        }
        if (TOGGLE_PROCESS.equals(this.getPhase())) {
            double mechanicsExperience = time / 100.0;
            mechanicsExperience += mechanicsExperience * experienceAptitudeModifier;
            this.person.getMind().getSkillManager().addExperience("Mechanics", mechanicsExperience);
        }
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> result = new ArrayList<String>(2);
        result.add("Mechanics");
        if (this.isEVA) {
            result.add("EVA Operations");
        }
        return result;
    }

    @Override
    public int getEffectiveSkillLevel() {
        SkillManager manager = this.person.getMind().getSkillManager();
        int EVAOperationsSkill = manager.getEffectiveSkillLevel("EVA Operations");
        int mechanicsSkill = manager.getEffectiveSkillLevel("Mechanics");
        if (this.isEVA) {
            return (int)Math.round((double)(EVAOperationsSkill + mechanicsSkill) / 2.0);
        }
        return mechanicsSkill;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (this.isEVA) {
            if ("Exit Airlock".equals(this.getPhase())) {
                return this.exitEVA(time);
            }
            if (TOGGLE_PROCESS.equals(this.getPhase())) {
                return this.toggleProcessPhase(time);
            }
            if ("Enter Airlock".equals(this.getPhase())) {
                return this.enterEVA(time);
            }
            return time;
        }
        if (TOGGLE_PROCESS.equals(this.getPhase())) {
            return this.toggleProcessPhase(time);
        }
        return time;
    }

    private double exitEVA(double time) {
        try {
            time = this.exitAirlock(time, this.airlock);
            this.addExperience(time);
        }
        catch (Exception e) {
            this.endTask();
        }
        if (this.exitedAirlock) {
            this.setPhase(TOGGLE_PROCESS);
            this.moveToResourceProcessLocation();
        }
        return time;
    }

    public void moveToResourceProcessLocation() {
        Point2D.Double newLocation = null;
        boolean goodLocation = false;
        for (int x = 0; x < 20 && !goodLocation; ++x) {
            Point2D.Double boundedLocalPoint = LocalAreaUtil.getRandomExteriorLocation(this.building, 1.0);
            newLocation = LocalAreaUtil.getLocalRelativeLocation(boundedLocalPoint.getX(), boundedLocalPoint.getY(), this.building);
            goodLocation = LocalAreaUtil.checkLocationCollision(newLocation.getX(), newLocation.getY(), this.person.getCoordinates());
        }
        this.person.setXLocation(newLocation.getX());
        this.person.setYLocation(newLocation.getY());
    }

    private double enterEVA(double time) {
        time = this.enterAirlock(time, this.airlock);
        this.addExperience(time);
        if (this.enteredAirlock) {
            this.endTask();
        }
        return time;
    }

    private double toggleProcessPhase(double time) {
        if (this.person.getPerformanceRating() == 0.0) {
            if (this.isEVA) {
                this.setPhase("Enter Airlock");
            } else {
                this.endTask();
            }
        }
        if (this.process.isProcessRunning() == this.toggleOn) {
            if (this.isEVA) {
                this.setPhase("Enter Airlock");
            } else {
                this.endTask();
            }
        }
        if (this.isDone()) {
            return time;
        }
        double workTime = time;
        int mechanicSkill = this.getEffectiveSkillLevel();
        if (mechanicSkill == 0) {
            workTime /= 2.0;
        }
        if (mechanicSkill > 1) {
            workTime += workTime * (0.2 * (double)mechanicSkill);
        }
        this.process.addToggleWorkTime(workTime);
        this.addExperience(time);
        if (this.process.isProcessRunning() == this.toggleOn) {
            if (this.isEVA) {
                this.setPhase("Enter Airlock");
            } else {
                this.endTask();
            }
        }
        this.checkForAccident(time);
        return 0.0;
    }

    @Override
    protected void checkForAccident(double time) {
        if (this.isEVA) {
            super.checkForAccident(time);
        }
        double chance = 0.001;
        int skill = this.person.getMind().getSkillManager().getEffectiveSkillLevel("Mechanics");
        chance = skill <= 3 ? (chance *= (double)(4 - skill)) : (chance /= (double)(skill - 2));
        if (RandomUtil.lessThanRandPercent((chance *= this.building.getMalfunctionManager().getWearConditionAccidentModifier()) * time)) {
            this.building.getMalfunctionManager().accident();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.airlock = null;
        this.process = null;
        this.building = null;
    }
}

