/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.ai.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.vehicle.Towing;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class UnloadVehicleGarage
extends Task
implements Serializable {
    private static Logger logger = Logger.getLogger(UnloadVehicleGarage.class.getName());
    private static final String UNLOADING = "Unloading";
    private static double UNLOAD_RATE = 20.0;
    private static final double STRESS_MODIFIER = 0.1;
    private static final double DURATION = 100.0;
    private Vehicle vehicle;
    private Settlement settlement;

    public UnloadVehicleGarage(Person person) {
        super("Unloading vehicle", person, true, false, 0.1, true, 100.0);
        this.settlement = person.getSettlement();
        VehicleMission mission = this.getMissionNeedingUnloading();
        if (mission != null) {
            this.vehicle = mission.getVehicle();
        } else {
            List<Vehicle> nonMissionVehicles = UnloadVehicleGarage.getNonMissionVehiclesNeedingUnloading(this.settlement);
            if (nonMissionVehicles.size() > 0) {
                this.vehicle = nonMissionVehicles.get(RandomUtil.getRandomInt(nonMissionVehicles.size() - 1));
            }
        }
        if (this.vehicle != null) {
            this.setDescription("Unloading " + this.vehicle.getName());
            Building garageBuilding = BuildingManager.getBuilding(this.vehicle);
            if (garageBuilding != null) {
                BuildingManager.addPersonToBuilding(person, garageBuilding);
            }
            if (this.vehicle == null || garageBuilding == null) {
                this.endTask();
            }
            this.addPhase(UNLOADING);
            this.setPhase(UNLOADING);
        } else {
            this.endTask();
        }
    }

    public UnloadVehicleGarage(Person person, Vehicle vehicle) {
        super("Unloading vehicle", person, true, false, 0.1, true, 100.0);
        this.setDescription("Unloading " + vehicle.getName());
        this.vehicle = vehicle;
        this.settlement = person.getSettlement();
        Building garage = BuildingManager.getBuilding(vehicle);
        if (garage != null) {
            BuildingManager.addPersonToBuilding(person, garage);
        }
        this.addPhase(UNLOADING);
        this.setPhase(UNLOADING);
    }

    public static double getProbability(Person person) {
        double result = 0.0;
        if (person.getLocationSituation().equals("In Settlement")) {
            try {
                int numVehicles = 0;
                numVehicles += UnloadVehicleGarage.getAllMissionsNeedingUnloading(person.getSettlement()).size();
                result = 50.0 * (double)(numVehicles += UnloadVehicleGarage.getNonMissionVehiclesNeedingUnloading(person.getSettlement()).size());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error finding unloading missions. " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
        result *= person.getPerformanceRating();
        Job job = person.getMind().getJob();
        if (job != null) {
            result *= job.getStartTaskProbabilityModifier(UnloadVehicleGarage.class);
        }
        return result;
    }

    private static List<Vehicle> getNonMissionVehiclesNeedingUnloading(Settlement settlement) {
        ArrayList<Vehicle> result = new ArrayList<Vehicle>();
        if (settlement != null) {
            for (Vehicle vehicle : settlement.getParkedVehicles()) {
                boolean needsUnloading = false;
                if (!vehicle.isReserved() && BuildingManager.getBuilding(vehicle) != null) {
                    if (vehicle.getInventory().getTotalInventoryMass(false) > 0.0) {
                        needsUnloading = true;
                    }
                    if (vehicle instanceof Towing && ((Towing)((Object)vehicle)).getTowedVehicle() != null) {
                        needsUnloading = true;
                    }
                }
                if (!needsUnloading) continue;
                result.add(vehicle);
            }
        }
        return result;
    }

    private static List<Mission> getAllMissionsNeedingUnloading(Settlement settlement) {
        ArrayList<Mission> result = new ArrayList<Mission>();
        MissionManager manager = Simulation.instance().getMissionManager();
        for (Mission mission : manager.getMissions()) {
            Vehicle vehicle;
            VehicleMission vehicleMission;
            if (!(mission instanceof VehicleMission) || !"Disembarking".equals(mission.getPhase()) || !(vehicleMission = (VehicleMission)mission).hasVehicle() || settlement != (vehicle = vehicleMission.getVehicle()).getSettlement() || UnloadVehicleGarage.isFullyUnloaded(vehicle) || BuildingManager.getBuilding(vehicle) == null) continue;
            result.add(vehicleMission);
        }
        return result;
    }

    private VehicleMission getMissionNeedingUnloading() {
        VehicleMission result = null;
        List<Mission> unloadingMissions = UnloadVehicleGarage.getAllMissionsNeedingUnloading(this.person.getSettlement());
        if (unloadingMissions.size() > 0) {
            int index = RandomUtil.getRandomInt(unloadingMissions.size() - 1);
            result = (VehicleMission)unloadingMissions.get(index);
        }
        return result;
    }

    public Vehicle getVehicle() {
        return this.vehicle;
    }

    @Override
    protected double performMappedPhase(double time) {
        if (this.getPhase() == null) {
            throw new IllegalArgumentException("Task phase is null");
        }
        if (UNLOADING.equals(this.getPhase())) {
            return this.unloadingPhase(time);
        }
        return time;
    }

    protected double unloadingPhase(double time) {
        Towing towingVehicle;
        Vehicle towedVehicle;
        double amountUnloading;
        int strength = this.person.getNaturalAttributeManager().getAttribute("Strength");
        double strengthModifier = 0.1 + (double)strength * 0.018;
        Inventory vehicleInv = this.vehicle.getInventory();
        if (this.settlement == null) {
            this.endTask();
            return 0.0;
        }
        Inventory settlementInv = this.settlement.getInventory();
        if (amountUnloading > 0.0) {
            Equipment equipment;
            Iterator<Unit> k = vehicleInv.findAllUnitsOfClass(Equipment.class).iterator();
            for (amountUnloading = UNLOAD_RATE * strengthModifier * time; k.hasNext() && amountUnloading > 0.0; amountUnloading -= equipment.getMass()) {
                equipment = (Equipment)k.next();
                this.unloadEquipmentInventory(equipment);
                vehicleInv.retrieveUnit(equipment);
                settlementInv.storeUnit(equipment);
            }
        }
        Iterator<AmountResource> i = vehicleInv.getAllAmountResourcesStored(false).iterator();
        while (i.hasNext() && amountUnloading > 0.0) {
            double capacity;
            AmountResource resource = i.next();
            double amount = vehicleInv.getAmountResourceStored(resource, false);
            if (amount > amountUnloading) {
                amount = amountUnloading;
            }
            if ((capacity = settlementInv.getAmountResourceRemainingCapacity(resource, true, false)) < amount) {
                amount = capacity;
                amountUnloading = 0.0;
            }
            try {
                vehicleInv.retrieveAmountResource(resource, amount);
                settlementInv.storeAmountResource(resource, amount, true);
            }
            catch (Exception e) {
                // empty catch block
            }
            amountUnloading -= amount;
        }
        if (amountUnloading > 0.0) {
            Iterator<ItemResource> j = vehicleInv.getAllItemResourcesStored().iterator();
            while (j.hasNext() && amountUnloading > 0.0) {
                ItemResource resource = j.next();
                int num = vehicleInv.getItemResourceNum(resource);
                if ((double)num * resource.getMassPerItem() > amountUnloading && (num = (int)Math.round(amountUnloading / resource.getMassPerItem())) == 0) {
                    num = 1;
                }
                vehicleInv.retrieveItemResources(resource, num);
                settlementInv.storeItemResources(resource, num);
                amountUnloading -= (double)num * resource.getMassPerItem();
            }
        }
        if (this.vehicle instanceof Towing && (towedVehicle = (towingVehicle = (Towing)((Object)this.vehicle)).getTowedVehicle()) != null) {
            towingVehicle.setTowedVehicle(null);
            towedVehicle.setTowingVehicle(null);
            if (!settlementInv.containsUnit(towedVehicle)) {
                settlementInv.storeUnit(towedVehicle);
                towedVehicle.determinedSettlementParkedLocationAndFacing();
            }
        }
        if (UnloadVehicleGarage.isFullyUnloaded(this.vehicle)) {
            this.endTask();
        }
        return 0.0;
    }

    private void unloadEquipmentInventory(Equipment equipment) {
        Inventory eInv = equipment.getInventory();
        Inventory sInv = this.settlement.getInventory();
        for (AmountResource resource : eInv.getAllAmountResourcesStored(false)) {
            double capacity;
            double amount = eInv.getAmountResourceStored(resource, false);
            if (amount < (capacity = sInv.getAmountResourceRemainingCapacity(resource, true, false))) {
                amount = capacity;
            }
            try {
                eInv.retrieveAmountResource(resource, amount);
                sInv.storeAmountResource(resource, amount, true);
            }
            catch (Exception e) {}
        }
    }

    @Override
    protected void addExperience(double time) {
    }

    public static boolean isFullyUnloaded(Vehicle vehicle) {
        return vehicle.getInventory().getTotalInventoryMass(false) == 0.0;
    }

    @Override
    public int getEffectiveSkillLevel() {
        return 0;
    }

    @Override
    public List<String> getAssociatedSkills() {
        ArrayList<String> results = new ArrayList<String>(0);
        return results;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.vehicle = null;
        this.settlement = null;
    }
}

