/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.medical;

import java.io.Serializable;
import java.util.Iterator;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.malfunction.MalfunctionFactory;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.Mind;
import org.mars_sim.msp.core.person.ai.task.TaskManager;
import org.mars_sim.msp.core.person.medical.Complaint;

public class DeathInfo
implements Serializable {
    private String timeOfDeath = Simulation.instance().getMasterClock().getMarsClock().getTimeStamp();
    private String illness;
    private String placeOfDeath;
    private Unit containerUnit;
    private Coordinates locationOfDeath;
    private String job;
    private String mission;
    private String missionPhase;
    private String task;
    private String taskPhase;
    private String malfunction;

    public DeathInfo(Person person) {
        TaskManager taskMgr;
        Complaint serious = person.getPhysicalCondition().getMostSerious();
        if (serious != null) {
            this.illness = serious.getName();
        }
        if (person.getLocationSituation().equals("Outside")) {
            this.placeOfDeath = "Outside";
        } else {
            this.containerUnit = person.getContainerUnit();
            this.placeOfDeath = this.containerUnit.getName();
        }
        this.locationOfDeath = person.getCoordinates();
        Mind mind = person.getMind();
        this.job = "";
        if (mind.getJob() != null) {
            this.job = mind.getJob().getName();
        }
        if (mind.getMission() != null) {
            this.mission = mind.getMission().getName();
            this.missionPhase = mind.getMission().getPhaseDescription();
        }
        if ((taskMgr = mind.getTaskManager()).hasTask()) {
            this.task = taskMgr.getTaskName();
            this.taskPhase = taskMgr.getPhase();
        }
        Iterator<Malfunctionable> i = MalfunctionFactory.getMalfunctionables(person).iterator();
        Malfunction mostSerious = null;
        int severity = 0;
        while (i.hasNext()) {
            Malfunction m;
            Malfunctionable entity = i.next();
            MalfunctionManager malfunctionMgr = entity.getMalfunctionManager();
            if (!malfunctionMgr.hasEmergencyMalfunction() || (m = malfunctionMgr.getMostSeriousEmergencyMalfunction()).getSeverity() <= severity) continue;
            mostSerious = m;
            severity = m.getSeverity();
        }
        if (mostSerious != null) {
            this.malfunction = mostSerious.getName();
        }
    }

    public String getTimeOfDeath() {
        if (this.timeOfDeath != null) {
            return this.timeOfDeath;
        }
        return "";
    }

    public String getPlaceOfDeath() {
        if (this.placeOfDeath != null) {
            return this.placeOfDeath;
        }
        return "";
    }

    public Unit getContainerUnit() {
        return this.containerUnit;
    }

    public String getIllness() {
        if (this.illness != null) {
            return this.illness;
        }
        return "";
    }

    public Coordinates getLocationOfDeath() {
        return this.locationOfDeath;
    }

    public String getJob() {
        if (this.job != null) {
            return this.job;
        }
        return "";
    }

    public String getMission() {
        if (this.mission != null) {
            return this.mission;
        }
        return "";
    }

    public String getMissionPhase() {
        if (this.missionPhase != null) {
            return this.missionPhase;
        }
        return "";
    }

    public String getTask() {
        if (this.task != null) {
            return this.task;
        }
        return "";
    }

    public String getTaskPhase() {
        if (this.taskPhase != null) {
            return this.taskPhase;
        }
        return "";
    }

    public String getMalfunction() {
        if (this.malfunction != null) {
            return this.malfunction;
        }
        return "";
    }
}

