/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.medical;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.medical.Complaint;
import org.mars_sim.msp.core.person.medical.MedicalAid;
import org.mars_sim.msp.core.person.medical.MedicalEvent;
import org.mars_sim.msp.core.person.medical.Treatment;

public class HealthProblem
implements Serializable {
    private static String CLASS_NAME = "org.mars_sim.msp.simulation.person.medical.HealthProblem";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private static final int DEGRADING = 0;
    private static final int TREATMENT = 1;
    private static final int RECOVERING = 2;
    private static final int CURED = 3;
    private static final int DEAD = 4;
    private Complaint illness;
    private Person sufferer;
    private int state;
    private double timePassed;
    private double duration;
    private MedicalAid usedAid;

    public HealthProblem(Complaint complaint, Person person, MedicalAid aid) {
        this.illness = complaint;
        this.sufferer = person;
        this.timePassed = 0.0;
        this.setState(0);
        this.duration = this.illness.getDegradePeriod();
        this.usedAid = null;
        Treatment treatment = this.illness.getRecoveryTreatment();
        MedicalEvent newEvent = new MedicalEvent(this.sufferer, this, "Illness Starts");
        Simulation.instance().getEventManager().registerNewEvent(newEvent);
        if (this.duration == 0.0 && treatment == null) {
            this.startRecovery();
        } else if (this.state == 0 && aid != null && aid.canTreatProblem(this)) {
            this.usedAid = aid;
            try {
                this.usedAid.requestTreatment(this);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "HeathProblem: " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
    }

    private void setState(int newState) {
        this.state = newState;
        this.sufferer.fireUnitUpdate("illness event", this.illness);
    }

    private int getState() {
        return this.state;
    }

    public boolean getDegrading() {
        return this.state == 0;
    }

    public boolean getCured() {
        return this.state == 3;
    }

    public int getHealthRating() {
        if (this.duration > 0.0) {
            return (int)(this.timePassed * 100.0 / this.duration);
        }
        return 100;
    }

    public Complaint getIllness() {
        return this.illness;
    }

    public Person getSufferer() {
        return this.sufferer;
    }

    public double getPerformanceFactor() {
        if (this.usedAid != null) {
            return 0.0;
        }
        return this.illness.getPerformanceFactor();
    }

    public boolean getRecovering() {
        return this.state == 2;
    }

    public boolean getAwaitingTreatment() {
        return this.state == 0 && this.usedAid != null;
    }

    public String getSituation() {
        return this.toString();
    }

    public String getStateString() {
        switch (this.state) {
            case 0: {
                return "degrading";
            }
            case 1: {
                return "treatment";
            }
            case 2: {
                return "recovering";
            }
            case 3: {
                return "cured";
            }
            case 4: {
                return "dead";
            }
        }
        return "";
    }

    public void startTreatment(double treatmentLength) {
        this.duration = treatmentLength;
        this.timePassed = 0.0;
        this.setState(1);
        MedicalEvent treatedEvent = new MedicalEvent(this.sufferer, this, "Illness Treated");
        Simulation.instance().getEventManager().registerNewEvent(treatedEvent);
    }

    public void stopTreatment() {
        if (this.state == 1) {
            if (this.duration > this.timePassed) {
                this.startDegrading();
            } else {
                this.startRecovery();
            }
        }
    }

    private void startDegrading() {
        this.setState(0);
        MedicalEvent degradingEvent = new MedicalEvent(this.sufferer, this, "Illness Degrades");
        Simulation.instance().getEventManager().registerNewEvent(degradingEvent);
    }

    public void startRecovery() {
        if (this.state == 0 || this.state == 1) {
            this.duration = this.illness.getRecoveryPeriod();
            this.timePassed = 0.0;
            if (this.duration != 0.0) {
                this.setState(2);
                if (this.usedAid != null && !this.illness.getRecoveryTreatment().getRetainAid()) {
                    try {
                        this.usedAid.stopTreatment(this);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.usedAid = null;
                }
                MedicalEvent recoveringEvent = new MedicalEvent(this.sufferer, this, "Illness Recovering");
                Simulation.instance().getEventManager().registerNewEvent(recoveringEvent);
            } else {
                this.setCured();
            }
        }
    }

    private void setCured() {
        this.setState(3);
        MedicalEvent curedEvent = new MedicalEvent(this.sufferer, this, "Illness Cured");
        Simulation.instance().getEventManager().registerNewEvent(curedEvent);
    }

    public Complaint timePassing(double time, PhysicalCondition condition) {
        Complaint result = null;
        this.timePassed += time;
        if (this.timePassed > this.duration) {
            if (this.state == 2) {
                this.setCured();
                if (this.usedAid != null) {
                    try {
                        this.usedAid.stopTreatment(this);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.usedAid = null;
                }
            } else if (this.state == 0) {
                if (this.duration != 0.0) {
                    Complaint nextPhase = this.illness.getNextPhase();
                    if (this.usedAid != null) {
                        try {
                            this.usedAid.stopTreatment(this);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.usedAid = null;
                    }
                    if (nextPhase == null) {
                        this.setState(4);
                        condition.setDead(this);
                    } else {
                        result = nextPhase;
                    }
                }
            } else if (this.state == 1) {
                this.startRecovery();
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.state == 2) {
            buffer.append("Recovering ");
            buffer.append(this.illness.getName());
        } else if (this.state == 1) {
            buffer.append("Treatment (");
            buffer.append(this.illness.getRecoveryTreatment().getName());
            buffer.append(") ");
            buffer.append(this.illness.getName());
        } else {
            buffer.append(this.illness.getName());
        }
        buffer.append(' ');
        buffer.append(this.getHealthRating());
        buffer.append('%');
        return buffer.toString();
    }

    public boolean isEnvironmentalProblem() {
        return Simulation.instance().getMedicalManager().isEnvironmentalComplaint(this.illness);
    }
}

