/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.medical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.mars_sim.msp.core.person.medical.Complaint;
import org.mars_sim.msp.core.person.medical.Treatment;

public class MedicalConfig
implements Serializable {
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String MEDICAL_COMPLAINT_LIST = "medical-complaint-list";
    private static final String MEDICAL_COMPLAINT = "medical-complaint";
    private static final String SERIOUSNESS = "seriousness";
    private static final String DEGRADE_TIME = "degrade-time";
    private static final String RECOVERY_TIME = "recovery-time";
    private static final String PROBABILITY = "probability";
    private static final String PERFORMANCE_PERCENT = "performance-percent";
    private static final String TREATMENT_TYPE = "treatment-type";
    private static final String DEGRADE_COMPLAINT = "degrade-complaint";
    private static final String TREATMENT_LIST = "treatment-list";
    private static final String TREATMENT = "treatment";
    private static final String SKILL = "skill";
    private static final String MEDICAL_TECH_LEVEL = "medical-tech-level";
    private static final String TREATMENT_TIME = "treatment-time";
    private static final String RETAINAID = "retainaid";
    private Document medicalDoc;
    private List<Complaint> complaintList;
    private List<Treatment> treatmentList;

    public MedicalConfig(Document medicalDoc) {
        this.medicalDoc = medicalDoc;
    }

    public List<Complaint> getComplaintList() {
        if (this.complaintList == null) {
            this.complaintList = new ArrayList<Complaint>();
            Element root = this.medicalDoc.getRootElement();
            Element medicalComplaintList = root.getChild(MEDICAL_COMPLAINT_LIST);
            List medicalComplaints = medicalComplaintList.getChildren(MEDICAL_COMPLAINT);
            for (Element medicalComplaint : medicalComplaints) {
                String complaintName = "";
                complaintName = medicalComplaint.getAttributeValue(NAME);
                Element seriousnessElement = medicalComplaint.getChild(SERIOUSNESS);
                int seriousness = Integer.parseInt(seriousnessElement.getAttributeValue(VALUE));
                double degradeTime = 0.0;
                Element degradeTimeElement = medicalComplaint.getChild(DEGRADE_TIME);
                if (degradeTimeElement != null) {
                    degradeTime = Double.parseDouble(degradeTimeElement.getAttributeValue(VALUE));
                }
                Element recoveryTimeElement = medicalComplaint.getChild(RECOVERY_TIME);
                double recoveryTime = Double.parseDouble(recoveryTimeElement.getAttributeValue(VALUE));
                Element probabilityElement = medicalComplaint.getChild(PROBABILITY);
                double probability = Double.parseDouble(probabilityElement.getAttributeValue(VALUE));
                Element performanceElement = medicalComplaint.getChild(PERFORMANCE_PERCENT);
                double performance = Double.parseDouble(performanceElement.getAttributeValue(VALUE));
                String treatmentStr = "";
                Element treatmentElement = medicalComplaint.getChild(TREATMENT_TYPE);
                if (treatmentElement != null) {
                    treatmentStr = treatmentElement.getAttributeValue(VALUE);
                }
                Treatment treatment = null;
                List<Treatment> treatmentList = this.getTreatmentList();
                for (Treatment tempTreatment : treatmentList) {
                    if (!tempTreatment.getName().equals(treatmentStr)) continue;
                    treatment = tempTreatment;
                    break;
                }
                if (treatmentStr.length() != 0 && treatment == null) {
                    throw new IllegalStateException("treatment: " + treatmentStr + " could not be found in treatment list");
                }
                String degradeComplaint = "";
                Element degradeComplaintElement = medicalComplaint.getChild(DEGRADE_COMPLAINT);
                if (degradeComplaintElement != null) {
                    degradeComplaint = degradeComplaintElement.getAttributeValue(VALUE);
                }
                Complaint complaint = new Complaint(complaintName, seriousness, degradeTime * 1000.0, recoveryTime * 1000.0, probability, treatment, degradeComplaint, performance);
                this.complaintList.add(complaint);
            }
            for (Complaint complaint : this.complaintList) {
                String degradeComplaintName = complaint.getNextPhaseStr();
                if (degradeComplaintName.length() == 0) continue;
                for (Complaint degradeComplaint : this.complaintList) {
                    if (!degradeComplaint.getName().equals(degradeComplaintName)) continue;
                    complaint.setNextComplaint(degradeComplaint);
                }
                if (complaint.getNextPhase() != null) continue;
                throw new IllegalStateException("Degrade complaint " + degradeComplaintName + " can not be found in medical complaint list.");
            }
        }
        return this.complaintList;
    }

    public List<Treatment> getTreatmentList() {
        if (this.treatmentList == null) {
            this.treatmentList = new ArrayList<Treatment>();
            Element root = this.medicalDoc.getRootElement();
            Element medicalTreatmentList = root.getChild(TREATMENT_LIST);
            List treatments = medicalTreatmentList.getChildren(TREATMENT);
            for (Element medicalTreatment : treatments) {
                String treatmentName = medicalTreatment.getAttributeValue(NAME);
                int skill = 0;
                Element skillElement = medicalTreatment.getChild(SKILL);
                if (skillElement != null) {
                    skill = Integer.parseInt(skillElement.getAttributeValue(VALUE));
                }
                int medicalTechLevel = 0;
                Element medicalTechLevelElement = medicalTreatment.getChild(MEDICAL_TECH_LEVEL);
                if (medicalTechLevelElement != null) {
                    medicalTechLevel = Integer.parseInt(medicalTechLevelElement.getAttributeValue(VALUE));
                }
                double treatmentTime = -1.0;
                Element treatmentTimeElement = medicalTreatment.getChild(TREATMENT_TIME);
                if (treatmentTimeElement != null) {
                    treatmentTime = Double.parseDouble(treatmentTimeElement.getAttributeValue(VALUE));
                }
                boolean retainaid = false;
                Element retainaidElement = medicalTreatment.getChild(RETAINAID);
                if (retainaidElement != null) {
                    String retainaidStr = retainaidElement.getAttributeValue(VALUE);
                    retainaid = retainaidStr.toLowerCase().equals("true");
                }
                Treatment treatment = new Treatment(treatmentName, skill, treatmentTime, false, retainaid, medicalTechLevel);
                this.treatmentList.add(treatment);
            }
        }
        return this.treatmentList;
    }

    public void destroy() {
        this.medicalDoc = null;
        if (this.complaintList != null) {
            this.complaintList.clear();
            this.complaintList = null;
        }
        if (this.treatmentList != null) {
            this.treatmentList.clear();
            this.treatmentList = null;
        }
    }
}

