/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.medical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.medical.HealthProblem;
import org.mars_sim.msp.core.person.medical.MedicalAid;
import org.mars_sim.msp.core.person.medical.MedicalManager;
import org.mars_sim.msp.core.person.medical.Treatment;

public class MedicalStation
implements MedicalAid,
Serializable {
    private int level;
    private int sickBeds;
    private List<HealthProblem> problemsBeingTreated;
    private List<HealthProblem> problemsAwaitingTreatment;
    private List<Treatment> supportedTreatments;

    public MedicalStation(int level, int sickBeds) {
        this.level = level;
        this.sickBeds = sickBeds;
        this.problemsBeingTreated = new ArrayList<HealthProblem>();
        this.problemsAwaitingTreatment = new ArrayList<HealthProblem>();
        MedicalManager medManager = Simulation.instance().getMedicalManager();
        this.supportedTreatments = medManager.getSupportedTreatments(level);
    }

    @Override
    public List<HealthProblem> getProblemsAwaitingTreatment() {
        return new ArrayList<HealthProblem>(this.problemsAwaitingTreatment);
    }

    @Override
    public List<HealthProblem> getProblemsBeingTreated() {
        return new ArrayList<HealthProblem>(this.problemsBeingTreated);
    }

    public int getSickBedNum() {
        return this.sickBeds;
    }

    public int getPatientNum() {
        return this.getPatients().size();
    }

    public Collection<Person> getPatients() {
        ConcurrentLinkedQueue<Person> result = new ConcurrentLinkedQueue<Person>();
        Iterator<HealthProblem> i = this.problemsBeingTreated.iterator();
        while (i.hasNext()) {
            Person patient = i.next().getSufferer();
            if (result.contains(patient)) continue;
            result.add(patient);
        }
        return result;
    }

    @Override
    public List<Treatment> getSupportedTreatments() {
        return new ArrayList<Treatment>(this.supportedTreatments);
    }

    @Override
    public boolean canTreatProblem(HealthProblem problem) {
        if (problem == null) {
            return false;
        }
        boolean degrading = problem.getDegrading();
        Treatment requiredTreatment = problem.getIllness().getRecoveryTreatment();
        boolean supported = this.supportedTreatments.contains(requiredTreatment);
        boolean treating = this.problemsBeingTreated.contains(problem);
        boolean waiting = this.problemsAwaitingTreatment.contains(problem);
        return supported && degrading && !treating && !waiting;
    }

    @Override
    public void requestTreatment(HealthProblem problem) {
        if (problem == null) {
            throw new IllegalArgumentException("problem is null");
        }
        if (this.canTreatProblem(problem)) {
            Treatment treatment = problem.getIllness().getRecoveryTreatment();
            if (treatment.getSelfAdminister() && this.getPatientNum() < this.sickBeds) {
                problem.startTreatment(treatment.getDuration());
                this.problemsBeingTreated.add(problem);
            } else {
                this.problemsAwaitingTreatment.add(problem);
            }
        } else {
            throw new IllegalStateException("Health problem cannot be treated at this facility.");
        }
    }

    @Override
    public void startTreatment(HealthProblem problem, double treatmentDuration) {
        if (problem == null) {
            throw new IllegalArgumentException("problem is null");
        }
        if (!this.problemsAwaitingTreatment.contains(problem)) {
            throw new IllegalStateException("Health problem not in medical station's waiting queue.");
        }
        problem.startTreatment(treatmentDuration);
        this.problemsBeingTreated.add(problem);
        this.problemsAwaitingTreatment.remove(problem);
    }

    @Override
    public void stopTreatment(HealthProblem problem) {
        if (this.problemsBeingTreated.contains(problem)) {
            problem.stopTreatment();
            this.problemsBeingTreated.remove(problem);
            boolean cured = problem.getCured();
            boolean dead = problem.getSufferer().getPhysicalCondition().isDead();
            boolean recovering = problem.getRecovering();
            if (!(cured || dead || recovering)) {
                this.problemsAwaitingTreatment.add(problem);
            }
        } else {
            throw new IllegalStateException("Health problem not currently being treated.");
        }
    }

    public int getTreatmentLevel() {
        return this.level;
    }

    public void destroy() {
        this.problemsBeingTreated.clear();
        this.problemsBeingTreated = null;
        this.problemsAwaitingTreatment.clear();
        this.problemsAwaitingTreatment = null;
        this.supportedTreatments.clear();
        this.supportedTreatments = null;
    }
}

