/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.person.medical;

import java.io.Serializable;
import org.mars_sim.msp.core.person.Person;

public abstract class Medication
implements Serializable,
Comparable<Medication> {
    private String name;
    private double duration;
    private double timeElapsed;
    private Person person;

    public Medication(String name, double duration, Person person) {
        this.name = name;
        this.duration = duration;
        this.person = person;
        this.timeElapsed = 0.0;
    }

    public String getName() {
        return this.name;
    }

    public double getDuration() {
        return this.duration;
    }

    public Person getPerson() {
        return this.person;
    }

    public double getTimeElapsed() {
        return this.timeElapsed;
    }

    public void timePassing(double time) {
        this.timeElapsed += time;
    }

    public boolean isMedicated() {
        return this.timeElapsed < this.duration;
    }

    public boolean equals(Object object) {
        boolean result = true;
        if (object instanceof Medication) {
            Medication med = (Medication)object;
            if (!this.name.equals(med.name)) {
                result = false;
            }
            if (this.duration != med.duration) {
                result = false;
            }
            if (this.timeElapsed != med.timeElapsed) {
                result = false;
            }
            if (!this.person.equals(med.person)) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int hashCode = this.name.hashCode();
        hashCode *= new Double(this.duration).hashCode();
        hashCode *= new Double(this.timeElapsed).hashCode();
        return hashCode *= this.person.hashCode();
    }

    @Override
    public int compareTo(Medication o) {
        return this.name.compareTo(o.name);
    }
}

