/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.resource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Phase;

class AmountResourcePhaseStorage
implements Serializable {
    private static final double SMALL_AMOUNT_COMPARISON = 1.0E-7;
    private Map<Phase, Double> amountResourcePhaseCapacities = null;
    private Map<Phase, StoredPhase> amountResourcePhaseStored = null;
    private transient double totalStoredCache = 0.0;
    private transient boolean totalStoredCacheDirty = true;

    AmountResourcePhaseStorage() {
    }

    void addAmountResourcePhaseCapacity(Phase phase, double capacity) {
        if (capacity < 0.0) {
            throw new IllegalStateException("Cannot add negative phase capacity: " + capacity);
        }
        if (this.amountResourcePhaseCapacities == null) {
            this.amountResourcePhaseCapacities = new HashMap<Phase, Double>();
        }
        if (this.hasAmountResourcePhaseCapacity(phase)) {
            double current = this.amountResourcePhaseCapacities.get(phase);
            this.amountResourcePhaseCapacities.put(phase, current + capacity);
        } else {
            this.amountResourcePhaseCapacities.put(phase, capacity);
        }
    }

    boolean hasAmountResourcePhaseCapacity(Phase phase) {
        boolean result = false;
        if (this.amountResourcePhaseCapacities != null) {
            result = this.amountResourcePhaseCapacities.containsKey(phase);
        }
        return result;
    }

    double getAmountResourcePhaseCapacity(Phase phase) {
        double result = 0.0;
        if (this.hasAmountResourcePhaseCapacity(phase)) {
            result = this.amountResourcePhaseCapacities.get(phase);
        }
        return result;
    }

    double getAmountResourcePhaseStored(Phase phase) {
        double result = 0.0;
        StoredPhase stored = this.getAmountResourcePhaseStoredObject(phase);
        if (stored != null) {
            result = stored.amount;
        }
        return result;
    }

    private StoredPhase getAmountResourcePhaseStoredObject(Phase phase) {
        StoredPhase result = null;
        if (this.amountResourcePhaseStored != null) {
            result = this.amountResourcePhaseStored.get(phase);
        }
        return result;
    }

    double getTotalAmountResourcePhasesStored(boolean allowDirty) {
        if (this.totalStoredCacheDirty && !allowDirty) {
            this.updateTotalAmountResourcePhasesStored();
        }
        return this.totalStoredCache;
    }

    private void updateTotalAmountResourcePhasesStored() {
        double totalAmount = 0.0;
        if (this.amountResourcePhaseStored != null) {
            Map<Phase, StoredPhase> tempMap = Collections.unmodifiableMap(this.amountResourcePhaseStored);
            Iterator<Phase> i = tempMap.keySet().iterator();
            while (i.hasNext()) {
                totalAmount += tempMap.get(i.next()).amount;
            }
        }
        this.totalStoredCache = totalAmount;
        this.totalStoredCacheDirty = false;
    }

    double getAmountResourcePhaseRemainingCapacity(Phase phase) {
        double result = 0.0;
        if (this.hasAmountResourcePhaseCapacity(phase)) {
            result = this.getAmountResourcePhaseCapacity(phase) - this.getAmountResourcePhaseStored(phase);
        }
        return result;
    }

    AmountResource getAmountResourcePhaseType(Phase phase) {
        StoredPhase stored;
        AmountResource result = null;
        if (this.amountResourcePhaseStored != null && (stored = this.amountResourcePhaseStored.get(phase)) != null) {
            result = stored.resource;
        }
        return result;
    }

    void storeAmountResourcePhase(AmountResource resource, double amount) {
        if (amount < 0.0) {
            throw new IllegalStateException("Cannot store negative amount of phase: " + amount);
        }
        if (amount > 1.0E-7) {
            Phase resourcePhase = resource.getPhase();
            boolean storable = false;
            if (this.getAmountResourcePhaseRemainingCapacity(resourcePhase) >= amount && (this.getAmountResourcePhaseStored(resourcePhase) == 0.0 || resource.equals(this.getAmountResourcePhaseType(resourcePhase)))) {
                storable = true;
            }
            if (storable) {
                StoredPhase stored;
                this.totalStoredCacheDirty = true;
                if (this.amountResourcePhaseStored == null) {
                    this.amountResourcePhaseStored = new HashMap<Phase, StoredPhase>();
                }
                if ((stored = this.getAmountResourcePhaseStoredObject(resourcePhase)) != null) {
                    stored.amount += amount;
                } else {
                    this.amountResourcePhaseStored.put(resourcePhase, new StoredPhase(resource, amount));
                }
            } else {
                throw new IllegalStateException("Amount resource could not be added in phase storage.");
            }
        }
    }

    void retrieveAmountResourcePhase(Phase phase, double amount) {
        if (amount < 0.0) {
            throw new IllegalStateException("Cannot retrieve negative amount of phase: " + amount);
        }
        if (amount > 0.0) {
            StoredPhase stored;
            boolean retrievable = false;
            if (this.getAmountResourcePhaseStored(phase) >= amount && (stored = this.amountResourcePhaseStored.get(phase)) != null) {
                this.totalStoredCacheDirty = true;
                stored.amount -= amount;
                retrievable = true;
                if (stored.amount <= 1.0E-7) {
                    this.amountResourcePhaseStored.remove(phase);
                }
            }
            if (!retrievable) {
                throw new IllegalStateException("Amount resource (" + phase.getName() + ":" + amount + ") could not be retrieved from phase storage");
            }
        }
    }

    public void destroy() {
        if (this.amountResourcePhaseCapacities != null) {
            this.amountResourcePhaseCapacities.clear();
        }
        this.amountResourcePhaseCapacities = null;
        if (this.amountResourcePhaseStored != null) {
            this.amountResourcePhaseStored.clear();
        }
        this.amountResourcePhaseStored = null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.totalStoredCacheDirty = true;
    }

    private static class StoredPhase
    implements Serializable {
        private AmountResource resource;
        private double amount;

        private StoredPhase(AmountResource resource, double amount) {
            this.resource = resource;
            this.amount = amount;
        }
    }
}

