/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.resource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mars_sim.msp.core.resource.AmountResource;

class AmountResourceTypeStorage
implements Serializable {
    private Map<AmountResource, ResourceAmount> amountResourceTypeCapacities = null;
    private Map<AmountResource, ResourceAmount> amountResourceTypeStored = null;
    private transient double totalAmountCache = 0.0;
    private transient boolean totalAmountCacheDirty = true;

    AmountResourceTypeStorage() {
    }

    void addAmountResourceTypeCapacity(AmountResource resource, double capacity) {
        if (capacity < 0.0) {
            throw new IllegalStateException("Cannot add negative type capacity: " + capacity);
        }
        if (this.amountResourceTypeCapacities == null) {
            this.amountResourceTypeCapacities = new HashMap<AmountResource, ResourceAmount>();
        }
        if (this.hasAmountResourceTypeCapacity(resource)) {
            ResourceAmount existingCapacity = this.amountResourceTypeCapacities.get(resource);
            existingCapacity.setAmount(existingCapacity.getAmount() + capacity);
        } else {
            this.amountResourceTypeCapacities.put(resource, new ResourceAmount(capacity));
        }
    }

    void removeAmountResourceTypeCapacity(AmountResource resource, double capacity) {
        double existingCapacity;
        double newCapacity;
        if (capacity < 0.0) {
            throw new IllegalStateException("Cannot remove negative type capacity: " + capacity);
        }
        if (this.amountResourceTypeCapacities == null) {
            this.amountResourceTypeCapacities = new HashMap<AmountResource, ResourceAmount>();
        }
        if ((newCapacity = (existingCapacity = this.getAmountResourceTypeCapacity(resource)) - capacity) > 0.0) {
            if (this.hasAmountResourceTypeCapacity(resource)) {
                ResourceAmount existingCapacityAmount = this.amountResourceTypeCapacities.get(resource);
                existingCapacityAmount.setAmount(newCapacity);
            } else {
                this.amountResourceTypeCapacities.put(resource, new ResourceAmount(newCapacity));
            }
        } else if (newCapacity == 0.0) {
            this.amountResourceTypeCapacities.remove(resource);
        } else {
            throw new IllegalStateException("Insufficient existing resource type capacity to remove - existing: " + existingCapacity + ", removed: " + capacity);
        }
    }

    boolean hasAmountResourceTypeCapacity(AmountResource resource) {
        boolean result = false;
        if (this.amountResourceTypeCapacities != null) {
            result = this.amountResourceTypeCapacities.containsKey(resource);
        }
        return result;
    }

    double getAmountResourceTypeCapacity(AmountResource resource) {
        double result = 0.0;
        if (this.hasAmountResourceTypeCapacity(resource)) {
            result = this.amountResourceTypeCapacities.get(resource).getAmount();
        }
        return result;
    }

    double getAmountResourceTypeStored(AmountResource resource) {
        double result = 0.0;
        ResourceAmount storedAmount = this.getAmountResourceTypeStoredObject(resource);
        if (storedAmount != null) {
            result = storedAmount.getAmount();
        }
        return result;
    }

    private ResourceAmount getAmountResourceTypeStoredObject(AmountResource resource) {
        ResourceAmount result = null;
        if (this.amountResourceTypeStored != null) {
            result = this.amountResourceTypeStored.get(resource);
        }
        return result;
    }

    double getTotalAmountResourceTypesStored(boolean allowDirty) {
        if (this.totalAmountCacheDirty && !allowDirty) {
            this.updateTotalAmountResourceTypesStored();
        }
        return this.totalAmountCache;
    }

    private void updateTotalAmountResourceTypesStored() {
        double totalAmount = 0.0;
        if (this.amountResourceTypeStored != null) {
            Map<AmountResource, ResourceAmount> tempMap = Collections.unmodifiableMap(this.amountResourceTypeStored);
            Iterator<AmountResource> i = tempMap.keySet().iterator();
            while (i.hasNext()) {
                totalAmount += tempMap.get(i.next()).getAmount();
            }
        }
        this.totalAmountCache = totalAmount;
        this.totalAmountCacheDirty = false;
    }

    Set<AmountResource> getAllAmountResourcesStored() {
        HashSet<AmountResource> result = null;
        if (this.amountResourceTypeStored != null) {
            result = new HashSet(this.amountResourceTypeStored.size());
            for (AmountResource resource : this.amountResourceTypeStored.keySet()) {
                if (!(this.getAmountResourceTypeStored(resource) > 0.0)) continue;
                result.add(resource);
            }
        } else {
            result = new HashSet<AmountResource>(0);
        }
        return result;
    }

    double getAmountResourceTypeRemainingCapacity(AmountResource resource) {
        double result = 0.0;
        if (this.hasAmountResourceTypeCapacity(resource)) {
            result = this.getAmountResourceTypeCapacity(resource) - this.getAmountResourceTypeStored(resource);
        }
        return result;
    }

    void storeAmountResourceType(AmountResource resource, double amount) {
        if (amount < 0.0) {
            throw new IllegalStateException("Cannot store negative amount of type: " + amount);
        }
        if (amount > 0.0) {
            if (this.getAmountResourceTypeRemainingCapacity(resource) >= amount) {
                ResourceAmount stored;
                this.totalAmountCacheDirty = true;
                if (this.amountResourceTypeStored == null) {
                    this.amountResourceTypeStored = new HashMap<AmountResource, ResourceAmount>();
                }
                if ((stored = this.getAmountResourceTypeStoredObject(resource)) != null) {
                    stored.setAmount(stored.getAmount() + amount);
                } else {
                    this.amountResourceTypeStored.put(resource, new ResourceAmount(amount));
                }
            } else {
                throw new IllegalStateException("Amount resource could not be added in type storage.");
            }
        }
    }

    void retrieveAmountResourceType(AmountResource resource, double amount) {
        if (amount < 0.0) {
            throw new IllegalStateException("Cannot retrieve negative amount of type: " + amount);
        }
        if (amount > 0.0) {
            if (this.getAmountResourceTypeStored(resource) >= amount) {
                this.totalAmountCacheDirty = true;
                ResourceAmount stored = this.getAmountResourceTypeStoredObject(resource);
                stored.setAmount(stored.getAmount() - amount);
            } else {
                throw new IllegalStateException("Amount resource (" + resource.getName() + ":" + amount + ") could not be retrieved from type storage");
            }
        }
    }

    public void destroy() {
        if (this.amountResourceTypeCapacities != null) {
            this.amountResourceTypeCapacities.clear();
        }
        this.amountResourceTypeCapacities = null;
        if (this.amountResourceTypeStored != null) {
            this.amountResourceTypeStored.clear();
        }
        this.amountResourceTypeStored = null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.totalAmountCacheDirty = true;
    }

    private static class ResourceAmount
    implements Serializable {
        private double amount;

        private ResourceAmount(double amount) {
            this.amount = amount;
        }

        private void setAmount(double amount) {
            this.amount = amount;
        }

        private double getAmount() {
            return this.amount;
        }
    }
}

