/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mars_sim.msp.core.resource.ItemResource;

public class Part
extends ItemResource {
    private List<MaintenanceEntity> maintenanceEntities = new ArrayList<MaintenanceEntity>();

    public Part(String name, double mass) {
        super(name, mass);
    }

    void addMaintenanceEntity(String name, int probability, int maxNumber) {
        this.maintenanceEntities.add(new MaintenanceEntity(name, probability, maxNumber));
    }

    public boolean hasMaintenanceEntity(String entityName) {
        if (entityName == null) {
            throw new IllegalArgumentException("name is null");
        }
        boolean result = false;
        Iterator<MaintenanceEntity> i = this.maintenanceEntities.iterator();
        while (i.hasNext()) {
            if (!i.next().name.equalsIgnoreCase(entityName)) continue;
            result = true;
        }
        return result;
    }

    public int getMaintenanceProbability(String entityName) {
        if (entityName == null) {
            throw new IllegalArgumentException("name is null");
        }
        int result = 0;
        for (MaintenanceEntity entity : this.maintenanceEntities) {
            if (!entity.name.equalsIgnoreCase(entityName)) continue;
            result = entity.probability;
        }
        return result;
    }

    public int getMaintenanceMaximumNumber(String entityName) {
        if (entityName == null) {
            throw new IllegalArgumentException("name is null");
        }
        int result = 0;
        for (MaintenanceEntity entity : this.maintenanceEntities) {
            if (!entity.name.equalsIgnoreCase(entityName)) continue;
            result = entity.maxNumber;
        }
        return result;
    }

    public static Set<Part> getParts() {
        HashSet<Part> result = new HashSet<Part>();
        for (ItemResource resource : ItemResource.getItemResources()) {
            if (!(resource instanceof Part)) continue;
            result.add((Part)resource);
        }
        return result;
    }

    private static class MaintenanceEntity
    implements Serializable {
        private String name;
        private int probability;
        private int maxNumber;

        private MaintenanceEntity(String name, int probability, int maxNumber) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.name = name;
            this.probability = probability;
            this.maxNumber = maxNumber;
        }
    }
}

