/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.resource;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;

public final class PartConfig
implements Serializable {
    private static final String PART = "part";
    private static final String NAME = "name";
    private static final String MASS = "mass";
    private static final String MAINTENANCE_ENTITY_LIST = "maintenance-entity-list";
    private static final String ENTITY = "entity";
    private static final String PROBABILITY = "probability";
    private static final String MAX_NUMBER = "max-number";
    private Set<ItemResource> itemResources = new HashSet<ItemResource>();

    public PartConfig(Document itemResourceDoc) {
        this.loadItemResources(itemResourceDoc);
    }

    private void loadItemResources(Document itemResourceDoc) {
        Element root = itemResourceDoc.getRootElement();
        List partNodes = root.getChildren(PART);
        for (Element partElement : partNodes) {
            String name = "";
            name = partElement.getAttributeValue(NAME);
            double mass = Double.parseDouble(partElement.getAttributeValue(MASS));
            Part part = new Part(name, mass);
            this.itemResources.add(part);
            Element entityListElement = partElement.getChild(MAINTENANCE_ENTITY_LIST);
            if (entityListElement == null) continue;
            List entityNodes = entityListElement.getChildren(ENTITY);
            for (Element entityElement : entityNodes) {
                String entityName = entityElement.getAttributeValue(NAME);
                int probability = Integer.parseInt(entityElement.getAttributeValue(PROBABILITY));
                int maxNumber = Integer.parseInt(entityElement.getAttributeValue(MAX_NUMBER));
                part.addMaintenanceEntity(entityName, probability, maxNumber);
            }
        }
    }

    public Set<ItemResource> getItemResources() {
        return this.itemResources;
    }
}

