/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.resource;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Phase
implements Serializable {
    private static final Set<Phase> phases = new HashSet<Phase>(3);
    public static final Phase GAS = new Phase("gas");
    public static final Phase LIQUID = new Phase("liquid");
    public static final Phase SOLID = new Phase("solid");
    private String name;
    private int hashcode = -1;

    private Phase(String name) {
        this.name = name;
        phases.add(this);
    }

    public String getName() {
        return this.name;
    }

    public static Phase findPhase(String name) {
        Phase result = null;
        for (Phase phase : phases) {
            if (!phase.name.equals(name.toLowerCase())) continue;
            result = phase;
        }
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("Phase: " + name + " could not be found.");
    }

    public static Set<Phase> getPhases() {
        return Collections.unmodifiableSet(phases);
    }

    public boolean equals(Object object) {
        if (object instanceof Phase) {
            Phase otherObject = (Phase)object;
            if (this.name.equals(otherObject.name)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = this.name.hashCode();
        }
        return this.hashcode;
    }

    public String toString() {
        return this.name;
    }
}

