/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.science;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.job.JobManager;
import org.mars_sim.msp.core.science.Science;

public class ScienceUtil {
    private static List<Science> sciences;

    private ScienceUtil() {
    }

    private static void loadSciences() {
        sciences = new ArrayList<Science>();
        sciences.add(new Science("Areology", new Job[]{JobManager.getJob("Areologist")}));
        sciences.add(new Science("Astronomy", new Job[]{JobManager.getJob("Astronomer")}));
        sciences.add(new Science("Biology", new Job[]{JobManager.getJob("Biologist")}));
        sciences.add(new Science("Botany", new Job[]{JobManager.getJob("Botanist")}));
        sciences.add(new Science("Chemistry", new Job[]{JobManager.getJob("Chemist")}));
        sciences.add(new Science("Mathematics", new Job[]{JobManager.getJob("Mathematician")}));
        sciences.add(new Science("Medicine", new Job[]{JobManager.getJob("Doctor")}));
        sciences.add(new Science("Meteorology", new Job[]{JobManager.getJob("Meteorologist")}));
        sciences.add(new Science("Physics", new Job[]{JobManager.getJob("Physicist")}));
        ScienceUtil.configureCollaborativeSciences();
    }

    private static void configureCollaborativeSciences() {
        Science areology = ScienceUtil.getScience("Areology");
        Science astronomy = ScienceUtil.getScience("Astronomy");
        Science biology = ScienceUtil.getScience("Biology");
        Science botany = ScienceUtil.getScience("Botany");
        Science chemistry = ScienceUtil.getScience("Chemistry");
        Science mathematics = ScienceUtil.getScience("Mathematics");
        Science medicine = ScienceUtil.getScience("Medicine");
        Science meteorology = ScienceUtil.getScience("Meteorology");
        Science physics = ScienceUtil.getScience("Physics");
        areology.setCollaborativeSciences(new Science[]{biology, chemistry, mathematics, meteorology});
        astronomy.setCollaborativeSciences(new Science[]{biology, chemistry, mathematics, physics});
        biology.setCollaborativeSciences(new Science[]{botany, chemistry, mathematics});
        botany.setCollaborativeSciences(new Science[]{biology, chemistry, mathematics});
        chemistry.setCollaborativeSciences(new Science[]{mathematics});
        mathematics.setCollaborativeSciences(new Science[0]);
        medicine.setCollaborativeSciences(new Science[]{biology, botany, chemistry, mathematics});
        meteorology.setCollaborativeSciences(new Science[]{chemistry, mathematics, physics});
        physics.setCollaborativeSciences(new Science[]{astronomy, mathematics});
    }

    public static List<Science> getAllSciences() {
        if (sciences == null) {
            ScienceUtil.loadSciences();
        }
        return Collections.unmodifiableList(sciences);
    }

    public static Science getScience(String name) {
        if (sciences == null) {
            ScienceUtil.loadSciences();
        }
        Science result = null;
        for (Science science : sciences) {
            if (!science.getName().equalsIgnoreCase(name)) continue;
            result = science;
        }
        return result;
    }

    public static String getAssociatedSkill(Science science) {
        if (sciences == null) {
            ScienceUtil.loadSciences();
        }
        return science.getName();
    }

    public static Job[] getAssociatedJobs(Science science) {
        if (sciences == null) {
            ScienceUtil.loadSciences();
        }
        Job[] jobs = science.getJobs();
        return (Job[])jobs.clone();
    }

    public static boolean isScienceJob(Job job) {
        if (sciences == null) {
            ScienceUtil.loadSciences();
        }
        boolean result = false;
        for (Science science : sciences) {
            Job[] jobs;
            for (Job job1 : jobs = science.getJobs()) {
                if (!job1.equals(job)) continue;
                result = true;
            }
        }
        return result;
    }

    public static Science getAssociatedScience(Job job) {
        if (sciences == null) {
            ScienceUtil.loadSciences();
        }
        Science result = null;
        for (Science science : sciences) {
            Job[] jobs;
            for (Job job1 : jobs = science.getJobs()) {
                if (!job1.equals(job)) continue;
                result = science;
            }
        }
        return result;
    }

    public static boolean isCollaborativeScience(Science primaryScience, Science science) {
        Science[] collaborators;
        if (sciences == null) {
            ScienceUtil.loadSciences();
        }
        boolean result = false;
        for (Science collaborator : collaborators = primaryScience.getCollaborativeSciences()) {
            if (!collaborator.equals(science)) continue;
            result = true;
        }
        return result;
    }
}

