/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.science;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScientificStudyEvent;
import org.mars_sim.msp.core.science.ScientificStudyListener;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.time.MarsClock;

public class ScientificStudy
implements Serializable,
Comparable<ScientificStudy> {
    public static final String PROPOSAL_PHASE = "Study Proposal";
    public static final String INVITATION_PHASE = "Collaborator Invitation";
    public static final String RESEARCH_PHASE = "Research";
    public static final String PAPER_PHASE = "Writing Paper";
    public static final String PEER_REVIEW_PHASE = "Peer Review";
    public static final String SUCCESSFUL_COMPLETION = "Successful Completion";
    public static final String FAILED_COMPLETION = "Failed Completion";
    public static final String CANCELED = "Canceled";
    public static final int MAX_NUM_COLLABORATORS = 3;
    private static final double BASE_PROPOSAL_WORK_TIME = 1000.0;
    private static final double BASE_PRIMARY_RESEARCH_WORK_TIME = 30000.0;
    private static final double BASE_COLLABORATIVE_RESEARCH_WORK_TIME = 10000.0;
    private static final double BASE_PRIMARY_PAPER_WORK_TIME = 5000.0;
    private static final double BASE_COLLABORATIVE_PAPER_WORK_TIME = 1000.0;
    private static final double PEER_REVIEW_TIME = 10000.0;
    static final double PRIMARY_WORK_DOWNTIME_ALLOWED = 30000.0;
    static final double COLLABORATIVE_WORK_DOWNTIME_ALLOWED = 30000.0;
    private String phase;
    private Science science;
    private int difficultyLevel;
    private Person primaryResearcher;
    private Map<Person, Science> collaborativeResearchers;
    private Map<Person, Boolean> invitedResearchers;
    private double proposalWorkTime;
    private double primaryResearchWorkTime;
    private Map<Person, Double> collaborativeResearchWorkTime;
    private double primaryPaperWorkTime;
    private Map<Person, Double> collaborativePaperWorkTime;
    private MarsClock peerReviewStartTime;
    private boolean completed;
    private String completionState;
    private Settlement primarySettlement;
    private MarsClock lastPrimaryResearchWorkTime;
    private Map<Person, MarsClock> lastCollaborativeResearchWorkTime;
    private double primaryResearcherAchievementEarned;
    private Map<Person, Double> collaborativeAchievementEarned;
    private transient List<ScientificStudyListener> listeners;

    ScientificStudy(Person primaryResearcher, Science science, int difficultyLevel) {
        this.primaryResearcher = primaryResearcher;
        this.science = science;
        this.difficultyLevel = difficultyLevel;
        this.phase = PROPOSAL_PHASE;
        this.collaborativeResearchers = new HashMap<Person, Science>(3);
        this.invitedResearchers = new HashMap<Person, Boolean>();
        this.proposalWorkTime = 0.0;
        this.primaryResearchWorkTime = 0.0;
        this.collaborativeResearchWorkTime = new HashMap<Person, Double>(3);
        this.primaryPaperWorkTime = 0.0;
        this.collaborativePaperWorkTime = new HashMap<Person, Double>(3);
        this.peerReviewStartTime = null;
        this.completed = false;
        this.completionState = null;
        this.primarySettlement = primaryResearcher.getAssociatedSettlement();
        this.lastPrimaryResearchWorkTime = null;
        this.lastCollaborativeResearchWorkTime = new HashMap<Person, MarsClock>(3);
        this.primaryResearcherAchievementEarned = 0.0;
        this.collaborativeAchievementEarned = new HashMap<Person, Double>(3);
        this.listeners = Collections.synchronizedList(new ArrayList());
    }

    public String getPhase() {
        return this.phase;
    }

    void setPhase(String phase) {
        this.phase = phase;
        this.fireScientificStudyUpdate("study phase change event");
    }

    public Science getScience() {
        return this.science;
    }

    public int getDifficultyLevel() {
        return this.difficultyLevel;
    }

    public Person getPrimaryResearcher() {
        return this.primaryResearcher;
    }

    public double getTotalProposalWorkTimeRequired() {
        double result = 1000.0 * (double)this.difficultyLevel;
        if (result == 0.0) {
            result = 1000.0;
        }
        return result;
    }

    public double getProposalWorkTimeCompleted() {
        return this.proposalWorkTime;
    }

    public void addProposalWorkTime(double workTime) {
        Settlement settlement;
        this.proposalWorkTime += workTime;
        double requiredWorkTime = this.getTotalProposalWorkTimeRequired();
        if (this.proposalWorkTime >= requiredWorkTime) {
            this.proposalWorkTime = requiredWorkTime;
        }
        if ((settlement = this.primaryResearcher.getAssociatedSettlement()) != null && !this.primarySettlement.equals(settlement)) {
            this.primarySettlement = settlement;
        }
        this.fireScientificStudyUpdate("study proposal work event");
    }

    public Map<Person, Science> getCollaborativeResearchers() {
        return new HashMap<Person, Science>(this.collaborativeResearchers);
    }

    public void addCollaborativeResearcher(Person researcher, Science science) {
        this.collaborativeResearchers.put(researcher, science);
        this.collaborativeResearchWorkTime.put(researcher, 0.0);
        this.collaborativePaperWorkTime.put(researcher, 0.0);
        this.lastCollaborativeResearchWorkTime.put(researcher, null);
        this.collaborativeAchievementEarned.put(researcher, 0.0);
        this.fireScientificStudyUpdate("add study collorator event", researcher);
    }

    public void removeCollaborativeResearcher(Person researcher) {
        this.collaborativeResearchers.remove(researcher);
        this.collaborativeResearchWorkTime.remove(researcher);
        this.collaborativePaperWorkTime.remove(researcher);
        this.lastCollaborativeResearchWorkTime.remove(researcher);
        this.collaborativeAchievementEarned.remove(researcher);
        this.fireScientificStudyUpdate("remove study collorator event", researcher);
    }

    public boolean hasResearcherBeenInvited(Person researcher) {
        return this.invitedResearchers.containsKey(researcher);
    }

    public boolean hasInvitedResearcherResponded(Person researcher) {
        boolean result = false;
        if (this.invitedResearchers.containsKey(researcher)) {
            result = this.invitedResearchers.get(researcher);
        }
        return result;
    }

    public int getNumOpenResearchInvitations() {
        int result = 0;
        Iterator<Person> i = this.invitedResearchers.keySet().iterator();
        while (i.hasNext()) {
            if (this.invitedResearchers.get(i.next()).booleanValue()) continue;
            ++result;
        }
        return result;
    }

    void cleanResearchInvitations() {
        Iterator<Person> i = this.invitedResearchers.keySet().iterator();
        while (i.hasNext()) {
            Person invitee = i.next();
            if (!invitee.getPhysicalCondition().isDead()) continue;
            i.remove();
        }
    }

    public void addInvitedResearcher(Person researcher) {
        if (!this.invitedResearchers.containsKey(researcher)) {
            this.invitedResearchers.put(researcher, false);
        }
    }

    public void respondingInvitedResearcher(Person researcher) {
        if (this.invitedResearchers.containsKey(researcher)) {
            this.invitedResearchers.put(researcher, true);
        }
    }

    public double getTotalPrimaryResearchWorkTimeRequired() {
        double result = 30000.0 * (double)this.difficultyLevel;
        if (result == 0.0) {
            result = 30000.0;
        }
        return result;
    }

    public double getPrimaryResearchWorkTimeCompleted() {
        return this.primaryResearchWorkTime;
    }

    public void addPrimaryResearchWorkTime(double workTime) {
        Settlement settlement;
        this.primaryResearchWorkTime += workTime;
        double requiredWorkTime = this.getTotalPrimaryResearchWorkTimeRequired();
        if (this.primaryResearchWorkTime >= requiredWorkTime) {
            this.primaryResearchWorkTime = requiredWorkTime;
        }
        if ((settlement = this.primaryResearcher.getAssociatedSettlement()) != null && !this.primarySettlement.equals(settlement)) {
            this.primarySettlement = settlement;
        }
        this.lastPrimaryResearchWorkTime = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
        this.fireScientificStudyUpdate("study primary research work event", this.getPrimaryResearcher());
    }

    public boolean isPrimaryResearchCompleted() {
        return this.primaryResearchWorkTime >= this.getTotalPrimaryResearchWorkTimeRequired();
    }

    public double getTotalCollaborativeResearchWorkTimeRequired() {
        double result = 10000.0 * (double)this.difficultyLevel;
        if (result == 0.0) {
            result = 10000.0;
        }
        return result;
    }

    public double getCollaborativeResearchWorkTimeCompleted(Person researcher) {
        if (this.collaborativeResearchWorkTime.containsKey(researcher)) {
            return this.collaborativeResearchWorkTime.get(researcher);
        }
        throw new IllegalArgumentException(researcher + " is not a collaborative researcher in this study.");
    }

    public void addCollaborativeResearchWorkTime(Person researcher, double workTime) {
        double currentWorkTime;
        if (this.collaborativeResearchWorkTime.containsKey(researcher)) {
            currentWorkTime = this.collaborativeResearchWorkTime.get(researcher);
            double requiredWorkTime = this.getTotalCollaborativeResearchWorkTimeRequired();
            if ((currentWorkTime += workTime) >= requiredWorkTime) {
                currentWorkTime = requiredWorkTime;
            }
        } else {
            throw new IllegalArgumentException(researcher + " is not a collaborative researcher in this study.");
        }
        this.collaborativeResearchWorkTime.put(researcher, currentWorkTime);
        this.lastCollaborativeResearchWorkTime.put(researcher, (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone());
        this.fireScientificStudyUpdate("study collaboration research work event", researcher);
    }

    public boolean isCollaborativeResearchCompleted(Person researcher) {
        if (this.collaborativeResearchWorkTime.containsKey(researcher)) {
            double requiredWorkTime;
            double currentWorkTime = this.collaborativeResearchWorkTime.get(researcher);
            return currentWorkTime >= (requiredWorkTime = this.getTotalCollaborativeResearchWorkTimeRequired());
        }
        throw new IllegalArgumentException(researcher + " is not a collaborative researcher in this study.");
    }

    public boolean isAllCollaborativeResearchCompleted() {
        boolean result = true;
        Iterator<Person> i = this.collaborativeResearchWorkTime.keySet().iterator();
        while (i.hasNext()) {
            if (this.isCollaborativeResearchCompleted(i.next())) continue;
            result = false;
        }
        return result;
    }

    public boolean isAllResearchCompleted() {
        return this.isPrimaryResearchCompleted() && this.isAllCollaborativeResearchCompleted();
    }

    public double getTotalPrimaryPaperWorkTimeRequired() {
        double result = 5000.0 * (double)this.difficultyLevel;
        if (result == 0.0) {
            result = 5000.0;
        }
        return result;
    }

    public double getPrimaryPaperWorkTimeCompleted() {
        return this.primaryPaperWorkTime;
    }

    public void addPrimaryPaperWorkTime(double workTime) {
        Settlement settlement;
        this.primaryPaperWorkTime += workTime;
        double requiredWorkTime = this.getTotalPrimaryPaperWorkTimeRequired();
        if (this.primaryPaperWorkTime >= requiredWorkTime) {
            this.primaryPaperWorkTime = requiredWorkTime;
        }
        if ((settlement = this.primaryResearcher.getAssociatedSettlement()) != null && !this.primarySettlement.equals(settlement)) {
            this.primarySettlement = settlement;
        }
        this.fireScientificStudyUpdate("study primary paper work event");
    }

    public boolean isPrimaryPaperCompleted() {
        return this.primaryPaperWorkTime >= this.getTotalPrimaryPaperWorkTimeRequired();
    }

    public double getTotalCollaborativePaperWorkTimeRequired() {
        double result = 1000.0 * (double)this.difficultyLevel;
        if (result == 0.0) {
            result = 1000.0;
        }
        return result;
    }

    public double getCollaborativePaperWorkTimeCompleted(Person researcher) {
        if (this.collaborativePaperWorkTime.containsKey(researcher)) {
            return this.collaborativePaperWorkTime.get(researcher);
        }
        throw new IllegalArgumentException(researcher + " is not a collaborative researcher in this study.");
    }

    public void addCollaborativePaperWorkTime(Person researcher, double workTime) {
        double currentWorkTime;
        if (this.collaborativePaperWorkTime.containsKey(researcher)) {
            currentWorkTime = this.collaborativePaperWorkTime.get(researcher);
            double requiredWorkTime = this.getTotalCollaborativePaperWorkTimeRequired();
            if ((currentWorkTime += workTime) >= requiredWorkTime) {
                currentWorkTime = requiredWorkTime;
            }
        } else {
            throw new IllegalArgumentException(researcher + " is not a collaborative researcher in this study.");
        }
        this.collaborativePaperWorkTime.put(researcher, currentWorkTime);
        this.fireScientificStudyUpdate("study collaboration paper work event", researcher);
    }

    public boolean isCollaborativePaperCompleted(Person researcher) {
        if (this.collaborativePaperWorkTime.containsKey(researcher)) {
            double requiredWorkTime;
            double currentWorkTime = this.collaborativePaperWorkTime.get(researcher);
            return currentWorkTime >= (requiredWorkTime = this.getTotalCollaborativePaperWorkTimeRequired());
        }
        throw new IllegalArgumentException(researcher + " is not a collaborative researcher in this study.");
    }

    public boolean isAllCollaborativePaperCompleted() {
        boolean result = true;
        Iterator<Person> i = this.collaborativePaperWorkTime.keySet().iterator();
        while (i.hasNext()) {
            if (this.isCollaborativePaperCompleted(i.next())) continue;
            result = false;
        }
        return result;
    }

    public boolean isAllPaperWritingCompleted() {
        return this.isPrimaryPaperCompleted() && this.isAllCollaborativePaperCompleted();
    }

    void startingPeerReview() {
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        this.peerReviewStartTime = (MarsClock)currentTime.clone();
    }

    public boolean isPeerReviewTimeFinished() {
        MarsClock currentTime;
        double peerReviewTime;
        boolean result = false;
        if (this.peerReviewStartTime != null && (peerReviewTime = MarsClock.getTimeDiff(currentTime = Simulation.instance().getMasterClock().getMarsClock(), this.peerReviewStartTime)) >= 10000.0) {
            result = true;
        }
        return result;
    }

    public double getPeerReviewTimeCompleted() {
        double result = 0.0;
        if (this.peerReviewStartTime != null) {
            MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
            result = MarsClock.getTimeDiff(currentTime, this.peerReviewStartTime);
        }
        return result;
    }

    public double getTotalPeerReviewTimeRequired() {
        return 10000.0;
    }

    void setCompleted(String completionState) {
        this.completed = true;
        this.completionState = completionState;
        this.fireScientificStudyUpdate("study completion event");
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public String getCompletionState() {
        if (this.completed) {
            return this.completionState;
        }
        return null;
    }

    public Settlement getPrimarySettlement() {
        return this.primarySettlement;
    }

    public MarsClock getLastPrimaryResearchWorkTime() {
        return this.lastPrimaryResearchWorkTime;
    }

    public MarsClock getLastCollaborativeResearchWorkTime(Person researcher) {
        MarsClock result = null;
        if (this.lastCollaborativeResearchWorkTime.containsKey(researcher)) {
            result = this.lastCollaborativeResearchWorkTime.get(researcher);
        }
        return result;
    }

    public double getPrimaryResearcherEarnedScientificAchievement() {
        return this.primaryResearcherAchievementEarned;
    }

    void setPrimaryResearchEarnedScientificAchievement(double earned) {
        this.primaryResearcherAchievementEarned = earned;
    }

    public double getCollaborativeResearcherEarnedScientificAchievement(Person researcher) {
        double result = 0.0;
        if (this.collaborativeAchievementEarned.containsKey(researcher)) {
            result = this.collaborativeAchievementEarned.get(researcher);
        }
        return result;
    }

    void setCollaborativeResearcherEarnedScientificAchievement(Person researcher, double earned) {
        if (this.collaborativeAchievementEarned.containsKey(researcher)) {
            this.collaborativeAchievementEarned.put(researcher, earned);
        }
    }

    public String toString() {
        return this.science.getName().toLowerCase() + " level " + this.difficultyLevel + " study";
    }

    @Override
    public int compareTo(ScientificStudy o) {
        return this.toString().compareTo(o.toString());
    }

    public final void addScientificStudyListener(ScientificStudyListener newListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (!this.listeners.contains(newListener)) {
            this.listeners.add(newListener);
        }
    }

    public final void removeScientificStudyListener(ScientificStudyListener oldListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (this.listeners.contains(oldListener)) {
            this.listeners.remove(oldListener);
        }
    }

    private void fireScientificStudyUpdate(String type) {
        this.fireScientificStudyUpdate(type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireScientificStudyUpdate(String updateType, Person researcher) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        List<ScientificStudyListener> list = this.listeners;
        synchronized (list) {
            Iterator<ScientificStudyListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().scientificStudyUpdate(new ScientificStudyEvent(this, researcher, updateType));
            }
        }
    }

    public void destroy() {
        this.phase = null;
        this.science = null;
        this.primaryResearcher = null;
        this.collaborativeResearchers.clear();
        this.collaborativeResearchers = null;
        this.invitedResearchers.clear();
        this.invitedResearchers = null;
        this.collaborativeResearchWorkTime.clear();
        this.collaborativeResearchWorkTime = null;
        this.collaborativePaperWorkTime.clear();
        this.collaborativePaperWorkTime = null;
        this.peerReviewStartTime = null;
        this.completionState = null;
        this.primarySettlement = null;
        this.lastPrimaryResearchWorkTime = null;
        this.lastCollaborativeResearchWorkTime.clear();
        this.lastCollaborativeResearchWorkTime = null;
        this.collaborativeAchievementEarned.clear();
        this.collaborativeAchievementEarned = null;
        this.listeners.clear();
        this.listeners = null;
    }
}

