/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.science;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyUtil;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.time.MarsClock;

public class ScientificStudyManager
implements Serializable {
    private static String CLASS_NAME = "org.mars_sim.msp.science.ScientificStudyManager";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private List<ScientificStudy> studies = new ArrayList<ScientificStudy>();

    public ScientificStudy createScientificStudy(Person researcher, Science science, int difficultyLevel) {
        if (researcher == null) {
            throw new IllegalArgumentException("Researcher cannot be null");
        }
        if (science == null) {
            throw new IllegalArgumentException("Science cannot be null");
        }
        if (difficultyLevel < 0) {
            throw new IllegalArgumentException("difficultyLevel must be positive value");
        }
        ScientificStudy study = new ScientificStudy(researcher, science, difficultyLevel);
        this.studies.add(study);
        logger.info(researcher.getName() + " begins writing proposal for new " + study.toString());
        return study;
    }

    public List<ScientificStudy> getOngoingStudies() {
        ArrayList<ScientificStudy> result = new ArrayList<ScientificStudy>();
        for (ScientificStudy study : this.studies) {
            if (study.isCompleted()) continue;
            result.add(study);
        }
        return result;
    }

    public List<ScientificStudy> getCompletedStudies() {
        ArrayList<ScientificStudy> result = new ArrayList<ScientificStudy>();
        for (ScientificStudy study : this.studies) {
            if (!study.isCompleted()) continue;
            result.add(study);
        }
        return result;
    }

    public List<ScientificStudy> getSuccessfulStudies() {
        ArrayList<ScientificStudy> result = new ArrayList<ScientificStudy>();
        for (ScientificStudy study : this.studies) {
            if (!study.isCompleted() || !study.getCompletionState().equals("Successful Completion")) continue;
            result.add(study);
        }
        return result;
    }

    public List<ScientificStudy> getFailedStudies() {
        ArrayList<ScientificStudy> result = new ArrayList<ScientificStudy>();
        for (ScientificStudy study : this.studies) {
            if (!study.isCompleted() || !study.getCompletionState().equals("Failed Completion")) continue;
            result.add(study);
        }
        return result;
    }

    public List<ScientificStudy> getCanceledStudies() {
        ArrayList<ScientificStudy> result = new ArrayList<ScientificStudy>();
        for (ScientificStudy study : this.studies) {
            if (!study.isCompleted() || !study.getCompletionState().equals("Canceled")) continue;
            result.add(study);
        }
        return result;
    }

    public ScientificStudy getOngoingPrimaryStudy(Person researcher) {
        ScientificStudy result = null;
        for (ScientificStudy study : this.studies) {
            if (study.isCompleted() || !study.getPrimaryResearcher().equals(researcher)) continue;
            result = study;
        }
        return result;
    }

    public List<ScientificStudy> getCompletedPrimaryStudies(Person researcher) {
        ArrayList<ScientificStudy> result = new ArrayList<ScientificStudy>();
        for (ScientificStudy study : this.studies) {
            if (!study.isCompleted() || !study.getPrimaryResearcher().equals(researcher)) continue;
            result.add(study);
        }
        return result;
    }

    public List<ScientificStudy> getOngoingCollaborativeStudies(Person researcher) {
        ArrayList<ScientificStudy> result = new ArrayList<ScientificStudy>();
        for (ScientificStudy study : this.studies) {
            if (study.isCompleted() || !study.getCollaborativeResearchers().containsKey(researcher)) continue;
            result.add(study);
        }
        return result;
    }

    public List<ScientificStudy> getCompletedCollaborativeStudies(Person researcher) {
        ArrayList<ScientificStudy> result = new ArrayList<ScientificStudy>();
        for (ScientificStudy study : this.studies) {
            if (!study.isCompleted() || !study.getCollaborativeResearchers().containsKey(researcher)) continue;
            result.add(study);
        }
        return result;
    }

    public List<ScientificStudy> getOngoingPrimaryStudies(Settlement settlement) {
        ArrayList<ScientificStudy> result = new ArrayList<ScientificStudy>();
        for (ScientificStudy study : this.studies) {
            if (study.isCompleted() || !settlement.equals(study.getPrimarySettlement())) continue;
            result.add(study);
        }
        return result;
    }

    public List<ScientificStudy> getCompletedPrimaryStudies(Settlement settlement) {
        ArrayList<ScientificStudy> result = new ArrayList<ScientificStudy>();
        for (ScientificStudy study : this.studies) {
            if (!study.isCompleted() || !settlement.equals(study.getPrimarySettlement())) continue;
            result.add(study);
        }
        return result;
    }

    public List<ScientificStudy> getOpenInvitationStudies(Person collaborativeResearcher) {
        ArrayList<ScientificStudy> result = new ArrayList<ScientificStudy>();
        for (ScientificStudy study : this.studies) {
            if (study.isCompleted() || !study.getPhase().equals("Collaborator Invitation") || !study.hasResearcherBeenInvited(collaborativeResearcher) || study.hasInvitedResearcherResponded(collaborativeResearcher)) continue;
            result.add(study);
        }
        return result;
    }

    public List<ScientificStudy> getAllStudies(Person researcher) {
        ArrayList<ScientificStudy> result = new ArrayList<ScientificStudy>();
        ScientificStudy primaryStudy = this.getOngoingPrimaryStudy(researcher);
        if (primaryStudy != null) {
            result.add(primaryStudy);
        }
        List<ScientificStudy> collaborativeStudies = this.getOngoingCollaborativeStudies(researcher);
        result.addAll(collaborativeStudies);
        List<ScientificStudy> completedPrimaryStudies = this.getCompletedPrimaryStudies(researcher);
        result.addAll(completedPrimaryStudies);
        List<ScientificStudy> completedCollaborativeStudies = this.getCompletedCollaborativeStudies(researcher);
        result.addAll(completedCollaborativeStudies);
        return result;
    }

    public List<ScientificStudy> getAllStudies(Settlement settlement) {
        ArrayList<ScientificStudy> result = new ArrayList<ScientificStudy>();
        List<ScientificStudy> primaryStudies = this.getOngoingPrimaryStudies(settlement);
        result.addAll(primaryStudies);
        List<ScientificStudy> completedPrimaryStudies = this.getCompletedPrimaryStudies(settlement);
        result.addAll(completedPrimaryStudies);
        return result;
    }

    public void updateStudies() {
        for (ScientificStudy study : this.studies) {
            if (study.isCompleted()) continue;
            if (this.isPrimaryResearcherDead(study)) {
                study.setCompleted("Canceled");
                logger.info(study.toString() + " canceled due to primary researcher death.");
                continue;
            }
            for (Person collaborator : study.getCollaborativeResearchers().keySet()) {
                if (!collaborator.getPhysicalCondition().isDead()) continue;
                study.removeCollaborativeResearcher(collaborator);
                logger.info(collaborator.getName() + " removed as collaborator in " + study.toString() + " due to death.");
            }
            if (study.getPhase().equals("Study Proposal")) {
                if (!(study.getProposalWorkTimeCompleted() >= study.getTotalProposalWorkTimeRequired())) continue;
                logger.info(study.getPrimaryResearcher().getName() + " finishes writing proposal for " + study.toString() + " and is starting to invite collaborative researchers");
                study.setPhase("Collaborator Invitation");
                continue;
            }
            if (study.getPhase().equals("Collaborator Invitation")) {
                study.cleanResearchInvitations();
                boolean phaseEnded = false;
                if (study.getCollaborativeResearchers().size() < 3) {
                    int openResearchInvitations;
                    int availableInvitees = ScientificStudyUtil.getAvailableCollaboratorsForInvite(study).size();
                    if (availableInvitees + (openResearchInvitations = study.getNumOpenResearchInvitations()) == 0) {
                        phaseEnded = true;
                    }
                } else {
                    phaseEnded = true;
                }
                if (!phaseEnded) continue;
                logger.info(study.toString() + " ending invitation phase with " + study.getCollaborativeResearchers().size() + " collaborative researchers.");
                logger.info(study.toString() + " starting research.");
                study.setPhase("Research");
                study.addPrimaryResearchWorkTime(0.0);
                Iterator<Person> k = study.getCollaborativeResearchers().keySet().iterator();
                while (k.hasNext()) {
                    study.addCollaborativeResearchWorkTime(k.next(), 0.0);
                }
                continue;
            }
            if (study.getPhase().equals("Research")) {
                MarsClock lastPrimaryWork;
                if (study.isAllResearchCompleted()) {
                    study.setPhase("Writing Paper");
                    logger.info(study.toString() + " finished research and is starting data results compiling.");
                    continue;
                }
                MarsClock currentDate = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
                if (!study.isPrimaryResearchCompleted() && (lastPrimaryWork = study.getLastPrimaryResearchWorkTime()) != null && MarsClock.getTimeDiff(currentDate, lastPrimaryWork) > 30000.0) {
                    study.setCompleted("Canceled");
                    logger.info(study.toString() + " canceled due to lack of primary researcher participation.");
                    continue;
                }
                for (Person researcher : study.getCollaborativeResearchers().keySet()) {
                    MarsClock lastCollaborativeWork;
                    if (study.isCollaborativeResearchCompleted(researcher) || (lastCollaborativeWork = study.getLastCollaborativeResearchWorkTime(researcher)) == null || !(MarsClock.getTimeDiff(currentDate, lastCollaborativeWork) > 30000.0)) continue;
                    study.removeCollaborativeResearcher(researcher);
                    logger.info(researcher.getName() + " removed as collaborator in " + study.toString() + " due to lack of participation.");
                }
                continue;
            }
            if (study.getPhase().equals("Writing Paper")) {
                if (!study.isAllPaperWritingCompleted()) continue;
                study.setPhase("Peer Review");
                study.startingPeerReview();
                logger.info(study.toString() + " has compiled data results and is starting peer review.");
                continue;
            }
            if (!study.getPhase().equals("Peer Review") || !study.isPeerReviewTimeFinished()) continue;
            if (ScientificStudyUtil.determinePeerReviewResults(study)) {
                study.setCompleted("Successful Completion");
                ScientificStudyUtil.provideCompletionAchievements(study);
                logger.info(study.toString() + " is completed with a successful peer review.");
                continue;
            }
            study.setCompleted("Failed Completion");
            logger.info(study.toString() + " is completed with a failed peer review.");
        }
    }

    private boolean isPrimaryResearcherDead(ScientificStudy study) {
        Person primaryResearcher = study.getPrimaryResearcher();
        return primaryResearcher.getPhysicalCondition().isDead();
    }

    public void destroy() {
        Iterator<ScientificStudy> i = this.studies.iterator();
        while (i.hasNext()) {
            i.next().destroy();
        }
        this.studies.clear();
        this.studies = null;
    }
}

