/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.LifeSupport;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.task.Maintenance;
import org.mars_sim.msp.core.person.ai.task.Repair;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.structure.PowerGrid;
import org.mars_sim.msp.core.structure.Structure;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.EVA;
import org.mars_sim.msp.core.structure.building.function.LivingAccommodations;
import org.mars_sim.msp.core.structure.construction.ConstructionManager;
import org.mars_sim.msp.core.structure.goods.GoodsManager;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class Settlement
extends Structure
implements LifeSupport {
    private static Logger logger = Logger.getLogger(Settlement.class.getName());
    public static final String ADD_ASSOCIATED_PERSON_EVENT = "add associated person";
    public static final String REMOVE_ASSOCIATED_PERSON_EVENT = "remove associated person";
    private static final double NORMAL_AIR_PRESSURE = 1.0;
    private static final double NORMAL_TEMP = 25.0;
    private static final double MAINTENANCE_TIME = 1000.0;
    protected BuildingManager buildingManager;
    protected GoodsManager goodsManager;
    protected ConstructionManager constructionManager;
    protected PowerGrid powerGrid;
    private String template;
    private boolean missionCreationOverride;
    private boolean manufactureOverride;
    private boolean resourceProcessOverride;
    private boolean constructionOverride;
    private Map<Science, Double> scientificAchievement;
    private double zeroPopulationTime;
    private int initialPopulation;

    protected Settlement(String name, Coordinates location) {
        super(name, location);
    }

    public Settlement(String name, String template, Coordinates location, int populationNumber) {
        super(name, location);
        this.template = template;
        this.getInventory().addGeneralCapacity(Double.MAX_VALUE);
        this.buildingManager = new BuildingManager(this);
        this.goodsManager = new GoodsManager(this);
        this.constructionManager = new ConstructionManager(this);
        this.powerGrid = new PowerGrid(this);
        this.scientificAchievement = new HashMap<Science, Double>(0);
        this.initialPopulation = populationNumber;
    }

    public int getPopulationCapacity() {
        int result = 0;
        for (Building building : this.buildingManager.getBuildings("Living Accommodations")) {
            LivingAccommodations livingAccommodations = (LivingAccommodations)building.getFunction("Living Accommodations");
            result += livingAccommodations.getBeds();
        }
        return result;
    }

    public int getCurrentPopulationNum() {
        return this.getInhabitants().size();
    }

    public Collection<Person> getInhabitants() {
        return CollectionUtils.getPerson(this.getInventory().getContainedUnits());
    }

    public int getAvailablePopulationCapacity() {
        return this.getPopulationCapacity() - this.getCurrentPopulationNum();
    }

    public Person[] getInhabitantArray() {
        Collection<Person> people = this.getInhabitants();
        Person[] personArray = new Person[people.size()];
        Iterator<Person> i = people.iterator();
        int count = 0;
        while (i.hasNext()) {
            personArray[count] = i.next();
            ++count;
        }
        return personArray;
    }

    public Collection<Vehicle> getParkedVehicles() {
        return CollectionUtils.getVehicle(this.getInventory().getContainedUnits());
    }

    public int getParkedVehicleNum() {
        return this.getParkedVehicles().size();
    }

    @Override
    public boolean lifeSupportCheck() {
        boolean result = true;
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        if (this.getInventory().getAmountResourceStored(oxygen, false) <= 0.0) {
            result = false;
        }
        AmountResource water = AmountResource.findAmountResource("water");
        if (this.getInventory().getAmountResourceStored(water, false) <= 0.0) {
            result = false;
        }
        if (this.getAirPressure() != 1.0) {
            result = false;
        }
        if (this.getTemperature() != 25.0) {
            result = false;
        }
        return result;
    }

    @Override
    public int getLifeSupportCapacity() {
        return this.getPopulationCapacity();
    }

    @Override
    public double provideOxygen(double amountRequested) {
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenTaken = amountRequested;
        double oxygenLeft = this.getInventory().getAmountResourceStored(oxygen, false);
        if (oxygenTaken > oxygenLeft) {
            oxygenTaken = oxygenLeft;
        }
        AmountResource carbonDioxide = AmountResource.findAmountResource("carbon dioxide");
        double carbonDioxideProvided = oxygenTaken;
        double carbonDioxideCapacity = this.getInventory().getAmountResourceRemainingCapacity(carbonDioxide, true, false);
        if (carbonDioxideProvided > carbonDioxideCapacity) {
            carbonDioxideProvided = carbonDioxideCapacity;
        }
        this.getInventory().retrieveAmountResource(oxygen, oxygenTaken);
        this.getInventory().storeAmountResource(carbonDioxide, carbonDioxideProvided, true);
        return oxygenTaken;
    }

    @Override
    public double provideWater(double amountRequested) {
        AmountResource water = AmountResource.findAmountResource("water");
        double waterTaken = amountRequested;
        double waterLeft = this.getInventory().getAmountResourceStored(water, false);
        if (waterTaken > waterLeft) {
            waterTaken = waterLeft;
        }
        this.getInventory().retrieveAmountResource(water, waterTaken);
        return waterTaken;
    }

    @Override
    public double getAirPressure() {
        double result = 1.0;
        double ambient = Simulation.instance().getMars().getWeather().getAirPressure(this.getCoordinates());
        if (result < ambient) {
            return ambient;
        }
        return result;
    }

    @Override
    public double getTemperature() {
        double result = 25.0;
        double ambient = Simulation.instance().getMars().getWeather().getTemperature(this.getCoordinates());
        if (result < ambient) {
            return ambient;
        }
        return result;
    }

    @Override
    public void timePassing(double time) {
        int overCrowding = this.getCurrentPopulationNum() - this.getPopulationCapacity();
        if (overCrowding > 0) {
            double stressModifier = 0.1 * (double)overCrowding * time;
            Iterator<Person> i = this.getInhabitants().iterator();
            while (i.hasNext()) {
                PhysicalCondition condition = i.next().getPhysicalCondition();
                condition.setStress(condition.getStress() + stressModifier);
            }
        }
        if (this.getCurrentPopulationNum() == 0) {
            this.zeroPopulationTime += time;
            if (this.zeroPopulationTime > 1000.0) {
                this.powerGrid.setPowerMode("Power down");
            }
        } else {
            this.zeroPopulationTime = 0.0;
            this.powerGrid.setPowerMode("Power up");
        }
        this.powerGrid.timePassing(time);
        this.buildingManager.timePassing(time);
        this.updateGoodsManager(time);
    }

    private void updateGoodsManager(double time) {
        if (!this.goodsManager.isInitialized() || time >= RandomUtil.getRandomDouble(1000.0)) {
            this.goodsManager.timePassing(time);
        }
    }

    public Collection<Person> getAffectedPeople() {
        ConcurrentLinkedQueue<Person> people = new ConcurrentLinkedQueue<Person>(this.getInhabitants());
        for (Person person : Simulation.instance().getUnitManager().getPeople()) {
            Task task = person.getMind().getTaskManager().getTask();
            if (task instanceof Maintenance && ((Maintenance)task).getEntity() == this && !people.contains(person)) {
                people.add(person);
            }
            if (!(task instanceof Repair) || ((Repair)((Object)task)).getEntity() != this || people.contains(person)) continue;
            people.add(person);
        }
        return people;
    }

    public BuildingManager getBuildingManager() {
        return this.buildingManager;
    }

    public GoodsManager getGoodsManager() {
        return this.goodsManager;
    }

    public Airlock getAvailableAirlock() {
        Airlock result = null;
        BuildingManager manager = this.buildingManager;
        List<Building> evaBuildings = manager.getBuildings("EVA");
        if (evaBuildings.size() > 0) {
            int rand = RandomUtil.getRandomInt(evaBuildings.size() - 1);
            Building building = evaBuildings.get(rand);
            EVA eva = (EVA)building.getFunction("EVA");
            result = eva.getAirlock();
        }
        return result;
    }

    public int getAirlockNum() {
        return this.buildingManager.getBuildings("EVA").size();
    }

    public PowerGrid getPowerGrid() {
        return this.powerGrid;
    }

    public String getTemplate() {
        return this.template;
    }

    public Collection<Person> getAllAssociatedPeople() {
        ConcurrentLinkedQueue<Person> result = new ConcurrentLinkedQueue<Person>();
        for (Person person : Simulation.instance().getUnitManager().getPeople()) {
            if (person.getAssociatedSettlement() != this) continue;
            result.add(person);
        }
        return result;
    }

    public Collection<Vehicle> getAllAssociatedVehicles() {
        Collection<Vehicle> result = this.getParkedVehicles();
        for (Mission mission : Simulation.instance().getMissionManager().getMissionsForSettlement(this)) {
            Vehicle vehicle;
            if (!(mission instanceof VehicleMission) || (vehicle = ((VehicleMission)mission).getVehicle()) == null || this.equals(vehicle.getSettlement())) continue;
            result.add(vehicle);
        }
        return result;
    }

    public void setMissionCreationOverride(boolean missionCreationOverride) {
        this.missionCreationOverride = missionCreationOverride;
    }

    public boolean getMissionCreationOverride() {
        return this.missionCreationOverride;
    }

    public void setConstructionOverride(boolean constructionOverride) {
        this.constructionOverride = constructionOverride;
    }

    public boolean getConstructionOverride() {
        return this.constructionOverride;
    }

    public void setManufactureOverride(boolean manufactureOverride) {
        this.manufactureOverride = manufactureOverride;
    }

    public boolean getManufactureOverride() {
        return this.manufactureOverride;
    }

    public void setResourceProcessOverride(boolean resourceProcessOverride) {
        this.resourceProcessOverride = resourceProcessOverride;
    }

    public boolean getResourceProcessOverride() {
        return this.resourceProcessOverride;
    }

    public ConstructionManager getConstructionManager() {
        return this.constructionManager;
    }

    public double getScientificAchievement(Science science) {
        double result = 0.0;
        if (this.scientificAchievement.containsKey(science)) {
            result = this.scientificAchievement.get(science);
        }
        return result;
    }

    public double getTotalScientificAchievement() {
        double result = 0.0;
        Iterator<Double> i = this.scientificAchievement.values().iterator();
        while (i.hasNext()) {
            result += i.next().doubleValue();
        }
        return result;
    }

    public void addScientificAchievement(double achievementCredit, Science science) {
        if (this.scientificAchievement.containsKey(science)) {
            achievementCredit += this.scientificAchievement.get(science).doubleValue();
        }
        this.scientificAchievement.put(science, achievementCredit);
    }

    public int getInitialPopulation() {
        return this.initialPopulation;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.buildingManager.destroy();
        this.buildingManager = null;
        this.goodsManager.destroy();
        this.goodsManager = null;
        this.constructionManager.destroy();
        this.constructionManager = null;
        this.powerGrid.destroy();
        this.powerGrid = null;
        this.template = null;
        this.scientificAchievement.clear();
        this.scientificAchievement = null;
    }
}

