/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mars_sim.msp.core.interplanetary.transport.resupply.ResupplyMissionTemplate;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.BuildingTemplate;

public class SettlementTemplate
implements Serializable {
    private String name;
    private int defaultPopulation;
    private List<BuildingTemplate> buildings;
    private Map<String, Integer> vehicles;
    private Map<String, Integer> equipment;
    private Map<AmountResource, Double> resources;
    private Map<Part, Integer> parts;
    private List<ResupplyMissionTemplate> resupplies;

    public SettlementTemplate(String name, int defaultPopulation) {
        this.name = name;
        this.defaultPopulation = defaultPopulation;
        this.buildings = new ArrayList<BuildingTemplate>();
        this.vehicles = new HashMap<String, Integer>();
        this.equipment = new HashMap<String, Integer>();
        this.resources = new HashMap<AmountResource, Double>();
        this.parts = new HashMap<Part, Integer>();
        this.resupplies = new ArrayList<ResupplyMissionTemplate>();
    }

    public String getTemplateName() {
        return this.name;
    }

    public int getDefaultPopulation() {
        return this.defaultPopulation;
    }

    public void addBuildingTemplate(BuildingTemplate buildingTemplate) {
        this.buildings.add(buildingTemplate);
    }

    public List<BuildingTemplate> getBuildingTemplates() {
        return new ArrayList<BuildingTemplate>(this.buildings);
    }

    public void addVehicles(String vehicleType, int number) {
        if (this.vehicles.containsKey(vehicleType)) {
            number += this.vehicles.get(vehicleType).intValue();
        }
        this.vehicles.put(vehicleType, number);
    }

    public Map<String, Integer> getVehicles() {
        return new HashMap<String, Integer>(this.vehicles);
    }

    public void addEquipment(String equipmentType, int number) {
        if (this.equipment.containsKey(equipmentType)) {
            number += this.equipment.get(equipmentType).intValue();
        }
        this.equipment.put(equipmentType, number);
    }

    public Map<String, Integer> getEquipment() {
        return new HashMap<String, Integer>(this.equipment);
    }

    public void addAmountResource(AmountResource resource, double amount) {
        if (this.resources.containsKey(resource)) {
            amount += this.resources.get(resource).doubleValue();
        }
        this.resources.put(resource, amount);
    }

    public Map<AmountResource, Double> getResources() {
        return new HashMap<AmountResource, Double>(this.resources);
    }

    public void addPart(Part part, int number) {
        if (this.parts.containsKey(part)) {
            number += this.parts.get(part).intValue();
        }
        this.parts.put(part, number);
    }

    public Map<Part, Integer> getParts() {
        return new HashMap<Part, Integer>(this.parts);
    }

    public void addResupplyMissionTemplate(ResupplyMissionTemplate resupplyMissionTemplate) {
        this.resupplies.add(resupplyMissionTemplate);
    }

    public List<ResupplyMissionTemplate> getResupplyMissionTemplates() {
        return new ArrayList<ResupplyMissionTemplate>(this.resupplies);
    }

    public void destroy() {
        this.name = null;
        this.buildings.clear();
        this.buildings = null;
        this.vehicles.clear();
        this.vehicles = null;
        this.equipment.clear();
        this.equipment = null;
        this.resources.clear();
        this.resources = null;
        this.parts.clear();
        this.parts = null;
        this.resupplies.clear();
        this.resupplies = null;
    }
}

