/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.core.structure.BuildingTemplate;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.AstronomicalObservation;
import org.mars_sim.msp.core.structure.building.function.Communication;
import org.mars_sim.msp.core.structure.building.function.Cooking;
import org.mars_sim.msp.core.structure.building.function.Dining;
import org.mars_sim.msp.core.structure.building.function.EVA;
import org.mars_sim.msp.core.structure.building.function.EarthReturn;
import org.mars_sim.msp.core.structure.building.function.Exercise;
import org.mars_sim.msp.core.structure.building.function.Farming;
import org.mars_sim.msp.core.structure.building.function.GroundVehicleMaintenance;
import org.mars_sim.msp.core.structure.building.function.LifeSupport;
import org.mars_sim.msp.core.structure.building.function.LivingAccommodations;
import org.mars_sim.msp.core.structure.building.function.Management;
import org.mars_sim.msp.core.structure.building.function.Manufacture;
import org.mars_sim.msp.core.structure.building.function.MedicalCare;
import org.mars_sim.msp.core.structure.building.function.PowerGeneration;
import org.mars_sim.msp.core.structure.building.function.PowerStorage;
import org.mars_sim.msp.core.structure.building.function.Recreation;
import org.mars_sim.msp.core.structure.building.function.Research;
import org.mars_sim.msp.core.structure.building.function.ResourceProcessing;
import org.mars_sim.msp.core.structure.building.function.Storage;
import org.mars_sim.msp.core.structure.building.function.VehicleMaintenance;
import org.mars_sim.msp.core.structure.construction.ConstructionManager;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.construction.ConstructionUtil;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class BuildingManager
implements Serializable {
    private static Logger logger = Logger.getLogger(BuildingManager.class.getName());
    public static final String ADD_BUILDING_EVENT = "add building";
    public static final String REMOVE_BUILDING_EVENT = "remove building";
    private Settlement settlement;
    private List<Building> buildings;
    private Map<String, Double> buildingValuesNewCache;
    private Map<String, Double> buildingValuesOldCache;
    private MarsClock lastBuildingValuesUpdateTime;

    public BuildingManager(Settlement settlement) {
        this(settlement, SimulationConfig.instance().getSettlementConfiguration().getSettlementTemplate(settlement.getTemplate()).getBuildingTemplates());
    }

    public BuildingManager(Settlement settlement, List<BuildingTemplate> buildingTemplates) {
        this.settlement = settlement;
        this.buildings = new ArrayList<Building>();
        if (buildingTemplates != null) {
            for (BuildingTemplate template : buildingTemplates) {
                this.addBuilding(template);
            }
        }
        this.buildingValuesNewCache = new HashMap<String, Double>();
        this.buildingValuesOldCache = new HashMap<String, Double>();
    }

    public Settlement getSettlement() {
        return this.settlement;
    }

    public void addBuilding(Building newBuilding) {
        if (!this.buildings.contains(newBuilding)) {
            this.buildings.add(newBuilding);
            this.settlement.fireUnitUpdate(ADD_BUILDING_EVENT, newBuilding);
        }
    }

    public void removeBuilding(Building oldBuilding) {
        if (this.buildings.contains(oldBuilding)) {
            oldBuilding.removeFunctionsFromSettlement();
            this.buildings.remove(oldBuilding);
            this.settlement.fireUnitUpdate(REMOVE_BUILDING_EVENT, oldBuilding);
        }
    }

    public void addBuilding(BuildingTemplate template) {
        Building newBuilding = new Building(template, this);
        this.addBuilding(newBuilding);
    }

    public List<Building> getBuildings() {
        return new ArrayList<Building>(this.buildings);
    }

    public List<Building> getBuildings(String functionName) {
        ArrayList<Building> functionBuildings = new ArrayList<Building>();
        for (Building building : this.buildings) {
            if (!building.hasFunction(functionName)) continue;
            functionBuildings.add(building);
        }
        return functionBuildings;
    }

    public List<Building> getBuildingsOfName(String buildingName) {
        ArrayList<Building> nameBuildings = new ArrayList<Building>();
        for (Building building : this.buildings) {
            if (!building.getName().equalsIgnoreCase(buildingName)) continue;
            nameBuildings.add(building);
        }
        return nameBuildings;
    }

    public int getBuildingNum() {
        return this.buildings.size();
    }

    public void timePassing(double time) {
        Iterator<Building> i = this.buildings.iterator();
        while (i.hasNext()) {
            i.next().timePassing(time);
        }
    }

    public static void addToRandomBuilding(Person person, Settlement settlement) {
        List<Building> habs = settlement.getBuildingManager().getBuildings("Life Support");
        List<Building> goodHabs = BuildingManager.getLeastCrowdedBuildings(habs);
        Building building = null;
        if (goodHabs.size() >= 1) {
            int rand = RandomUtil.getRandomInt(goodHabs.size() - 1);
            int count = 0;
            for (Building tempBuilding : goodHabs) {
                if (count == rand) {
                    building = tempBuilding;
                }
                ++count;
            }
        }
        if (building == null) {
            throw new IllegalStateException("No inhabitable buildings available for " + person.getName());
        }
        BuildingManager.addPersonToBuilding(person, building);
    }

    public static void addToRandomBuilding(GroundVehicle vehicle, Settlement settlement) {
        List<Building> garages = settlement.getBuildingManager().getBuildings("Ground Vehicle Maintenance");
        ArrayList<VehicleMaintenance> openGarages = new ArrayList<VehicleMaintenance>();
        for (Building garageBuilding : garages) {
            VehicleMaintenance garage = (VehicleMaintenance)garageBuilding.getFunction("Ground Vehicle Maintenance");
            if (garage.getCurrentVehicleNumber() >= garage.getVehicleCapacity()) continue;
            openGarages.add(garage);
        }
        if (openGarages.size() > 0) {
            int rand = RandomUtil.getRandomInt(openGarages.size() - 1);
            ((VehicleMaintenance)openGarages.get(rand)).addVehicle(vehicle);
        }
    }

    public static Building getBuilding(Person person) {
        Building result = null;
        if (person.getLocationSituation().equals("In Settlement")) {
            Settlement settlement = person.getSettlement();
            for (Building building : settlement.getBuildingManager().getBuildings("Life Support")) {
                try {
                    LifeSupport lifeSupport = (LifeSupport)building.getFunction("Life Support");
                    if (!lifeSupport.containsPerson(person)) continue;
                    result = building;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "BuildingManager.getBuilding(): " + e.getMessage());
                }
            }
        }
        return result;
    }

    public static Building getBuilding(Vehicle vehicle) {
        if (vehicle == null) {
            throw new IllegalArgumentException("vehicle is null");
        }
        Building result = null;
        Settlement settlement = vehicle.getSettlement();
        if (settlement != null) {
            for (Building garageBuilding : settlement.getBuildingManager().getBuildings("Ground Vehicle Maintenance")) {
                try {
                    VehicleMaintenance garage = (VehicleMaintenance)garageBuilding.getFunction("Ground Vehicle Maintenance");
                    if (!garage.containsVehicle(vehicle)) continue;
                    result = garageBuilding;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "BuildingManager.getBuilding(): " + e.getMessage());
                }
            }
        }
        return result;
    }

    public static List<Building> getUncrowdedBuildings(List<Building> buildingList) {
        ArrayList<Building> result = new ArrayList<Building>();
        try {
            for (Building building : buildingList) {
                LifeSupport lifeSupport = (LifeSupport)building.getFunction("Life Support");
                if (lifeSupport.getAvailableOccupancy() <= 0) continue;
                result.add(building);
            }
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("BuildingManager.getUncrowdedBuildings(): building isn't a life support building.");
        }
        return result;
    }

    public static List<Building> getLeastCrowdedBuildings(List<Building> buildingList) {
        ArrayList<Building> result = new ArrayList<Building>();
        int leastCrowded = Integer.MAX_VALUE;
        Iterator<Building> i = buildingList.iterator();
        while (i.hasNext()) {
            LifeSupport lifeSupport = (LifeSupport)i.next().getFunction("Life Support");
            int crowded = lifeSupport.getOccupantNumber() - lifeSupport.getOccupantCapacity();
            if (crowded < -1) {
                crowded = -1;
            }
            if (crowded >= leastCrowded) continue;
            leastCrowded = crowded;
        }
        for (Building building : buildingList) {
            LifeSupport lifeSupport = (LifeSupport)building.getFunction("Life Support");
            int crowded = lifeSupport.getOccupantNumber() - lifeSupport.getOccupantCapacity();
            if (crowded < -1) {
                crowded = -1;
            }
            if (crowded != leastCrowded) continue;
            result.add(building);
        }
        return result;
    }

    public static Map<Building, Double> getBestRelationshipBuildings(Person person, List<Building> buildingList) {
        HashMap<Building, Double> result = new HashMap<Building, Double>(buildingList.size());
        RelationshipManager relationshipManager = Simulation.instance().getRelationshipManager();
        for (Building building : buildingList) {
            LifeSupport lifeSupport = (LifeSupport)building.getFunction("Life Support");
            double buildingRelationships = 0.0;
            int numPeople = 0;
            for (Person occupant : lifeSupport.getOccupants()) {
                if (person == occupant) continue;
                buildingRelationships += relationshipManager.getOpinionOfPerson(person, occupant);
                ++numPeople;
            }
            double prob = 50.0;
            if (numPeople > 0 && (prob = buildingRelationships / (double)numPeople) < 0.0) {
                prob = 0.0;
            }
            result.put(building, prob);
        }
        return result;
    }

    public static List<Building> getNonMalfunctioningBuildings(List<Building> buildingList) {
        ArrayList<Building> result = new ArrayList<Building>();
        for (Building building : buildingList) {
            boolean malfunction = building.getMalfunctionManager().hasMalfunction();
            if (malfunction) continue;
            result.add(building);
        }
        return result;
    }

    public static void addPersonToBuilding(Person person, Building building) {
        if (building != null) {
            try {
                LifeSupport lifeSupport = (LifeSupport)building.getFunction("Life Support");
                if (!lifeSupport.containsPerson(person)) {
                    lifeSupport.addPerson(person);
                }
                Point2D.Double buildingLoc = LocalAreaUtil.getRandomInteriorLocation(building);
                Point2D.Double settlementLoc = LocalAreaUtil.getLocalRelativeLocation(buildingLoc.getX(), buildingLoc.getY(), building);
                person.setXLocation(settlementLoc.getX());
                person.setYLocation(settlementLoc.getY());
            }
            catch (Exception e) {
                throw new IllegalStateException("BuildingManager.addPersonToBuilding(): " + e.getMessage());
            }
        } else {
            throw new IllegalStateException("Building is null");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removePersonFromBuilding(Person person, Building building) {
        if (building == null) throw new IllegalStateException("Building is null");
        try {
            LifeSupport lifeSupport = (LifeSupport)building.getFunction("Life Support");
            if (!lifeSupport.containsPerson(person)) return;
            lifeSupport.removePerson(person);
            return;
        }
        catch (Exception e) {
            throw new IllegalStateException("BuildingManager.removePersonFromBuilding(): " + e.getMessage());
        }
    }

    public double getBuildingValue(String buildingName, boolean newBuilding) {
        ConstructionStageInfo frameConstInfo;
        ConstructionStageInfo buildingConstInfo;
        double hoursInSol;
        buildingName = buildingName.toLowerCase().trim();
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        if (this.lastBuildingValuesUpdateTime == null || MarsClock.getTimeDiff(currentTime, this.lastBuildingValuesUpdateTime) > 1000.0) {
            this.buildingValuesNewCache.clear();
            this.buildingValuesOldCache.clear();
            this.lastBuildingValuesUpdateTime = (MarsClock)currentTime.clone();
        }
        if (newBuilding && this.buildingValuesNewCache.containsKey(buildingName)) {
            return this.buildingValuesNewCache.get(buildingName);
        }
        if (!newBuilding && this.buildingValuesOldCache.containsKey(buildingName)) {
            return this.buildingValuesOldCache.get(buildingName);
        }
        double result = 0.0;
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        if (config.hasCommunication(buildingName)) {
            result += Communication.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasCooking(buildingName)) {
            result += Cooking.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasDining(buildingName)) {
            result += Dining.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasEVA(buildingName)) {
            result += EVA.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasExercise(buildingName)) {
            result += Exercise.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasFarming(buildingName)) {
            result += Farming.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasGroundVehicleMaintenance(buildingName)) {
            result += GroundVehicleMaintenance.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasLifeSupport(buildingName)) {
            result += LifeSupport.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasLivingAccommodations(buildingName)) {
            result += LivingAccommodations.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasManufacture(buildingName)) {
            result += Manufacture.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasMedicalCare(buildingName)) {
            result += MedicalCare.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasPowerGeneration(buildingName)) {
            result += PowerGeneration.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasPowerStorage(buildingName)) {
            result += PowerStorage.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasRecreation(buildingName)) {
            result += Recreation.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasResearchLab(buildingName)) {
            result += Research.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasResourceProcessing(buildingName)) {
            result += ResourceProcessing.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasStorage(buildingName)) {
            result += Storage.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasAstronomicalObservation(buildingName)) {
            result += AstronomicalObservation.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasManagement(buildingName)) {
            result += Management.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        if (config.hasEarthReturn(buildingName)) {
            result += EarthReturn.getFunctionValue(buildingName, newBuilding, this.settlement);
        }
        result *= 1000.0;
        double power = config.getBasePowerRequirement(buildingName);
        double powerPerSol = power * (hoursInSol = MarsClock.convertMillisolsToSeconds(1000.0) / 60.0 / 60.0);
        double powerValue = powerPerSol * this.settlement.getPowerGrid().getPowerValue();
        if ((result -= powerValue) < 0.0) {
            result = 0.0;
        }
        if (newBuilding && (buildingConstInfo = ConstructionUtil.getConstructionStageInfo(buildingName)) != null && (frameConstInfo = ConstructionUtil.getPrerequisiteStage(buildingConstInfo)) != null && !frameConstInfo.isConstructable() && !this.hasBuildingFrame(frameConstInfo.getName())) {
            result = 0.0;
        }
        if (newBuilding) {
            this.buildingValuesNewCache.put(buildingName, result);
        } else {
            this.buildingValuesOldCache.put(buildingName, result);
        }
        return result;
    }

    public double getBuildingValue(Building building) {
        double result = 0.0;
        result = this.getBuildingValue(building.getName(), false);
        double wearCondition = building.getMalfunctionManager().getWearCondition();
        return result *= wearCondition / 100.0 * 0.75 + 0.25;
    }

    public boolean checkIfNewBuildingLocationOpen(double xLoc, double yLoc, double width, double length, double facing) {
        return this.checkIfNewBuildingLocationOpen(xLoc, yLoc, width, length, facing, null);
    }

    public boolean checkIfNewBuildingLocationOpen(double xLoc, double yLoc, double width, double length, double facing, ConstructionSite site) {
        boolean goodLocation = true;
        Rectangle2D.Double newBuildingRect = new Rectangle2D.Double(xLoc - width / 2.0, yLoc - length / 2.0, width, length);
        Path2D newBuildingPath = this.getPathFromRectangleRotation(newBuildingRect, facing);
        for (Building existingBuilding : this.settlement.getBuildingManager().getBuildings()) {
            Rectangle2D.Double existingBuildingRect = new Rectangle2D.Double(existingBuilding.getXLocation() - existingBuilding.getWidth() / 2.0, existingBuilding.getYLocation() - existingBuilding.getLength() / 2.0, existingBuilding.getWidth(), existingBuilding.getLength());
            Path2D existingBuildingPath = this.getPathFromRectangleRotation(existingBuildingRect, existingBuilding.getFacing());
            Area area = new Area(newBuildingPath);
            area.intersect(new Area(existingBuildingPath));
            if (area.isEmpty()) continue;
            goodLocation = false;
            break;
        }
        Iterator<ConstructionSite> j = this.settlement.getConstructionManager().getConstructionSites().iterator();
        while (j.hasNext() && goodLocation) {
            ConstructionSite existingSite = j.next();
            if (site != null && site.equals(existingSite)) continue;
            Rectangle2D.Double existingSiteRect = new Rectangle2D.Double(existingSite.getXLocation() - existingSite.getWidth() / 2.0, existingSite.getYLocation() - existingSite.getLength() / 2.0, existingSite.getWidth(), existingSite.getLength());
            Path2D existingSitePath = this.getPathFromRectangleRotation(existingSiteRect, existingSite.getFacing());
            Area area = new Area(newBuildingPath);
            area.intersect(new Area(existingSitePath));
            if (area.isEmpty()) continue;
            goodLocation = false;
            break;
        }
        return goodLocation;
    }

    private Path2D getPathFromRectangleRotation(Rectangle2D rectangle, double rotation) {
        double radianRotation = rotation * (Math.PI / 180);
        AffineTransform at = AffineTransform.getRotateInstance(radianRotation, rectangle.getCenterX(), rectangle.getCenterY());
        return new Path2D.Double(rectangle, at);
    }

    public boolean hasBuildingFrame(String frameName) {
        ConstructionStageInfo frameStageInfo;
        boolean result = false;
        for (Building building : this.buildings) {
            ConstructionStageInfo frameStageInfo2;
            ConstructionStageInfo buildingStageInfo = ConstructionUtil.getConstructionStageInfo(building.getName());
            if (buildingStageInfo == null || (frameStageInfo2 = ConstructionUtil.getPrerequisiteStage(buildingStageInfo)) == null || !frameStageInfo2.getName().equals(frameName)) continue;
            result = true;
            break;
        }
        if (!result && (frameStageInfo = ConstructionUtil.getConstructionStageInfo(frameName)) != null) {
            ConstructionManager constManager = this.settlement.getConstructionManager();
            for (ConstructionSite site : constManager.getConstructionSites()) {
                if (!site.hasStage(frameStageInfo)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public void destroy() {
        this.settlement = null;
        Iterator<Building> i = this.buildings.iterator();
        while (i.hasNext()) {
            i.next().destroy();
        }
        this.buildings.clear();
        this.buildings = null;
        this.buildingValuesNewCache.clear();
        this.buildingValuesNewCache = null;
        this.buildingValuesOldCache.clear();
        this.buildingValuesOldCache = null;
        this.lastBuildingValuesUpdateTime = null;
    }
}

