/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.awt.geom.Point2D;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;

public class BuildingAirlock
extends Airlock {
    private static Logger logger = Logger.getLogger(BuildingAirlock.class.getName());
    private Building building;

    public BuildingAirlock(Building building, int capacity) {
        super(capacity);
        this.building = building;
        if (building == null) {
            throw new IllegalArgumentException("building is null.");
        }
    }

    @Override
    public boolean enterAirlock(Person person, boolean inside) {
        boolean result = super.enterAirlock(person, inside);
        if (result && inside) {
            BuildingManager.addPersonToBuilding(person, this.building);
        }
        return result;
    }

    @Override
    protected void exitAirlock(Person person) {
        Inventory inv = this.building.getInventory();
        if (this.inAirlock(person)) {
            if ("pressurized".equals(this.getState())) {
                BuildingManager.addPersonToBuilding(person, this.building);
                inv.storeUnit(person);
            } else if ("depressurized".equals(this.getState())) {
                BuildingManager.removePersonFromBuilding(person, this.building);
                inv.retrieveUnit(person);
                Point2D.Double buildingLoc = LocalAreaUtil.getRandomExteriorLocation(this.building, 1.0);
                Point2D.Double settlementLoc = LocalAreaUtil.getLocalRelativeLocation(buildingLoc.getX(), buildingLoc.getY(), this.building);
                person.setXLocation(settlementLoc.getX());
                person.setYLocation(settlementLoc.getY());
            } else {
                logger.severe("Building airlock in incorrect state for exiting: " + this.getState());
            }
        } else {
            throw new IllegalStateException(person.getName() + " not in airlock of " + this.getEntityName());
        }
    }

    @Override
    public String getEntityName() {
        Settlement settlement = this.building.getBuildingManager().getSettlement();
        return settlement.getName() + ": " + this.building.getName();
    }

    @Override
    public Inventory getEntityInventory() {
        return this.building.getInventory();
    }

    @Override
    public Object getEntity() {
        return this.building;
    }
}

